/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePath {
    private static List<String> getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List<String> r, List<String> f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        if (j >= 0) {
            s = s + f.get(j);
        }
        return s;
    }

    public static String getRelativePath(File home, File f) {
        List<String> homelist = RelativePath.getPathList(home);
        int start_list = 0;
        int end_list = homelist.size();
        if (home.isFile() && homelist.size() > 0) {
            ++start_list;
        }
        List<String> filelist = RelativePath.getPathList(f);
        String s = RelativePath.matchPathLists(homelist.subList(start_list, end_list), filelist);
        return s;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("RelativePath <home> <file>");
            return;
        }
        System.out.println("home = " + args[0]);
        System.out.println("file = " + args[1]);
        System.out.println("path = " + RelativePath.getRelativePath(new File(args[0]), new File(args[1])));
    }
}

