/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GNSS.Ellipsoid;
import GNSS.GRS80;
import GNSS.Gnss;
import GNSS.RinexFile;
import GNSS.RinexOFile;
import GPosGui.AntennaComboBox;
import GPosGui.GPosFrame;
import GPosGui.GPosParent;
import GPosGui.LatEntryPanel;
import GPosGui.LonEntryPanel;
import GPosGui.PomPanel;
import GPosGui.RinexObsFileNameField;
import GPosGui.UnitsPopupSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomPanelUsingButtons_2_0
extends JPanel {
    private JLabel AntIdLabel_;
    private JPanel BannerPanel_;
    private JPanel ButtonPanel_;
    private JLabel Mon1Label_;
    private JLabel Mon2Label_;
    private JLabel Mon3Label_;
    private JLabel MonLabel_;
    private JComboBox MonType_;
    private JLabel ObsFileNameLabel_;
    private JLabel Off1Label_;
    private JLabel OffLabel_;
    private JLabel Title_;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private AntennaComboBox AntIdEntry_;
    protected Color BannerBackground_ = UIManager.getDefaults().getColor("Panel.foreground");
    protected Color BannerForeground_ = UIManager.getDefaults().getColor("Panel.background");
    protected GPosFrame Parent_ = null;
    protected boolean InitFromRinexHeaderEveryTime_ = false;
    protected boolean InitFromRinexHeaderFirstTime_ = false;
    protected boolean Initialized_ = false;
    private Ellipsoid Ellipsoid_ = new GRS80();
    private JLabel InitSource_ = null;
    private LatEntryPanel LatField_;
    private LonEntryPanel LonField_;
    private MouseListener PopupMenuListener_;
    private PomPanel OtherPomPanel_;
    private SpecialFileNameField ObsFileNameField_;
    private String ChooserTitle_ = "Select a RINEX Obs (\"O\") File";
    private String InitialTitle_ = "STATION";
    private UnitsPopupSpinner MonXField_;
    private UnitsPopupSpinner MonYField_;
    private UnitsPopupSpinner MonZField_;
    private UnitsPopupSpinner Off1Field_;
    private boolean AutoEnableFlag_ = false;
    private int CoordinateFormat_;
    private int LonDisplay_ = 0;
    public static final int AUTO_LON = 0;
    public static final int EAST_LON = 1;
    public static final int WEST_LON = -1;
    public static final int PLH_FORMAT = 1;
    public static final int XYZ_FORMAT = 0;

    public PomPanelUsingButtons_2_0() {
        this.initComponents();
        this.setOverwriteMode(false);
    }

    public PomPanelUsingButtons_2_0(String title) {
        this.initComponents();
        this.setTitle(title);
        this.InitialTitle_ = title;
        this.setOverwriteMode(false);
    }

    public PomPanelUsingButtons_2_0(GPosFrame parent) {
        this.Parent_ = parent;
        this.BannerBackground_ = GPosParent.GPosBlue;
        this.BannerForeground_ = GPosParent.GPosSilver;
        this.initComponents();
        this.setOverwriteMode(false);
    }

    public PomPanelUsingButtons_2_0(GPosFrame parent, String title) {
        this.Parent_ = parent;
        this.InitialTitle_ = title;
        this.BannerBackground_ = GPosParent.GPosBlue;
        this.BannerForeground_ = GPosParent.GPosSilver;
        this.initComponents();
        this.setTitle(title);
        this.setOverwriteMode(false);
    }

    private void initComponents() {
        this.BannerPanel_ = new JPanel();
        this.Title_ = new JLabel();
        this.ButtonPanel_ = new JPanel();
        this.jPanel1 = new JPanel();
        this.ObsFileNameLabel_ = new JLabel();
        this.ObsFileNameField_ = new SpecialFileNameField(this.Parent_);
        this.ObsFileNameField_.setMustExistFlag(true);
        this.ObsFileNameField_.setEmptyIsOkFlag(false);
        this.ObsFileNameField_.setDirTag("RINEX");
        this.AntIdLabel_ = new JLabel();
        this.AntIdEntry_ = new AntennaComboBox();
        this.jPanel2 = new JPanel();
        this.MonLabel_ = new JLabel();
        this.MonType_ = new JComboBox();
        this.Mon1Label_ = new JLabel();
        String[] names = new String[]{"meters", "decimeters", "centimeters", "millimeters"};
        Double[] sizes = new Double[]{1.0, 0.1, 0.01, 0.001};
        this.MonXField_ = new UnitsPopupSpinner(1115064.1336, 0.001, "m");
        this.MonXField_.setFormat("0.0000");
        this.MonXField_.setColumns(14);
        this.MonXField_.setSteps(names, sizes);
        this.LatField_ = new LatEntryPanel();
        this.Mon2Label_ = new JLabel();
        this.MonYField_ = new UnitsPopupSpinner(-4843968.4793, 0.001, "m");
        this.MonYField_.setFormat("0.0000");
        this.MonYField_.setColumns(14);
        this.MonYField_.setSteps(names, sizes);
        this.LonField_ = new LonEntryPanel();
        this.Mon3Label_ = new JLabel();
        this.MonZField_ = new UnitsPopupSpinner(3983266.0464, 0.001, "m");
        this.MonZField_.setFormat("0.0000");
        this.MonZField_.setColumns(14);
        this.MonZField_.setSteps(names, sizes);
        this.OffLabel_ = new JLabel();
        this.Off1Label_ = new JLabel();
        this.Off1Field_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.Off1Field_.setFormat("0.0000");
        this.Off1Field_.setColumns(10);
        this.Off1Field_.setSteps(names, sizes);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createLineBorder(GPosParent.GPosBlue));
        this.setFocusable(false);
        this.BannerPanel_.setLayout(new GridBagLayout());
        this.BannerPanel_.setBackground(this.BannerBackground_);
        this.BannerPanel_.setForeground(this.BannerForeground_);
        this.Title_.setBackground(this.BannerPanel_.getBackground());
        this.Title_.setForeground(this.BannerPanel_.getForeground());
        this.Title_.setText(" STATION ");
        this.Title_.setFocusable(false);
        this.Title_.setHorizontalTextPosition(0);
        this.Title_.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.BannerPanel_.add((Component)this.Title_, gridBagConstraints);
        this.ButtonPanel_.setLayout(new GridLayout(1, 0, 1, 0));
        this.ButtonPanel_.setBackground(UIManager.getDefaults().getColor("Panel.foreground"));
        this.ButtonPanel_.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.BannerPanel_.add((Component)this.ButtonPanel_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.BannerPanel_, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.ObsFileNameLabel_.setLabelFor(this.ObsFileNameField_);
        this.ObsFileNameField_.setToolTipText("Enter the RINEX observation (\"o\") file name.");
        this.ObsFileNameField_.setBackgroundToError();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.ObsFileNameField_, gridBagConstraints);
        this.ObsFileNameLabel_.setText(this.i18nString("ObsFileNameLabel", "RINEX Obs File:"));
        this.ObsFileNameLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.ObsFileNameLabel_, gridBagConstraints);
        this.AntIdLabel_.setLabelFor(this.AntIdEntry_);
        this.AntIdEntry_.setToolTipText("Enter a standard IGS antenna ID.");
        this.AntIdEntry_.setMinimumSize(new Dimension(170, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.AntIdEntry_, gridBagConstraints);
        this.AntIdLabel_.setText(this.i18nString("AntIdLabel", "Antenna:"));
        this.AntIdLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.AntIdLabel_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.MonLabel_.setText(this.i18nString("MonLabel", "Monument:"));
        this.MonLabel_.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonLabel_, gridBagConstraints);
        this.MonType_.removeAllItems();
        for (Gnss.COORDINATE crd : Gnss.COORDINATE.values()) {
            this.MonType_.addItem(crd.toString());
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonType_, gridBagConstraints);
        this.MonXField_.setToolTipText("<html>Monument X coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonXField_, gridBagConstraints);
        this.LatField_.setToolTipText("<html>Monument latitude in degrees, minutes, seconds.");
        this.Mon1Label_.setText("X");
        this.Mon1Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon1Label_, gridBagConstraints);
        this.MonYField_.setToolTipText("<html>Monument Y coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonYField_, gridBagConstraints);
        this.LonField_.setToolTipText("<html>Monument longitude in degrees, minutes, seconds.");
        this.Mon2Label_.setText("Y");
        this.Mon2Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon2Label_, gridBagConstraints);
        this.MonZField_.setToolTipText("<html>Monument Z coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonZField_, gridBagConstraints);
        this.Mon3Label_.setText("Z");
        this.Mon3Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon3Label_, gridBagConstraints);
        this.OffLabel_.setText(this.i18nString("OffLabel", "Mon \u2192 ARP:"));
        this.OffLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.OffLabel_, gridBagConstraints);
        this.Off1Field_.setToolTipText("<html>Height offset in meters.<br>Right-click on the field<br>to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Off1Field_, gridBagConstraints);
        this.Off1Label_.setText("H");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Off1Label_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    protected JLabel addInitializationButton(JLabel button, boolean enabled) {
        this.ButtonPanel_.add(button);
        button.setEnabled(enabled);
        return button;
    }

    protected JLabel addInitializationButton(String text, boolean enabled) {
        JLabel button = this.makeButton(text, enabled);
        this.ButtonPanel_.add(button);
        return button;
    }

    protected void InitButtonsMouseReleased(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
    }

    protected String applyValuesFromRinexHeader() {
        if (this.ObsFileNameField_.isOk()) {
            String name;
            boolean flag = true;
            String msg = this.i18nString("RinexDidNotContain", "The RINEX obs file did not contain:");
            RinexFile file = this.ObsFileNameField_.getRinexFile();
            if (file.has("ANT_TYPE")) {
                if (((String)file.get("ANT_TYPE")).trim().length() > 0) {
                    this.set(FIELD.ANTENNA, (String)file.get("ANT_TYPE"));
                } else {
                    flag = false;
                    msg = msg.concat("\n  " + this.i18nString("AnAntennaType", "an antenna type"));
                }
            } else {
                flag = false;
                msg = msg.concat("\n  \"ANT # / TYPE\"");
            }
            if (file.has("APP_POS_X")) {
                this.set(FIELD.MONUMENT_FRAME, Gnss.COORDINATE.WGS84G1150);
                this.set(FIELD.MONUMENT_X, (Double)file.get("APP_POS_X"));
                this.set(FIELD.MONUMENT_Y, (Double)file.get("APP_POS_Y"));
                this.set(FIELD.MONUMENT_Z, (Double)file.get("APP_POS_Z"));
            } else {
                flag = false;
                msg = msg.concat("\n  \"APPROX POSITION XYZ\"");
            }
            if (file.has("ANT_DEL_E")) {
                this.set(FIELD.OFFSET_1, (Double)file.get("ANT_DEL_H"));
            } else {
                flag = false;
                msg = msg.concat("\n  \"ANTENNA: DELTA H/E/N\"");
            }
            if (file.has("MARKER_NAME") && (name = ((String)file.get("MARKER_NAME")).trim()).length() > 0) {
                this.setTitle(this.InitialTitle_ + " (" + name + ")");
            }
            if (flag) {
                return "";
            }
            return msg.concat("\n" + this.i18nString("ValuesNotSet", "The associated values have not been set."));
        }
        return "";
    }

    public String doOnSettingFileName(boolean input_is_ok) {
        String msg = new String("");
        if (this.Title_ != null) {
            if (input_is_ok) {
                if (this.AutoEnableFlag_) {
                    this.setEnabled(true);
                }
                if (this.InitFromRinexHeaderEveryTime_ || this.InitFromRinexHeaderFirstTime_ && !this.Initialized_) {
                    msg = this.applyValuesFromRinexHeader();
                }
            } else if (this.AutoEnableFlag_) {
                this.setEnabled(false);
                this.setEnabled(FIELD.FILE_NAME, true);
            }
        }
        return msg;
    }

    public Object get(FIELD field) {
        if (field == FIELD.FILE) {
            return this.ObsFileNameField_.getRinexFile();
        }
        if (field == FIELD.FILE_NAME) {
            return this.ObsFileNameField_.getText();
        }
        if (field == FIELD.FULL_FILE_NAME) {
            return this.ObsFileNameField_.getFullPath();
        }
        if (field == FIELD.ANTENNA) {
            return this.AntIdEntry_.getText();
        }
        if (field == FIELD.INTERVAL) {
            return this.ObsFileNameField_.getRinexFile().get("INTERVAL");
        }
        if (field == FIELD.MONUMENT_FRAME) {
            return Gnss.COORDINATE.fromString((String)((String)this.MonType_.getSelectedItem()));
        }
        if (field == FIELD.MONUMENT_X) {
            return this.MonXField_.getValue();
        }
        if (field == FIELD.MONUMENT_Y) {
            return this.MonYField_.getValue();
        }
        if (field == FIELD.MONUMENT_Z) {
            return this.MonZField_.getValue();
        }
        if (field == FIELD.OFFSET_1) {
            return this.Off1Field_.getValue();
        }
        if (field == FIELD.START_TIME) {
            return this.ObsFileNameField_.getRinexFile().readTimeOfFirstEpoch();
        }
        if (field == FIELD.STOP_TIME) {
            return this.ObsFileNameField_.getRinexFile().readTimeOfLastEpoch();
        }
        return null;
    }

    protected JLabel getInitSource() {
        return this.InitSource_;
    }

    public boolean getOverwriteMode() {
        return this.ObsFileNameField_.getOverwriteMode();
    }

    public RinexOFile getRinexFile() {
        return (RinexOFile)this.get(FIELD.FILE);
    }

    public String getRnxFileName() {
        return ((RinexOFile)this.get(FIELD.FILE)).getCanonicalPath();
    }

    public String getTitle() {
        return this.Title_.getText();
    }

    public Dimension getTitleSize() {
        return this.Title_.getPreferredSize();
    }

    public boolean isOk() {
        return this.ObsFileNameField_.isOk();
    }

    protected JLabel makeButton(String text, boolean enabled) {
        JLabel button = new JLabel();
        button.setHorizontalAlignment(0);
        button.setText(text);
        button.setBorder(new SoftBevelBorder(0));
        button.setForeground(this.BannerForeground_);
        button.setBackground(this.BannerBackground_);
        button.setOpaque(true);
        button.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PomPanelUsingButtons_2_0.this.InitButtonsMouseReleased(evt);
            }
        });
        button.setEnabled(enabled);
        return button;
    }

    protected void reset() {
        this.applyValuesFromRinexHeader();
    }

    public void resetText() {
        this.ObsFileNameField_.setTextOnly(this.ObsFileNameField_.getRinexFile().getFile());
    }

    public void set(FIELD field, Object value) {
        block26: {
            if (value == null) {
                this.ObsFileNameField_.setTextQuietly("");
                this.Initialized_ = false;
                this.setTitle(this.InitialTitle_);
            } else {
                if (field == FIELD.FILE) {
                    try {
                        if (value instanceof File) {
                            this.ObsFileNameField_.setTextQuietly(((File)value).getCanonicalPath());
                            this.Initialized_ = true;
                        } else if (value instanceof RinexFile) {
                            this.ObsFileNameField_.setTextQuietly(((RinexFile)value).getCanonicalPath());
                            this.Initialized_ = true;
                        }
                        break block26;
                    }
                    catch (IOException ex) {
                        if (value instanceof File) {
                            this.ObsFileNameField_.setTextQuietly(((File)value).getAbsolutePath());
                            this.Initialized_ = true;
                        } else if (value instanceof RinexFile) {
                            this.ObsFileNameField_.setTextQuietly(((RinexFile)value).getAbsolutePath());
                            this.Initialized_ = true;
                        }
                        break block26;
                    }
                }
                if (field == FIELD.FILE_NAME || field == FIELD.FULL_FILE_NAME) {
                    this.ObsFileNameField_.setTextQuietly((String)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.ANTENNA) {
                    this.AntIdEntry_.setText((String)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.MONUMENT_FRAME) {
                    this.MonType_.setSelectedItem(((Gnss.COORDINATE)value).toString());
                    this.Initialized_ = true;
                } else if (field == FIELD.MONUMENT_X) {
                    this.MonXField_.setValue((Double)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.MONUMENT_Y) {
                    this.MonYField_.setValue((Double)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.MONUMENT_Z) {
                    this.MonZField_.setValue((Double)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.OFFSET_1) {
                    this.Off1Field_.setValue((Double)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.LINK) {
                    this.OtherPomPanel_ = (PomPanel)value;
                }
            }
        }
    }

    public void setAntennaIdList(Set<String> set) {
        this.AntIdEntry_.createMenus(set);
    }

    public void setAntennaIdList(String[] array) {
        this.AntIdEntry_.createMenus(array);
    }

    public void setAutoEnableFlag(boolean flag) {
        this.AutoEnableFlag_ = flag;
    }

    public void setDirTag(String input) {
        if (input != null && input.length() > 0) {
            this.ObsFileNameField_.setDirTag(input);
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.OffLabel_.setEnabled(flag);
        this.MonLabel_.setEnabled(flag);
        this.ObsFileNameLabel_.setEnabled(flag);
        this.ObsFileNameField_.setEnabled(flag);
        this.AntIdLabel_.setEnabled(flag);
        this.AntIdEntry_.setEnabled(flag);
        this.MonType_.setEnabled(flag);
        this.Mon1Label_.setEnabled(flag);
        this.MonXField_.setEnabled(flag);
        this.Mon2Label_.setEnabled(flag);
        this.MonYField_.setEnabled(flag);
        this.Mon3Label_.setEnabled(flag);
        this.MonZField_.setEnabled(flag);
        this.Off1Label_.setEnabled(flag);
        this.Off1Field_.setEnabled(flag);
    }

    public void setEnabled(FIELD field, boolean flag) {
        if (field.equals((Object)FIELD.FILE_NAME)) {
            this.ObsFileNameLabel_.setEnabled(flag);
            this.ObsFileNameField_.setEnabled(flag);
        } else if (field.equals((Object)FIELD.ANTENNA)) {
            this.AntIdLabel_.setEnabled(flag);
            this.AntIdEntry_.setEnabled(flag);
        } else if (field.equals((Object)FIELD.MONUMENT_FRAME)) {
            this.MonType_.setEnabled(flag);
        } else if (field.equals((Object)FIELD.MONUMENT_X)) {
            this.Mon1Label_.setEnabled(flag);
            this.MonXField_.setEnabled(flag);
        } else if (field.equals((Object)FIELD.MONUMENT_Y)) {
            this.Mon2Label_.setEnabled(flag);
            this.MonYField_.setEnabled(flag);
        } else if (field.equals((Object)FIELD.MONUMENT_Z)) {
            this.Mon3Label_.setEnabled(flag);
            this.MonZField_.setEnabled(flag);
        } else if (field.equals((Object)FIELD.ANT_DEL_H) || field.equals((Object)FIELD.OFFSET_1)) {
            this.Off1Label_.setEnabled(flag);
            this.Off1Field_.setEnabled(flag);
        }
    }

    public void setInitFromRinexHeaderEveryTime(boolean flag) {
        this.InitFromRinexHeaderEveryTime_ = flag;
    }

    public void setInitFromRinexHeaderFirstTime(boolean flag) {
        this.InitFromRinexHeaderFirstTime_ = flag;
    }

    protected void setInitSource(JLabel item) {
        if (item != this.InitSource_) {
            if (this.InitSource_ != null) {
                this.InitSource_.setBackground(this.BannerBackground_);
                this.InitSource_.setForeground(this.BannerForeground_);
            }
            if (item != null) {
                item.setBackground(this.BannerForeground_);
                item.setForeground(this.BannerBackground_);
            }
            this.InitSource_ = item;
        }
    }

    public void setLonDisplay(int input) {
        this.LonDisplay_ = input;
    }

    public void setLink(PomPanel other) {
        this.OtherPomPanel_ = other;
    }

    public void setMonumentLabel(String input) {
        this.MonLabel_.setText(input);
    }

    public void setOffsetLabel(String input) {
        this.OffLabel_.setText(input);
    }

    public void setOverwriteMode(boolean mode) {
        this.ObsFileNameField_.setOverwriteMode(mode);
        this.MonXField_.setOverwriteMode(mode);
        this.MonYField_.setOverwriteMode(mode);
        this.MonZField_.setOverwriteMode(mode);
        this.Off1Field_.setOverwriteMode(mode);
    }

    public void setTitle(String input) {
        this.Title_.setText(" " + input.trim() + " ");
    }

    public void setTitleSize(Dimension size) {
        this.Title_.setSize(size);
    }

    public void setTitleSize(int width, int height) {
        this.Title_.setSize(width, height);
        this.Title_.setPreferredSize(new Dimension(width, height));
        this.Title_.setMinimumSize(new Dimension(width, height));
    }

    public String i18nString(String name, String alt) {
        return this.Parent_ != null ? this.Parent_.i18nString(name, alt) : alt;
    }

    public class SpecialFileNameField
    extends RinexObsFileNameField {
        public SpecialFileNameField(GPosFrame parent) {
            super(parent);
        }

        public void setText(File input) {
            String msg;
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath(this.DirTag_, super.getRinexFile().getCanonicalPath());
            }
            if ((msg = PomPanelUsingButtons_2_0.this.doOnSettingFileName(this.isOk())) != null && msg.length() > 0) {
                JOptionPane.showMessageDialog(this.Parent_, msg, PomPanelUsingButtons_2_0.this.i18nString("MissingRinexHeaderInfo", "Missing RINEX Header Info"), 2);
            }
        }

        public void setText(String input) {
            String msg;
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath(this.DirTag_, super.getRinexFile().getCanonicalPath());
            }
            if ((msg = PomPanelUsingButtons_2_0.this.doOnSettingFileName(this.isOk())) != null && msg.length() > 0) {
                JOptionPane.showMessageDialog(this.Parent_, msg, PomPanelUsingButtons_2_0.this.i18nString("MissingRinexHeaderInfo", "Missing RINEX Header Info"), 2);
            }
        }

        public void setTextQuietly(File input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath(this.DirTag_, super.getRinexFile().getCanonicalPath());
            }
            PomPanelUsingButtons_2_0.this.doOnSettingFileName(this.isOk());
        }

        public void setTextQuietly(String input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath(this.DirTag_, super.getRinexFile().getCanonicalPath());
            }
            PomPanelUsingButtons_2_0.this.doOnSettingFileName(this.isOk());
        }

        public void setTextOnly(File input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath(this.DirTag_, super.getRinexFile().getCanonicalPath());
            }
        }

        public void setTextOnly(String input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath(this.DirTag_, super.getRinexFile().getCanonicalPath());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FIELD {
        ANTENNA,
        ANT_DEL_H,
        FILE,
        FILE_NAME,
        FULL_FILE_NAME,
        INTERVAL,
        INITIALIZE_FROM_OPUS,
        LINK,
        MONUMENT_FRAME,
        MONUMENT_X,
        MONUMENT_Y,
        MONUMENT_Z,
        OFFSET_1,
        START_TIME,
        START_TIME_FRAME,
        STOP_TIME,
        STOP_TIME_FRAME;

    }
}

