/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GNSS.GpsTime;
import GNSS.GpsTimeZone;
import GPosGui.GpsDateSpinnerModel;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GpsDateSpinnerEditor
extends JTextField
implements ActionListener,
FocusListener,
ChangeListener {
    private int Index_ = 0;
    private GpsTime Epoch_ = new GpsTime();
    private GpsDateSpinnerModel Model_;
    private JFormattedTextField Field_;
    private JSpinner Spinner_;
    private String Format_;
    private static final String[] ValidDateFormats_ = new String[]{"MJD", "SINEX", "YYYY-DDD", "YYYY-MM-DD"};
    private static final String[] ValidTimeFormats_ = new String[]{"HH", "HH:MM", "HH:MM:SS", "HH:MM:SS.S", "HH:MM:SS.SS", "HH:MM:SS.SSS", "Second-Of-Day"};
    private static final int MaxFormatColumns_ = 12;

    public GpsDateSpinnerEditor(JSpinner spinner, String format) {
        this.Spinner_ = spinner;
        this.Model_ = (GpsDateSpinnerModel)spinner.getModel();
        spinner.addChangeListener(this);
        this.addActionListener(this);
        this.addFocusListener(this);
        this.setFormat(format);
        this.setColumns(12);
        this.setEditable(true);
        this.setValue((Date)this.Model_.getValue());
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.Model_ != null) {
            try {
                this.Model_.setValue(this.parseString(this.getText()));
                this.setBackground(Color.white);
            }
            catch (ParseException ex) {
                this.setBackground(Color.pink);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private String createString() {
        switch (this.Index_) {
            case 0: {
                return this.Epoch_.toMjdString();
            }
            case 1: {
                return this.Epoch_.toSinexDateString();
            }
            case 2: {
                return this.Epoch_.toIsoYdString();
            }
            case 3: {
                return this.Epoch_.toIsoYmdString();
            }
            case 4: {
                return this.Epoch_.toIsoHString();
            }
            case 5: {
                return this.Epoch_.toIsoHmString();
            }
            case 6: {
                return this.Epoch_.toIsoHmsString();
            }
            case 7: {
                return this.Epoch_.toIsoHms1String();
            }
            case 8: {
                return this.Epoch_.toIsoHms2String();
            }
            case 9: {
                return this.Epoch_.toIsoHms3String();
            }
            case 10: {
                return this.Epoch_.toSinexTimeString();
            }
        }
        return this.Epoch_.toIsoYmdString();
    }

    public void focusGained(FocusEvent evt) {
    }

    public void focusLost(FocusEvent evt) {
        if (this.Model_ != null) {
            try {
                this.Model_.setValue(this.parseString(this.getText()));
                this.setBackground(Color.white);
            }
            catch (ParseException ex) {
                this.setBackground(Color.pink);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public String getFormat() {
        return this.Format_;
    }

    private int getFormatIndex(String format) {
        int index;
        for (index = 0; index < ValidDateFormats_.length; ++index) {
            if (!format.equalsIgnoreCase(ValidDateFormats_[index])) continue;
            return index;
        }
        for (index = 0; index < ValidTimeFormats_.length; ++index) {
            if (!format.equalsIgnoreCase(ValidTimeFormats_[index])) continue;
            return ValidDateFormats_.length + index;
        }
        throw new IllegalArgumentException("\"" + format + "\" is not a valid GpsDateEditor format");
    }

    public GpsDateSpinnerModel getModel() {
        return this.Model_;
    }

    public GpsTimeZone getTimeZone() {
        return (GpsTimeZone)this.Epoch_.getTimeZone();
    }

    public static String[] getValidDateFormats() {
        return ValidDateFormats_;
    }

    public static String[] getValidTimeFormats() {
        return ValidTimeFormats_;
    }

    private boolean isFormatOk(String format) {
        int index;
        for (index = 0; index < ValidDateFormats_.length; ++index) {
            if (!format.equalsIgnoreCase(ValidDateFormats_[index])) continue;
            return true;
        }
        for (index = 0; index < ValidTimeFormats_.length; ++index) {
            if (!format.equalsIgnoreCase(ValidTimeFormats_[index])) continue;
            return true;
        }
        return false;
    }

    public boolean isOk() {
        try {
            this.parseString(this.getText());
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    private Date parseString(String input) throws ParseException {
        switch (this.Index_) {
            case 0: {
                this.Epoch_.fromMjdString(input);
                break;
            }
            case 1: {
                this.Epoch_.fromSinexDateString(input);
                break;
            }
            case 2: {
                this.Epoch_.fromIsoYdString(input);
                break;
            }
            case 3: {
                this.Epoch_.fromIsoYmdString(input);
                break;
            }
            case 4: {
                this.Epoch_.fromIsoHString(input);
                break;
            }
            case 5: {
                this.Epoch_.fromIsoHmString(input);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.Epoch_.fromIsoHmsString(input);
                break;
            }
            case 10: {
                this.Epoch_.fromSinexTimeString(input);
                break;
            }
            default: {
                this.Epoch_.fromIsoYmdString(input);
            }
        }
        return this.Epoch_.getTime();
    }

    public void setFormat(String format) {
        this.Index_ = this.getFormatIndex(format);
        if (this.Index_ < ValidDateFormats_.length) {
            this.Format_ = ValidDateFormats_[this.Index_];
            this.Model_.setChangeField(6);
        } else {
            int index = this.Index_ - ValidDateFormats_.length;
            this.Format_ = ValidTimeFormats_[index];
            if (index == 0) {
                this.Model_.setChangeField(11);
            } else if (index == 1) {
                this.Model_.setChangeField(12);
            } else {
                this.Model_.setChangeField(13);
            }
        }
        this.setValue((Date)this.Model_.getValue());
    }

    public void setFormat(int index) {
        if (index >= 0 && index < ValidDateFormats_.length) {
            this.Index_ = index;
            this.Format_ = ValidDateFormats_[this.Index_];
            this.setValue((Date)this.Model_.getValue());
        } else if (index >= ValidDateFormats_.length && index < ValidDateFormats_.length + ValidTimeFormats_.length) {
            this.Index_ = index;
            this.Format_ = ValidTimeFormats_[this.Index_ - ValidDateFormats_.length];
            this.setValue((Date)this.Model_.getValue());
        } else {
            throw new IllegalArgumentException("\"" + index + "\" is not a valid GpsDateEditor format");
        }
    }

    public void setModel(GpsDateSpinnerModel model) {
        this.Model_ = model;
    }

    public void setValue(Object input) {
        this.Epoch_.setTimeInMillis(((Date)input).getTime());
        this.setText(this.createString());
    }

    public void stateChanged(ChangeEvent evt) {
        if (this.Model_ != null) {
            this.setValue((Date)this.Model_.getValue());
        }
    }
}

