/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GPosGui.GPosDirMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GPosParent {
    private static final ImageIcon PoweredByGPosIcon_ = GPosParent.createImageIcon("/GPosGui/images/gpos_logo48.gif", "Powered by GPos logo");
    private static final ImageIcon GPosIcon_ = GPosParent.createImageIcon("/GPosGui/images/gpos_logo16.gif", "GPos logo");
    protected GPosDirMap DirMap_ = new GPosDirMap();
    protected File UserPropertiesFile_;
    protected Locale Locale_;
    protected Properties Properties_;
    protected ResourceBundle DefaultBundle_;
    protected ResourceBundle ResourceBundle_;
    protected String Name_ = "GPosParent";
    protected String Version_ = "1.0";
    protected String Info_ = "a standard parent base class for GPos tools";
    protected static final String Contact_ = "\n  General Positioning LLC\n  5144 Clark Drive\n  Roeland Park, KS 66205-1402\n  USA\n  contact@generalpositioning.com";
    public static final Color GPosBlue = new Color(19, 22, 135);
    public static final Color GPosSilver = new Color(238, 238, 238);

    public GPosParent(String name, String version) {
        this(name, version, Locale.getDefault());
    }

    public GPosParent(String name, String version, Locale locale) {
        this.Name_ = name;
        this.Version_ = version;
        this.Locale_ = locale;
        try {
            this.DefaultBundle_ = ResourceBundle.getBundle(GPosParent.class.getPackage().getName() + ".default", this.Locale_);
        }
        catch (Exception e) {
            System.err.println("Error: global resource file\n" + e.toString());
        }
        try {
            this.ResourceBundle_ = ResourceBundle.getBundle(this.getClass().getPackage().getName() + "." + this.Name_, this.Locale_);
        }
        catch (Exception e) {
            System.err.println("Error: application resource file\n" + e.toString());
        }
        Properties glob_prop = new Properties();
        try {
            InputStream fin = null;
            fin = this.getClass().getClassLoader().getResourceAsStream(this.getClass().getPackage().getName() + "." + this.Name_ + ".xml");
            if (fin != null) {
                glob_prop.loadFromXML(fin);
                fin.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Error: global properties file not found\n" + fnfe.toString());
        }
        catch (IOException ioe) {
            System.err.println("Error: reading global properties\n" + ioe.toString());
        }
        this.Properties_ = new Properties(glob_prop);
        this.UserPropertiesFile_ = new File(System.getProperty("user.home") + File.separator + this.Name_ + ".xml");
        if (this.UserPropertiesFile_.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.UserPropertiesFile_);
                if (fis != null) {
                    this.Properties_.loadFromXML(fis);
                    fis.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Error: user properties file not found\n" + fnfe.toString());
            }
            catch (IOException ioe) {
                System.err.println("Error: reading user properties\n" + ioe.toString());
            }
        }
        this.DirMap_.put("CURRENT", new File("."));
        if (this.i18nString("info") != null) {
            this.Info_ = this.i18nString("info");
        }
        this.initComponents();
    }

    protected void initComponents() {
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new GPosParent("test", "test 1.0");
            }
        });
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = GPosParent.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        return null;
    }

    protected void centerOnScreen(JFrame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension jFrameSize = frame.getSize();
        if (jFrameSize.height > screenSize.height) {
            jFrameSize.height = screenSize.height;
        }
        if (jFrameSize.width > screenSize.width) {
            jFrameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - jFrameSize.width) / 2, (screenSize.height - jFrameSize.height) / 2);
    }

    public String getContactInfo() {
        return Contact_;
    }

    public ResourceBundle getDefaultBundle() {
        return this.DefaultBundle_;
    }

    public GPosDirMap getDirMap() {
        return this.DirMap_;
    }

    public ImageIcon getGPosIcon() {
        return GPosIcon_;
    }

    public String getProgramInfo() {
        return this.Info_;
    }

    public String getProgramName() {
        return this.Name_;
    }

    public String getProgramVersion() {
        return this.Version_;
    }

    public String getPath(String name) {
        if (!this.DirMap_.containsKey(name)) {
            this.DirMap_.put(name, this.DirMap_.get("CURRENT"));
        }
        return this.DirMap_.get(name);
    }

    public ImageIcon getPoweredByGPosIcon() {
        return PoweredByGPosIcon_;
    }

    public Properties getProperties() {
        return this.Properties_;
    }

    public ResourceBundle getResourceBundle() {
        return this.ResourceBundle_;
    }

    public File getUserPropertiesFile() {
        return this.UserPropertiesFile_;
    }

    public boolean i18nKey(String key) {
        return this.i18nString(key) != null;
    }

    public String i18nString(String key) {
        try {
            return this.ResourceBundle_.getString(key);
        }
        catch (Exception e1) {
            try {
                return this.DefaultBundle_.getString(key);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public String i18nString(String key, String alt) {
        try {
            return this.ResourceBundle_.getString(key);
        }
        catch (Exception e1) {
            try {
                return this.DefaultBundle_.getString(key);
            }
            catch (Exception e2) {
                return alt;
            }
        }
    }

    public boolean propKey(String key) {
        if (this.Properties_ != null) {
            return this.Properties_.containsKey(key);
        }
        return false;
    }

    public String propString(String key) {
        if (this.Properties_ != null) {
            return this.Properties_.getProperty(key);
        }
        return null;
    }

    public String propString(String key, String alt) {
        if (this.Properties_ != null) {
            return this.Properties_.getProperty(key, alt);
        }
        return null;
    }

    public void setIconImage(JFrame frame, Image input) {
        if (input != null) {
            frame.setIconImage(input);
        }
    }

    public void setIconImage(JFrame frame, ImageIcon input) {
        if (input != null) {
            frame.setIconImage(input.getImage());
        }
    }

    public void setPath(String name, String path) {
        if (name != null) {
            if (path == null) {
                if (this.DirMap_.containsKey(name)) {
                    this.DirMap_.remove(name);
                }
            } else {
                this.DirMap_.put("CURRENT", path);
                this.DirMap_.put(name, path);
            }
        }
    }

    public void setPropString(String key, String value) {
        if (this.Properties_ != null && key != null && value != null) {
            this.Properties_.setProperty(key, value);
        }
    }

    public void writeUserProperties() {
        try {
            FileOutputStream fos = new FileOutputStream(this.UserPropertiesFile_);
            this.Properties_.storeToXML(fos, this.Name_);
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Error: user properties file could not be created\n" + fnfe.toString());
        }
        catch (IOException ioe) {
            System.err.println("Error: writing user properties file\n" + ioe.toString());
        }
    }
}

