/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GPosGui.GPosDirMap;
import GPosGui.GPosParent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.layout.GroupLayout;

public class GPosFrame
extends JFrame {
    private static final ImageIcon PoweredByGPosIcon_ = GPosFrame.createImageIcon("/GPosGui/images/gpos_logo48.gif", "Powered by GPos logo");
    private static final ImageIcon GPosIcon_ = GPosFrame.createImageIcon("/GPosGui/images/gpos_logo16.gif", "GPos logo");
    protected GPosDirMap DirMap_;
    protected File UserPropertiesFile_;
    protected Locale Locale_;
    protected Properties Properties_;
    protected ResourceBundle DefaultBundle_;
    protected ResourceBundle ResourceBundle_;
    protected Object Parent_ = null;
    protected String Name_ = "GPosFrame";
    protected String Version_ = "1.0";
    protected String Info_ = "A standardized JFrame.";
    protected String Contact_ = "\n  General Positioning LLC\n  5144 Clark Drive\n  Roeland Park, KS 66205-1402\n  USA\n  contact@generalpositioning.com";
    protected String UserPropertiesFileName_;

    public GPosFrame(String name, String version) {
        this(name, version, Locale.getDefault());
    }

    public GPosFrame(String name, String version, Locale locale) {
        this.Name_ = name;
        this.Version_ = version;
        this.Locale_ = locale;
        this.Parent_ = null;
        this.pre_init();
        this.initComponents();
    }

    public GPosFrame(Object parent) {
        this.Parent_ = parent;
        this.pre_init();
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GPosFrame("test", "test 1.0").setVisible(true);
            }
        });
    }

    protected void AboutActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, this.getAbout(), "About " + this.Name_, 1, this.getPoweredByGPosIcon());
    }

    protected void QuitActionPerformed() {
        System.exit(0);
    }

    protected void QuitActionPerformed(ActionEvent ae) {
        this.QuitActionPerformed();
    }

    protected void QuitActionPerformed(WindowEvent we) {
        this.QuitActionPerformed();
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = GPosParent.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        return null;
    }

    protected void centerOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension jFrameSize = super.getSize();
        if (jFrameSize.height > screenSize.height) {
            jFrameSize.height = screenSize.height;
        }
        if (jFrameSize.width > screenSize.width) {
            jFrameSize.width = screenSize.width;
        }
        super.setLocation((screenSize.width - jFrameSize.width) / 2, (screenSize.height - jFrameSize.height) / 2);
    }

    public String getAbout() {
        return this.Name_ + " (" + this.Version_ + ") " + this.Info_ + "\n" + this.Contact_;
    }

    public String getContactInfo() {
        return this.Contact_;
    }

    public ResourceBundle getDefaultBundle() {
        return this.DefaultBundle_;
    }

    public GPosDirMap getDirMap() {
        return this.DirMap_;
    }

    public File getFile(String path) {
        String dir_name = this.getPath(path);
        if (dir_name == null) {
            return new File(".");
        }
        return new File(dir_name);
    }

    public ImageIcon getGPosIcon() {
        return GPosIcon_;
    }

    public String getPath(String name) {
        if (!this.DirMap_.containsKey(name)) {
            this.DirMap_.put(name, this.DirMap_.get("CURRENT"));
        }
        return this.DirMap_.get(name);
    }

    public String getPath(String path, String name) {
        return this.getPath(path) + File.separator + name;
    }

    public String getProgramInfo() {
        return this.Info_;
    }

    public String getProgramName() {
        return this.Name_;
    }

    public String getProgramVersion() {
        return this.Version_;
    }

    public ImageIcon getPoweredByGPosIcon() {
        return PoweredByGPosIcon_;
    }

    public Properties getProperties() {
        return this.Properties_;
    }

    public ResourceBundle getResourceBundle() {
        return this.ResourceBundle_;
    }

    public File getUserPropertiesFile() {
        return this.UserPropertiesFile_;
    }

    public boolean i18nKey(String key) {
        return this.i18nString(key) != null;
    }

    public String i18nString(String key) {
        try {
            return this.ResourceBundle_.getString(key);
        }
        catch (Exception e1) {
            try {
                return this.DefaultBundle_.getString(key);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public String i18nString(String key, String alt) {
        try {
            return this.ResourceBundle_.getString(key);
        }
        catch (Exception e1) {
            try {
                return this.DefaultBundle_.getString(key);
            }
            catch (Exception e2) {
                return alt;
            }
        }
    }

    protected void pre_init() {
        if (this.Parent_ instanceof GPosFrame) {
            this.Name_ = ((GPosFrame)this.Parent_).getProgramName();
            this.Version_ = ((GPosFrame)this.Parent_).getProgramVersion();
            this.Info_ = ((GPosFrame)this.Parent_).getProgramInfo();
            this.Contact_ = ((GPosFrame)this.Parent_).getContactInfo();
            this.UserPropertiesFile_ = ((GPosFrame)this.Parent_).getUserPropertiesFile();
            this.Properties_ = ((GPosFrame)this.Parent_).getProperties();
            this.DefaultBundle_ = ((GPosFrame)this.Parent_).getDefaultBundle();
            this.ResourceBundle_ = ((GPosFrame)this.Parent_).getResourceBundle();
            this.DirMap_ = ((GPosFrame)this.Parent_).getDirMap();
            this.setIconImage(((GPosFrame)this.Parent_).getGPosIcon());
            this.setTitle(((GPosFrame)this.Parent_).getProgramName());
        } else if (this.Parent_ instanceof GPosParent) {
            this.Name_ = ((GPosParent)this.Parent_).getProgramName();
            this.Version_ = ((GPosParent)this.Parent_).getProgramVersion();
            this.Info_ = ((GPosParent)this.Parent_).getProgramInfo();
            this.Contact_ = ((GPosParent)this.Parent_).getContactInfo();
            this.UserPropertiesFile_ = ((GPosParent)this.Parent_).getUserPropertiesFile();
            this.Properties_ = ((GPosParent)this.Parent_).getProperties();
            this.DefaultBundle_ = ((GPosParent)this.Parent_).getDefaultBundle();
            this.ResourceBundle_ = ((GPosParent)this.Parent_).getResourceBundle();
            this.DirMap_ = ((GPosParent)this.Parent_).getDirMap();
            this.setIconImage(((GPosParent)this.Parent_).getGPosIcon());
            this.setTitle(((GPosParent)this.Parent_).getProgramName());
        } else {
            this.setIconImage(this.getGPosIcon());
            this.setTitle(this.Name_);
            try {
                this.DefaultBundle_ = ResourceBundle.getBundle(GPosParent.class.getPackage().getName() + ".default", this.Locale_);
            }
            catch (Exception e) {
                System.err.println("Error: global resource file\n" + e.toString());
            }
            try {
                this.ResourceBundle_ = ResourceBundle.getBundle(this.getClass().getPackage().getName() + "." + this.Name_, this.Locale_);
            }
            catch (Exception e) {
                System.err.println("Error: application resource file\n" + e.toString());
            }
            Properties glob_prop = new Properties();
            try {
                InputStream fin = null;
                fin = this.getClass().getClassLoader().getResourceAsStream(this.getClass().getPackage().getName() + "." + this.Name_ + ".xml");
                if (fin != null) {
                    glob_prop.loadFromXML(fin);
                    fin.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Error: global properties file not found\n" + fnfe.toString());
            }
            catch (IOException ioe) {
                System.err.println("Error: reading global properties\n" + ioe.toString());
            }
            this.Properties_ = new Properties(glob_prop);
            File UserPropertiesFile_ = new File(System.getProperty("user.home") + File.separator + this.Name_ + ".xml");
            if (UserPropertiesFile_.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(UserPropertiesFile_);
                    if (fis != null) {
                        this.Properties_.loadFromXML(fis);
                        fis.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("Error: user properties file not found\n" + fnfe.toString());
                }
                catch (IOException ioe) {
                    System.err.println("Error: reading user properties\n" + ioe.toString());
                }
            }
            this.DirMap_ = new GPosDirMap();
            this.DirMap_.put("CURRENT", new File("."));
            if (this.i18nString("info") != null) {
                this.Info_ = this.i18nString("info");
            }
        }
    }

    public boolean propKey(String key) {
        if (this.Properties_ != null) {
            return this.Properties_.containsKey(key);
        }
        return false;
    }

    public String propString(String key) {
        if (this.Properties_ != null) {
            return this.Properties_.getProperty(key);
        }
        return null;
    }

    public String propString(String key, String alt) {
        if (this.Properties_ != null) {
            return this.Properties_.getProperty(key, alt);
        }
        return null;
    }

    public void setIconImage(Image input) {
        if (input != null) {
            super.setIconImage(input);
        }
    }

    public void setIconImage(ImageIcon input) {
        if (input != null) {
            super.setIconImage(input.getImage());
        }
    }

    public void setPath(String name, String path) {
        if (name != null) {
            if (path == null) {
                if (this.DirMap_.containsKey(name)) {
                    this.DirMap_.remove(name);
                }
            } else {
                this.DirMap_.put("CURRENT", path);
                this.DirMap_.put(name, path);
            }
        }
    }

    public void setPropString(String key, String value) {
        if (this.Properties_ != null && key != null && value != null) {
            this.Properties_.setProperty(key, value);
        }
    }

    public void writeUserProperties() {
        try {
            FileOutputStream fos = new FileOutputStream(this.UserPropertiesFile_);
            this.Properties_.storeToXML(fos, this.Name_);
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Error: user properties file could not be created\n" + fnfe.toString());
        }
        catch (IOException ioe) {
            System.err.println("Error: writing user properties file\n" + ioe.toString());
        }
    }
}

