/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GNSS.GpsTime;
import java.awt.Toolkit;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SpinnerDateModel;

public class GPosDateSpinnerModel
extends SpinnerDateModel {
    protected GpsTime Current_ = new GpsTime();
    protected boolean Round_ = false;
    protected int Interval_ = 1;

    public GPosDateSpinnerModel() {
        this(new Date());
    }

    public GPosDateSpinnerModel(Date date) {
        this(date, 12);
    }

    public GPosDateSpinnerModel(Date date, int calendar_field) {
        this(date, (Comparable)null, (Comparable)null, calendar_field);
    }

    public GPosDateSpinnerModel(int calendar_field) {
        this(new Date(), calendar_field);
    }

    public GPosDateSpinnerModel(Date date, Comparable start, Comparable end, int calendar_field) {
        super(date, start, end, calendar_field);
        this.Current_.setTime(date);
        this.setChangeField(calendar_field);
    }

    public int getChangeField() {
        return super.getCalendarField();
    }

    public Object getNextValue() {
        this.Current_.add(this.getCalendarField(), this.Interval_);
        Date end = (Date)this.getEnd();
        if (end == null || end.compareTo(this.Current_.getTime()) >= 0) {
            this.fireStateChanged();
        } else {
            this.Current_.setTime(end);
            Toolkit.getDefaultToolkit().beep();
        }
        return this.Current_.getTime();
    }

    public Object getPreviousValue() {
        this.Current_.add(this.getCalendarField(), -this.Interval_);
        Date start = (Date)this.getStart();
        if (start == null || start.compareTo(this.Current_.getTime()) <= 0) {
            this.fireStateChanged();
        } else {
            this.Current_.setTime(start);
            Toolkit.getDefaultToolkit().beep();
        }
        return this.Current_.getTime();
    }

    private void round() {
        if (this.Round_) {
            switch (this.getCalendarField()) {
                case 5: 
                case 6: {
                    this.Current_.set(10, 0);
                }
                case 11: {
                    this.Current_.set(12, 0);
                }
                case 12: {
                    this.Current_.set(13, 0);
                }
                case 13: {
                    this.Current_.set(14, 0);
                    this.Round_ = false;
                    this.setValue(this.Current_.getTime());
                    break;
                }
                default: {
                    this.Round_ = false;
                }
            }
        }
    }

    public void setCalendarField(int calendar_field) {
    }

    public void setChangeField(int calendar_field) {
        super.setCalendarField(calendar_field);
        this.Round_ = false;
    }

    public void setChangeField(int calendar_field, int interval) {
        super.setCalendarField(calendar_field);
        this.Interval_ = StrictMath.abs(interval);
        this.Round_ = false;
    }

    public void setValue(Object value) {
        if (value instanceof Date) {
            Date start = (Date)this.getStart();
            Date end = (Date)this.getEnd();
            if (!(start != null && start.compareTo((Date)value) > 0 || end != null && end.compareTo((Date)value) < 0)) {
                this.Current_.setTime((Date)value);
                this.round();
                super.setValue(this.Current_.getTime());
            } else {
                super.setValue(this.Current_.getTime());
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (value instanceof Calendar) {
            this.setValue(((Calendar)value).getTime());
        } else {
            throw new IllegalArgumentException("illegal value");
        }
    }
}

