/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GPosGui.DegreeField;
import GPosGui.GPosLabel;
import GPosGui.MinuteField;
import GPosGui.SecondField;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.ParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DmsEntryPanel
extends JPanel {
    private JComboBox Hemi_;
    private DegreeField Degrees_;
    private MinuteField Minutes_;
    private SecondField Seconds_;
    private GPosLabel DegreeUnits_;
    private GPosLabel MinuteUnits_;
    private GPosLabel SecondUnits_;
    private String[] HemiNames_;
    private int DegCol_ = 2;

    public DmsEntryPanel(int deg_col, String[] hemi_names) {
        this.DegCol_ = deg_col;
        this.HemiNames_ = hemi_names;
        this.initComponents();
    }

    private void initComponents() {
        this.Hemi_ = new JComboBox();
        this.Degrees_ = new DegreeField(this.DegCol_);
        this.DegreeUnits_ = new GPosLabel();
        this.Minutes_ = new MinuteField();
        this.Minutes_.setLink(this.Degrees_);
        this.MinuteUnits_ = new GPosLabel();
        this.Seconds_ = new SecondField();
        this.Seconds_.setLink(this.Minutes_);
        this.SecondUnits_ = new GPosLabel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.Degrees_, gridBagConstraints);
        this.DegreeUnits_.setLabelFor(this.Degrees_);
        this.DegreeUnits_.setFont(new Font("Monospaced", 1, 12));
        this.DegreeUnits_.setText("<html><font size=+1>&#176;</font></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.DegreeUnits_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.Minutes_, gridBagConstraints);
        this.MinuteUnits_.setLabelFor(this.Minutes_);
        this.MinuteUnits_.setFont(new Font("Monospaced", 1, 12));
        this.MinuteUnits_.setText("<html><font size=+1>&#146;</font></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.MinuteUnits_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.Seconds_, gridBagConstraints);
        this.SecondUnits_.setLabelFor(this.Seconds_);
        this.SecondUnits_.setFont(new Font("Monospaced", 1, 12));
        this.SecondUnits_.setLabelFor(this.DegreeUnits_);
        this.SecondUnits_.setText("<html><font size=+1>&#148;</font></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.SecondUnits_, gridBagConstraints);
        this.Hemi_.setModel(new DefaultComboBoxModel<String>(this.HemiNames_));
        this.Hemi_.setFont(new Font("Monospaced", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.add((Component)this.Hemi_, gridBagConstraints);
    }

    public void commitEdit() throws ParseException {
        this.Degrees_.commitEdit();
        this.Minutes_.commitEdit();
        this.Seconds_.commitEdit();
    }

    public Integer getDegrees() {
        return this.Degrees_.getValue();
    }

    public Integer getMinutes() {
        return this.Minutes_.getValue();
    }

    public Double getSeconds() {
        return this.Seconds_.getValue();
    }

    public Double getValue() {
        return (this.Hemi_.getSelectedIndex() == 0 ? 1.0 : -1.0) * ((this.Seconds_.getValue() / 60.0 + this.Minutes_.getValue().doubleValue()) / 60.0 + this.Degrees_.getValue().doubleValue());
    }

    public void setDegrees(Number value) {
        if (value != null) {
            this.Degrees_.setValue(value.intValue());
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.DegreeUnits_.setEnabled(flag);
        this.Hemi_.setEnabled(flag);
        this.MinuteUnits_.setEnabled(flag);
        this.SecondUnits_.setEnabled(flag);
        this.Degrees_.setEnabled(flag);
        this.Minutes_.setEnabled(flag);
        this.Seconds_.setEnabled(flag);
    }

    public void setFont(Font font) {
        if (font != null && this.Hemi_ != null) {
            Font bold = new Font(font.getFontName(), font.getSize(), 1);
            Font plain = new Font(font.getFontName(), font.getSize(), 0);
            this.Hemi_.setFont(bold);
            this.DegreeUnits_.setFont(bold);
            this.Degrees_.setFont(plain);
            this.MinuteUnits_.setFont(bold);
            this.Minutes_.setFont(plain);
            this.SecondUnits_.setFont(bold);
            this.Seconds_.setFont(plain);
        }
    }

    public void setMinutes(Number value) {
        if (value != null) {
            this.Minutes_.setValue(value.intValue());
        }
    }

    public void setSeconds(Number value) {
        if (value != null) {
            this.Seconds_.setValue(value.doubleValue());
        }
    }

    public void setToolTipText(String input) {
        super.setToolTipText(input);
        this.Hemi_.setToolTipText(input);
        this.Degrees_.setToolTipText(input);
        this.DegreeUnits_.setToolTipText(input);
        this.Minutes_.setToolTipText(input);
        this.MinuteUnits_.setToolTipText(input);
        this.Seconds_.setToolTipText(input);
        this.SecondUnits_.setToolTipText(input);
    }

    public void setValue(Number value) {
        if (value != null) {
            double tmp = value.doubleValue();
            if (tmp < 0.0) {
                this.Hemi_.setSelectedIndex(1);
                tmp = -tmp;
            } else {
                this.Hemi_.setSelectedIndex(0);
            }
            this.setDegrees((int)tmp);
            tmp -= (double)((int)tmp);
            this.setMinutes((int)(tmp *= 60.0));
            tmp -= (double)((int)tmp);
            this.setSeconds(tmp *= 60.0);
        }
    }
}

