/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import java.awt.Font;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;

public class DegreeField
extends JFormattedTextField {
    private static final String Zeros_ = "000";

    public DegreeField() {
        super(new DecimalFormat(Zeros_));
        super.setColumns(3);
        super.setFont(new Font("Monospaced", 0, 12));
        super.setValue(0);
    }

    public DegreeField(int columns) {
        super(new DecimalFormat(Zeros_.substring(0, columns < 3 ? columns : 3)));
        super.setColumns(columns);
        super.setFont(new Font("Monospaced", 0, 12));
        super.setValue(0);
    }

    public Integer getValue() {
        return super.getValue() == null ? 0 : ((Number)super.getValue()).intValue();
    }

    public Integer getNextValue() {
        return (this.getValue() + 1) % (super.getColumns() == 3 ? 360 : 90);
    }

    public Integer getPreviousValue() {
        return this.getValue() - 1 < 0 ? (super.getColumns() == 3 ? 359 : 89) : this.getValue() - 1;
    }

    public void setValue(Integer value) {
        if (value < 0) {
            super.setValue(0);
            Toolkit.getDefaultToolkit().beep();
        } else if (value >= (super.getColumns() == 3 ? 360 : 90)) {
            super.setValue(super.getColumns() == 3 ? 360 : 90);
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.setValue(value);
        }
    }

    public void setValue(String input) {
        this.setValue(Integer.parseInt(input));
    }
}

