/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisLabels {
    public static final long MillisOfDay = 86400000L;
    public static final long MillisOfHour = 3600000L;
    public static final long MillisOfMinute = 60000L;
    public static final long MillisOfSecond = 1000L;
    static final double[] DecimalMultiples_ = new double[]{2.0, 3.0, 4.0, 5.0};
    static final long[] DayMultiples_ = new long[]{86400000L, 129600000L, 172800000L, 604800000L, 1209600000L, 2419200000L};
    static final long[] HourMultiples_ = new long[]{3600000L, 0x6DDD00L, 10800000L, 14400000L, 21600000L, 28800000L, 43200000L, 86400000L, 129600000L, 172800000L, 604800000L, 1209600000L, 2419200000L};
    static final long[] MinuteMultiples_ = new long[]{60000L, 120000L, 300000L, 600000L, 900000L, 1200000L, 1800000L, 3600000L, 5400000L, 0x6DDD00L, 18000000L, 36000000L, 54000000L, 72000000L, 108000000L, 216000000L};
    static final long[] SecondMultiples_ = new long[]{1000L, 2000L, 5000L, 10000L, 15000L, 20000L, 30000L, 60000L, 90000L, 120000L, 300000L, 600000L, 900000L, 1200000L, 1800000L, 3600000L};
    private Date Start_ = new Date();
    private DateFormat DateFormat_ = DateFormat.LONG;
    private DecimalFormat DF_ = new DecimalFormat();
    private GregorianCalendar Calendar_ = new GregorianCalendar();
    private Object Max_;
    private Object Min_;
    private SimpleDateFormat SDF_ = new SimpleDateFormat();
    private SortedMap<Object, String> ALabels_ = new TreeMap<Object, String>();
    private SortedMap<Object, String> BLabels_ = new TreeMap<Object, String>();
    private String UnitsPrefix_ = new String("");
    public static final SortedMap<Integer, String> SILengthPrefixes_ = new TreeMap<Integer, String>(){
        {
            this.put(-9, "n");
            this.put(-6, "\u00b5");
            this.put(-3, "m");
            this.put(-2, "c");
            this.put(0, "");
            this.put(3, "k");
        }
    };
    public static final SortedMap<Integer, String> SITimePrefixes_ = new TreeMap<Integer, String>(){
        {
            this.put(-12, "p");
            this.put(-9, "n");
            this.put(-6, "\u00b5");
            this.put(-3, "m");
            this.put(-2, "c");
            this.put(0, "");
            this.put(3, "k");
            this.put(6, "M");
            this.put(9, "G");
        }
    };

    public AxisLabels(TimeZone zone) {
        this.Calendar_.setTimeZone(zone);
        this.SDF_.setTimeZone(zone);
    }

    private void addMinorTimeTicks(Date epoch0, Date epoch1, boolean tick_marks) {
        if (tick_marks && !epoch1.equals(epoch0) && this.ALabels_.size() > 0) {
            long interval = epoch1.getTime() - epoch0.getTime();
            interval = (interval > 0L ? interval : -interval) / (long)this.ALabels_.size();
            if (interval > 604800000L) {
                return;
            }
            if (interval > 259200000L) {
                interval = 86400000L;
            } else if (interval > 86400000L) {
                interval = 21600000L;
            } else if (interval > 43200000L) {
                interval = 10800000L;
            } else if (interval > 21600000L) {
                interval = 0x6DDD00L;
            } else if (interval > 10800000L) {
                interval = 3600000L;
            } else if (interval > 3600000L) {
                interval = 1800000L;
            } else if (interval > 1800000L) {
                interval = 900000L;
            } else if (interval > 600000L) {
                interval = 300000L;
            } else if (interval > 300000L) {
                interval = 60000L;
            } else if (interval > 60000L) {
                interval = 30000L;
            } else if (interval > 30000L) {
                interval = 15000L;
            } else if (interval > 10000L) {
                interval = 5000L;
            } else if (interval > 5000L) {
                interval = 1000L;
            } else {
                return;
            }
            Date value = new Date(epoch0.getTime() - epoch0.getTime() % interval + interval);
            while (value.before(epoch1)) {
                if (!this.ALabels_.containsKey(value)) {
                    this.ALabels_.put(value.clone(), "");
                }
                value.setTime(value.getTime() + interval);
            }
        }
    }

    private void convertDoublesToDates(Date epoch0, Date epoch1, double value0, double value1) {
        Double tmp;
        this.BLabels_.putAll(this.ALabels_);
        this.ALabels_.clear();
        Iterator<Object> itr = this.BLabels_.keySet().iterator();
        long delta_long = epoch1.getTime() - epoch0.getTime();
        double delta_double = value1 - value0;
        while (itr.hasNext()) {
            tmp = (Double)itr.next();
            this.ALabels_.put(new Date(epoch0.getTime() + StrictMath.round((double)delta_long * ((tmp - value0) / delta_double))), (String)this.BLabels_.get(tmp));
        }
        this.BLabels_.clear();
        tmp = (Double)this.Min_;
        this.Min_ = new Date(epoch0.getTime() + StrictMath.round((double)delta_long * ((tmp - value0) / delta_double)));
        tmp = (Double)this.Max_;
        this.Max_ = new Date(epoch0.getTime() + StrictMath.round((double)delta_long * ((tmp - value0) / delta_double)));
    }

    private long findInterval(Date epoch0, Date epoch1, int max_labels, boolean minimal, long[] permitted_intervals) {
        long delta = epoch1.getTime() - epoch0.getTime();
        long interval = 3600000L;
        for (int i = 0; i < permitted_intervals.length && delta / (interval = permitted_intervals[i]) > (long)max_labels; ++i) {
        }
        if (minimal) {
            long time = epoch0.getTime() % 86400000L;
            time = time <= interval ? 0L : (time -= time % interval);
            this.Start_.setTime(epoch0.getTime() - epoch0.getTime() % 86400000L + time);
            while (this.Start_.before(epoch0)) {
                this.Start_.setTime(this.Start_.getTime() + interval);
            }
        } else {
            long time = epoch1.getTime() % 86400000L;
            time = time <= interval ? interval : (time += interval - time % interval);
            this.Start_.setTime(epoch1.getTime() - epoch1.getTime() % 86400000L + time);
            while (this.Start_.after(epoch0)) {
                this.Start_.setTime(this.Start_.getTime() - interval);
            }
        }
        return interval;
    }

    private void getTimeLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal, long[] multiples, String format) {
        long interval = this.findInterval(epoch0, epoch1, max_labels, minimal, multiples);
        this.ALabels_.clear();
        this.BLabels_.clear();
        long tmp_day = -1L;
        while (this.Start_.before(epoch1)) {
            if (tmp_day != this.Start_.getTime() / 86400000L) {
                tmp_day = this.Start_.getTime() / 86400000L;
                this.SDF_.applyPattern(this.DateFormat_.toString());
                this.BLabels_.put(this.Start_.clone(), this.SDF_.format(this.Start_));
                this.SDF_.applyPattern(format);
                this.Min_ = this.Start_.clone();
            }
            this.ALabels_.put(this.Start_.clone(), this.SDF_.format(this.Start_));
            this.Start_.setTime(this.Start_.getTime() + interval);
            this.Max_ = this.Start_.clone();
        }
        if (this.Start_.equals(epoch1) || !minimal) {
            if (tmp_day != this.Start_.getTime() / 86400000L) {
                tmp_day = this.Start_.getTime() / 86400000L;
                this.SDF_.applyPattern(this.DateFormat_.toString());
                this.BLabels_.put(this.Start_.clone(), this.SDF_.format(this.Start_));
                this.SDF_.applyPattern(format);
            }
            this.ALabels_.put(this.Start_.clone(), this.SDF_.format(this.Start_));
            this.Max_ = this.Start_.clone();
        }
    }

    public void clear() {
        this.ALabels_.clear();
        this.BLabels_.clear();
        this.UnitsPrefix_ = "";
    }

    public int countALabels() {
        return this.ALabels_.size();
    }

    public int countBLabels() {
        return this.BLabels_.size();
    }

    public SortedMap<Object, String> getALabels() {
        return this.ALabels_;
    }

    public SortedMap<Object, String> getBLabels() {
        return this.BLabels_;
    }

    public DateFormat getDateFormat() {
        return this.DateFormat_;
    }

    public void getDayLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal) {
        this.getTimeLabels(epoch0, epoch1, max_labels, minimal, DayMultiples_, "HH");
        this.ALabels_.clear();
        this.ALabels_.putAll(this.BLabels_);
        this.BLabels_.clear();
    }

    public void getDecimalLabels(double lower, double upper, int max_labels, boolean minimal) {
        this.getDecimalLabels(lower, upper, max_labels, minimal, false, null);
    }

    public void getDecimalLabels(double lower, double upper, int max_labels, boolean minimal, boolean minor_ticks) {
        this.getDecimalLabels(lower, upper, max_labels, minimal, minor_ticks, null);
    }

    public void getDecimalLabels(double lower, double upper, int max_labels, boolean minimal, boolean minor_ticks, SortedMap<Integer, String> prefixes) {
        this.clear();
        double ideal = (upper - lower) / (double)max_labels;
        if (ideal > 0.001) {
            Double tmp;
            double fraction;
            double log = StrictMath.log10(ideal);
            double interval_power = StrictMath.floor(log);
            double error = fraction = log - interval_power;
            double factor = 1.0;
            double value = DecimalMultiples_[DecimalMultiples_.length - 1];
            for (int i = 0; i < DecimalMultiples_.length; ++i) {
                value = DecimalMultiples_[i];
                double log_value = StrictMath.log10(value);
                double trial_error = StrictMath.abs(fraction - log_value);
                if (!(trial_error < error)) continue;
                error = trial_error;
                factor = value;
            }
            double ul_power = StrictMath.floor(StrictMath.max(StrictMath.log10(StrictMath.abs(lower)), StrictMath.log10(StrictMath.abs(upper))));
            double label_power = 0.0;
            double scale_for_label = 1.0;
            Integer offset = 0;
            if (prefixes != null) {
                Integer i;
                offset = (int)prefixes.firstKey();
                Iterator<Integer> itr = prefixes.keySet().iterator();
                while (itr.hasNext() && !((double)(i = Integer.valueOf(itr.next())).intValue() > ul_power)) {
                    offset = i;
                }
                this.UnitsPrefix_ = (String)prefixes.get(offset);
                label_power = -offset.intValue();
                scale_for_label = StrictMath.pow(10.0, -offset.intValue());
            }
            offset = (int)StrictMath.round(label_power + interval_power);
            if (factor == 2.5) {
                if (offset >= 0) {
                    this.DF_.applyPattern("0.0");
                } else if (offset == -1) {
                    this.DF_.applyPattern("0.0#");
                } else if (offset == -2) {
                    this.DF_.applyPattern("0.0##");
                } else {
                    this.DF_.applyPattern("0.0##E0");
                }
            } else if (offset >= 0) {
                this.DF_.applyPattern("0");
            } else if (offset == -1) {
                this.DF_.applyPattern("0.0");
            } else if (offset == -2) {
                this.DF_.applyPattern("0.0#");
            } else if (offset == -3) {
                this.DF_.applyPattern("0.0##");
            } else if (offset == -4) {
                this.DF_.applyPattern("0.0###");
            } else if (offset == -5) {
                this.DF_.applyPattern("0.0####");
            } else {
                this.DF_.applyPattern("0.0##E0");
            }
            double grid = factor * StrictMath.pow(10.0, interval_power);
            this.ALabels_.clear();
            this.BLabels_.clear();
            Double save_tmp = null;
            double save_value = 0.0;
            double base = lower < 0.0 ? grid * StrictMath.ceil(lower / grid) : grid * StrictMath.floor(lower / grid);
            value = base;
            int i = 0;
            while (value < upper && this.ALabels_.size() < 50) {
                tmp = new Double(value);
                if (!this.ALabels_.containsKey(tmp)) {
                    if (value < lower) {
                        if (!minimal) {
                            save_tmp = tmp;
                            save_value = value;
                        }
                    } else if (value == lower) {
                        this.ALabels_.clear();
                        this.ALabels_.put(tmp, this.DF_.format(tmp * scale_for_label));
                        save_tmp = null;
                    } else {
                        if (save_tmp != null) {
                            this.ALabels_.put(save_tmp, this.DF_.format(save_tmp * scale_for_label));
                            save_tmp = null;
                        }
                        this.ALabels_.put(tmp, this.DF_.format(tmp * scale_for_label));
                    }
                }
                value = base + (double)(++i) * grid;
            }
            if (value == upper || !minimal) {
                if (save_tmp != null) {
                    this.ALabels_.put(save_tmp, this.DF_.format(save_tmp * scale_for_label));
                    save_tmp = null;
                }
                if (!this.ALabels_.containsKey(tmp = new Double(value))) {
                    this.ALabels_.put(tmp, this.DF_.format(tmp * scale_for_label));
                }
            }
            if (minor_ticks) {
                factor = factor == 1.0 || factor == 2.5 ? 0.5 : 1.0;
                grid = factor * StrictMath.pow(10.0, interval_power);
                i = 0;
                while (value > lower && this.ALabels_.size() < 50) {
                    if (value <= upper && !this.ALabels_.containsKey(tmp = new Double(value))) {
                        this.ALabels_.put(tmp, "");
                    }
                    value = base + (double)(--i) * grid;
                }
                i = 0;
                while (value < upper && this.ALabels_.size() < 50) {
                    if (value >= lower && !this.ALabels_.containsKey(tmp = new Double(value))) {
                        this.ALabels_.put(tmp, "");
                    }
                    value = base + (double)(++i) * grid;
                }
            }
            if (minimal) {
                this.Max_ = new Double(upper);
                this.Min_ = new Double(lower);
            } else {
                this.Max_ = (double)((Double)this.ALabels_.firstKey());
                this.Min_ = (double)((Double)this.ALabels_.lastKey());
            }
        }
    }

    public void getDecimalSecondLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal) {
        Double tmp;
        this.Calendar_.setTime(epoch0);
        double second0 = (double)this.Calendar_.get(13) + (double)this.Calendar_.get(14) / 1000.0;
        double second1 = second0 + (double)(epoch1.getTime() - epoch0.getTime()) / 1000.0;
        this.getDecimalLabels(second0, second1, max_labels, minimal);
        TreeMap<Object, String> tmp_labels = new TreeMap<Object, String>(this.ALabels_);
        Iterator itr = tmp_labels.keySet().iterator();
        int tmp_minute = -1;
        int tmp_hour = -1;
        long delta_long = epoch1.getTime() - epoch0.getTime();
        double delta_double = second1 - second0;
        this.BLabels_.clear();
        this.ALabels_.clear();
        while (itr.hasNext()) {
            tmp = (Double)itr.next();
            this.Calendar_.setTime(new Date(epoch0.getTime() + StrictMath.round((double)delta_long * ((tmp - second0) / delta_double))));
            if (tmp_hour != this.Calendar_.get(11)) {
                tmp_hour = this.Calendar_.get(11);
                tmp_minute = this.Calendar_.get(12);
                this.SDF_.applyPattern(this.DateFormat_.toString());
                this.BLabels_.put(this.Calendar_.getTime(), this.SDF_.format(this.Calendar_.getTime()));
                this.SDF_.applyPattern("HH:mm:ss.SSS");
                this.ALabels_.put(this.Calendar_.getTime(), this.SDF_.format(this.Calendar_.getTime()));
                continue;
            }
            if (tmp_minute != this.Calendar_.get(12)) {
                tmp_minute = this.Calendar_.get(12);
                this.SDF_.applyPattern("mm:ss.SSS");
                this.ALabels_.put(this.Calendar_.getTime(), this.SDF_.format(this.Calendar_.getTime()));
                continue;
            }
            tmp_minute = this.Calendar_.get(12);
            this.SDF_.applyPattern("ss.SSS");
            this.ALabels_.put(this.Calendar_.getTime(), this.SDF_.format(this.Calendar_.getTime()));
        }
        tmp = (Double)this.Min_;
        this.Min_ = new Date(epoch0.getTime() + StrictMath.round((double)delta_long * ((tmp - second0) / delta_double)));
        tmp = (Double)this.Max_;
        this.Max_ = new Date(epoch0.getTime() + StrictMath.round((double)delta_long * ((tmp - second0) / delta_double)));
    }

    public void getDecimalYearLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal) {
        this.Calendar_.setTime(epoch0);
        double year0 = (double)this.Calendar_.get(1) + (double)(this.Calendar_.get(6) - 1) / (double)this.Calendar_.getActualMaximum(6);
        this.Calendar_.setTime(epoch1);
        double year1 = (double)this.Calendar_.get(1) + (double)(this.Calendar_.get(6) - 1) / (double)this.Calendar_.getActualMaximum(6);
        this.getDecimalLabels(year0, year1, max_labels, minimal);
        this.convertDoublesToDates(epoch0, epoch1, year0, year1);
    }

    public void getHourLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal) {
        this.getTimeLabels(epoch0, epoch1, max_labels, minimal, HourMultiples_, "HH:mm");
    }

    private long getInterval() {
        if (this.ALabels_.size() > 0) {
            long interval = ((Date)this.ALabels_.lastKey()).getTime() - ((Date)this.ALabels_.firstKey()).getTime();
            return (interval > 0L ? interval : -interval) / (long)this.ALabels_.size();
        }
        return 0L;
    }

    public Object getMax() {
        return this.Max_;
    }

    public Object getMin() {
        return this.Min_;
    }

    public void getMinuteLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal) {
        this.getTimeLabels(epoch0, epoch1, max_labels, minimal, MinuteMultiples_, "HH:mm");
    }

    public void getSecondLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal) {
        this.getTimeLabels(epoch0, epoch1, max_labels, minimal, SecondMultiples_, "HH:mm:ss");
    }

    public void getTimeLabels(Date epoch0, Date epoch1, int max_labels, boolean minimal, boolean minor_ticks) {
        long delta = epoch1.getTime() - epoch0.getTime();
        if (delta < 6000L) {
            this.getDecimalSecondLabels(epoch0, epoch1, max_labels, minimal);
        } else if (delta < 180000L) {
            this.getSecondLabels(epoch0, epoch1, max_labels, minimal);
        } else if (delta < 10800000L) {
            this.getMinuteLabels(epoch0, epoch1, max_labels, minimal);
            this.addMinorTimeTicks(epoch0, epoch1, minor_ticks);
        } else if (delta < 259200000L) {
            this.getHourLabels(epoch0, epoch1, max_labels, minimal);
            this.addMinorTimeTicks(epoch0, epoch1, minor_ticks);
        } else {
            this.getDayLabels(epoch0, epoch1, max_labels, minimal);
            this.addMinorTimeTicks(epoch0, epoch1, minor_ticks);
        }
    }

    public String getUnitsPrefix() {
        return this.UnitsPrefix_;
    }

    public void setDateFormat(DateFormat date_format) {
        this.DateFormat_ = date_format;
    }

    public void setLongDateFormat() {
        this.setDateFormat(DateFormat.LONG);
    }

    public void setShortDateFormat() {
        this.setDateFormat(DateFormat.SHORT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateFormat {
        LONG("yyyy-MM-dd"),
        SHORT("yyyy-DDD");

        private final String Name_;

        private DateFormat(String name) {
            this.Name_ = name;
        }

        public String toString() {
            return this.Name_;
        }
    }
}

