/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GPosGui.AutoCompleteField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AutoCompleteDocument
extends PlainDocument {
    protected AttributeSet AS_ = null;
    protected Case Case_ = Case.CaseSensitive;
    protected JTextField Parent_ = null;
    protected List<String> List_ = new ArrayList<String>();
    protected String Default_ = new String();
    protected String Suggestion_ = new String();
    protected boolean Replace_ = false;
    protected int End_ = 0;
    protected int Start_ = 0;

    public AutoCompleteDocument() {
    }

    public AutoCompleteDocument(JTextField parent) {
        this();
        this.Parent_ = parent;
    }

    protected String complete() throws BadLocationException {
        int length = super.getLength();
        this.Suggestion_ = this.complete(super.getText(0, length));
        if (this.Suggestion_ == null) {
            this.setNoMatchColor();
        } else {
            this.setMatchColor();
            if (this.Suggestion_.length() > 0) {
                super.insertString(length, this.Suggestion_, this.AS_);
                Caret caret = this.Parent_.getCaret();
                caret.setDot(length + this.Suggestion_.length());
                caret.moveDot(length);
            }
        }
        return this.Suggestion_;
    }

    protected String complete(String str) {
        switch (this.Case_) {
            case IgnoreCase: {
                return this.completeIgnoreCase(str);
            }
            case LowerCase: {
                return this.completeLowerCase(str);
            }
            case UpperCase: {
                return this.completeUpperCase(str);
            }
        }
        return this.completeCaseSensitive(str);
    }

    protected String completeCaseSensitive(String str) {
        if (str == null || str.length() == 0) {
            return this.Default_;
        }
        if (this.Default_.length() >= str.length() && this.Default_.startsWith(str)) {
            return this.Default_.substring(str.length());
        }
        for (String trial : this.List_) {
            if (trial.length() < str.length() || !trial.startsWith(str)) continue;
            return trial.substring(str.length());
        }
        return null;
    }

    protected String completeIgnoreCase(String str) {
        if (str == null || str.length() == 0) {
            return this.Default_;
        }
        String lc_str = str.toLowerCase();
        if (this.Default_.length() >= lc_str.length() && this.Default_.toLowerCase().startsWith(lc_str.toLowerCase())) {
            return this.Default_.substring(lc_str.length());
        }
        for (String trial : this.List_) {
            if (trial.length() < lc_str.length() || !trial.toLowerCase().startsWith(lc_str)) continue;
            return trial.substring(lc_str.length());
        }
        return null;
    }

    protected String completeLowerCase(String str) {
        if (str == null || str.length() == 0) {
            return this.Default_.toLowerCase();
        }
        String lc_str = str.toLowerCase();
        if (this.Default_.length() >= lc_str.length() && this.Default_.toLowerCase().startsWith(lc_str.toLowerCase())) {
            return this.Default_.substring(lc_str.length()).toLowerCase();
        }
        for (String trial : this.List_) {
            if (trial.length() < lc_str.length() || !trial.toLowerCase().startsWith(lc_str)) continue;
            return trial.substring(lc_str.length()).toLowerCase();
        }
        return null;
    }

    protected String completeUpperCase(String str) {
        if (str == null || str.length() == 0) {
            return this.Default_.toUpperCase();
        }
        String lc_str = str.toUpperCase();
        if (this.Default_.length() >= lc_str.length() && this.Default_.toUpperCase().startsWith(lc_str.toUpperCase())) {
            return this.Default_.substring(lc_str.length()).toUpperCase();
        }
        for (String trial : this.List_) {
            if (trial.length() < lc_str.length() || !trial.toUpperCase().startsWith(lc_str)) continue;
            return trial.substring(lc_str.length()).toUpperCase();
        }
        return null;
    }

    public String getDefault() {
        return this.Default_;
    }

    public List getList() {
        return this.List_;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet as) throws BadLocationException {
        this.AS_ = as;
        switch (this.Case_) {
            case LowerCase: {
                super.insertString(offs, str.toLowerCase(), as);
                break;
            }
            case UpperCase: {
                super.insertString(offs, str.toUpperCase(), as);
                break;
            }
            default: {
                super.insertString(offs, str, as);
            }
        }
        this.complete();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.Replace_) {
            super.remove(offs, len);
        } else {
            if (this.Suggestion_ != null && this.Suggestion_.length() > 0 && this.Suggestion_.equals(super.getText(offs, len)) && offs > 0) {
                --offs;
                ++len;
            }
            super.remove(offs, len);
            this.complete();
        }
    }

    @Override
    public void replace(int offs, int len, String str, AttributeSet as) throws BadLocationException {
        this.Replace_ = true;
        super.replace(offs, len, str, as);
        this.Replace_ = false;
    }

    public void reset() {
        try {
            this.remove(0, super.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setCase(Case input) {
        if (input != null && !this.Case_.equals((Object)input)) {
            this.Case_ = input;
            try {
                Caret caret = this.Parent_.getCaret();
                int dot = caret.getDot() < caret.getMark() ? caret.getDot() : caret.getMark();
                int mark = caret.getDot() > caret.getMark() ? caret.getDot() : caret.getMark();
                switch (this.Case_) {
                    case LowerCase: {
                        super.replace(0, super.getLength(), super.getText(0, super.getLength()).toLowerCase(), this.AS_);
                        break;
                    }
                    case UpperCase: {
                        super.replace(0, super.getLength(), super.getText(0, super.getLength()).toUpperCase(), this.AS_);
                        break;
                    }
                    default: {
                        super.replace(0, super.getLength(), super.getText(0, super.getLength()), this.AS_);
                    }
                }
                caret.setDot(dot);
                caret.moveDot(mark);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setDefault(String str) {
        this.Default_ = str;
    }

    public void setList(List<String> list) {
        Caret caret;
        this.List_.clear();
        if (list != null) {
            Iterator<String> itr = list.iterator();
            while (itr.hasNext()) {
                this.List_.add(itr.next().trim());
            }
        }
        int dot = (caret = this.Parent_.getCaret()).getDot() < caret.getMark() ? caret.getDot() : caret.getMark();
        int length = super.getLength();
        try {
            this.replace(0, length, super.getText(0, dot), this.AS_);
            if (super.getText(0, super.getLength()).length() == 0) {
                this.reset();
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    protected void setMatchColor() {
        if (this.Parent_ instanceof AutoCompleteField) {
            ((AutoCompleteField)this.Parent_).setMatchColor();
        }
    }

    protected void setNoMatchColor() {
        if (this.Parent_ instanceof AutoCompleteField) {
            ((AutoCompleteField)this.Parent_).setNoMatchColor();
        }
    }

    public void setParent(JTextField parent) {
        this.Parent_ = parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Case {
        CaseSensitive,
        IgnoreCase,
        LowerCase,
        UpperCase;

    }
}

