/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GNSS.AntennaId;
import GPosGui.AntennaAutoCompleteField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntennaComboBox
extends JPanel {
    private JButton LaunchMenu_;
    private JPopupMenu PopupMenu_;
    private static final String Blanks_ = "                    ";
    private static final String NullAntenna_ = "NONE            NONE";
    private static final String[] DefaultList_ = new String[]{"NONE            NONE"};
    static final int MaxSubmenuLength_ = 30;
    private ArrayList<JMenuItem> ItemList_ = new ArrayList(DefaultList_.length + 1);
    private ArrayList<JMenu> MenuList_ = new ArrayList(20);
    private Font DefaultFont_;
    private Font Font_ = this.DefaultFont_ = new Font("Monospaced", 0, 12);
    AntennaAutoCompleteField EntryField_;
    private SortedSet<String> AntList_ = new TreeSet<String>();
    private SortedSet<String> ManList_ = new TreeSet<String>();
    private TreeMap<String, JMenu> NameList_ = new TreeMap();
    private int Index_ = 0;

    public AntennaComboBox() {
        this.initComponents();
    }

    private void initComponents() {
        this.PopupMenu_ = new JPopupMenu();
        this.EntryField_ = new AntennaAutoCompleteField(this.NameList_.keySet(), 20);
        this.LaunchMenu_ = new JButton();
        this.createMenus(DefaultList_);
        this.setMinimumSize(new Dimension(24, 24));
        this.setPreferredSize(new Dimension(164, 24));
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(24, 24));
        this.setPreferredSize(new Dimension(170, 24));
        this.EntryField_.setFont(this.Font_);
        this.EntryField_.setUpperCase();
        this.EntryField_.setDefault(NullAntenna_);
        this.EntryField_.reset();
        this.add((Component)this.EntryField_, "Center");
        this.LaunchMenu_.setIcon(new ImageIcon(this.getClass().getResource("/GPosGui/images/DownArrow.gif")));
        this.LaunchMenu_.setMargin(new Insets(2, 2, 2, 2));
        this.LaunchMenu_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AntennaComboBox.this.LaunchMenu_ActionPerformed(evt);
            }
        });
        this.add((Component)this.LaunchMenu_, "East");
    }

    private void LaunchMenu_ActionPerformed(ActionEvent evt) {
        this.PopupMenu_.show(this, this.EntryField_.getBounds().x, this.EntryField_.getBounds().height);
    }

    private void PopupItemActionPerformed(ActionEvent evt) {
        this.EntryField_.setText(((JMenuItem)evt.getSource()).getText());
    }

    public void createMenus(List<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        this.createMenus(array);
    }

    public void createMenus(Set<String> set) {
        String[] array = new String[set.size()];
        set.toArray(array);
        this.createMenus(array);
    }

    public void createMenus(String[] array) {
        JMenuItem item;
        this.ItemList_.clear();
        this.NameList_.clear();
        this.EntryField_.setList(array);
        Iterator<JMenu> itr = this.MenuList_.iterator();
        while (itr.hasNext()) {
            itr.next().removeAll();
        }
        this.MenuList_.clear();
        this.PopupMenu_.removeAll();
        this.ManList_.clear();
        for (String name : array) {
            if (name.length() < 3 || name.substring(0, 3).equalsIgnoreCase(NullAntenna_.substring(0, 3)) || this.ManList_.contains(name.substring(0, 3))) continue;
            this.ManList_.add(name.substring(0, 3));
        }
        JMenu other_menu = new JMenu("Others");
        int other_menu_size = 0;
        for (String man_name : this.ManList_) {
            this.AntList_.clear();
            for (String ant_name : array) {
                if (ant_name.length() < 3 || !ant_name.substring(0, 3).equals(man_name) || this.AntList_.contains(ant_name)) continue;
                this.AntList_.add(ant_name);
            }
            if (this.AntList_.size() == 1) {
                item = new JMenuItem(this.AntList_.first());
                item.setFont(this.Font_);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        AntennaComboBox.this.PopupItemActionPerformed(evt);
                    }
                });
                other_menu.add(item);
                this.ItemList_.add(item);
                this.NameList_.put(this.AntList_.first(), other_menu);
                ++other_menu_size;
                continue;
            }
            JMenu menu = new JMenu(man_name);
            this.MenuList_.add(menu);
            int count = 0;
            Iterator item_itr = this.AntList_.iterator();
            while (item_itr.hasNext()) {
                JMenuItem item2 = new JMenuItem((String)item_itr.next());
                item2.setFont(this.Font_);
                item2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        AntennaComboBox.this.PopupItemActionPerformed(evt);
                    }
                });
                if (count > 0 && count % 30 == 0) {
                    this.PopupMenu_.add(menu);
                    menu = new JMenu(man_name + " (cont)");
                    this.MenuList_.add(menu);
                }
                menu.add(item2);
                this.ItemList_.add(item2);
                this.NameList_.put(item2.getText(), menu);
                ++count;
            }
            this.PopupMenu_.add(menu);
        }
        if (other_menu_size > 0) {
            other_menu.add(new JSeparator());
        }
        item = new JMenuItem(NullAntenna_);
        item.setFont(this.Font_);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AntennaComboBox.this.PopupItemActionPerformed(evt);
            }
        });
        other_menu.add(item);
        this.ItemList_.add(item);
        this.NameList_.put(NullAntenna_, other_menu);
        this.MenuList_.add(other_menu);
        this.PopupMenu_.add(other_menu);
    }

    public String getDefaultAntenna() {
        return this.EntryField_.getDefault();
    }

    public String getIgsAntennaId() {
        return AntennaId.getIgsAntennaId((String)this.EntryField_.getText());
    }

    public String getNullAntenna() {
        return NullAntenna_;
    }

    public String getText() {
        return this.EntryField_.getText();
    }

    public void hideMenu() {
    }

    public void setDefaultAntenna(String str) {
        this.EntryField_.setDefault(str);
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.EntryField_.setEnabled(flag);
        this.LaunchMenu_.setEnabled(flag);
        this.PopupMenu_.setEnabled(flag);
    }

    public void setText(String str) {
        this.EntryField_.setText(str);
    }

    @Override
    public void setToolTipText(String str) {
        super.setToolTipText(str);
        this.EntryField_.setToolTipText(str);
        this.LaunchMenu_.setToolTipText(str);
    }

    public void showMenu(String str) {
    }
}

