/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GPosGui.GPosCaret;
import GPosGui.GPosLabel;
import GPosGui.PopupMenuListener;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;

public class UnitsPopupSpinner
extends JPanel {
    private JSpinner Entry_;
    private JPopupMenu PopupMenu_;
    private GPosCaret Caret_ = new GPosCaret();
    private GPosLabel Units_;
    private MouseListener PopupMenuListener_;
    private String[] StepNames_ = new String[]{"tenths of a unit"};
    private Double[] StepSizes_ = new Double[]{0.1};

    public UnitsPopupSpinner() {
        this.initComponents();
        JFormattedTextField ftf = this.getTextField();
        if (ftf != null) {
            ftf.setCaret(this.Caret_);
        }
    }

    public UnitsPopupSpinner(Double value, String units) {
        this();
        this.Entry_.setValue(value);
        this.Units_.setText(units);
    }

    public UnitsPopupSpinner(double value, String units) {
        this();
        this.Entry_.setValue(value);
        this.Units_.setText(units);
    }

    public UnitsPopupSpinner(Double value, Double step_size, String units) {
        this();
        this.init(value, step_size);
        this.Units_.setText(units);
    }

    public UnitsPopupSpinner(double value, double step_size, String units) {
        this();
        this.init(value, step_size);
        this.Units_.setText(units);
    }

    public UnitsPopupSpinner(Double value, Double minimum, Double maximum, Double step_size, String units) {
        this();
        this.init(value, minimum, maximum, step_size);
        this.Units_.setText(units);
    }

    public UnitsPopupSpinner(double value, double minimum, double maximum, double step_size, String units) {
        this();
        this.init(value, minimum, maximum, step_size);
        this.Units_.setText(units);
    }

    private void initComponents() {
        this.PopupMenu_ = new JPopupMenu();
        this.PopupMenuListener_ = new PopupMenuListener(this.PopupMenu_);
        this.Units_ = new GPosLabel();
        this.Entry_ = new JSpinner();
        this.setLayout(new GridBagLayout());
        this.Units_.setFont(new Font("Monospaced", 1, 12));
        this.Units_.setText("units");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.Units_, gridBagConstraints);
        this.Entry_.setFont(new Font("Monospaced", 0, 12));
        this.Entry_.setModel(new SpinnerNumberModel(new Double(0.0), null, null, new Double(1.0)));
        this.getTextField().setFocusLostBehavior(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.Entry_, gridBagConstraints);
    }

    private void PopupItemActionPerformed(ActionEvent evt) {
        String text = ((JMenuItem)evt.getSource()).getText();
        for (int i = 0; i < this.StepNames_.length; ++i) {
            if (!text.equals(this.StepNames_[i])) continue;
            this.setStepSize(this.StepSizes_[i]);
            break;
        }
    }

    public void commitEdit() throws ParseException {
        this.Entry_.commitEdit();
    }

    public boolean getOverwriteMode() {
        JFormattedTextField ftf = this.getTextField();
        if (ftf != null) {
            return ((DefaultFormatter)ftf.getFormatter()).getOverwriteMode();
        }
        return false;
    }

    public JFormattedTextField getTextField() {
        JComponent editor = this.Entry_.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return null;
    }

    public Double getValue() {
        return (Double)this.Entry_.getValue();
    }

    public void init(Double value, Double step_size) {
        this.Entry_.setModel(new SpinnerNumberModel(value, null, null, step_size));
    }

    public void init(double value, double step_size) {
        this.Entry_.setModel(new SpinnerNumberModel(new Double(value), null, null, new Double(step_size)));
    }

    public void init(Double value, Double minimum, Double maximum, Double step_size) {
        this.Entry_.setModel(new SpinnerNumberModel(value, minimum, maximum, step_size));
    }

    public void init(double value, double minimum, double maximum, double step_size) {
        this.Entry_.setModel(new SpinnerNumberModel(new Double(value), new Double(minimum), new Double(maximum), new Double(step_size)));
    }

    public void setColumns(int columns) {
        this.getTextField().setColumns(columns);
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.Entry_.setEnabled(flag);
        this.Units_.setEnabled(flag);
        JFormattedTextField ftf = this.getTextField();
        MouseListener[] lstnrs = ftf.getMouseListeners();
        if (flag) {
            int i;
            for (i = 0; i < lstnrs.length && !(lstnrs[i] instanceof PopupMenuListener); ++i) {
            }
            if (i == lstnrs.length) {
                ftf.addMouseListener(this.PopupMenuListener_);
            }
        } else {
            for (int i = 0; i < lstnrs.length; ++i) {
                if (!(lstnrs[i] instanceof PopupMenuListener)) continue;
                ftf.removeMouseListener(lstnrs[i]);
            }
        }
    }

    public void setFormat(String format) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.Entry_.getEditor();
        this.Entry_.setEditor(new JSpinner.NumberEditor(this.Entry_, format));
        this.Entry_.setFont(editor.getFont());
        this.setColumns(editor.getTextField().getColumns());
        this.getTextField().addMouseListener(this.PopupMenuListener_);
    }

    public void setFont(Font font) {
        if (font != null && this.Entry_ != null) {
            this.Units_.setFont(new Font(font.getFontName(), font.getSize(), 1));
            this.Entry_.setFont(new Font(font.getFontName(), font.getSize(), 0));
        }
    }

    public void setHorizontalAlignment(int align) {
        this.getTextField().setHorizontalAlignment(align);
    }

    public void setMaximum(Double maximum) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.Entry_.getModel();
        this.Entry_.setModel(new SpinnerNumberModel((Double)model.getValue(), (Double)model.getMinimum(), maximum, (Double)model.getStepSize()));
    }

    public void setMaximum(double maximum) {
        this.setMaximum(new Double(maximum));
    }

    public void setMinimum(Double minimum) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.Entry_.getModel();
        this.Entry_.setModel(new SpinnerNumberModel((Double)model.getValue(), minimum, (Double)model.getMaximum(), (Double)model.getStepSize()));
    }

    public void setMinimum(double minimum) {
        this.setMinimum(new Double(minimum));
    }

    public void setOverwriteMode(boolean mode) {
        JFormattedTextField ftf = this.getTextField();
        if (ftf != null) {
            if (!(ftf.getCaret() instanceof GPosCaret)) {
                ftf.setCaret(this.Caret_);
            }
            ((DefaultFormatter)ftf.getFormatter()).setOverwriteMode(mode);
            ((GPosCaret)ftf.getCaret()).setOverwriteMode(mode);
        }
    }

    public void setStepSize(Double step_size) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.Entry_.getModel();
        this.Entry_.setModel(new SpinnerNumberModel((Double)model.getValue(), (Double)model.getMinimum(), (Double)model.getMaximum(), step_size));
    }

    public void setStepSize(double step_size) {
        this.setStepSize(new Double(step_size));
    }

    public void setSteps(String[] names, Double[] sizes) {
        if (names.length > 0 && names.length == sizes.length) {
            this.StepNames_ = names;
            this.StepSizes_ = sizes;
            this.PopupMenu_.removeAll();
            for (int i = 0; i < names.length; ++i) {
                JMenuItem item = new JMenuItem(names[i]);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        UnitsPopupSpinner.this.PopupItemActionPerformed(evt);
                    }
                });
                this.PopupMenu_.add(item);
            }
        }
    }

    public void setToolTipText(String input) {
        super.setToolTipText(input);
        this.getTextField().setToolTipText(input);
    }

    public void setValue(Double value) {
        this.Entry_.setValue(value);
    }
}

