/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GNSS.Ellipsoid;
import GNSS.GRS80;
import GNSS.Gnss;
import GNSS.OpusFile;
import GNSS.RinexFile;
import GNSS.SeasonalMetModel;
import GPosGui.AntennaComboBox;
import GPosGui.GPosFrame;
import GPosGui.GPosParent;
import GPosGui.LatEntryPanel;
import GPosGui.LonEntryPanel;
import GPosGui.PomPanel;
import GPosGui.RinexObsFileNameField;
import GPosGui.UnitsPopupSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomPanelUsingButtons
extends JPanel {
    private JLabel AntIdLabel_;
    private JPanel BannerPanel_;
    private JPanel ButtonPanel_;
    protected JLabel InitFromOpus_;
    protected JLabel InitFromRinex_;
    protected JLabel InitFromSinex_;
    private JLabel Met1Label_;
    private JLabel Met2Label_;
    private JLabel Met3Label_;
    private JLabel MetLabel_;
    private JButton MetModel_;
    private JLabel Mon1Label_;
    private JLabel Mon2Label_;
    private JLabel Mon3Label_;
    private JLabel MonButton_;
    private JComboBox MonType_;
    private JLabel ObsFileNameLabel_;
    private JLabel Off1Label_;
    private JLabel Off2Label_;
    private JLabel Off3Label_;
    private JLabel OffLabel_;
    private JLabel Title_;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private AntennaComboBox AntIdEntry_;
    protected Color BannerBackground_ = UIManager.getDefaults().getColor("Panel.foreground");
    protected Color BannerForeground_ = UIManager.getDefaults().getColor("Panel.background");
    private Ellipsoid Ellipsoid_ = new GRS80();
    private GPosFrame Parent_ = null;
    private JLabel InitSource_ = null;
    private LatEntryPanel LatField_;
    private LonEntryPanel LonField_;
    private MouseListener PopupMenuListener_;
    private OpusFile OpusFile_;
    private PomPanel OtherPomPanel_;
    private RinexFile CurrentFile_ = new RinexFile();
    private SpecialFileNameField ObsFileNameField_;
    private String ChooserTitle_ = "Select a RINEX Obs (\"O\") File";
    private String InitialTitle_ = "STATION";
    private UnitsPopupSpinner HgtField_;
    private UnitsPopupSpinner Met1Field_;
    private UnitsPopupSpinner Met2Field_;
    private UnitsPopupSpinner Met3Field_;
    private UnitsPopupSpinner MonXField_;
    private UnitsPopupSpinner MonYField_;
    private UnitsPopupSpinner MonZField_;
    private UnitsPopupSpinner Off1Field_;
    private UnitsPopupSpinner Off2Field_;
    private UnitsPopupSpinner Off3Field_;
    private boolean AutoEnableFlag_ = false;
    private boolean InitFromRinexHeaderEveryTime_ = false;
    private boolean InitFromRinexHeaderFirstTime_ = false;
    private boolean Initialized_ = false;
    private int CoordinateFormat_;
    private int LonDisplay_ = 0;
    public static final int AUTO_LON = 0;
    public static final int EAST_LON = 1;
    public static final int WEST_LON = -1;
    public static final int PLH_FORMAT = 1;
    public static final int XYZ_FORMAT = 0;

    public PomPanelUsingButtons() {
        this.initComponents();
    }

    public PomPanelUsingButtons(String title) {
        this.initComponents();
        this.setTitle(title);
        this.InitialTitle_ = title;
    }

    public PomPanelUsingButtons(GPosFrame parent) {
        this.Parent_ = parent;
        this.BannerBackground_ = GPosParent.GPosBlue;
        this.BannerForeground_ = GPosParent.GPosSilver;
        this.initComponents();
    }

    public PomPanelUsingButtons(GPosFrame parent, String title) {
        this.Parent_ = parent;
        this.InitialTitle_ = title;
        this.BannerBackground_ = GPosParent.GPosBlue;
        this.BannerForeground_ = GPosParent.GPosSilver;
        this.initComponents();
        this.setTitle(title);
    }

    private void initComponents() {
        this.BannerPanel_ = new JPanel();
        this.Title_ = new JLabel();
        this.ButtonPanel_ = new JPanel();
        this.InitFromRinex_ = new JLabel();
        this.InitFromSinex_ = new JLabel();
        this.InitFromOpus_ = new JLabel();
        this.jPanel1 = new JPanel();
        this.ObsFileNameLabel_ = new JLabel();
        this.ObsFileNameField_ = new SpecialFileNameField(this.Parent_);
        this.ObsFileNameField_.setMustExistFlag(true);
        this.ObsFileNameField_.setEmptyIsOkFlag(false);
        this.ObsFileNameField_.setDirTag("WORK");
        this.AntIdLabel_ = new JLabel();
        this.AntIdEntry_ = new AntennaComboBox();
        this.jPanel2 = new JPanel();
        this.MonButton_ = new JLabel();
        this.MonType_ = new JComboBox();
        this.Mon1Label_ = new JLabel();
        String[] names = new String[]{"meters", "decimeters", "centimeters", "millimeters"};
        Double[] sizes = new Double[]{1.0, 0.1, 0.01, 0.001};
        this.MonXField_ = new UnitsPopupSpinner(1115064.1336, 0.001, "m");
        this.MonXField_.setFormat("0.0000");
        this.MonXField_.setColumns(14);
        this.MonXField_.setSteps(names, sizes);
        this.LatField_ = new LatEntryPanel();
        this.Mon2Label_ = new JLabel();
        this.MonYField_ = new UnitsPopupSpinner(-4843968.4793, 0.001, "m");
        this.MonYField_.setFormat("0.0000");
        this.MonYField_.setColumns(14);
        this.MonYField_.setSteps(names, sizes);
        this.LonField_ = new LonEntryPanel();
        this.Mon3Label_ = new JLabel();
        this.MonZField_ = new UnitsPopupSpinner(3983266.0464, 0.001, "m");
        this.MonZField_.setFormat("0.0000");
        this.MonZField_.setColumns(14);
        this.MonZField_.setSteps(names, sizes);
        this.HgtField_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.HgtField_.setFormat("0.0000");
        this.HgtField_.setColumns(10);
        this.HgtField_.setSteps(names, sizes);
        this.OffLabel_ = new JLabel();
        this.Off1Label_ = new JLabel();
        this.Off1Field_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.Off1Field_.setFormat("0.0000");
        this.Off1Field_.setColumns(10);
        this.Off1Field_.setSteps(names, sizes);
        this.Off2Label_ = new JLabel();
        this.Off2Field_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.Off2Field_.setFormat("0.0000");
        this.Off2Field_.setColumns(10);
        this.Off2Field_.setSteps(names, sizes);
        this.Off3Label_ = new JLabel();
        this.Off3Field_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.Off3Field_.setFormat("0.0000");
        this.Off3Field_.setColumns(10);
        this.Off3Field_.setSteps(names, sizes);
        this.MetLabel_ = new JLabel();
        this.MetModel_ = new JButton();
        this.Met1Label_ = new JLabel();
        String[] names1 = new String[]{"tenths of a degree C"};
        Double[] sizes1 = new Double[]{0.1};
        this.Met1Field_ = new UnitsPopupSpinner((Double)22.1444, (Double)-273.15, null, (Double)0.1, "<html><font size=+1>&#176;</font>C</html>");
        this.Met1Field_.setFormat("0.0");
        this.Met1Field_.setColumns(6);
        this.Met1Field_.setSteps(names1, sizes1);
        this.Met2Label_ = new JLabel();
        String[] names2 = new String[]{"tenths of a millibar"};
        this.Met2Field_ = new UnitsPopupSpinner((Double)996.0965, (Double)0.0, null, (Double)0.1, "mbar");
        this.Met2Field_.setFormat("0.0");
        this.Met2Field_.setColumns(6);
        this.Met2Field_.setSteps(names2, sizes1);
        this.Met3Label_ = new JLabel();
        String[] names3 = new String[]{"tenths of a percent"};
        this.Met3Field_ = new UnitsPopupSpinner(50.0, 0.0, 100.0, 0.1, "%");
        this.Met3Field_.setFormat("0.0");
        this.Met3Field_.setColumns(6);
        this.Met3Field_.setSteps(names3, sizes1);
        this.setLayout(new GridBagLayout());
        this.setFocusable(false);
        this.BannerPanel_.setLayout(new GridBagLayout());
        this.BannerPanel_.setBackground(this.BannerBackground_);
        this.BannerPanel_.setForeground(this.BannerForeground_);
        this.Title_.setBackground(this.BannerPanel_.getBackground());
        this.Title_.setForeground(this.BannerPanel_.getForeground());
        this.Title_.setText(" STATION ");
        this.Title_.setFocusable(false);
        this.Title_.setHorizontalTextPosition(0);
        this.Title_.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.BannerPanel_.add((Component)this.Title_, gridBagConstraints);
        this.ButtonPanel_.setLayout(new GridLayout(1, 0, 1, 0));
        this.ButtonPanel_.setBackground(UIManager.getDefaults().getColor("Panel.foreground"));
        this.ButtonPanel_.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.InitFromRinex_.setBackground(UIManager.getDefaults().getColor("Panel.foreground"));
        this.InitFromRinex_.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.InitFromRinex_.setHorizontalAlignment(0);
        this.InitFromRinex_.setText(" RINEX ");
        this.InitFromRinex_.setBorder(new SoftBevelBorder(0));
        this.InitFromRinex_.setEnabled(false);
        this.InitFromRinex_.setOpaque(true);
        this.InitFromRinex_.setForeground(this.BannerForeground_);
        this.InitFromRinex_.setBackground(this.BannerBackground_);
        this.InitFromRinex_.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PomPanelUsingButtons.this.InitButtonsMouseReleased(evt);
            }
        });
        this.ButtonPanel_.add(this.InitFromRinex_);
        this.InitFromSinex_.setBackground(UIManager.getDefaults().getColor("Panel.foreground"));
        this.InitFromSinex_.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.InitFromSinex_.setHorizontalAlignment(0);
        this.InitFromSinex_.setText(" SINEX ");
        this.InitFromSinex_.setBorder(new SoftBevelBorder(0));
        this.InitFromSinex_.setOpaque(true);
        this.InitFromSinex_.setForeground(this.BannerForeground_);
        this.InitFromSinex_.setBackground(this.BannerBackground_);
        this.InitFromSinex_.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PomPanelUsingButtons.this.InitButtonsMouseReleased(evt);
            }
        });
        this.ButtonPanel_.add(this.InitFromSinex_);
        this.InitFromOpus_.setBackground(UIManager.getDefaults().getColor("Panel.foreground"));
        this.InitFromOpus_.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.InitFromOpus_.setHorizontalAlignment(0);
        this.InitFromOpus_.setText(" OPUS ");
        this.InitFromOpus_.setBorder(new SoftBevelBorder(0));
        this.InitFromOpus_.setOpaque(true);
        this.InitFromOpus_.setForeground(this.BannerForeground_);
        this.InitFromOpus_.setBackground(this.BannerBackground_);
        this.InitFromOpus_.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PomPanelUsingButtons.this.InitButtonsMouseReleased(evt);
            }
        });
        this.ButtonPanel_.add(this.InitFromOpus_);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.BannerPanel_.add((Component)this.ButtonPanel_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.BannerPanel_, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.ObsFileNameLabel_.setLabelFor(this.ObsFileNameField_);
        this.ObsFileNameField_.setToolTipText("Enter the RINEX observation (\"o\") file name.");
        this.ObsFileNameField_.setBackgroundToError();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.ObsFileNameField_, gridBagConstraints);
        this.ObsFileNameLabel_.setText(this.i18nString("ObsFileNameLabel", "RINEX Obs File:"));
        this.ObsFileNameLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.ObsFileNameLabel_, gridBagConstraints);
        this.AntIdLabel_.setLabelFor(this.AntIdEntry_);
        this.AntIdEntry_.setToolTipText("Enter a standard IGS antenna ID.");
        this.AntIdEntry_.setMinimumSize(new Dimension(170, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.AntIdEntry_, gridBagConstraints);
        this.AntIdLabel_.setText(this.i18nString("AntIdLabel", "Antenna:"));
        this.AntIdLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.AntIdLabel_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.MonButton_.setText(this.i18nString("MonLabel", "Monument:"));
        this.MonButton_.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonButton_, gridBagConstraints);
        this.MonType_.removeAllItems();
        for (Gnss.COORDINATE crd : Gnss.COORDINATE.values()) {
            this.MonType_.addItem(crd.toString());
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonType_, gridBagConstraints);
        this.MonXField_.setToolTipText("<html>Monument X coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonXField_, gridBagConstraints);
        this.LatField_.setToolTipText("<html>Monument latitude in degrees, minutes, seconds.");
        this.Mon1Label_.setText("X");
        this.Mon1Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon1Label_, gridBagConstraints);
        this.MonYField_.setToolTipText("<html>Monument Y coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonYField_, gridBagConstraints);
        this.LonField_.setToolTipText("<html>Monument longitude in degrees, minutes, seconds.");
        this.Mon2Label_.setText("Y");
        this.Mon2Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon2Label_, gridBagConstraints);
        this.MonZField_.setToolTipText("<html>Monument Z coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonZField_, gridBagConstraints);
        this.HgtField_.setToolTipText("<html>Monument ellipsoidal height in meters.<br>Right-click on the field to set the step size.</html>");
        this.Mon3Label_.setText("Z");
        this.Mon3Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon3Label_, gridBagConstraints);
        this.OffLabel_.setText(this.i18nString("OffLabel", "Mon \u2192 ARP:"));
        this.OffLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.OffLabel_, gridBagConstraints);
        this.Off1Field_.setToolTipText("<html>North offset in meters.<br>Right-click on the field<br>to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Off1Field_, gridBagConstraints);
        this.Off1Label_.setText("H");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Off1Label_, gridBagConstraints);
        this.Off2Field_.setToolTipText("<html>East offset in meters.<br>Right-click on the field<br>to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Off2Field_, gridBagConstraints);
        this.Off2Label_.setText("E");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Off2Label_, gridBagConstraints);
        this.Off3Field_.setToolTipText("<html>Up offset in meters.<br>Right-click on the field<br>to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Off3Field_, gridBagConstraints);
        this.Off3Label_.setText("N");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Off3Label_, gridBagConstraints);
        this.MetLabel_.setText(this.i18nString("MetLabel", "Surface Met:"));
        this.MetLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MetLabel_, gridBagConstraints);
        this.MetModel_.setText(this.i18nString("MetModelLabel", "Model"));
        this.MetModel_.setToolTipText(this.i18nString("MetModelToolTip", "Apply a surface meteorological model."));
        this.MetModel_.setMargin(new Insets(2, 2, 2, 2));
        this.MetModel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PomPanelUsingButtons.this.MetModel_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MetModel_, gridBagConstraints);
        this.Met1Field_.setToolTipText("Air temperature in degrees Celsius.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Met1Field_, gridBagConstraints);
        this.Met1Label_.setText("T");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Met1Label_, gridBagConstraints);
        this.Met2Field_.setToolTipText("Barometric pressure in millibars.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Met2Field_, gridBagConstraints);
        this.Met2Label_.setText("P");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Met2Label_, gridBagConstraints);
        this.Met3Field_.setToolTipText("Relative humidity as a percent of saturation.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Met3Field_, gridBagConstraints);
        this.Met3Label_.setText("RH");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Met3Label_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void MetModel_ActionPerformed(ActionEvent evt) {
        this.applyMetModel();
    }

    protected JLabel addInitializationButton(JLabel button, boolean enabled) {
        this.ButtonPanel_.add(button);
        button.setEnabled(enabled);
        return button;
    }

    protected JLabel addInitializationButton(String text, boolean enabled) {
        JLabel button = this.makeButton(text, enabled);
        this.ButtonPanel_.add(button);
        return button;
    }

    protected void InitButtonsMouseReleased(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
        if (button == this.InitFromRinex_) {
            this.applyValuesFromRinexHeader();
            this.setInitSource(button);
        } else if (button != this.InitFromSinex_ && button == this.InitFromOpus_) {
            this.selectOpusFile();
            this.setInitSource(button);
        }
    }

    private void applyMetModel() {
        boolean flag;
        Date epoch = new Date();
        if (this.ObsFileNameField_.isOk()) {
            RinexFile file = this.ObsFileNameField_.getRinexFile();
            if (file.has("FIRST_TIME")) {
                epoch = (Date)file.get("FIRST_TIME");
                flag = true;
            } else {
                int n = JOptionPane.showConfirmDialog(this, this.i18nString("RinexTOFWarning", "The RINEX file did not contain a \"TIME OF FIRST OBS\" record.\n") + this.i18nString("UseCurrentTime", "Use the current time?"), this.i18nString("ApplyMetModel", "Apply Met Model"), 0, 0);
                flag = n == 0;
            }
        } else {
            int n = JOptionPane.showConfirmDialog(this, this.i18nString("RinexNotEntered", "A RINEX obs file has not been entered.\n") + this.i18nString("UseCurrentTime", "Use the current time?"), this.i18nString("ApplyMetModel", "Apply Met Model"), 0, 2);
            flag = n == 0;
        }
        if (flag) {
            this.setValuesFromMetModel(epoch);
        }
    }

    protected String applyValuesFromRinexHeader() {
        if (this.ObsFileNameField_.isOk()) {
            String name;
            this.setInitSource(this.InitFromRinex_);
            boolean flag = true;
            String msg = this.i18nString("RinexDidNotContain", "The RINEX obs file did not contain:");
            RinexFile file = this.ObsFileNameField_.getRinexFile();
            if (file.has("ANT_TYPE")) {
                if (((String)file.get("ANT_TYPE")).trim().length() > 0) {
                    this.set(FIELD.ANTENNA, (String)file.get("ANT_TYPE"));
                } else {
                    flag = false;
                    msg = msg.concat("\n  " + this.i18nString("AnAntennaType", "an antenna type"));
                }
            } else {
                flag = false;
                msg = msg.concat("\n  \"ANT # / TYPE\"");
            }
            if (file.has("APP_POS_X")) {
                this.set(FIELD.MONUMENT_FRAME, Gnss.COORDINATE.WGS84G1150);
                this.set(FIELD.MONUMENT_X, (Double)file.get("APP_POS_X"));
                this.set(FIELD.MONUMENT_Y, (Double)file.get("APP_POS_Y"));
                this.set(FIELD.MONUMENT_Z, (Double)file.get("APP_POS_Z"));
            } else {
                flag = false;
                msg = msg.concat("\n  \"APPROX POSITION XYZ\"");
            }
            if (file.has("ANT_DEL_E")) {
                this.set(FIELD.OFFSET_1, (Double)file.get("ANT_DEL_H"));
                this.set(FIELD.OFFSET_2, (Double)file.get("ANT_DEL_E"));
                this.set(FIELD.OFFSET_3, (Double)file.get("ANT_DEL_N"));
            } else {
                flag = false;
                msg = msg.concat("\n  \"ANTENNA: DELTA H/E/N\"");
            }
            if (!file.has("FIRST_TIME")) {
                flag = false;
                msg = msg.concat("\n  \"TIME OF FIRST OBS\"");
            }
            if (file.has("MARKER_NAME") && (name = ((String)file.get("MARKER_NAME")).trim()).length() > 0) {
                this.setTitle(this.InitialTitle_ + " (" + name + ")");
            }
            if (flag) {
                return "";
            }
            return msg.concat("\n" + this.i18nString("ValuesNotSet", "The associated values have not been set."));
        }
        return "";
    }

    protected void applyValuesFromOpus() {
        if (this.OpusFile_.getIos() == 0) {
            this.setInitSource(this.InitFromOpus_);
            boolean flag = true;
            String msg = this.i18nString("OpusDidNotContain", "The OPUS report did not contain:");
            if (this.OpusFile_.has("REF_FRAME") && this.OpusFile_.has("POS_X") && this.OpusFile_.has("POS_Y") && this.OpusFile_.has("POS_Z")) {
                this.set(FIELD.MONUMENT_FRAME, Gnss.COORDINATE.ITRF05);
                this.set(FIELD.MONUMENT_X, (Double)this.OpusFile_.get(OpusFile.Fields.POS_X));
                this.set(FIELD.MONUMENT_Y, (Double)this.OpusFile_.get(OpusFile.Fields.POS_Y));
                this.set(FIELD.MONUMENT_Z, (Double)this.OpusFile_.get(OpusFile.Fields.POS_Z));
            } else {
                flag = false;
                msg = msg.concat("\n  " + this.i18nString("Coordiantes", "coordinates"));
            }
            if (this.OpusFile_.has("ANT_TYPE")) {
                this.set(FIELD.ANTENNA, (String)this.OpusFile_.get(OpusFile.Fields.ANT_TYPE));
            } else {
                flag = false;
                msg = msg.concat("\n  " + this.i18nString("AntennaType", "antenna type"));
            }
            if (this.OpusFile_.has("ANT_DEL_N") && this.OpusFile_.has("ANT_DEL_E") && this.OpusFile_.has("ANT_DEL_H")) {
                this.set(FIELD.OFFSET_1, (Double)this.OpusFile_.get(OpusFile.Fields.ANT_DEL_H));
                this.set(FIELD.OFFSET_2, (Double)this.OpusFile_.get(OpusFile.Fields.ANT_DEL_E));
                this.set(FIELD.OFFSET_3, (Double)this.OpusFile_.get(OpusFile.Fields.ANT_DEL_N));
            } else {
                flag = false;
                msg = msg.concat("\n  " + this.i18nString("AntennaOffset", "antenna offset"));
            }
            if (!flag) {
                JOptionPane.showMessageDialog(this, msg, this.i18nString("ApplyValuesFromOpus", "Apply Values From OPUS"), 0);
            }
            this.applyMetModel();
        } else {
            JOptionPane.showMessageDialog(this, this.OpusFile_.getStatus(), this.i18nString("ApplyValuesFromOpus", "Apply Values From OPUS"), 0);
        }
    }

    public void doOnSettingFileName(boolean flag) {
        if (this.InitFromRinex_ != null) {
            if (flag) {
                if (this.AutoEnableFlag_) {
                    this.setEnabled(true);
                } else {
                    this.InitFromRinex_.setEnabled(true);
                    this.InitFromSinex_.setEnabled(true);
                    this.InitFromOpus_.setEnabled(true);
                }
                if (this.InitFromRinexHeaderEveryTime_ || this.InitFromRinexHeaderFirstTime_ && !this.Initialized_) {
                    String msg = this.applyValuesFromRinexHeader();
                    if (msg.length() > 0) {
                        JOptionPane.showMessageDialog(this.Parent_, msg, this.i18nString("MissingRinexHeaderInfo", "Missing RINEX Header Info"), 2);
                    }
                    if (this.ObsFileNameField_.getRinexFile().has("FIRST_TIME")) {
                        this.setValuesFromMetModel((Date)this.ObsFileNameField_.getRinexFile().get("FIRST_TIME"));
                    } else {
                        this.setValuesFromMetModel(new Date());
                    }
                }
            } else if (this.AutoEnableFlag_) {
                this.setEnabled(false);
                this.setEnabled("FILE_NAME", true);
            } else {
                this.InitFromRinex_.setEnabled(false);
                this.InitFromSinex_.setEnabled(false);
                this.InitFromOpus_.setEnabled(false);
            }
        }
    }

    public Object get(FIELD field) {
        if (field == FIELD.FILE) {
            return this.ObsFileNameField_.getRinexFile();
        }
        if (field == FIELD.FILE_NAME) {
            return this.ObsFileNameField_.getText();
        }
        if (field == FIELD.ANTENNA) {
            return this.AntIdEntry_.getText();
        }
        if (field == FIELD.INTERVAL) {
            return this.ObsFileNameField_.getRinexFile().get("INTERVAL");
        }
        if (field == FIELD.MONUMENT_FRAME) {
            return Gnss.COORDINATE.fromString((String)((String)this.MonType_.getSelectedItem()));
        }
        if (field == FIELD.MONUMENT_X) {
            return this.MonXField_.getValue();
        }
        if (field == FIELD.MONUMENT_Y) {
            return this.MonYField_.getValue();
        }
        if (field == FIELD.MONUMENT_Z) {
            return this.MonZField_.getValue();
        }
        if (field == FIELD.OFFSET_1) {
            return this.Off1Field_.getValue();
        }
        if (field == FIELD.OFFSET_2) {
            return this.Off2Field_.getValue();
        }
        if (field == FIELD.OFFSET_3) {
            return this.Off3Field_.getValue();
        }
        if (field == FIELD.OFFSET_TYPE) {
            return Gnss.OFFSET.HEN;
        }
        if (field == FIELD.PRESSURE) {
            return this.Met2Field_.getValue();
        }
        if (field == FIELD.RELATIVE_HUMIDITY) {
            return this.Met3Field_.getValue();
        }
        if (field == FIELD.START_TIME) {
            return this.ObsFileNameField_.getRinexFile().readTimeOfFirstEpoch();
        }
        if (field == FIELD.STOP_TIME) {
            return this.ObsFileNameField_.getRinexFile().readTimeOfLastEpoch();
        }
        if (field == FIELD.TEMPERATURE) {
            return this.Met1Field_.getValue();
        }
        return null;
    }

    protected JLabel getInitSource() {
        return this.InitSource_;
    }

    public String getRnxFileName() {
        return this.CurrentFile_.getCanonicalPath();
    }

    public String getTitle() {
        return this.Title_.getText();
    }

    public Dimension getTitleSize() {
        return this.Title_.getPreferredSize();
    }

    public boolean isOk() {
        return this.ObsFileNameField_.isOk();
    }

    protected JLabel makeButton(String text, boolean enabled) {
        JLabel button = new JLabel();
        button.setHorizontalAlignment(0);
        button.setText(text);
        button.setBorder(new SoftBevelBorder(0));
        button.setForeground(this.BannerForeground_);
        button.setBackground(this.BannerBackground_);
        button.setOpaque(true);
        button.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PomPanelUsingButtons.this.InitButtonsMouseReleased(evt);
            }
        });
        button.setEnabled(enabled);
        return button;
    }

    protected void reset() {
        if (this.InitSource_ == this.InitFromRinex_) {
            this.applyValuesFromRinexHeader();
        } else if (this.InitSource_ == this.InitFromSinex_ || this.InitSource_ == this.InitFromOpus_) {
            // empty if block
        }
    }

    protected void selectOpusFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(this.i18nString("SelectOpusReportFile", "Select The OPUS Report File"));
        if (this.OpusFile_ != null && this.OpusFile_.getIos() == 0) {
            chooser.setCurrentDirectory(this.OpusFile_.getFile().getParentFile());
        } else if (this.Parent_ != null) {
            chooser.setCurrentDirectory(new File(this.Parent_.getPath("WORK")));
        }
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            try {
                this.OpusFile_ = new OpusFile(chooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                this.OpusFile_ = new OpusFile(chooser.getSelectedFile().getAbsolutePath());
            }
            this.applyValuesFromOpus();
        }
    }

    public void set(FIELD field, Object value) {
        block35: {
            if (field == FIELD.FILE) {
                try {
                    if (value instanceof File) {
                        this.ObsFileNameField_.setText(((File)value).getCanonicalPath());
                        this.Initialized_ = true;
                    } else if (value instanceof RinexFile) {
                        this.ObsFileNameField_.setText(((RinexFile)value).getCanonicalPath());
                        this.Initialized_ = true;
                    }
                    break block35;
                }
                catch (IOException ex) {
                    if (value instanceof File) {
                        this.ObsFileNameField_.setText(((File)value).getAbsolutePath());
                        this.Initialized_ = true;
                    } else if (value instanceof RinexFile) {
                        this.ObsFileNameField_.setText(((RinexFile)value).getAbsolutePath());
                        this.Initialized_ = true;
                    }
                    break block35;
                }
            }
            if (field == FIELD.FILE_NAME) {
                this.ObsFileNameField_.setText((String)value);
                this.Initialized_ = true;
            } else if (field == FIELD.ANTENNA) {
                this.AntIdEntry_.setText((String)value);
                this.Initialized_ = true;
            } else if (field == FIELD.MONUMENT_FRAME) {
                this.MonType_.setSelectedItem(((Gnss.COORDINATE)value).toString());
                this.Initialized_ = true;
            } else if (field == FIELD.MONUMENT_X) {
                this.MonXField_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field == FIELD.MONUMENT_Y) {
                this.MonYField_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field == FIELD.MONUMENT_Z) {
                this.MonZField_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field == FIELD.OFFSET_1) {
                this.Off1Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field == FIELD.OFFSET_2) {
                this.Off2Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field == FIELD.OFFSET_3) {
                this.Off3Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field != FIELD.OFFSET_TYPE) {
                if (field == FIELD.TEMPERATURE) {
                    this.Met1Field_.setValue((Double)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.PRESSURE) {
                    this.Met2Field_.setValue((Double)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.RELATIVE_HUMIDITY) {
                    this.Met3Field_.setValue((Double)value);
                    this.Initialized_ = true;
                } else if (field == FIELD.LINK) {
                    this.OtherPomPanel_ = (PomPanel)value;
                }
            }
        }
    }

    public void setAntennaIdList(Set<String> set) {
        this.AntIdEntry_.createMenus(set);
    }

    public void setAntennaIdList(String[] array) {
        this.AntIdEntry_.createMenus(array);
    }

    public void setAutoEnableFlag(boolean flag) {
        this.AutoEnableFlag_ = flag;
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.InitFromRinex_.setEnabled(flag);
        this.InitFromSinex_.setEnabled(flag);
        this.InitFromOpus_.setEnabled(flag);
        this.LatField_.setEnabled(flag);
        this.LonField_.setEnabled(flag);
        this.HgtField_.setEnabled(flag);
        this.MetLabel_.setEnabled(flag);
        this.MetModel_.setEnabled(flag);
        this.OffLabel_.setEnabled(flag);
        this.MonButton_.setEnabled(flag);
        this.ObsFileNameLabel_.setEnabled(flag);
        this.ObsFileNameField_.setEnabled(flag);
        this.AntIdLabel_.setEnabled(flag);
        this.AntIdEntry_.setEnabled(flag);
        this.MonType_.setEnabled(flag);
        this.Mon1Label_.setEnabled(flag);
        this.MonXField_.setEnabled(flag);
        this.Mon2Label_.setEnabled(flag);
        this.MonYField_.setEnabled(flag);
        this.Mon3Label_.setEnabled(flag);
        this.MonZField_.setEnabled(flag);
        this.Off1Label_.setEnabled(flag);
        this.Off1Field_.setEnabled(flag);
        this.Off2Label_.setEnabled(flag);
        this.Off2Field_.setEnabled(flag);
        this.Off3Label_.setEnabled(flag);
        this.Off3Field_.setEnabled(flag);
        this.Met1Label_.setEnabled(flag);
        this.Met1Field_.setEnabled(flag);
        this.Met2Label_.setEnabled(flag);
        this.Met2Field_.setEnabled(flag);
        this.Met3Label_.setEnabled(flag);
        this.Met3Field_.setEnabled(flag);
    }

    public void setEnabled(String field, boolean flag) {
        if (field.equals("INIT_RINEX")) {
            this.InitFromRinex_.setEnabled(flag);
        } else if (field.equals("INIT_SINEX")) {
            this.InitFromSinex_.setEnabled(flag);
        } else if (field.equals("INIT_OPUS")) {
            this.InitFromOpus_.setEnabled(flag);
        } else if (field.equals("FILE_NAME")) {
            this.ObsFileNameLabel_.setEnabled(flag);
            this.ObsFileNameField_.setEnabled(flag);
        } else if (field.equals("ANT_TYPE")) {
            this.AntIdLabel_.setEnabled(flag);
            this.AntIdEntry_.setEnabled(flag);
        } else if (field.equals("POS_TYPE")) {
            this.MonType_.setEnabled(flag);
        } else if (field.equals("POS_X")) {
            this.Mon1Label_.setEnabled(flag);
            this.MonXField_.setEnabled(flag);
        } else if (field.equals("POS_Y")) {
            this.Mon2Label_.setEnabled(flag);
            this.MonYField_.setEnabled(flag);
        } else if (field.equals("POS_Z")) {
            this.Mon3Label_.setEnabled(flag);
            this.MonZField_.setEnabled(flag);
        } else if (field.equals("ANT_DEL_N")) {
            this.Off1Label_.setEnabled(flag);
            this.Off1Field_.setEnabled(flag);
        } else if (field.equals("ANT_DEL_E")) {
            this.Off2Label_.setEnabled(flag);
            this.Off2Field_.setEnabled(flag);
        } else if (field.equals("ANT_DEL_H")) {
            this.Off3Label_.setEnabled(flag);
            this.Off3Field_.setEnabled(flag);
        } else if (field.equals("MET_T")) {
            this.Met1Label_.setEnabled(flag);
            this.Met1Field_.setEnabled(flag);
        } else if (field.equals("MET_P")) {
            this.Met2Label_.setEnabled(flag);
            this.Met2Field_.setEnabled(flag);
        } else if (field.equals("MET_RH")) {
            this.Met3Label_.setEnabled(flag);
            this.Met3Field_.setEnabled(flag);
        }
    }

    public void setInitFromRinexHeaderEveryTime(boolean flag) {
        this.InitFromRinexHeaderEveryTime_ = flag;
    }

    public void setInitFromRinexHeaderFirstTime(boolean flag) {
        this.InitFromRinexHeaderFirstTime_ = flag;
    }

    protected void setInitSource(JLabel item) {
        if (item != this.InitSource_) {
            if (this.InitSource_ != null) {
                this.InitSource_.setBackground(this.BannerBackground_);
                this.InitSource_.setForeground(this.BannerForeground_);
            }
            item.setBackground(this.BannerForeground_);
            item.setForeground(this.BannerBackground_);
            this.InitSource_ = item;
        }
    }

    public void setLonDisplay(int input) {
        this.LonDisplay_ = input;
    }

    public void setLink(PomPanel other) {
        this.OtherPomPanel_ = other;
    }

    public void setTitle(String input) {
        this.Title_.setText(" " + input.trim() + " ");
    }

    public void setTitleSize(Dimension size) {
        this.Title_.setSize(size);
    }

    public void setTitleSize(int width, int height) {
        this.Title_.setSize(width, height);
        this.Title_.setPreferredSize(new Dimension(width, height));
        this.Title_.setMinimumSize(new Dimension(width, height));
    }

    private void setValuesFromMetModel(Date epoch) {
        Double[] plh = this.Ellipsoid_.toPlh((Double)this.get(FIELD.MONUMENT_X), (Double)this.get(FIELD.MONUMENT_Y), (Double)this.get(FIELD.MONUMENT_Z));
        this.set(FIELD.PRESSURE, SeasonalMetModel.getP((Date)epoch, (Double)plh[0], (Double)plh[2]));
        this.set(FIELD.RELATIVE_HUMIDITY, 100.0 * SeasonalMetModel.getRH((Date)epoch, (Double)plh[0], (Double)plh[2]));
        this.set(FIELD.TEMPERATURE, SeasonalMetModel.getT((Date)epoch, (Double)plh[0], (Double)plh[2]));
    }

    public String i18nString(String name, String alt) {
        return this.Parent_ != null ? this.Parent_.i18nString(name, alt) : alt;
    }

    public class SpecialFileNameField
    extends RinexObsFileNameField {
        public SpecialFileNameField(GPosFrame parent) {
            super(parent);
        }

        public void setText(File input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath("WORK", super.getRinexFile().getCanonicalPath());
            }
            PomPanelUsingButtons.this.doOnSettingFileName(this.isOk());
        }

        public void setText(String input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath("WORK", super.getRinexFile().getCanonicalPath());
            }
            PomPanelUsingButtons.this.doOnSettingFileName(this.isOk());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FIELD {
        ANTENNA,
        FILE,
        FILE_NAME,
        INTERVAL,
        LINK,
        MONUMENT_FRAME,
        MONUMENT_X,
        MONUMENT_Y,
        MONUMENT_Z,
        OFFSET_1,
        OFFSET_2,
        OFFSET_3,
        OFFSET_TYPE,
        PRESSURE,
        RELATIVE_HUMIDITY,
        START_TIME,
        START_TIME_FRAME,
        STOP_TIME,
        STOP_TIME_FRAME,
        TEMPERATURE;

    }
}

