/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GNSS.Ellipsoid;
import GNSS.GRS80;
import GNSS.PomFile;
import GNSS.RinexFile;
import GNSS.SeasonalMetModel;
import GPosGui.AntennaComboBox;
import GPosGui.GPosFrame;
import GPosGui.LatEntryPanel;
import GPosGui.LonEntryPanel;
import GPosGui.PomFileFilter;
import GPosGui.PopupMenuListener;
import GPosGui.RinexObsFileNameField;
import GPosGui.UnitsPopupSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomPanel
extends JPanel {
    private JLabel AntIdLabel_;
    private JLabel Met1Label_;
    private JLabel Met2Label_;
    private JLabel Met3Label_;
    private JLabel MetLabel_;
    private JButton MetModel_;
    private JLabel Mon1Label_;
    private JLabel Mon2Label_;
    private JLabel Mon3Label_;
    private JLabel MonButton_;
    private JComboBox MonType_;
    private JLabel ObsFileNameLabel_;
    private JLabel Off1Label_;
    private JLabel Off2Label_;
    private JLabel Off3Label_;
    private JLabel OffLabel_;
    private JComboBox OffType_;
    private JMenuItem PomItem_;
    private JPopupMenu PopupMenu_;
    private JMenuItem RnxItem_;
    private JMenuItem SnxItem_;
    private JLabel Title_;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private static final String[] MonTypeList_ = new String[]{"ITRF", "NAD83", "WGS84"};
    private static final int ITRF = 0;
    private static final int NAD83 = 1;
    private static final int WGS84 = 2;
    private static final String[] OffTypeList_ = new String[]{"MON->ARP", "MON->L1PC"};
    private static final int POS_TO_ARP = 0;
    private static final int POS_TO_L1PC = 1;
    private AntennaComboBox AntIdEntry_;
    private Ellipsoid Ellipsoid_ = new GRS80();
    private GPosFrame Parent_ = null;
    private JMenuItem LastInitItem_ = null;
    private LatEntryPanel LatField_;
    private LonEntryPanel LonField_;
    private MouseListener PopupMenuListener_;
    private PomFile PomFile_;
    private PomPanel Other_;
    private PomPanel Reference_;
    private PomPanel ThisWidget_;
    private RinexFile CurrentFile_ = new RinexFile();
    private SpecialFileNameField ObsFileNameField_;
    private String ChooserTitle_ = "Select a RINEX Obs (\"O\") File";
    private UnitsPopupSpinner HgtField_;
    private UnitsPopupSpinner Met1Field_;
    private UnitsPopupSpinner Met2Field_;
    private UnitsPopupSpinner Met3Field_;
    private UnitsPopupSpinner MonXField_;
    private UnitsPopupSpinner MonYField_;
    private UnitsPopupSpinner MonZField_;
    private UnitsPopupSpinner Off1Field_;
    private UnitsPopupSpinner Off2Field_;
    private UnitsPopupSpinner Off3Field_;
    private boolean AutoEnableFlag_ = false;
    private boolean InitFromRinexHeaderEveryTime_ = false;
    private boolean InitFromRinexHeaderFirstTime_ = false;
    private boolean Initialized_ = false;
    private int CoordinateFormat_;
    private int LonDisplay_ = 0;
    public static final int AUTO_LON = 0;
    public static final int EAST_LON = 1;
    public static final int WEST_LON = -1;
    public static final int PLH_FORMAT = 1;
    public static final int XYZ_FORMAT = 0;

    public PomPanel() {
        this.initComponents();
    }

    public PomPanel(String title) {
        this.initComponents();
        this.setTitle(title);
    }

    public PomPanel(GPosFrame parent) {
        this.Parent_ = parent;
        this.initComponents();
    }

    public PomPanel(GPosFrame parent, String title) {
        this.Parent_ = parent;
        this.initComponents();
        this.setTitle(title);
    }

    private void initComponents() {
        int i;
        this.PopupMenu_ = new JPopupMenu();
        this.RnxItem_ = new JMenuItem();
        this.SnxItem_ = new JMenuItem();
        this.PomItem_ = new JMenuItem();
        this.Title_ = new JLabel();
        this.jPanel1 = new JPanel();
        this.ObsFileNameLabel_ = new JLabel();
        this.ObsFileNameField_ = new SpecialFileNameField(this.Parent_);
        this.ObsFileNameField_.setMustExistFlag(true);
        this.ObsFileNameField_.setEmptyIsOkFlag(false);
        this.ObsFileNameField_.setDirTag("WORK");
        this.AntIdLabel_ = new JLabel();
        this.AntIdEntry_ = new AntennaComboBox();
        this.jPanel2 = new JPanel();
        this.MonButton_ = new JLabel();
        this.MonType_ = new JComboBox();
        this.Mon1Label_ = new JLabel();
        String[] names = new String[]{"meters", "decimeters", "centimeters", "millimeters"};
        Double[] sizes = new Double[]{1.0, 0.1, 0.01, 0.001};
        this.MonXField_ = new UnitsPopupSpinner(1115064.1336, 0.001, "m");
        this.MonXField_.setFormat("0.0000");
        this.MonXField_.setColumns(14);
        this.MonXField_.setSteps(names, sizes);
        this.LatField_ = new LatEntryPanel();
        this.Mon2Label_ = new JLabel();
        this.MonYField_ = new UnitsPopupSpinner(-4843968.4793, 0.001, "m");
        this.MonYField_.setFormat("0.0000");
        this.MonYField_.setColumns(14);
        this.MonYField_.setSteps(names, sizes);
        this.LonField_ = new LonEntryPanel();
        this.Mon3Label_ = new JLabel();
        this.MonZField_ = new UnitsPopupSpinner(3983266.0464, 0.001, "m");
        this.MonZField_.setFormat("0.0000");
        this.MonZField_.setColumns(14);
        this.MonZField_.setSteps(names, sizes);
        this.HgtField_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.HgtField_.setFormat("0.0000");
        this.HgtField_.setColumns(10);
        this.HgtField_.setSteps(names, sizes);
        this.OffLabel_ = new JLabel();
        this.OffType_ = new JComboBox();
        this.Off1Label_ = new JLabel();
        this.Off1Field_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.Off1Field_.setFormat("0.0000");
        this.Off1Field_.setColumns(10);
        this.Off1Field_.setSteps(names, sizes);
        this.Off2Label_ = new JLabel();
        this.Off2Field_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.Off2Field_.setFormat("0.0000");
        this.Off2Field_.setColumns(10);
        this.Off2Field_.setSteps(names, sizes);
        this.Off3Label_ = new JLabel();
        this.Off3Field_ = new UnitsPopupSpinner(0.0, 0.001, "m");
        this.Off3Field_.setFormat("0.0000");
        this.Off3Field_.setColumns(10);
        this.Off3Field_.setSteps(names, sizes);
        this.MetLabel_ = new JLabel();
        this.MetModel_ = new JButton();
        this.Met1Label_ = new JLabel();
        String[] names1 = new String[]{"tenths of a degree C"};
        Double[] sizes1 = new Double[]{0.1};
        this.Met1Field_ = new UnitsPopupSpinner((Double)22.1444, (Double)-273.15, null, (Double)0.1, "<html><font size=+1>&#176;</font>C</html>");
        this.Met1Field_.setFormat("0.0");
        this.Met1Field_.setColumns(6);
        this.Met1Field_.setSteps(names1, sizes1);
        this.Met2Label_ = new JLabel();
        String[] names2 = new String[]{"tenths of a millibar"};
        this.Met2Field_ = new UnitsPopupSpinner((Double)996.0965, (Double)0.0, null, (Double)0.1, "mbar");
        this.Met2Field_.setFormat("0.0");
        this.Met2Field_.setColumns(6);
        this.Met2Field_.setSteps(names2, sizes1);
        this.Met3Label_ = new JLabel();
        String[] names3 = new String[]{"tenths of a percent"};
        this.Met3Field_ = new UnitsPopupSpinner(50.0, 0.0, 100.0, 0.1, "%");
        this.Met3Field_.setFormat("0.0");
        this.Met3Field_.setColumns(6);
        this.Met3Field_.setSteps(names3, sizes1);
        this.PopupMenuListener_ = new PopupMenuListener(this.PopupMenu_);
        this.Title_.addMouseListener(this.PopupMenuListener_);
        this.PopupMenu_.setToolTipText("Initialize site values from ...");
        this.RnxItem_.setText("RINEX");
        this.RnxItem_.setToolTipText("Initialize station values from the RINEX header.");
        this.RnxItem_.setEnabled(false);
        this.RnxItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PomPanel.this.PopupItemActionPerformed(evt);
            }
        });
        this.PopupMenu_.add(this.RnxItem_);
        this.SnxItem_.setText("SINEX");
        this.SnxItem_.setToolTipText("Initilze station values from a SINEX file.");
        this.SnxItem_.setEnabled(false);
        this.SnxItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PomPanel.this.PopupItemActionPerformed(evt);
            }
        });
        this.PopupMenu_.add(this.SnxItem_);
        this.PomItem_.setText("POM");
        this.PomItem_.setToolTipText("Initialize station values from a POM file.");
        this.PomItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PomPanel.this.PopupItemActionPerformed(evt);
            }
        });
        this.PopupMenu_.add(this.PomItem_);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setFocusable(false);
        this.Title_.setBackground(new Color(51, 51, 51));
        this.Title_.setComponentPopupMenu(this.PopupMenu_);
        this.Title_.setForeground(new Color(235, 235, 235));
        this.Title_.setText(" STATION ");
        this.Title_.setFocusable(false);
        this.Title_.setHorizontalTextPosition(0);
        this.Title_.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.Title_, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.ObsFileNameLabel_.setLabelFor(this.ObsFileNameField_);
        this.ObsFileNameField_.setToolTipText("Enter the RINEX observation (\"o\") file name.");
        this.ObsFileNameField_.setBackgroundToError();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.ObsFileNameField_, gridBagConstraints);
        this.ObsFileNameLabel_.setText("Obs File:");
        this.ObsFileNameLabel_.setToolTipText("Enter the RINEX observation (\"o\") file name.");
        this.ObsFileNameLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.ObsFileNameLabel_, gridBagConstraints);
        this.AntIdLabel_.setLabelFor(this.AntIdEntry_);
        this.AntIdEntry_.setToolTipText("Enter a standard IGS antenna ID.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.AntIdEntry_, gridBagConstraints);
        this.AntIdLabel_.setText("Antenna ID:");
        this.AntIdLabel_.setToolTipText("Enter a standard IGS antenna ID.");
        this.AntIdLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.AntIdLabel_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.MonButton_.setText("Monument:");
        this.MonButton_.setToolTipText("<html>Enter coordinates as geocentric X, Y and Z .\n<br>Click to convert to geodetic latitude, longitude and ellipsoid height.</html>");
        this.MonButton_.setBorder(BorderFactory.createEtchedBorder());
        this.MonButton_.setHorizontalTextPosition(10);
        this.MonButton_.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PomPanel.this.MonButton_MouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonButton_, gridBagConstraints);
        this.MonType_.removeAllItems();
        for (i = 0; i < MonTypeList_.length; ++i) {
            this.MonType_.addItem(MonTypeList_[i]);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonType_, gridBagConstraints);
        this.MonXField_.setToolTipText("<html>Monument X coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonXField_, gridBagConstraints);
        this.LatField_.setToolTipText("<html>Monument latitude in degrees, minutes, seconds.");
        this.Mon1Label_.setText("X");
        this.Mon1Label_.setToolTipText("Monument X coordinate in meters.");
        this.Mon1Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon1Label_, gridBagConstraints);
        this.MonYField_.setToolTipText("<html>Monument Y coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonYField_, gridBagConstraints);
        this.LonField_.setToolTipText("<html>Monument longitude in degrees, minutes, seconds.");
        this.Mon2Label_.setText("Y");
        this.Mon2Label_.setToolTipText("Monument Y coordinate in meters.");
        this.Mon2Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon2Label_, gridBagConstraints);
        this.MonZField_.setToolTipText("<html>Monument Z coordinate in meters.<br>Right-click on the field to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MonZField_, gridBagConstraints);
        this.HgtField_.setToolTipText("<html>Monument ellipsoidal height in meters.<br>Right-click on the field to set the step size.</html>");
        this.Mon3Label_.setText("Z");
        this.Mon3Label_.setToolTipText("Monument Z coordinate in meters.");
        this.Mon3Label_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Mon3Label_, gridBagConstraints);
        this.OffLabel_.setText("Offset:");
        this.OffLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.OffLabel_, gridBagConstraints);
        this.OffType_.removeAllItems();
        for (i = 0; i < OffTypeList_.length; ++i) {
            this.OffType_.addItem(OffTypeList_[i]);
        }
        this.OffType_.setFont(new Font("Monospaced", 1, 12));
        this.OffType_.setToolTipText("Type of offset.");
        this.OffType_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PomPanel.this.OffType_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.OffType_, gridBagConstraints);
        this.Off1Field_.setToolTipText("<html>North offset in meters.<br>Right-click on the field<br>to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Off1Field_, gridBagConstraints);
        this.Off1Label_.setText("N");
        this.Off1Label_.setToolTipText("North offset in meters.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Off1Label_, gridBagConstraints);
        this.Off2Field_.setToolTipText("<html>East offset in meters.<br>Right-click on the field<br>to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Off2Field_, gridBagConstraints);
        this.Off2Label_.setText("E");
        this.Off2Label_.setToolTipText("East offset in meters.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Off2Label_, gridBagConstraints);
        this.Off3Field_.setToolTipText("<html>Up offset in meters.<br>Right-click on the field<br>to set the step size.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Off3Field_, gridBagConstraints);
        this.Off3Label_.setText("U");
        this.Off3Label_.setToolTipText("Up offset in meters.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Off3Label_, gridBagConstraints);
        this.MetLabel_.setText("Surface Met:");
        this.MetLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MetLabel_, gridBagConstraints);
        this.MetModel_.setText("Model");
        this.MetModel_.setToolTipText("Apply a met model.");
        this.MetModel_.setMargin(new Insets(2, 2, 2, 2));
        this.MetModel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PomPanel.this.MetModel_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.MetModel_, gridBagConstraints);
        this.Met1Field_.setToolTipText("Air temperature in degrees Celsius.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Met1Field_, gridBagConstraints);
        this.Met1Label_.setText("T");
        this.Met1Label_.setToolTipText("Air temperature in degress C.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Met1Label_, gridBagConstraints);
        this.Met2Field_.setToolTipText("Barometric pressure in millibars.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Met2Field_, gridBagConstraints);
        this.Met2Label_.setText("P");
        this.Met2Label_.setToolTipText("Barometric pressure in millibars.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Met2Label_, gridBagConstraints);
        this.Met3Field_.setToolTipText("Relative humidity as a percent of saturation.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3333;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.Met3Field_, gridBagConstraints);
        this.Met3Label_.setText("RH");
        this.Met3Label_.setToolTipText("Relative humidity as a percent of saturation.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel2.add((Component)this.Met3Label_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void PopupItemActionPerformed(ActionEvent evt) {
        this.LastInitItem_ = (JMenuItem)evt.getSource();
        if (this.LastInitItem_ == this.RnxItem_) {
            this.applyValuesFromRinexHeader();
        } else if (this.LastInitItem_ != this.SnxItem_ && this.LastInitItem_ == this.PomItem_) {
            this.selectPomFile();
        }
    }

    private void MonButton_MouseReleased(MouseEvent evt) {
        if (this.CoordinateFormat_ == 0) {
            this.showCoordsAsPlh();
        } else {
            this.showCoordsAsXyz();
        }
    }

    private void OffType_ActionPerformed(ActionEvent evt) {
        int index = this.OffType_.getSelectedIndex();
        this.Off1Label_.setToolTipText("<html>North " + OffTypeList_[index] + " offset in meters.</html>");
        this.Off1Field_.setToolTipText("<html>North " + OffTypeList_[index] + " offset in meters." + "<br>Right-click on the field to set the step size.</html>");
        this.Off2Label_.setToolTipText("<html>East " + OffTypeList_[index] + " offset in meters.</html>");
        this.Off2Field_.setToolTipText("<html>East " + OffTypeList_[index] + " offset in meters." + "<br>Right-click on the field to set the step size.</html>");
        this.Off3Label_.setToolTipText("<html>Up " + OffTypeList_[index] + " offset in meters.</html>");
        this.Off3Field_.setToolTipText("<html>Up " + OffTypeList_[index] + " offset in meters." + "<br>Right-click on the field to set the step size.</html>");
    }

    private void MetModel_ActionPerformed(ActionEvent evt) {
        this.applyMetModel();
    }

    private void applyMetModel() {
        boolean flag;
        Date epoch = new Date();
        if (this.ObsFileNameField_.isOk()) {
            RinexFile file = this.ObsFileNameField_.getRinexFile();
            if (file.has("FIRST_TIME")) {
                epoch = (Date)file.get("FIRST_TIME");
                flag = true;
            } else {
                int n = JOptionPane.showConfirmDialog(this, "The RINEX file did not contain a \"TIME OF FIRST OBS\" record.\nUse the current time?", "Apply Met Model", 0, 0);
                flag = n == 0;
            }
        } else {
            int n = JOptionPane.showConfirmDialog(this, "A RINEX obs file has not been entered.\nUse the current time?", "Apply Met Model", 0, 2);
            flag = n == 0;
        }
        if (flag) {
            this.setValuesFromMetModel(epoch);
        }
    }

    protected void applyValuesFromPom() {
        if (this.PomFile_.getIos() == 0) {
            this.LastInitItem_ = this.PomItem_;
            this.set("ANT_TYPE", (String)this.PomFile_.get("ANT_TYPE"));
            this.set("POS_TYPE", MonTypeList_[0]);
            this.set("POS_X", (Double)this.PomFile_.get("POS_X"));
            this.set("POS_Y", (Double)this.PomFile_.get("POS_Y"));
            this.set("POS_Z", (Double)this.PomFile_.get("POS_Z"));
            this.set("ANT_DEL_TYPE", OffTypeList_[1]);
            this.set("ANT_DEL_N", (Double)this.PomFile_.get("ANT_DEL_N"));
            this.set("ANT_DEL_E", (Double)this.PomFile_.get("ANT_DEL_E"));
            this.set("ANT_DEL_H", (Double)this.PomFile_.get("ANT_DEL_H"));
            this.set("MET_T", (Double)this.PomFile_.get("MET_T"));
            this.set("MET_P", (Double)this.PomFile_.get("MET_P"));
            this.set("MET_RH", (Double)this.PomFile_.get("MET_RH"));
        } else {
            JOptionPane.showMessageDialog(this, this.PomFile_.getStatus(), "Apply POM File Values", 0);
        }
    }

    protected String applyValuesFromRinexHeader() {
        if (this.ObsFileNameField_.isOk()) {
            this.LastInitItem_ = this.RnxItem_;
            boolean flag = true;
            String msg = "The RINEX obs file did not contain:";
            RinexFile file = this.ObsFileNameField_.getRinexFile();
            if (file.has("ANT_TYPE")) {
                if (((String)file.get("ANT_TYPE")).trim().length() > 0) {
                    this.set("ANT_TYPE", (String)file.get("ANT_TYPE"));
                } else {
                    flag = false;
                    msg = msg.concat("\n  an antenna type");
                }
            } else {
                flag = false;
                msg = msg.concat("\n  \"ANT # / TYPE\" record");
            }
            if (file.has("APP_POS_X")) {
                this.set("POS_TYPE", MonTypeList_[2]);
                this.set("POS_X", (Double)file.get("APP_POS_X"));
                this.set("POS_Y", (Double)file.get("APP_POS_Y"));
                this.set("POS_Z", (Double)file.get("APP_POS_Z"));
            } else {
                flag = false;
                msg = msg.concat("\n  \"APPROX POSITION XYZ\" record");
            }
            if (file.has("ANT_DEL_E")) {
                this.set("ANT_DEL_TYPE", OffTypeList_[0]);
                this.set("ANT_DEL_N", (Double)file.get("ANT_DEL_N"));
                this.set("ANT_DEL_E", (Double)file.get("ANT_DEL_E"));
                this.set("ANT_DEL_H", (Double)file.get("ANT_DEL_H"));
            } else {
                flag = false;
                msg = msg.concat("\n  \"ANTENNA: DELTA H/E/N\" record");
            }
            if (!file.has("FIRST_TIME")) {
                flag = false;
                msg = msg.concat("\n  \"TIME OF FIRST OBS\" record");
            }
            if (flag) {
                return "";
            }
            return msg.concat("\nThe associated values have not been set.");
        }
        return "";
    }

    private void setValuesFromMetModel(Date epoch) {
        Double[] plh = this.Ellipsoid_.toPlh((Double)this.get("POS_X"), (Double)this.get("POS_Y"), (Double)this.get("POS_Z"));
        this.set("MET_T", SeasonalMetModel.getT((Date)epoch, (Double)plh[0], (Double)plh[2]));
        this.set("MET_P", SeasonalMetModel.getP((Date)epoch, (Double)plh[0], (Double)plh[2]));
        this.set("MET_RH", 100.0 * SeasonalMetModel.getRH((Date)epoch, (Double)plh[0], (Double)plh[2]));
    }

    public void doOnSettingFileName(boolean flag) {
        if (this.RnxItem_ != null) {
            if (flag) {
                if (this.AutoEnableFlag_) {
                    this.setEnabled(true);
                } else {
                    this.RnxItem_.setEnabled(true);
                }
                if (this.InitFromRinexHeaderEveryTime_ || this.InitFromRinexHeaderFirstTime_ && !this.Initialized_) {
                    String msg = this.applyValuesFromRinexHeader();
                    if (msg.length() > 0) {
                        JOptionPane.showMessageDialog(this.Parent_, msg, "Missing RINEX Header Info", 2);
                    }
                    if (this.ObsFileNameField_.getRinexFile().has("FIRST_TIME")) {
                        this.setValuesFromMetModel((Date)this.ObsFileNameField_.getRinexFile().get("FIRST_TIME"));
                    } else {
                        this.setValuesFromMetModel(new Date());
                    }
                }
            } else if (this.AutoEnableFlag_) {
                this.setEnabled(false);
                this.setEnabled("FILE_NAME", true);
            } else {
                this.RnxItem_.setEnabled(false);
            }
        }
    }

    public Object get(String field) {
        if (field.equals("FILE")) {
            return this.ObsFileNameField_.getRinexFile();
        }
        if (field.equals("FILE_NAME")) {
            return this.ObsFileNameField_.getText();
        }
        if (field.equals("ANT_TYPE")) {
            return this.AntIdEntry_.getText();
        }
        if (field.equals("POS_TYPE")) {
            return this.MonType_.getSelectedItem();
        }
        if (field.equals("POS_X")) {
            if (this.CoordinateFormat_ == 0) {
                return this.MonXField_.getValue();
            }
            Double[] xyz = this.Ellipsoid_.toXyz(this.LatField_.getValue(), this.LonField_.getValue(), this.HgtField_.getValue());
            return xyz[0];
        }
        if (field.equals("POS_Y")) {
            if (this.CoordinateFormat_ == 0) {
                return this.MonYField_.getValue();
            }
            Double[] xyz = this.Ellipsoid_.toXyz(this.LatField_.getValue(), this.LonField_.getValue(), this.HgtField_.getValue());
            return xyz[1];
        }
        if (field.equals("POS_Z")) {
            if (this.CoordinateFormat_ == 0) {
                return this.MonZField_.getValue();
            }
            Double[] xyz = this.Ellipsoid_.toXyz(this.LatField_.getValue(), this.LonField_.getValue(), this.HgtField_.getValue());
            return xyz[2];
        }
        if (field.equals("ANT_DEL_TYPE")) {
            return this.OffType_.getSelectedItem();
        }
        if (field.equals("ANT_DEL_N")) {
            return this.Off1Field_.getValue();
        }
        if (field.equals("ANT_DEL_E")) {
            return this.Off2Field_.getValue();
        }
        if (field.equals("ANT_DEL_H")) {
            return this.Off3Field_.getValue();
        }
        if (field.equals("MET_T")) {
            return this.Met1Field_.getValue();
        }
        if (field.equals("MET_P")) {
            return this.Met2Field_.getValue();
        }
        if (field.equals("MET_RH")) {
            return this.Met3Field_.getValue();
        }
        if (field.equals("START_TIME")) {
            return this.ObsFileNameField_.getRinexFile().readTimeOfFirstEpoch();
        }
        if (field.equals("STOP_TIME")) {
            return this.ObsFileNameField_.getRinexFile().readTimeOfLastEpoch();
        }
        return null;
    }

    protected JMenuItem getLastInitItem() {
        return this.LastInitItem_;
    }

    public String getRnxFileName() {
        return this.CurrentFile_.getCanonicalPath();
    }

    public JPopupMenu getPopupMenu() {
        return this.PopupMenu_;
    }

    public Dimension getTitleSize() {
        return this.Title_.getPreferredSize();
    }

    public boolean isOk() {
        return this.ObsFileNameField_.isOk();
    }

    protected void reset() {
        if (this.LastInitItem_ == this.RnxItem_) {
            this.applyValuesFromRinexHeader();
        } else if (this.LastInitItem_ != this.SnxItem_ && this.LastInitItem_ == this.PomItem_) {
            this.applyValuesFromPom();
        }
    }

    private void selectPomFile() {
        int option;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new PomFileFilter());
        chooser.setDialogTitle("Select The POM File");
        if (this.Parent_ != null) {
            chooser.setCurrentDirectory(new File(this.Parent_.getPath("POM")));
        }
        if ((option = chooser.showOpenDialog(this)) == 0) {
            try {
                PomFile PomFile_ = new PomFile(chooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                PomFile PomFile_ = new PomFile(chooser.getSelectedFile().getAbsolutePath());
            }
            if (this.PomFile_.getIos() == 0) {
                if (this.Parent_ != null) {
                    this.Parent_.setPath("POM", this.PomFile_.getPath());
                }
                this.applyValuesFromPom();
            }
        }
    }

    public void set(String field, Object value) {
        block48: {
            if (field.equals("FILE")) {
                try {
                    if (value instanceof File) {
                        this.ObsFileNameField_.setText(((File)value).getCanonicalPath());
                        this.Initialized_ = true;
                    } else if (value instanceof RinexFile) {
                        this.ObsFileNameField_.setText(((RinexFile)value).getCanonicalPath());
                        this.Initialized_ = true;
                    }
                    break block48;
                }
                catch (IOException ex) {
                    if (value instanceof File) {
                        this.ObsFileNameField_.setText(((File)value).getAbsolutePath());
                        this.Initialized_ = true;
                    } else if (value instanceof RinexFile) {
                        this.ObsFileNameField_.setText(((RinexFile)value).getAbsolutePath());
                        this.Initialized_ = true;
                    }
                    break block48;
                }
            }
            if (field.equals("FILE_NAME")) {
                this.ObsFileNameField_.setText((String)value);
                this.Initialized_ = true;
            } else if (field.equals("ANT_TYPE")) {
                this.AntIdEntry_.setText((String)value);
                this.Initialized_ = true;
            } else if (field.equals("POS_TYPE") && value instanceof String) {
                this.MonType_.setSelectedItem((String)value);
                this.Initialized_ = true;
            } else if (field.equals("POS_TYPE") && value instanceof Integer) {
                this.MonType_.setSelectedIndex((Integer)value);
                this.Initialized_ = true;
            } else if (field.equals("POS_X")) {
                Double[] plh = this.Ellipsoid_.toPlh((Double)value, this.MonYField_.getValue(), this.MonZField_.getValue());
                this.MonXField_.setValue((Double)value);
                this.LatField_.setValue(plh[0]);
                if (this.LonDisplay_ < 0 || this.LonDisplay_ == 0 && plh[1] > 180.0) {
                    this.LonField_.setValue(plh[1] - 360.0);
                } else {
                    this.LonField_.setValue(plh[1]);
                }
                this.HgtField_.setValue(plh[2]);
                this.Initialized_ = true;
            } else if (field.equals("POS_Y")) {
                Double[] plh = this.Ellipsoid_.toPlh(this.MonXField_.getValue(), (Double)value, this.MonZField_.getValue());
                this.MonYField_.setValue((Double)value);
                this.LatField_.setValue(plh[0]);
                if (this.LonDisplay_ < 0 || this.LonDisplay_ == 0 && plh[1] > 180.0) {
                    this.LonField_.setValue(plh[1] - 360.0);
                } else {
                    this.LonField_.setValue(plh[1]);
                }
                this.HgtField_.setValue(plh[2]);
                this.Initialized_ = true;
            } else if (field.equals("POS_Z")) {
                Double[] plh = this.Ellipsoid_.toPlh(this.MonXField_.getValue(), this.MonYField_.getValue(), (Double)value);
                this.MonZField_.setValue((Double)value);
                this.LatField_.setValue(plh[0]);
                if (this.LonDisplay_ < 0 || this.LonDisplay_ == 0 && plh[1] > 180.0) {
                    this.LonField_.setValue(plh[1] - 360.0);
                } else {
                    this.LonField_.setValue(plh[1]);
                }
                this.HgtField_.setValue(plh[2]);
                this.Initialized_ = true;
            } else if (field.equals("ANT_DEL_TYPE") && value instanceof String) {
                this.OffType_.setSelectedItem((String)value);
                this.Initialized_ = true;
            } else if (field.equals("POS_TYPE") && value instanceof Integer) {
                this.OffType_.setSelectedIndex((Integer)value);
                this.Initialized_ = true;
            } else if (field.equals("ANT_DEL_N")) {
                this.Off1Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field.equals("ANT_DEL_E")) {
                this.Off2Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field.equals("ANT_DEL_H")) {
                this.Off3Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field.equals("MET_T")) {
                this.Met1Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field.equals("MET_P")) {
                this.Met2Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field.equals("MET_RH")) {
                this.Met3Field_.setValue((Double)value);
                this.Initialized_ = true;
            } else if (field.equals("LINK_OTHER")) {
                this.Other_ = (PomPanel)value;
            } else if (field.equals("LINK_REFERENCE")) {
                this.Reference_ = (PomPanel)value;
            }
        }
    }

    public void setAntennaIdList(Set<String> set) {
        this.AntIdEntry_.createMenus(set);
    }

    public void setAntennaIdList(String[] array) {
        this.AntIdEntry_.createMenus(array);
    }

    public void setAutoEnableFlag(boolean flag) {
        this.AutoEnableFlag_ = flag;
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.RnxItem_.setEnabled(flag);
        this.PomItem_.setEnabled(flag);
        this.LatField_.setEnabled(flag);
        this.LonField_.setEnabled(flag);
        this.HgtField_.setEnabled(flag);
        this.MetLabel_.setEnabled(flag);
        this.MetModel_.setEnabled(flag);
        this.OffLabel_.setEnabled(flag);
        this.MonButton_.setEnabled(flag);
        this.ObsFileNameLabel_.setEnabled(flag);
        this.ObsFileNameField_.setEnabled(flag);
        this.AntIdLabel_.setEnabled(flag);
        this.AntIdEntry_.setEnabled(flag);
        this.MonType_.setEnabled(flag);
        this.Mon1Label_.setEnabled(flag);
        this.MonXField_.setEnabled(flag);
        this.Mon2Label_.setEnabled(flag);
        this.MonYField_.setEnabled(flag);
        this.Mon3Label_.setEnabled(flag);
        this.MonZField_.setEnabled(flag);
        this.OffType_.setEnabled(flag);
        this.Off1Label_.setEnabled(flag);
        this.Off1Field_.setEnabled(flag);
        this.Off2Label_.setEnabled(flag);
        this.Off2Field_.setEnabled(flag);
        this.Off3Label_.setEnabled(flag);
        this.Off3Field_.setEnabled(flag);
        this.Met1Label_.setEnabled(flag);
        this.Met1Field_.setEnabled(flag);
        this.Met2Label_.setEnabled(flag);
        this.Met2Field_.setEnabled(flag);
        this.Met3Label_.setEnabled(flag);
        this.Met3Field_.setEnabled(flag);
    }

    public void setEnabled(String field, boolean flag) {
        if (field.equals("FILE_NAME")) {
            this.ObsFileNameLabel_.setEnabled(flag);
            this.ObsFileNameField_.setEnabled(flag);
        } else if (field.equals("ANT_TYPE")) {
            this.AntIdLabel_.setEnabled(flag);
            this.AntIdEntry_.setEnabled(flag);
        } else if (field.equals("POS_TYPE")) {
            this.MonType_.setEnabled(flag);
        } else if (field.equals("POS_X")) {
            this.Mon1Label_.setEnabled(flag);
            this.MonXField_.setEnabled(flag);
        } else if (field.equals("POS_Y")) {
            this.Mon2Label_.setEnabled(flag);
            this.MonYField_.setEnabled(flag);
        } else if (field.equals("POS_Z")) {
            this.Mon3Label_.setEnabled(flag);
            this.MonZField_.setEnabled(flag);
        } else if (field.equals("ANT_DEL_TYPE")) {
            this.OffType_.setEnabled(flag);
        } else if (field.equals("ANT_DEL_N")) {
            this.Off1Label_.setEnabled(flag);
            this.Off1Field_.setEnabled(flag);
        } else if (field.equals("ANT_DEL_E")) {
            this.Off2Label_.setEnabled(flag);
            this.Off2Field_.setEnabled(flag);
        } else if (field.equals("ANT_DEL_H")) {
            this.Off3Label_.setEnabled(flag);
            this.Off3Field_.setEnabled(flag);
        } else if (field.equals("MET_T")) {
            this.Met1Label_.setEnabled(flag);
            this.Met1Field_.setEnabled(flag);
        } else if (field.equals("MET_P")) {
            this.Met2Label_.setEnabled(flag);
            this.Met2Field_.setEnabled(flag);
        } else if (field.equals("MET_RH")) {
            this.Met3Label_.setEnabled(flag);
            this.Met3Field_.setEnabled(flag);
        }
    }

    public void setInitFromRinexHeaderEveryTime(boolean flag) {
        this.InitFromRinexHeaderEveryTime_ = flag;
    }

    public void setInitFromRinexHeaderFirstTime(boolean flag) {
        this.InitFromRinexHeaderFirstTime_ = flag;
    }

    protected void setLastInitItem(JMenuItem item) {
        this.LastInitItem_ = item;
    }

    public void setLonDisplay(int input) {
        this.LonDisplay_ = input;
    }

    public void setOtherPomPanel(PomPanel other) {
        this.Other_ = other;
    }

    public void setReferencePomPanel(PomPanel reference) {
        this.Reference_ = reference;
    }

    public void setTitle(String input) {
        this.Title_.setText(" " + input.trim() + " ");
    }

    public void setTitleSize(Dimension size) {
        this.Title_.setSize(size);
    }

    public void setTitleSize(int width, int height) {
        this.Title_.setSize(width, height);
        this.Title_.setPreferredSize(new Dimension(width, height));
        this.Title_.setMinimumSize(new Dimension(width, height));
    }

    public void showCoordsAsPlh() {
        if (this.CoordinateFormat_ == 0) {
            this.MonButton_.setToolTipText("<html>Enter coordinates as geodetic latitude, longitude and ellipsoid height.<br>Click to convert to geocentric X, Y and Z.</html>");
            this.CoordinateFormat_ = 1;
            try {
                this.MonXField_.commitEdit();
            }
            catch (ParseException ex) {
                // empty catch block
            }
            try {
                this.MonYField_.commitEdit();
            }
            catch (ParseException ex) {
                // empty catch block
            }
            try {
                this.MonZField_.commitEdit();
            }
            catch (ParseException ex) {
                // empty catch block
            }
            Double[] plh = this.Ellipsoid_.toPlh(this.MonXField_.getValue(), this.MonYField_.getValue(), this.MonZField_.getValue());
            this.LatField_.setValue(plh[0]);
            if (this.LonDisplay_ < 0 || this.LonDisplay_ == 0 && plh[1] > 180.0) {
                this.LonField_.setValue(plh[1] - 360.0);
            } else {
                this.LonField_.setValue(plh[1]);
            }
            this.HgtField_.setValue(plh[2]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.Mon1Label_.setText("Lat:");
            this.Mon1Label_.setToolTipText("<html>Monument latitude in &#176;, &#146; and &#148;.</html>");
            this.jPanel2.remove(this.MonXField_);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.3333;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.jPanel2.add((Component)this.LatField_, gridBagConstraints);
            this.Mon2Label_.setText("Lon:");
            this.Mon2Label_.setToolTipText("<html>Monument longitude in &#176;, &#146; and &#148;.</html>");
            this.jPanel2.remove(this.MonYField_);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.3333;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.jPanel2.add((Component)this.LonField_, gridBagConstraints);
            this.Mon3Label_.setText("El Hgt:");
            this.Mon1Label_.setToolTipText("<html>Monument ellipsoidal height in meters.<br>Right-click on the field to set the step size.</html>");
            this.jPanel2.remove(this.MonZField_);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 7;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.3333;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.jPanel2.add((Component)this.HgtField_, gridBagConstraints);
            if (this.Parent_ != null) {
                this.Parent_.pack();
            } else {
                this.validate();
                this.repaint();
            }
        }
    }

    public void showCoordsAsXyz() {
        if (this.CoordinateFormat_ == 1) {
            this.CoordinateFormat_ = 0;
            this.MonButton_.setToolTipText("<html>Enter coordinates as geocentric X, Y and Z.<br>Click to convert to geodetic latitude, longitude and ellipsoid height.</html>");
            try {
                this.LatField_.commitEdit();
            }
            catch (ParseException ex) {
                // empty catch block
            }
            try {
                this.LonField_.commitEdit();
            }
            catch (ParseException ex) {
                // empty catch block
            }
            try {
                this.HgtField_.commitEdit();
            }
            catch (ParseException ex) {
                // empty catch block
            }
            Double[] xyz = this.Ellipsoid_.toXyz(this.LatField_.getValue(), this.LonField_.getValue(), this.HgtField_.getValue());
            this.MonXField_.setValue(xyz[0]);
            this.MonYField_.setValue(xyz[1]);
            this.MonZField_.setValue(xyz[2]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.Mon1Label_.setText("X:");
            this.Mon1Label_.setToolTipText("<html>Monument X coordinate in meters.<br>Right-click on the field to set the step size.</html>");
            this.jPanel2.remove(this.LatField_);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.3333;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.jPanel2.add((Component)this.MonXField_, gridBagConstraints);
            this.Mon2Label_.setText("Y:");
            this.Mon2Label_.setToolTipText("<html>Monument Y coordinate in meters.<br>Right-click on the field to set the step size.</html>");
            this.jPanel2.remove(this.LonField_);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.3333;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.jPanel2.add((Component)this.MonYField_, gridBagConstraints);
            this.Mon3Label_.setText("Z:");
            this.Mon3Label_.setToolTipText("<html>Monument Z coordinate in meters.<br>Right-click on the field to set the step size.</html>");
            this.jPanel2.remove(this.HgtField_);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 7;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.3333;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.jPanel2.add((Component)this.MonZField_, gridBagConstraints);
            if (this.Parent_ != null) {
                this.Parent_.pack();
            } else {
                this.validate();
                this.repaint();
            }
        }
    }

    public void showLonAsEastOnly() {
        this.LonDisplay_ = 1;
    }

    public void showLonAsWestOnly() {
        this.LonDisplay_ = -1;
    }

    public void showLonAutoSelectHemi() {
        this.LonDisplay_ = 0;
    }

    public class SpecialFileNameField
    extends RinexObsFileNameField {
        public SpecialFileNameField(GPosFrame parent) {
            super(parent);
        }

        public void setText(File input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath("WORK", super.getRinexFile().getCanonicalPath());
            }
            PomPanel.this.doOnSettingFileName(this.isOk());
        }

        public void setText(String input) {
            super.setText(input);
            if (this.isOk() && this.Parent_ != null) {
                this.Parent_.setPath("WORK", super.getRinexFile().getCanonicalPath());
            }
            PomPanel.this.doOnSettingFileName(this.isOk());
        }
    }
}

