/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KPosFileFilter
extends FileFilter {
    protected String Description_;
    static final String InputFileName_ = new String("KPos.inp");
    static final String ParameterFileName_ = new String("KPos.par");
    static final String IntegersFileName_ = new String("KPos.int");
    static final String TropoFileName_ = new String("KPos.tro");
    static final String EditFileName_ = new String("KPos.edt");
    static final String StopFileName_ = new String("KPos.stp");
    protected static final HashMap<String, String> PublicPlotDescription_ = new HashMap();
    protected static final HashMap<String, String> PrivatePlotDescription_;
    protected static final HashMap<String, String> PublicInputDescription_;
    protected static final HashMap<String, String> PrivateInputDescription_;
    protected static final HashMap<String, String> PublicOutputDescription_;
    protected static final HashMap<String, String> PrivateOutputDescription_;

    public KPosFileFilter() {
        this("All Kintools files");
    }

    public KPosFileFilter(String description) {
        this.Description_ = description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return PublicPlotDescription_.containsKey(file.getName()) || PublicInputDescription_.containsKey(file.getName()) || PublicOutputDescription_.containsKey(file.getName());
    }

    public static Set<String> getAllFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicPlotDescription_.keySet());
        tmp.addAll(PrivatePlotDescription_.keySet());
        tmp.addAll(PublicInputDescription_.keySet());
        tmp.addAll(PrivateInputDescription_.keySet());
        tmp.addAll(PublicOutputDescription_.keySet());
        tmp.addAll(PrivateOutputDescription_.keySet());
        return tmp;
    }

    public static Set<String> getAllInputFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicInputDescription_.keySet());
        tmp.addAll(PrivateInputDescription_.keySet());
        return tmp;
    }

    public static Set<String> getAllPlotFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicPlotDescription_.keySet());
        tmp.addAll(PrivatePlotDescription_.keySet());
        return tmp;
    }

    public static Set<String> getAllOutputFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicOutputDescription_.keySet());
        tmp.addAll(PrivateOutputDescription_.keySet());
        return tmp;
    }

    @Override
    public String getDescription() {
        return this.Description_;
    }

    public static String getEditFileName() {
        return EditFileName_;
    }

    public static String getFileDescription(String key) {
        if (PublicPlotDescription_.containsKey(key)) {
            return PublicPlotDescription_.get(key);
        }
        if (PrivatePlotDescription_.containsKey(key)) {
            return PrivatePlotDescription_.get(key);
        }
        if (PublicInputDescription_.containsKey(key)) {
            return PublicInputDescription_.get(key);
        }
        if (PrivateInputDescription_.containsKey(key)) {
            return PrivateInputDescription_.get(key);
        }
        if (PublicOutputDescription_.containsKey(key)) {
            return PublicOutputDescription_.get(key);
        }
        if (PrivateOutputDescription_.containsKey(key)) {
            return PrivateOutputDescription_.get(key);
        }
        return new String("");
    }

    public static Set<String> getFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicPlotDescription_.keySet());
        tmp.addAll(PublicInputDescription_.keySet());
        tmp.addAll(PublicOutputDescription_.keySet());
        return tmp;
    }

    public static Set<String> getInputFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicInputDescription_.keySet());
        return tmp;
    }

    public static String getInputFileName() {
        return InputFileName_;
    }

    public static String getIntegersFileName() {
        return IntegersFileName_;
    }

    public static Set<String> getPlotFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicPlotDescription_.keySet());
        return tmp;
    }

    public static Set<String> getOutputFileNames() {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.addAll(PublicOutputDescription_.keySet());
        return tmp;
    }

    public static String getParameterFileName() {
        return ParameterFileName_;
    }

    public static String getStopFileName() {
        return StopFileName_;
    }

    public static String getTropoFileName() {
        return TropoFileName_;
    }

    public static boolean isMember(String name) {
        return PublicPlotDescription_.containsKey(name) || PublicInputDescription_.containsKey(name) || PublicOutputDescription_.containsKey(name);
    }

    static {
        PublicPlotDescription_.put("elv.plt", "SV Elevation Plot");
        PublicPlotDescription_.put("ion.plt", "Ionospheric Delay Plot");
        PublicPlotDescription_.put("pmr.plt", "Phase Minus Range Plot");
        PublicPlotDescription_.put("rrs.plt", "Range Residuals Plot");
        PublicPlotDescription_.put("prs.plt", "Phase Residuals Plot");
        PublicPlotDescription_.put("psl.plt", "Phase Solution Plot");
        PublicPlotDescription_.put("rsl.plt", "Range Solution Plot");
        PublicPlotDescription_.put("qck.plt", "Quality Check Plot");
        PublicPlotDescription_.put("dif.plt", "Solution Difference Plot");
        PublicPlotDescription_.put("wln.plt", "Widelane Residuals Plot");
        PublicPlotDescription_.put("nsv.plt", "Number Of SVs Plot");
        PublicPlotDescription_.put("cor.plt", "Ionospheric Correction Plot");
        PublicPlotDescription_.put("tsf.plt", "Tropo Scale Factor Plot");
        PrivatePlotDescription_ = new HashMap();
        PrivatePlotDescription_.put("elv.lim", "SV Elevation Plot (deprecated)");
        PrivatePlotDescription_.put("ion.lim", "Ionospheric Delay Plot (deprecated)");
        PrivatePlotDescription_.put("pmr.lim", "Phase Minus Range Plot (deprecated)");
        PrivatePlotDescription_.put("rrs.lim", "Range Residuals Plot (deprecated)");
        PrivatePlotDescription_.put("prs.lim", "Phase Residuals Plot (deprecated)");
        PrivatePlotDescription_.put("psl.lim", "Phase Solution Plot (deprecated)");
        PrivatePlotDescription_.put("rsl.lim", "Range Solution Plot (deprecated)");
        PrivatePlotDescription_.put("qck.lim", "Quality Check Plot (deprecated)");
        PrivatePlotDescription_.put("dif.lim", "Solution Difference Plot (deprecated)");
        PrivatePlotDescription_.put("wln.lim", "Widelane Residuals Plot (deprecated)");
        PrivatePlotDescription_.put("nsv.lim", "Number Of SVs Plot (deprecated)");
        PrivatePlotDescription_.put("cor.lim", "Ionospheric Correction Plot (deprecated)");
        PrivatePlotDescription_.put("tsf.lim", "Tropo Scale Factor Plot (deprecated)");
        PublicInputDescription_ = new HashMap();
        PrivateInputDescription_ = new HashMap();
        PrivateInputDescription_.put(InputFileName_, "Input Control File");
        PrivateInputDescription_.put(ParameterFileName_, "Parameter Control File");
        PrivateInputDescription_.put(IntegersFileName_, "Integers");
        PrivateInputDescription_.put(TropoFileName_, "Tropo Model Parameters");
        PrivateInputDescription_.put(EditFileName_, "Edit Instructions");
        PrivateInputDescription_.put(StopFileName_, "Stop Processing");
        PrivateInputDescription_.put("kinpos_t.inp", "Input Control File (deprecated)");
        PrivateInputDescription_.put("param_t", "Parameter Control File (deprecated)");
        PrivateInputDescription_.put("integers", "Integers (deprecated)");
        PrivateInputDescription_.put("tropo", "Tropo Model Parameters (deprecated)");
        PrivateInputDescription_.put("kars.edt", "Edit Instructions (deprecated)");
        PrivateInputDescription_.put("kinpos.inp", "Input Control File (defunct)");
        PrivateInputDescription_.put("param", "Parameter Control File (defunct)");
        PrivateInputDescription_.put("integer", "Integers (defunct)");
        PrivateInputDescription_.put("integer.inp", "Integers (defunct)");
        PrivateInputDescription_.put("phifix", "Phifix (defunct)");
        PublicOutputDescription_ = new HashMap();
        PublicOutputDescription_.put("Kphs.neu", "Phase Neu Solution File");
        PublicOutputDescription_.put("Kphs.xyz", "Phase Xyz Solution File");
        PublicOutputDescription_.put("Krng.neu", "Range Neu Solution File");
        PublicOutputDescription_.put("Krng.xyz", "Range Xyz Solution File");
        PublicOutputDescription_.put("psolxyz", "Phase Neu Solution File (deprecated)");
        PublicOutputDescription_.put("psolneu", "Phase Xyz Solution File (deprecated)");
        PublicOutputDescription_.put("rsolxyz", "Range Neu Solution File (deprecated)");
        PublicOutputDescription_.put("rsolneu", "Phase Xyz Solution File (deprecated)");
        PrivateOutputDescription_ = new HashMap();
        PrivateOutputDescription_.put("KPos.out", "Output File");
        PrivateOutputDescription_.put("KPos.lli", "Cycle Slips File");
        PrivateOutputDescription_.put("KPos.tst", "Diagnostics File");
        PrivateOutputDescription_.put("kinpos.out", "Output File (deprecated)");
        PrivateOutputDescription_.put("cyslips", "Cycle Slips File (deprecated)");
        PrivateOutputDescription_.put("test", "Diagnostics File (deprecated)");
    }
}

