/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GNSS.GpsTimeZone;
import GPosGui.GPosCaret;
import GPosGui.GPosDateSpinnerEditor;
import GPosGui.GPosDateSpinnerModel;
import GPosGui.PopupMenuListener;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;

public class GPosDateSpinner
extends JSpinner {
    protected static final long MillisInDay_ = 86400000L;
    protected static final long MillisInHour_ = 3600000L;
    protected static final long MillisInMinute_ = 60000L;
    protected static final long MillisInSecond_ = 1000L;
    protected static final long MillisInTenth_ = 100L;
    protected static final long MillisInHundredth_ = 10L;
    protected static final String LongFormat_ = "yyyy-MM-dd HH:mm:ss.SSS";
    protected static final String ShortFormat_ = "yyyy-DDD HH:mm:ss.SSS";
    protected GPosCaret Caret_ = new GPosCaret();
    private MouseListener PopupListener_;
    private JPopupMenu Popup_;
    protected String[] List_;
    protected String IntervalList_ = "Data Interval";
    protected String[] ShortList_ = new String[]{"Year", "Day-of-year", "Hour", "Minute", "Second"};
    protected String[] LongList_ = new String[]{"Year", "Month", "Day", "Hour", "Minute", "Second"};
    protected int Interval_ = 0;
    protected int IntervalField_ = 14;
    protected int[] ShortField_ = new int[]{1, 6, 11, 12, 13};
    protected int[] LongField_ = new int[]{1, 2, 5, 11, 12, 13};

    public GPosDateSpinner() {
        this(new GPosDateSpinnerModel());
    }

    public GPosDateSpinner(SpinnerModel model) {
        super(model);
        this.setEditor(new GPosDateSpinnerEditor(this));
        this.getTextField().setCaret(this.Caret_);
        this.Popup_ = new JPopupMenu();
        this.PopupListener_ = new PopupMenuListener(this.Popup_);
        this.addMouseListener(this.PopupListener_);
        this.setLongDateFormat();
    }

    public GPosDateSpinner(Date date) {
        this(new GPosDateSpinnerModel(date));
    }

    public GPosDateSpinner(Date date, int calendar_field) {
        this(new GPosDateSpinnerModel(date, calendar_field));
    }

    public GPosDateSpinner(Date date, Comparable start, Comparable end, int calendar_field) {
        this(new GPosDateSpinnerModel(date, start, end, calendar_field));
    }

    public GPosDateSpinner(int calendar_field) {
        this(new GPosDateSpinnerModel(calendar_field));
    }

    protected void PopupItemActionPerformed(ActionEvent evt) {
        int index;
        JMenuItem item = (JMenuItem)evt.getSource();
        if (item.getText().startsWith(this.IntervalList_)) {
            this.setCalendarField(this.IntervalField_, this.Interval_);
        }
        for (index = 0; index < this.LongList_.length; ++index) {
            if (!item.getText().startsWith(this.LongList_[index])) continue;
            this.setCalendarField(this.LongField_[index], 1);
            return;
        }
        for (index = 0; index < this.ShortList_.length; ++index) {
            if (!item.getText().startsWith(this.ShortList_[index])) continue;
            this.setCalendarField(this.ShortField_[index], 1);
            return;
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.getTextField().addMouseListener(listener);
        super.addMouseListener(listener);
    }

    protected JComponent createEditor(SpinnerModel model) {
        if (model instanceof GPosDateSpinnerModel) {
            return new GPosDateSpinnerEditor(this);
        }
        return super.createEditor(model);
    }

    protected void fillPopupMenu() {
        this.Popup_.removeAll();
        if (this.Interval_ != 0) {
            JMenuItem item = new JMenuItem(this.IntervalList_);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GPosDateSpinner.this.PopupItemActionPerformed(evt);
                }
            });
            this.Popup_.add(item);
            JSeparator separator = new JSeparator();
            this.Popup_.add(separator);
        }
        for (int i = 0; i < this.List_.length; ++i) {
            JMenuItem item = new JMenuItem(this.List_[i]);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GPosDateSpinner.this.PopupItemActionPerformed(evt);
                }
            });
            this.Popup_.add(item);
        }
    }

    protected void fillPopupMenu(String[] list) {
        this.List_ = list;
        this.fillPopupMenu();
    }

    public int getCalendarField() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerDateModel) {
            return ((SpinnerDateModel)model).getCalendarField();
        }
        return -1;
    }

    public boolean getOverwriteMode() {
        return ((DefaultFormatter)this.getTextField().getFormatter()).getOverwriteMode();
    }

    public JFormattedTextField getTextField() {
        JComponent editor = super.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return null;
    }

    public TimeZone getTimeZone() {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
        if (editor instanceof JSpinner.DateEditor) {
            return ((JSpinner.DateEditor)editor).getFormat().getTimeZone();
        }
        return new GpsTimeZone();
    }

    public void setCalendarField(int field) {
        SpinnerModel model = this.getModel();
        if (model instanceof GPosDateSpinnerModel) {
            ((GPosDateSpinnerModel)model).setChangeField(field);
        }
    }

    public void setCalendarField(int field, int interval) {
        SpinnerModel model = this.getModel();
        if (model instanceof GPosDateSpinnerModel) {
            ((GPosDateSpinnerModel)model).setChangeField(field, interval);
        }
    }

    public void setColumns(int columns) {
        if (columns > 0) {
            this.getTextField().setColumns(columns);
        }
    }

    public void setEditor(JComponent editor) {
        if (editor != null) {
            super.setEditor(editor);
            this.getTextField().addMouseListener(this.PopupListener_);
            this.fireStateChanged();
        }
    }

    public void setEnd(Comparable max_limit) {
        if (max_limit != null) {
            SpinnerModel model = this.getModel();
            if (model instanceof SpinnerDateModel) {
                ((SpinnerDateModel)model).setEnd(max_limit);
            } else if (model instanceof SpinnerNumberModel) {
                ((SpinnerNumberModel)model).setMaximum(max_limit);
            }
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.getTextField().setFont(font);
            this.fireStateChanged();
        }
    }

    public void setFormat(String format) {
        if (format != null) {
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                ((JSpinner.DateEditor)editor).getFormat().applyPattern(format);
                this.fireStateChanged();
            } else if (editor instanceof JSpinner.NumberEditor) {
                ((JSpinner.NumberEditor)editor).getFormat().applyPattern(format);
                this.fireStateChanged();
            }
        }
    }

    public void setInterval() {
        this.setInterval(0.0);
    }

    public void setInterval(double interval) {
        long tmp = StrictMath.round(1000.0 * interval);
        if (tmp >= 0L) {
            if (tmp != 0L) {
                if (tmp % 86400000L == 0L) {
                    this.IntervalField_ = 5;
                    this.Interval_ = (int)(tmp / 86400000L);
                } else if (tmp % 3600000L == 0L) {
                    this.IntervalField_ = 11;
                    this.Interval_ = (int)(tmp / 3600000L);
                } else if (tmp % 60000L == 0L) {
                    this.IntervalField_ = 12;
                    this.Interval_ = (int)(tmp / 60000L);
                } else if (tmp % 1000L == 0L) {
                    this.IntervalField_ = 13;
                    this.Interval_ = (int)(tmp / 1000L);
                } else if (tmp > 0L) {
                    this.IntervalField_ = 14;
                    this.Interval_ = (int)tmp;
                }
            }
            this.setCalendarField(this.IntervalField_, this.Interval_);
            this.fillPopupMenu();
        }
    }

    public void setLimits(Comparable min_limit, Comparable max_limit) {
        this.setStart(min_limit);
        this.setEnd(max_limit);
    }

    public void setLongDateFormat() {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
        if (editor instanceof JSpinner.DateEditor) {
            ((JSpinner.DateEditor)editor).getFormat().applyPattern(LongFormat_);
            this.fillPopupMenu(this.LongList_);
            this.fireStateChanged();
        }
    }

    public void setOverwriteMode(boolean mode) {
        if (!(this.getTextField().getCaret() instanceof GPosCaret)) {
            this.getTextField().setCaret(this.Caret_);
        }
        ((DefaultFormatter)this.getTextField().getFormatter()).setOverwriteMode(mode);
        ((GPosCaret)this.getTextField().getCaret()).setOverwriteMode(mode);
    }

    public void setShortDateFormat() {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
        if (editor instanceof JSpinner.DateEditor) {
            ((JSpinner.DateEditor)editor).getFormat().applyPattern(ShortFormat_);
            this.fillPopupMenu(this.ShortList_);
            this.fireStateChanged();
        }
    }

    public void setStart(Comparable min_limit) {
        if (min_limit != null) {
            SpinnerModel model = this.getModel();
            if (model instanceof SpinnerDateModel) {
                ((SpinnerDateModel)model).setStart(min_limit);
            } else if (model instanceof SpinnerNumberModel) {
                ((SpinnerNumberModel)model).setMinimum(min_limit);
            }
        }
    }
}

