/*
 * Decompiled with CFR 0.152.
 */
package GPosGui;

import GPosGui.GPosFrame;
import GPosGui.GPosTextField;
import GPosGui.RelativePath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileNameField
extends JPanel
implements Serializable {
    private JButton Button_;
    private JTextField Entry_;
    private Color DefaultColor_ = Color.WHITE;
    private Color BackgroundErrorColor_ = Color.PINK;
    private FileFilter Filter_;
    private JFileChooser Chooser_;
    private String ChooserTitle_ = "Select a file";
    protected String DirTag_ = "CURRENT";
    protected GPosFrame Parent_ = null;
    protected boolean EmptyIsOk_ = true;
    protected boolean MustExist_ = false;

    public FileNameField() {
        this.initComponents();
    }

    public FileNameField(GPosFrame parent) {
        this.Parent_ = parent;
        this.initComponents();
    }

    public FileNameField(FileFilter filter) {
        this.Filter_ = filter;
        this.initComponents();
    }

    public FileNameField(GPosFrame parent, FileFilter filter) {
        this.Parent_ = parent;
        this.Filter_ = filter;
        this.initComponents();
    }

    public FileNameField(String dir_tag) {
        this.setDirTag(dir_tag);
        this.initComponents();
    }

    public FileNameField(GPosFrame parent, String dir_tag) {
        this.Parent_ = parent;
        this.setDirTag(dir_tag);
        this.initComponents();
    }

    public FileNameField(FileFilter filter, String dir_tag) {
        this.Filter_ = filter;
        this.setDirTag(dir_tag);
        this.initComponents();
    }

    public FileNameField(GPosFrame parent, FileFilter filter, String dir_tag) {
        this.Parent_ = parent;
        this.Filter_ = filter;
        this.setDirTag(dir_tag);
        this.initComponents();
    }

    private void initComponents() {
        this.Chooser_ = new JFileChooser();
        if (this.Filter_ != null) {
            this.Chooser_.addChoosableFileFilter(this.Filter_);
        }
        this.Chooser_.setDialogTitle(this.ChooserTitle_);
        this.Entry_ = new GPosTextField();
        this.Button_ = new JButton();
        this.setLayout(new BorderLayout());
        this.Entry_.setFont(new Font("Monospaced", 0, 12));
        this.DefaultColor_ = this.Entry_.getBackground();
        this.Entry_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileNameField.this.Entry_ActionPerformed(evt);
            }
        });
        this.Entry_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FileNameField.this.Entry_FocusLost(evt);
            }
        });
        this.add((Component)this.Entry_, "Center");
        this.Button_.setIcon(new ImageIcon(this.getClass().getResource("/GPosGui/images/Open16.gif")));
        this.Button_.setMargin(new Insets(1, 1, 1, 1));
        this.Button_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileNameField.this.Button_ActionPerformed(evt);
            }
        });
        this.add((Component)this.Button_, "East");
    }

    private void Entry_FocusLost(FocusEvent evt) {
        String file_name = this.Entry_.getText();
        if (file_name.length() > 0) {
            if (this.Parent_ != null) {
                File file = new File(file_name);
                if (file.isAbsolute()) {
                    this.setText(file);
                } else {
                    this.setText(this.Parent_.getPath("WORK") + File.separator + file_name);
                }
            } else {
                this.setText(this.Entry_.getText());
            }
        }
    }

    private void Entry_ActionPerformed(ActionEvent evt) {
        String file_name = this.Entry_.getText();
        if (file_name.length() > 0) {
            if (this.Parent_ != null) {
                File file = new File(file_name);
                if (file.isAbsolute()) {
                    this.setText(file);
                } else {
                    this.setText(this.Parent_.getPath("WORK") + File.separator + file_name);
                }
            } else {
                this.setText(this.Entry_.getText());
            }
        }
    }

    private void Button_ActionPerformed(ActionEvent evt) {
        int option;
        if (this.Parent_ != null) {
            this.Chooser_.setCurrentDirectory(new File(this.Parent_.getPath(this.DirTag_)));
        }
        if ((option = this.Chooser_.showOpenDialog(this)) == 0) {
            try {
                this.setText(this.Chooser_.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                this.setText(this.Chooser_.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void emptyFieldIsOk() {
        this.EmptyIsOk_ = true;
    }

    public Color getBackground() {
        if (this.Entry_ == null) {
            return null;
        }
        return this.Entry_.getBackground();
    }

    public int getColumns() {
        if (this.Entry_ == null) {
            return 0;
        }
        return this.Entry_.getColumns();
    }

    public String getDirTag() {
        return this.DirTag_;
    }

    public boolean getEmptyIsOkFlag() {
        return this.EmptyIsOk_;
    }

    public JTextField getEntryField() {
        return this.Entry_;
    }

    public Font getFont() {
        if (this.Entry_ == null) {
            return null;
        }
        return this.Entry_.getFont();
    }

    public String getFullPath() {
        String file_name = this.Entry_.getText();
        if (file_name.length() == 0 || !this.isOk()) {
            return "";
        }
        File file = this.Parent_ != null ? new File(this.Parent_.getPath("WORK") + File.separator + this.Entry_.getText()) : new File(this.Entry_.getText());
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            return file.getAbsolutePath();
        }
    }

    public boolean getMustExistFlag() {
        return this.MustExist_;
    }

    public boolean getOverwriteMode() {
        return ((GPosTextField)this.Entry_).getOverwriteMode();
    }

    public String getText() {
        return this.Entry_.getText();
    }

    public boolean isOk() {
        return this.Entry_.getBackground() == this.DefaultColor_;
    }

    public void mustExist() {
        this.MustExist_ = true;
    }

    public void setBackground(Color color) {
        if (this.Entry_ != null) {
            this.Entry_.setBackground(color);
        }
    }

    public void setBackgroundErrorColor(Color color) {
        this.BackgroundErrorColor_ = color;
    }

    public void setBackgroundToDefault() {
        this.Entry_.setBackground(this.DefaultColor_);
    }

    public void setBackgroundToError() {
        this.Entry_.setBackground(this.BackgroundErrorColor_);
    }

    public void setColumns(int columns) {
        if (this.Entry_ != null) {
            this.Entry_.setColumns(columns);
        }
    }

    public void setDefaultBackground(Color color) {
        if (this.Entry_ != null) {
            this.DefaultColor_ = color;
            this.Entry_.setBackground(this.DefaultColor_);
        }
    }

    public void setDirTag(String input) {
        if (input != null && input.length() > 0) {
            this.DirTag_ = input;
        }
    }

    public void setEmptyIsOkFlag(boolean flag) {
        this.EmptyIsOk_ = flag;
    }

    public void setEnabled(boolean input) {
        this.Entry_.setEditable(input);
        this.Button_.setEnabled(input);
    }

    public void setFont(Font font) {
        if (this.Entry_ != null) {
            this.Entry_.setFont(new Font(font.getFontName(), font.getSize(), 0));
        }
    }

    public void setMustExistFlag(boolean flag) {
        this.MustExist_ = flag;
    }

    public void setOverwriteMode(boolean mode) {
        if (this.Entry_ != null) {
            ((GPosTextField)this.Entry_).setOverwriteMode(mode);
            this.repaint();
        }
    }

    public void setText(File input) {
        if (this.testInput(input)) {
            this.Entry_.setBackground(this.DefaultColor_);
            if (this.Parent_ == null) {
                try {
                    this.Entry_.setText(input.getCanonicalPath());
                }
                catch (IOException ex) {
                    this.Entry_.setText(input.getAbsolutePath());
                }
            } else {
                this.Entry_.setText(RelativePath.getRelativePath(this.Parent_.getFile("WORK"), input));
                try {
                    this.Parent_.setPath(this.DirTag_, input.getCanonicalPath());
                }
                catch (IOException ex) {
                    this.Parent_.setPath(this.DirTag_, input.getAbsolutePath());
                }
            }
        } else {
            this.Entry_.setBackground(this.BackgroundErrorColor_);
            this.Entry_.setText("");
        }
    }

    public void setText(String input) {
        if (this.testInput(input)) {
            if (input == null) {
                this.Entry_.setText("");
            } else {
                this.setText(new File(input));
            }
        } else {
            this.Entry_.setBackground(this.BackgroundErrorColor_);
            this.Entry_.setText(input);
        }
    }

    public void setToolTipText(String input) {
        this.Entry_.setToolTipText(input);
        this.Button_.setToolTipText(input);
    }

    public boolean testInput(File input) {
        return input != null && (!this.MustExist_ || input.exists() && input.isFile());
    }

    public boolean testInput(String input) {
        return (input == null || input.length() == 0) && this.EmptyIsOk_ || this.testInput(new File(input));
    }
}

