/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Ellipsoid;

public class UserDefEllip
extends Ellipsoid {
    private Double Eccentricity_Squared_;
    private Double Flattening_;
    private Double SemiMajorAxis_;
    private Double SemiMinorAxis_;
    private String Name_;

    public UserDefEllip(String name, Double semi_major, Double flattening) {
        this.set(name, semi_major, flattening);
    }

    public Double getEccentricitySquared() {
        return this.Eccentricity_Squared_;
    }

    public Double getFlattening() {
        return this.Flattening_;
    }

    public String getName() {
        return this.Name_;
    }

    public Double getSemiMajorAxis() {
        return this.SemiMajorAxis_;
    }

    public Double getSemiMinorAxis() {
        return this.SemiMinorAxis_;
    }

    public final void set(Double semi_major, Double flattening) {
        this.SemiMajorAxis_ = semi_major;
        this.Flattening_ = flattening;
        this.SemiMinorAxis_ = this.SemiMajorAxis_ * (1.0 - this.Flattening_);
        this.Eccentricity_Squared_ = 1.0 - StrictMath.pow(this.SemiMinorAxis_ / this.SemiMajorAxis_, 2.0);
    }

    public final void set(String name, Double semi_major, Double flattening) {
        this.Name_ = name;
        this.set(semi_major, flattening);
    }
}

