/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SPN;
import GNSS.Sinex.SiteAntenna;
import GNSS.Sinex.SiteData;
import GNSS.Sinex.SiteEccentricity;
import GNSS.Sinex.SiteId;
import GNSS.Sinex.SiteReceiver;
import GNSS.Sinex.SolutionEpochs;
import GNSS.Sinex.SolutionEstimate;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class SiteInfo
extends SiteId {
    private SortedSet<SiteAntenna> AntennaStorage_ = new TreeSet<SiteAntenna>();
    private SortedSet<SiteEccentricity> EccentricityStorage_ = new TreeSet<SiteEccentricity>();
    private SortedSet<SiteReceiver> ReceiverStorage_ = new TreeSet<SiteReceiver>();
    private SortedSet<SolutionEpochs> EpochsStorage_ = new TreeSet<SolutionEpochs>();

    public SiteInfo() {
    }

    public SiteInfo(SiteId id) {
        this.set(id.getSiteCode(), id.getPointCode(), id.getSolutionId());
        this.setMonumentId(id.getMonumentId());
        this.setHeight(id.getHeight());
        this.setLatitude(id.getLatitude());
        this.setLongitude(id.getLongitude());
        this.setObservationCode(id.getObservationCode());
        this.setStationDescription(id.getStationDescription());
    }

    public SiteInfo(String input) throws IllegalArgumentException {
        super(input);
    }

    public SiteInfo(String site_code, String point_code) throws IllegalArgumentException {
        this.set(site_code, point_code);
    }

    public SiteInfo(String site_code, String point_code, String solution_code) throws IllegalArgumentException {
        this.set(site_code, point_code, solution_code);
    }

    public void add(Object input) {
        if (input instanceof SiteId) {
            this.add((SiteId)input);
        } else if (input instanceof SiteAntenna) {
            this.add((SiteAntenna)input);
        } else if (input instanceof SiteEccentricity) {
            this.add((SiteEccentricity)input);
        } else if (input instanceof SiteReceiver) {
            this.add((SiteReceiver)input);
        } else if (input instanceof SolutionEpochs) {
            this.add((SolutionEpochs)input);
        }
    }

    public void add(SiteAntenna input) {
        this.AntennaStorage_.add(input);
    }

    public void add(SiteEccentricity input) {
        this.EccentricityStorage_.add(input);
    }

    public void add(SiteId input) {
        this.set(input.getSiteCode(), input.getPointCode(), input.getSolutionId());
        this.setMonumentId(input.getMonumentId());
        this.setHeight(input.getHeight());
        this.setLatitude(input.getLatitude());
        this.setLongitude(input.getLongitude());
        this.setObservationCode(input.getObservationCode());
        this.setStationDescription(input.getStationDescription());
    }

    public void add(SiteReceiver input) {
        this.ReceiverStorage_.add(input);
    }

    public void add(SolutionEstimate input) {
        SolutionEpochs tmp_se2;
        for (SolutionEpochs tmp_se2 : this.EpochsStorage_) {
            if (tmp_se2.compareSPN(input) != 0) continue;
            tmp_se2.add(input);
            return;
        }
        tmp_se2 = new SolutionEpochs();
        tmp_se2.add(input);
        this.EpochsStorage_.add(tmp_se2);
    }

    public void add(SolutionEpochs input) {
        Iterator itr = this.EpochsStorage_.iterator();
        while (itr.hasNext()) {
            SolutionEpochs tmp_se = (SolutionEpochs)itr.next();
            if (tmp_se.equals(input)) {
                return;
            }
            tmp_se = (SolutionEpochs)itr.next();
            if (tmp_se.compareSPN(input) != 0) continue;
            if (tmp_se.isFirstEpochSet() && input.isFirstEpochSet() && tmp_se.getFirstEpoch().compareTo(input.getFirstEpoch()) > 0) {
                tmp_se.setFirstEpoch(input.getFirstEpoch());
            } else if (!tmp_se.isFirstEpochSet() && input.isFirstEpochSet()) {
                tmp_se.setFirstEpoch(input.getFirstEpoch());
            }
            if (tmp_se.isLastEpochSet() && input.isLastEpochSet() && tmp_se.getLastEpoch().compareTo(input.getLastEpoch()) < 0) {
                tmp_se.setLastEpoch(input.getLastEpoch());
            } else if (!tmp_se.isLastEpochSet() && input.isLastEpochSet()) {
                tmp_se.setLastEpoch(input.getLastEpoch());
            }
            return;
        }
        this.EpochsStorage_.add(input);
    }

    public Object get(DataInterface.Type type, DataInterface.Info info, Calendar epoch) {
        switch (type) {
            case ANT: {
                SiteData data = this.getStorage(this.AntennaStorage_.iterator(), epoch);
                return data == null ? null : ((SiteAntenna)data).get(info);
            }
            case ECC: {
                SiteData data = this.getStorage(this.EccentricityStorage_.iterator(), epoch);
                return data == null ? null : ((SiteEccentricity)data).get(info);
            }
            case EST: {
                SiteData data = this.getStorage(this.EpochsStorage_.iterator(), epoch);
                return data == null ? null : ((SolutionEpochs)data).getEstimate(info, epoch);
            }
            case RCV: {
                SiteData data = this.getStorage(this.ReceiverStorage_.iterator(), epoch);
                return data == null ? null : ((SiteReceiver)data).get(info);
            }
            case STDDEV: {
                SiteData data = this.getStorage(this.EpochsStorage_.iterator(), epoch);
                return data == null ? null : ((SolutionEpochs)data).getStandardDeviation(info, epoch);
            }
        }
        return null;
    }

    public Double getEst(DataInterface.Info info, Calendar epoch) {
        return (Double)this.get(DataInterface.Type.EST, info, epoch);
    }

    public Double getEstimate(DataInterface.Info info, Calendar epoch) {
        return (Double)this.get(DataInterface.Type.EST, info, epoch);
    }

    public SiteData getStorage(Iterator itr, Calendar epoch) {
        SiteData data = null;
        if (itr.hasNext()) {
            data = (SiteData)itr.next();
            if (data.getFirstEpoch().compareTo(epoch) >= 0) {
                return data;
            }
            while (itr.hasNext()) {
                data = (SiteData)itr.next();
                if (data.getFirstEpoch().compareTo(epoch) > 0 || data.getLastEpoch().compareTo(epoch) < 0) continue;
                return data;
            }
        }
        return data;
    }

    public String getAntennaSerialNumber(SPN input, Calendar epoch) {
        SiteAntenna ant2 = null;
        for (SiteAntenna ant2 : this.AntennaStorage_) {
            if (!input.equals(ant2) || epoch.compareTo(ant2.getRemoved()) >= 0) continue;
            return ant2.getSerialNumber().toString();
        }
        return ant2 == null ? null : ant2.getSerialNumber().toString();
    }

    public String getAntennaSerialNumber(SPN input, Date date) {
        SiteAntenna ant2 = null;
        for (SiteAntenna ant2 : this.AntennaStorage_) {
            if (!input.equals(ant2) || date.compareTo(ant2.getRemoved().getTime()) >= 0) continue;
            return ant2.getSerialNumber().toString();
        }
        return ant2 == null ? null : ant2.getSerialNumber().toString();
    }

    public String getAntennaType(SPN input, Calendar epoch) {
        SiteAntenna ant2 = null;
        for (SiteAntenna ant2 : this.AntennaStorage_) {
            if (!input.equals(ant2) || epoch.compareTo(ant2.getRemoved()) >= 0) continue;
            return ant2.getType().toString();
        }
        return ant2 == null ? null : ant2.getType().toString();
    }

    public String getAntennaType(SPN input, Date date) {
        SiteAntenna ant2 = null;
        for (SiteAntenna ant2 : this.AntennaStorage_) {
            if (!input.equals(ant2) || date.compareTo(ant2.getRemoved().getTime()) >= 0) continue;
            return ant2.getType().toString();
        }
        return ant2 == null ? null : ant2.getType().toString();
    }

    public String getReceiverFirmware(SPN input, Calendar epoch) {
        SiteReceiver rcvr2 = null;
        for (SiteReceiver rcvr2 : this.ReceiverStorage_) {
            if (!input.equals(rcvr2) || epoch.compareTo(rcvr2.getRemoved()) >= 0) continue;
            return rcvr2.getFirmware().toString();
        }
        return rcvr2 == null ? null : rcvr2.getFirmware().toString();
    }

    public String getReceiverFirmware(SPN input, Date date) {
        SiteReceiver rcvr2 = null;
        for (SiteReceiver rcvr2 : this.ReceiverStorage_) {
            if (!input.equals(rcvr2) || date.compareTo(rcvr2.getRemoved().getTime()) >= 0) continue;
            return rcvr2.getFirmware().toString();
        }
        return rcvr2 == null ? null : rcvr2.getFirmware().toString();
    }

    public String getReceiverSerialNumber(SPN input, Calendar epoch) {
        SiteReceiver rcvr2 = null;
        for (SiteReceiver rcvr2 : this.ReceiverStorage_) {
            if (!input.equals(rcvr2) || epoch.compareTo(rcvr2.getRemoved()) >= 0) continue;
            return rcvr2.getSerialNumber().toString();
        }
        return rcvr2 == null ? null : rcvr2.getSerialNumber().toString();
    }

    public String getReceiverSerialNumber(SPN input, Date date) {
        SiteReceiver rcvr2 = null;
        for (SiteReceiver rcvr2 : this.ReceiverStorage_) {
            if (!input.equals(rcvr2) || date.compareTo(rcvr2.getRemoved().getTime()) >= 0) continue;
            return rcvr2.getSerialNumber().toString();
        }
        return rcvr2 == null ? null : rcvr2.getSerialNumber().toString();
    }

    public String getReceiverType(SPN input, Calendar epoch) {
        SiteReceiver rcvr2 = null;
        for (SiteReceiver rcvr2 : this.ReceiverStorage_) {
            if (!input.equals(rcvr2) || epoch.compareTo(rcvr2.getRemoved()) >= 0) continue;
            return rcvr2.getType().toString();
        }
        return rcvr2 == null ? null : rcvr2.getType().toString();
    }

    public String getReceiverType(SPN input, Date date) {
        SiteReceiver rcvr2 = null;
        for (SiteReceiver rcvr2 : this.ReceiverStorage_) {
            if (!input.equals(rcvr2) || date.compareTo(rcvr2.getRemoved().getTime()) >= 0) continue;
            return rcvr2.getType().toString();
        }
        return rcvr2 == null ? null : rcvr2.getType().toString();
    }

    public Double getStandardDeviation(DataInterface.Info info, Calendar epoch) {
        return (Double)this.get(DataInterface.Type.STDDEV, info, epoch);
    }

    public Double getStdDev(DataInterface.Info info, Calendar epoch) {
        return (Double)this.get(DataInterface.Type.STDDEV, info, epoch);
    }

    public String toString() {
        String tmp = super.toString();
        Iterator itr = this.ReceiverStorage_.iterator();
        while (itr.hasNext()) {
            tmp = tmp + "\n" + ((SiteReceiver)itr.next()).toString();
        }
        itr = this.AntennaStorage_.iterator();
        while (itr.hasNext()) {
            tmp = tmp + "\n" + ((SiteAntenna)itr.next()).toString();
        }
        itr = this.EccentricityStorage_.iterator();
        while (itr.hasNext()) {
            tmp = tmp + "\n" + ((SiteEccentricity)itr.next()).toString();
        }
        itr = this.EpochsStorage_.iterator();
        while (itr.hasNext()) {
            tmp = tmp + "\n" + ((SolutionEpochs)itr.next()).toString();
        }
        itr = this.EpochsStorage_.iterator();
        while (itr.hasNext()) {
            Iterator<SolutionEstimate> itr2 = ((SolutionEpochs)itr.next()).iterator();
            while (itr2.hasNext()) {
                tmp = tmp + "\n" + itr2.next().toString();
            }
        }
        return tmp;
    }
}

