/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Sinex.SPN;
import GNSS.Sinex.SiteAntenna;
import GNSS.Sinex.SiteEccentricity;
import GNSS.Sinex.SiteId;
import GNSS.Sinex.SiteReceiver;
import GNSS.Sinex.SolutionEpochs;
import GNSS.Sinex.SolutionEstimate;
import GNSS.SiteInfo;
import GNSS.UtcTime;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SinexFile {
    private Matcher Matcher_;
    private static final Pattern Comment_ = Pattern.compile("^\\*");
    private static final Pattern Data_ = Pattern.compile("^ ");
    private static final Pattern EndBlock_ = Pattern.compile("^-(.*)");
    private static final Pattern StartBlock_ = Pattern.compile("^+(.*)");
    private static final Pattern Header_ = Pattern.compile("^%");
    private static final Pattern HeaderData_ = Pattern.compile("^%=(SNX)([\\d ]\\d\\.\\d\\d) (.{3}) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) (.{3}) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) (.) ([\\d ]{4}\\d) (.)([ SOETCAXV]*)$");
    private static final Pattern FileComment_ = Pattern.compile("^[\\+\\-]FILE/COMMENT.*$");
    private static final Pattern FileCommentData_ = Pattern.compile(" (.*) *$");
    private static final Pattern FileReference_ = Pattern.compile("^[\\+\\-]FILE/REFERENCE.*$");
    private static final Pattern FileReferenceData_ = Pattern.compile(" (.*) *$");
    private static final Pattern InputAcknowledgments_ = Pattern.compile("^[\\+\\-]INPUT/ACKNOWLEDGMENTS.*$");
    private static final Pattern InputAcknowledgmentsData_ = Pattern.compile(" (.*) *$");
    private static final Pattern InputFiles_ = Pattern.compile("^[\\+\\-]INPUT/FILES.*$");
    private static final Pattern InputFilesData_ = Pattern.compile(" (.{3}) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) (.{29}) (.{32}) *$");
    private static final Pattern InputHistory_ = Pattern.compile("^[\\+\\-]INPUT/HISTORY.*$");
    private static final Pattern InputHistoryData_ = Pattern.compile("^ ([\\+\\=])(SNX)([\\d ]\\d\\.\\d\\d) (.{3}) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) (.{3}) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) (.) ([\\d ]{4}\\d) (.)([ SOETCAXV]*)$");
    private static final Pattern SatelliteId_ = Pattern.compile("^[\\+\\-]SATELLITE/ID.*$");
    private static final Pattern SatelliteIdData_ = Pattern.compile(" ([ GRES][ \\d]{2}\\d) ([ \\d]\\d) (.{9}) (.) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) (.{20}) *$");
    private static final Pattern SatellitePhaseCenter_ = Pattern.compile("^[\\+\\-]SATELLITE/PHASE_CENTER.*$");
    private static final Pattern SatellitePhaseCenterData_ = Pattern.compile(" ([ GRES][ \\d]{2}\\d) (.) (.{10}) ([AR]) ([EF]) *$ (//d) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) (//d) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4})");
    private static final Pattern SiteGpsPhaseCenter_ = Pattern.compile("^[\\+\\-]SITE/GPS_PHASE_CENTER.*$");
    private static final Pattern SiteGpsPhaseCenterData_ = Pattern.compile(" (.{20}) (.{5}) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) ([\\+\\- ]\\.\\d{4}) (.{10}) *$");
    private final String DefaultEpoch_ = "00:000:00000";
    private ArrayList<TreeMap<String, Object>> FileList_ = new ArrayList();
    private ArrayList<SPN> SiteIdList_ = new ArrayList(25);
    private ArrayList<SPN> WorkingSiteIdList_ = new ArrayList(25);
    private SortedSet<SiteInfo> Sites_ = new TreeSet<SiteInfo>();
    private RandomAccessFile FileStream_;
    private String Status_ = "";
    private TreeMap<String, Object> WorkingFile_ = null;
    private UtcTime DefaultFirstEpoch_ = new UtcTime(1980, 0, 6, 0, 0, 0);
    private UtcTime DefaultLastEpoch_ = new UtcTime(2050, 0, 1, 0, 0, 0);
    private UtcTime UtcEpoch_ = new UtcTime();
    private boolean AscendingPriority_ = true;
    private int Ios_ = 0;
    private int LineCount_ = 0;
    private long FileLength_ = 0L;
    private long StartOfInfo_ = 0L;

    public SinexFile() {
    }

    public SinexFile(boolean priority) {
        this.AscendingPriority_ = priority;
    }

    public int addFile(File file) {
        this.Ios_ = 0;
        this.Status_ = "";
        for (TreeMap<String, Object> WorkingFile_ : this.FileList_) {
            if (!SinexFile.isSameFile((File)WorkingFile_.get("FILE"), file)) continue;
            this.Status_ = (String)WorkingFile_.get("STATUS");
            this.Ios_ = (Integer)WorkingFile_.get("IOS");
            return this.Ios_;
        }
        this.WorkingFile_ = new TreeMap();
        this.WorkingFile_.put("FILE", file);
        this.WorkingFile_.put("LENGTH", file.length());
        this.WorkingFile_.put("IOS", this.Ios_);
        this.WorkingFile_.put("STATUS", this.Status_.toString());
        this.WorkingFile_.put("HAS BEEN READ", false);
        this.FileList_.add(this.WorkingFile_);
        this.WorkingSiteIdList_.clear();
        this.WorkingSiteIdList_.addAll(this.SiteIdList_);
        this.Ios_ = this.readFile();
        if (this.Ios_ == 0) {
            // empty if block
        }
        return this.Ios_;
    }

    public int addFile(SinexFile sinex_file) {
        return 0;
    }

    public int addFile(String file_name) {
        try {
            return this.addFile(new File(file_name));
        }
        catch (NullPointerException npe) {
            this.Status_ = "No file name was entered.";
            this.Ios_ = 1;
            return 1;
        }
    }

    public void addSite(SPN site_identifier) {
        if (site_identifier != null) {
            this.WorkingSiteIdList_.clear();
            Iterator<SPN> site_id_itr = this.SiteIdList_.iterator();
            while (site_id_itr.hasNext()) {
                if (!site_identifier.equals(site_id_itr.next())) continue;
                return;
            }
            this.SiteIdList_.add(site_identifier);
            this.WorkingSiteIdList_.add(site_identifier);
            for (TreeMap<String, Object> this.WorkingFile_ : this.FileList_) {
                if ((Integer)this.WorkingFile_.get("IOS") != 0) continue;
                this.readFile();
            }
        }
    }

    public void addSite(String site_code) {
        this.addSite(new SPN(site_code));
    }

    public void addSite(String site_code, String point_code) {
        this.addSite(new SPN(site_code, point_code));
    }

    public void addSite(String site_code, String point_code, String solution_id) {
        this.addSite(new SPN(site_code, point_code, solution_id));
    }

    public Object get(String name) {
        if (name.equalsIgnoreCase("NUMBER OF FILES")) {
            return this.FileList_.size();
        }
        Object value = null;
        for (int i = 0; i < this.FileList_.size(); ++i) {
            if (!this.FileList_.get(i).containsKey(name)) continue;
            value = this.FileList_.get(i).get(name);
            break;
        }
        return value;
    }

    public Object get(int index, String name) {
        if (name.equalsIgnoreCase("NUMBER OF FILES")) {
            return this.FileList_.size();
        }
        if (index < this.FileList_.size() && this.FileList_.get(index).containsKey(name)) {
            return this.FileList_.get(index).get(name);
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.WorkingFile_ != null) {
            return ((File)this.WorkingFile_.get("FILE")).getAbsolutePath();
        }
        return null;
    }

    public String getAbsolutePath(int index) {
        if (index >= 0 && index < this.FileList_.size()) {
            return ((File)this.FileList_.get(index).get("FILE")).getAbsolutePath();
        }
        return null;
    }

    public String getCanonicalPath() {
        if (this.WorkingFile_ != null) {
            try {
                return ((File)this.WorkingFile_.get("FILE")).getCanonicalPath();
            }
            catch (IOException ex) {
                return ((File)this.WorkingFile_.get("FILE")).getAbsolutePath();
            }
        }
        return null;
    }

    public String getCanonicalPath(int index) {
        if (index >= 0 && index < this.FileList_.size()) {
            try {
                return ((File)this.FileList_.get(index).get("FILE")).getCanonicalPath();
            }
            catch (IOException ex) {
                return ((File)this.FileList_.get(index).get("FILE")).getAbsolutePath();
            }
        }
        return null;
    }

    public File getFile() {
        if (this.WorkingFile_ != null) {
            return (File)this.WorkingFile_.get("FILE");
        }
        return null;
    }

    public File getFile(int index) {
        if (index >= 0 && index < this.FileList_.size()) {
            return (File)this.FileList_.get(index).get("FILE");
        }
        return null;
    }

    public int getIos() {
        return this.Ios_;
    }

    public String getName() {
        if (this.WorkingFile_ != null) {
            return ((File)this.WorkingFile_.get("FILE")).getName();
        }
        return null;
    }

    public String getName(int index) {
        if (index >= 0 && index < this.FileList_.size()) {
            return ((File)this.FileList_.get(index).get("FILE")).getName();
        }
        return null;
    }

    public String getPath() {
        if (this.WorkingFile_ != null) {
            return this.getCanonicalPath().substring(0, this.getCanonicalPath().length() - this.getName().length() - 1);
        }
        return null;
    }

    public String getPath(int index) {
        if (index >= 0 && index < this.FileList_.size()) {
            return this.getCanonicalPath(index).substring(0, this.getCanonicalPath(index).length() - this.getName(index).length() - 1);
        }
        return null;
    }

    public SiteInfo getSiteInfo(String site_code) {
        return this.getSiteInfo(new SPN(site_code));
    }

    public SiteInfo getSiteInfo(SPN input) {
        SiteInfo site2;
        for (SiteInfo site2 : this.Sites_) {
            if (!input.equals(site2)) continue;
            return site2;
        }
        site2 = new SiteInfo(input.getSiteCode(), input.getPointCode());
        this.Sites_.add(site2);
        return site2;
    }

    public SiteInfo getSiteInfo(String site_code, String point_code) {
        return this.getSiteInfo(new SPN(site_code, point_code));
    }

    public SiteInfo getSiteInfo(String site_code, String point_code, String solution_id) {
        return this.getSiteInfo(new SPN(site_code, point_code, solution_id));
    }

    public String getStatus() {
        return this.Status_;
    }

    public Object has(String name) {
        if (name.equalsIgnoreCase("NUMBER OF FILES")) {
            return true;
        }
        boolean value = false;
        for (int i = 0; i < this.FileList_.size(); ++i) {
            if (!this.FileList_.get(i).containsKey(name)) continue;
            value = true;
            break;
        }
        return value;
    }

    public boolean has(int index, String name) {
        if (name.equalsIgnoreCase("NUMBER OF FILES")) {
            return true;
        }
        return index < this.FileList_.size() && this.FileList_.get(index).containsKey(name);
    }

    private static boolean isSameFile(File one, File two) {
        try {
            return one != null && two != null && one.exists() && two.exists() && one.isFile() && two.isFile() && one.canRead() && two.canRead() && one.getCanonicalPath().equals(two.getCanonicalPath()) && one.lastModified() == two.lastModified();
        }
        catch (IOException ex) {
            return false;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public long length() {
        if (this.WorkingFile_ != null) {
            return (Long)this.WorkingFile_.get("LENGTH");
        }
        return 0L;
    }

    public long length(int index) {
        if (index >= 0 && index < this.FileList_.size()) {
            return (Long)this.FileList_.get(index).get("LENGTH");
        }
        return 0L;
    }

    public long tell() {
        try {
            return this.FileStream_.getFilePointer();
        }
        catch (IOException ioe) {
            return this.FileLength_;
        }
    }

    public int tellPercentage() {
        try {
            return this.FileLength_ == 0L ? 0 : (int)(100L * this.FileStream_.getFilePointer() / this.FileLength_);
        }
        catch (IOException ioe) {
            return 100;
        }
    }

    private void initAll() {
        this.Ios_ = 0;
        this.Status_ = "";
    }

    private void close() {
        if (this.FileStream_ != null) {
            File file = (File)this.WorkingFile_.get("FILE");
            try {
                this.FileStream_.close();
                this.WorkingFile_.put("IOS", this.Ios_);
                this.WorkingFile_.put("STATUS", this.Status_.toString());
                this.FileStream_ = null;
            }
            catch (IOException ioe) {
                this.Ios_ = 107;
                this.Status_ = "closing \"" + file.toString() + "\"\n" + ioe.getMessage();
                this.WorkingFile_.put("IOS", this.Ios_);
                this.WorkingFile_.put("STATUS", this.Status_.toString());
                this.WorkingFile_ = null;
                this.FileStream_ = null;
            }
            catch (SecurityException se) {
                this.Ios_ = 108;
                this.Status_ = "closing \"" + file.toString() + "\"\n" + se.getMessage();
                this.WorkingFile_.put("IOS", this.Ios_);
                this.WorkingFile_.put("STATUS", this.Status_.toString());
                this.WorkingFile_ = null;
                this.FileStream_ = null;
            }
        }
    }

    private RandomAccessFile open() {
        if (this.WorkingFile_ != null && (Integer)this.WorkingFile_.get("IOS") == 0) {
            File file = (File)this.WorkingFile_.get("FILE");
            try {
                return new RandomAccessFile(file, "r");
            }
            catch (IOException ioe) {
                this.Ios_ = 102;
                this.Status_ = "opening \"" + file.toString() + "\"\n" + ioe.getMessage();
                this.WorkingFile_.put("IOS", this.Ios_);
                this.WorkingFile_.put("STATUS", this.Status_.toString());
                this.WorkingFile_ = null;
                return null;
            }
            catch (SecurityException se) {
                this.Ios_ = 103;
                this.Status_ = "opening \"" + file.toString() + "\"\n" + se.getMessage();
                this.WorkingFile_.put("IOS", this.Ios_);
                this.WorkingFile_.put("STATUS", this.Status_.toString());
                this.WorkingFile_ = null;
                return null;
            }
        }
        return null;
    }

    public int read(String file_name) {
        return this.addFile(file_name);
    }

    public int read(SinexFile sinex_file) {
        return this.addFile(sinex_file);
    }

    public int read(File file) {
        return this.addFile(file);
    }

    private int readSiteAntennaBlock(int count) throws IOException, IllegalArgumentException {
        String text = "";
        Pattern block_pattern = SiteAntenna.getBlockPattern();
        Pattern data_pattern = SiteAntenna.getDataPattern();
        while ((text = this.FileStream_.readLine()) != null) {
            ++count;
            this.Matcher_ = data_pattern.matcher(text);
            if (this.Matcher_.find(0)) {
                SiteAntenna id = new SiteAntenna(this.WorkingFile_.get("START TIME"), this.WorkingFile_.get("STOP TIME"), this.Matcher_);
                Iterator<SPN> itr = this.WorkingSiteIdList_.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equals(id)) continue;
                    this.getSiteInfo(id).add(id);
                }
                continue;
            }
            this.Matcher_ = block_pattern.matcher(text);
            if (this.Matcher_.find(0)) break;
            this.Matcher_ = Comment_.matcher(text);
            if (this.Matcher_.find(0)) continue;
            this.Status_ = "unrecognized record in " + SiteAntenna.getBlock() + " block @ line " + Integer.toString(count);
            this.Ios_ = 2068;
            break;
        }
        return count;
    }

    private int readSiteEccentricityBlock(int count) throws IOException, IllegalArgumentException {
        String text = "";
        Pattern block_pattern = SiteEccentricity.getBlockPattern();
        Pattern data_pattern = SiteEccentricity.getDataPattern();
        while ((text = this.FileStream_.readLine()) != null) {
            ++count;
            this.Matcher_ = data_pattern.matcher(text);
            if (this.Matcher_.find(0)) {
                SiteEccentricity id = new SiteEccentricity(this.WorkingFile_.get("START TIME"), this.WorkingFile_.get("STOP TIME"), this.Matcher_);
                Iterator<SPN> itr = this.WorkingSiteIdList_.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equals(id)) continue;
                    this.getSiteInfo(id).add(id);
                }
                continue;
            }
            this.Matcher_ = block_pattern.matcher(text);
            if (this.Matcher_.find(0)) break;
            this.Matcher_ = Comment_.matcher(text);
            if (this.Matcher_.find(0)) continue;
            this.Status_ = "unrecognized record in " + SiteEccentricity.getBlock() + " block @ line " + Integer.toString(count);
            this.Ios_ = 2069;
            break;
        }
        return count;
    }

    private int readSiteIdBlock(int count) throws IOException, IllegalArgumentException {
        String text = "";
        Pattern block_pattern = SiteId.getBlockPattern();
        Pattern data_pattern = SiteId.getDataPattern();
        while ((text = this.FileStream_.readLine()) != null) {
            ++count;
            this.Matcher_ = data_pattern.matcher(text);
            if (this.Matcher_.find(0)) {
                SiteId id = new SiteId(this.Matcher_);
                Iterator<SPN> itr = this.WorkingSiteIdList_.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equals(id)) continue;
                    this.getSiteInfo(id).add(id);
                }
                continue;
            }
            this.Matcher_ = block_pattern.matcher(text);
            if (this.Matcher_.find(0)) break;
            this.Matcher_ = Comment_.matcher(text);
            if (this.Matcher_.find(0)) continue;
            this.Status_ = "unrecognized record in " + SiteId.getBlock() + " block @ line " + Integer.toString(count);
            this.Ios_ = 2070;
            break;
        }
        return count;
    }

    private int readSiteReceiverBlock(int count) throws IOException, IllegalArgumentException {
        String text = "";
        Pattern block_pattern = SiteReceiver.getBlockPattern();
        Pattern data_pattern = SiteReceiver.getDataPattern();
        while ((text = this.FileStream_.readLine()) != null) {
            ++count;
            this.Matcher_ = data_pattern.matcher(text);
            if (this.Matcher_.find(0)) {
                SiteReceiver id = new SiteReceiver(this.WorkingFile_.get("START TIME"), this.WorkingFile_.get("STOP TIME"), this.Matcher_);
                Iterator<SPN> itr = this.WorkingSiteIdList_.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equals(id)) continue;
                    this.getSiteInfo(id).add(id);
                }
                continue;
            }
            this.Matcher_ = block_pattern.matcher(text);
            if (this.Matcher_.find(0)) break;
            this.Matcher_ = Comment_.matcher(text);
            if (this.Matcher_.find(0)) continue;
            this.Status_ = "unrecognized record in " + SiteReceiver.getBlock() + " block @ line " + Integer.toString(count);
            this.Ios_ = 2071;
            break;
        }
        return count;
    }

    private int readSolutionEstimateBlock(int count) throws IOException, IllegalArgumentException {
        String text = "";
        Pattern block_pattern = SolutionEstimate.getBlockPattern();
        Pattern data_pattern = SolutionEstimate.getDataPattern();
        while ((text = this.FileStream_.readLine()) != null) {
            ++count;
            this.Matcher_ = data_pattern.matcher(text);
            if (this.Matcher_.find(0)) {
                SolutionEstimate id = new SolutionEstimate(this.Matcher_);
                Iterator<SPN> itr = this.WorkingSiteIdList_.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equals(id)) continue;
                    this.getSiteInfo(id).add(id);
                }
                continue;
            }
            this.Matcher_ = block_pattern.matcher(text);
            if (this.Matcher_.find(0)) break;
            this.Matcher_ = Comment_.matcher(text);
            if (this.Matcher_.find(0)) continue;
            this.Status_ = "unrecognized record in " + SolutionEstimate.getBlock() + " block @ line " + Integer.toString(count);
            this.Ios_ = 2072;
            break;
        }
        return count;
    }

    private int readSolutionEpochsBlock(int count) throws IOException, IllegalArgumentException {
        String text = "";
        Pattern block_pattern = SolutionEpochs.getBlockPattern();
        Pattern data_pattern = SolutionEpochs.getDataPattern();
        while ((text = this.FileStream_.readLine()) != null) {
            ++count;
            this.Matcher_ = data_pattern.matcher(text);
            if (this.Matcher_.find(0)) {
                SolutionEpochs id = new SolutionEpochs(this.WorkingFile_.get("START TIME"), this.WorkingFile_.get("STOP TIME"), this.Matcher_);
                Iterator<SPN> itr = this.WorkingSiteIdList_.iterator();
                while (itr.hasNext()) {
                    if (!itr.next().equals(id)) continue;
                    this.getSiteInfo(id).add(id);
                }
                continue;
            }
            this.Matcher_ = block_pattern.matcher(text);
            if (this.Matcher_.find(0)) break;
            this.Matcher_ = Comment_.matcher(text);
            if (this.Matcher_.find(0)) continue;
            this.Status_ = "unrecognized record in " + SolutionEpochs.getBlock() + " block @ line " + Integer.toString(count);
            this.Ios_ = 2072;
            break;
        }
        return count;
    }

    private int readFile() {
        if (this.WorkingFile_ != null && (this.Ios_ = ((Integer)this.WorkingFile_.get("IOS")).intValue()) == 0) {
            this.FileStream_ = this.open();
            if (this.FileStream_ != null) {
                this.Ios_ = (Boolean)this.WorkingFile_.get("HAS BEEN READ") != false ? this.readFileBlockByBlock() : this.readFileLineByLine();
                this.WorkingFile_.put("IOS", this.Ios_);
                this.WorkingFile_.put("STATUS", this.Status_.toString());
                this.close();
            }
            return this.Ios_;
        }
        this.Ios_ = (Integer)this.WorkingFile_.get("IOS");
        if (this.Ios_ != 0) {
            this.Status_ = (String)this.WorkingFile_.get("STATUS");
            return this.Ios_;
        }
        this.Status_ = "invalid or empty file";
        this.Ios_ = -1;
        return -1;
    }

    private int readFileBlockByBlock() {
        String text = "";
        int line_count = 0;
        try {
            if (this.WorkingFile_.containsKey(SiteAntenna.getBlock() + " POINTER")) {
                this.FileStream_.seek((Long)this.WorkingFile_.get(SiteAntenna.getBlock() + " POINTER"));
                line_count = this.readSiteAntennaBlock((Integer)this.WorkingFile_.get(SiteAntenna.getBlock() + " LINE"));
            }
            if (this.WorkingFile_.containsKey(SiteEccentricity.getBlock() + " POINTER")) {
                this.FileStream_.seek((Long)this.WorkingFile_.get(SiteEccentricity.getBlock() + " POINTER"));
                line_count = this.readSiteEccentricityBlock((Integer)this.WorkingFile_.get(SiteEccentricity.getBlock() + " LINE"));
            }
            if (this.WorkingFile_.containsKey(SiteId.getBlock() + " POINTER")) {
                this.FileStream_.seek((Long)this.WorkingFile_.get(SiteId.getBlock() + " POINTER"));
                line_count = this.readSiteIdBlock((Integer)this.WorkingFile_.get(SiteId.getBlock() + " LINE"));
            }
            if (this.WorkingFile_.containsKey(SiteReceiver.getBlock() + " POINTER")) {
                this.FileStream_.seek((Long)this.WorkingFile_.get(SiteReceiver.getBlock() + " POINTER"));
                line_count = this.readSiteReceiverBlock((Integer)this.WorkingFile_.get(SiteReceiver.getBlock() + " LINE"));
            }
            if (this.WorkingFile_.containsKey(SolutionEpochs.getBlock() + " POINTER")) {
                this.FileStream_.seek((Long)this.WorkingFile_.get(SolutionEpochs.getBlock() + " POINTER"));
                line_count = this.readSolutionEpochsBlock((Integer)this.WorkingFile_.get(SolutionEpochs.getBlock() + " LINE"));
            }
        }
        catch (NumberFormatException nfe) {
            this.Status_ = "nfe in SINEX file @ line " + line_count + "\n" + nfe.getMessage();
            this.Ios_ = 2011;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            this.Status_ = "sioobe in SINEX file @ line " + line_count + "\n" + sioobe.getMessage();
            this.Ios_ = 2012;
        }
        catch (EOFException eof) {
            this.Status_ = "eof reached";
            this.Ios_ = -1;
        }
        catch (RuntimeException re) {
            this.Status_ = "re in SINEX file @ line " + line_count + "\n" + re.getMessage();
            this.Ios_ = 2013;
        }
        catch (IOException ioex) {
            this.Status_ = "ioex in SINEX file @ line " + line_count + "\n" + ioex.getMessage();
            this.Ios_ = 2014;
        }
        return this.Ios_;
    }

    private int readFileLineByLine() {
        String text = "";
        int line_count = 0;
        try {
            this.FileStream_.seek(0L);
            boolean in_block = false;
            while (this.Ios_ == 0 && (text = this.FileStream_.readLine()) != null) {
                ++line_count;
                this.Matcher_ = Header_.matcher(text);
                if (this.Matcher_.find(0)) {
                    this.scanHeaderLine(text);
                    continue;
                }
                this.Matcher_ = FileComment_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = FileReference_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = InputAcknowledgments_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = InputFiles_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = InputHistory_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = SatelliteId_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = SatellitePhaseCenter_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = SiteAntenna.getBlockPattern().matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    in_block = text.charAt(0) == '+';
                    if (!in_block) continue;
                    this.WorkingFile_.put(SiteAntenna.getBlock() + " POINTER", this.FileStream_.getFilePointer());
                    this.WorkingFile_.put(SiteAntenna.getBlock() + " LINE", line_count);
                    line_count = this.readSiteAntennaBlock(line_count);
                    System.out.println(SiteAntenna.getBlock() + " " + this.WorkingFile_.get(SiteAntenna.getBlock() + " LINE"));
                    System.out.println(SiteAntenna.getBlock() + " " + this.WorkingFile_.get(SiteAntenna.getBlock() + " POINTER"));
                    System.out.println(SiteAntenna.getBlock() + " " + line_count);
                    in_block = this.Ios_ != 0;
                    continue;
                }
                this.Matcher_ = SiteEccentricity.getBlockPattern().matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    in_block = text.charAt(0) == '+';
                    if (!in_block) continue;
                    this.WorkingFile_.put(SiteEccentricity.getBlock() + " POINTER", this.FileStream_.getFilePointer());
                    this.WorkingFile_.put(SiteEccentricity.getBlock() + " LINE", line_count);
                    line_count = this.readSiteEccentricityBlock(line_count);
                    System.out.println(SiteEccentricity.getBlock() + " " + this.WorkingFile_.get(SiteEccentricity.getBlock() + " LINE"));
                    System.out.println(SiteEccentricity.getBlock() + " " + this.WorkingFile_.get(SiteEccentricity.getBlock() + " POINTER"));
                    System.out.println(SiteEccentricity.getBlock() + " " + line_count);
                    in_block = this.Ios_ != 0;
                    continue;
                }
                this.Matcher_ = SiteGpsPhaseCenter_.matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    continue;
                }
                this.Matcher_ = SiteId.getBlockPattern().matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    if (!in_block) continue;
                    this.WorkingFile_.put(SiteId.getBlock() + " POINTER", this.FileStream_.getFilePointer());
                    this.WorkingFile_.put(SiteId.getBlock() + " LINE", line_count);
                    line_count = this.readSiteIdBlock(line_count);
                    System.out.println(SiteId.getBlock() + " " + this.WorkingFile_.get(SiteId.getBlock() + " LINE"));
                    System.out.println(SiteId.getBlock() + " " + this.WorkingFile_.get(SiteId.getBlock() + " POINTER"));
                    System.out.println(SiteId.getBlock() + " " + line_count);
                    in_block = this.Ios_ != 0;
                    continue;
                }
                this.Matcher_ = SiteReceiver.getBlockPattern().matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    if (!in_block) continue;
                    this.WorkingFile_.put(SiteReceiver.getBlock() + " POINTER", this.FileStream_.getFilePointer());
                    this.WorkingFile_.put(SiteReceiver.getBlock() + " LINE", line_count);
                    line_count = this.readSiteReceiverBlock(line_count);
                    System.out.println(SiteReceiver.getBlock() + " " + this.WorkingFile_.get(SiteReceiver.getBlock() + " LINE"));
                    System.out.println(SiteReceiver.getBlock() + " " + this.WorkingFile_.get(SiteReceiver.getBlock() + " POINTER"));
                    System.out.println(SiteReceiver.getBlock() + " " + line_count);
                    in_block = this.Ios_ != 0;
                    continue;
                }
                this.Matcher_ = SolutionEpochs.getBlockPattern().matcher(text);
                if (this.Matcher_.find(0)) {
                    in_block = text.charAt(0) == '+';
                    in_block = text.charAt(0) == '+';
                    if (!in_block) continue;
                    this.WorkingFile_.put(SolutionEpochs.getBlock() + " POINTER", this.FileStream_.getFilePointer());
                    this.WorkingFile_.put(SolutionEpochs.getBlock() + " LINE", line_count);
                    line_count = this.readSolutionEpochsBlock(line_count);
                    System.out.println(SolutionEpochs.getBlock() + " " + this.WorkingFile_.get(SolutionEpochs.getBlock() + " LINE"));
                    System.out.println(SolutionEpochs.getBlock() + " " + this.WorkingFile_.get(SolutionEpochs.getBlock() + " POINTER"));
                    System.out.println(SolutionEpochs.getBlock() + " " + line_count);
                    in_block = this.Ios_ != 0;
                    continue;
                }
                this.Matcher_ = SolutionEstimate.getBlockPattern().matcher(text);
                if (!this.Matcher_.find(0)) continue;
                in_block = text.charAt(0) == '+';
                in_block = text.charAt(0) == '+';
                if (!in_block) continue;
                this.WorkingFile_.put(SolutionEstimate.getBlock() + " POINTER", this.FileStream_.getFilePointer());
                this.WorkingFile_.put(SolutionEstimate.getBlock() + " LINE", line_count);
                line_count = this.readSolutionEstimateBlock(line_count);
                System.out.println(SolutionEstimate.getBlock() + " " + this.WorkingFile_.get(SolutionEstimate.getBlock() + " LINE"));
                System.out.println(SolutionEstimate.getBlock() + " " + this.WorkingFile_.get(SolutionEstimate.getBlock() + " POINTER"));
                System.out.println(SolutionEstimate.getBlock() + " " + line_count);
                in_block = this.Ios_ != 0;
            }
            if (in_block && this.Ios_ == 0) {
                this.Status_ = "unexpected EOF";
                this.Ios_ = 2020;
                return this.Ios_;
            }
            this.WorkingFile_.put("HAS BEEN READ", true);
        }
        catch (NumberFormatException nfe) {
            this.Status_ = "nfe in SINEX file @ line " + line_count + "\n" + nfe.getMessage();
            this.Ios_ = 2021;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            this.Status_ = "sioobe in SINEX file @ line " + line_count + "\n" + sioobe.getMessage();
            this.Ios_ = 2022;
        }
        catch (EOFException eof) {
            this.Status_ = "eof reached";
            this.Ios_ = -1;
        }
        catch (RuntimeException re) {
            this.Status_ = "re in SINEX file @ line " + line_count + "\n" + re.getMessage();
            this.Ios_ = 2023;
        }
        catch (IOException ioex) {
            this.Status_ = "ioex in SINEX file @ line " + line_count + "\n" + ioex.getMessage();
            this.Ios_ = 2024;
        }
        return this.Ios_;
    }

    private int readHeader() {
        if (this.WorkingFile_ != null && (this.Ios_ = ((Integer)this.WorkingFile_.get("IOS")).intValue()) == 0) {
            this.FileStream_ = this.open();
            if (this.FileStream_ != null) {
                try {
                    this.Ios_ = this.scanHeaderLine(this.FileStream_.readLine());
                    this.close();
                }
                catch (IOException ioex) {
                    this.Status_ = "ioex in SINEX file header\n" + ioex.getMessage();
                    this.Ios_ = 2001;
                }
            }
        } else {
            this.Status_ = "invalid or empty file";
            this.Ios_ = -1;
        }
        return this.Ios_;
    }

    private int scanHeaderLine(String text) {
        if (text == null) {
            this.Status_ = "empty file";
            this.Ios_ = 2002;
        } else {
            this.Matcher_ = HeaderData_.matcher(text);
            if (this.Matcher_.find(0)) {
                try {
                    this.WorkingFile_.put("TYPE", this.Matcher_.group(1).trim());
                    this.WorkingFile_.put("FORMAT", Double.valueOf(this.Matcher_.group(2).trim()));
                    this.WorkingFile_.put("FILE AGENCY", this.Matcher_.group(3).trim());
                    if (this.Matcher_.group(4).equals("00:000:00000")) {
                        this.UtcEpoch_.setTime(new Date());
                    } else {
                        this.UtcEpoch_.fromSinexString(this.Matcher_.group(4));
                    }
                    this.WorkingFile_.put("CREATION TIME", this.UtcEpoch_.getTime());
                    this.WorkingFile_.put("DATA AGENCY", this.Matcher_.group(5).trim());
                    if (this.Matcher_.group(6).equals("00:000:00000")) {
                        this.UtcEpoch_.setTime(this.DefaultFirstEpoch_.getTime());
                    } else {
                        this.UtcEpoch_.fromSinexString(this.Matcher_.group(6));
                    }
                    this.WorkingFile_.put("START TIME", this.UtcEpoch_.getTime());
                    if (this.Matcher_.group(7).equals("00:000:00000")) {
                        this.UtcEpoch_.setTime(this.DefaultLastEpoch_.getTime());
                    } else {
                        this.UtcEpoch_.fromSinexString(this.Matcher_.group(7));
                    }
                    this.WorkingFile_.put("STOP TIME", this.UtcEpoch_.getTime());
                    this.WorkingFile_.put("OBSERVATION", this.Matcher_.group(8));
                    this.WorkingFile_.put("NUMBER OF ESTIMATES", Integer.valueOf(this.Matcher_.group(9)));
                    this.WorkingFile_.put("CONTRAINT", this.Matcher_.group(10));
                    StringTokenizer tokens = new StringTokenizer(this.Matcher_.group(11));
                    ArrayList<String> contents = new ArrayList<String>(tokens.countTokens());
                    while (tokens.hasMoreTokens()) {
                        contents.add(tokens.nextToken());
                    }
                    this.WorkingFile_.put("CONTENTS", contents);
                }
                catch (NumberFormatException nfe) {
                    this.Status_ = "nfe in SINEX header " + nfe.getMessage();
                    this.Ios_ = 2003;
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    this.Status_ = "sioobe in SINEX header " + sioobe.getMessage();
                    this.Ios_ = 2004;
                }
                catch (RuntimeException re) {
                    this.Status_ = "re in SINEX header " + re.getMessage();
                    this.Ios_ = 2005;
                }
                catch (ParseException pex) {
                    this.Status_ = "pex in SINEX header " + pex.getMessage();
                    this.Ios_ = 2006;
                }
            } else {
                this.Status_ = "not a SINEX format file";
                this.Ios_ = 2008;
            }
        }
        this.Ios_ = 0;
        return this.Ios_;
    }
}

