/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SPN;
import GNSS.Sinex.SinexString;
import GNSS.UtcTime;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SolutionEstimate
extends SPN {
    private static final DecimalFormat EstExpFmt_ = new DecimalFormat("E+0;E-0");
    private static final DecimalFormat EstStdDevFmt_ = new DecimalFormat(" .0000000;-.0000000");
    private static final DecimalFormat EstValFmt_ = new DecimalFormat("+.0000000000000000;-.0000000000000000");
    private static final DecimalFormat IndexFmt_ = new DecimalFormat("####0");
    private static final String Block_ = "SOLUTION/ESTIMATE";
    private static final Pattern BlockPattern_ = Pattern.compile("^[\\+\\-]SOLUTION/ESTIMATE.*$");
    private static final Pattern DataPattern_ = Pattern.compile(" ([\\d ]{4}\\d) (.{6}) " + SPN.getDataPattern().pattern() + " ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d)" + " (.{4}) (.)" + " ([\\+\\-\\d\\.EeDd ]{21})" + " ([\\+\\-\\d\\.EeDd ]{11})" + " *$");
    private Double Estimate_ = 0.0;
    private Double StandardDeviation_ = 0.0;
    private Integer Index_ = 0;
    private SinexString ConstraintCode_ = new SinexString("2", 1, 1, true, true);
    private SinexString Type_ = new SinexString("UNKNWN", 1, 6, true, true);
    private SinexString Units_ = new SinexString(4, true, false);
    private UtcTime Epoch_ = new UtcTime();

    public SolutionEstimate() {
    }

    public SolutionEstimate(Matcher matcher) throws IllegalArgumentException {
        this.set(matcher);
    }

    public SolutionEstimate(String input) throws IllegalArgumentException {
        this.set(input);
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof SolutionEstimate) {
            return this.compareTo((SolutionEstimate)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareTo(SolutionEstimate input) {
        int value = super.compareTo(input);
        if (value == 0) {
            value = this.Index_.compareTo(input.getIndex());
            if (value == 0) {
                return -this.Type_.compareTo(input.getType());
            }
            return value;
        }
        return value;
    }

    public boolean equals(Object input) {
        if (input instanceof SolutionEstimate) {
            return this.equals((SolutionEstimate)input);
        }
        return false;
    }

    public boolean equals(SolutionEstimate input) {
        return this.compareTo(input) == 0;
    }

    public Object get(DataInterface.Info info_type) {
        if (DataInterface.Info.INDEX == info_type) {
            return this.getIndex();
        }
        if (DataInterface.Info.TYPE == info_type) {
            return this.getType();
        }
        if (DataInterface.Info.EPOCH == info_type) {
            return this.getEpoch();
        }
        if (DataInterface.Info.UNITS == info_type) {
            return this.getUnits();
        }
        if (DataInterface.Info.EST == info_type) {
            return this.getEstimate();
        }
        if (DataInterface.Info.STDDEV == info_type) {
            return this.getStandardDeviation();
        }
        if (this.Type_.equals(info_type.name())) {
            return this.getEstimate();
        }
        if (DataInterface.Info.EST == info_type) {
            return this.getEstimate();
        }
        return null;
    }

    public static String getBlock() {
        return Block_;
    }

    public static Pattern getBlockPattern() {
        return BlockPattern_;
    }

    public SinexString getConstraintCode() {
        return this.ConstraintCode_;
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public UtcTime getEpoch() {
        return this.Epoch_;
    }

    public Double getEst() {
        return this.getEstimate();
    }

    public Double getEstimate() {
        return this.Estimate_;
    }

    public Integer getIndex() {
        return this.Index_;
    }

    public Object getStandardDeviation(DataInterface.Info info_type) {
        if (DataInterface.Info.S == info_type) {
            return this.getSiteCode();
        }
        if (DataInterface.Info.P == info_type) {
            return this.getPointCode();
        }
        if (DataInterface.Info.N == info_type) {
            return this.getSolutionId();
        }
        if (DataInterface.Info.INDEX == info_type) {
            return this.getIndex();
        }
        if (DataInterface.Info.TYPE == info_type) {
            return this.getType();
        }
        if (DataInterface.Info.EPOCH == info_type) {
            return this.getEpoch();
        }
        if (DataInterface.Info.UNITS == info_type) {
            return this.getUnits();
        }
        if (DataInterface.Info.EST == info_type) {
            return this.getEstimate();
        }
        if (DataInterface.Info.STDDEV == info_type) {
            return this.getStandardDeviation();
        }
        if (this.Type_.equals(info_type.name())) {
            return this.getStandardDeviation();
        }
        return null;
    }

    public Double getStandardDeviation() {
        return this.StandardDeviation_;
    }

    public Object getStdDev(DataInterface.Info info_type) {
        return this.getStandardDeviation(info_type);
    }

    public Double getStdDev() {
        return this.getStandardDeviation();
    }

    public SinexString getType() {
        return this.Type_;
    }

    public UtcTime getTime() {
        return this.getEpoch();
    }

    public SinexString getUnits() {
        return this.Units_;
    }

    public boolean has(DataInterface.Info info_type) {
        if (DataInterface.Info.S == info_type) {
            return true;
        }
        if (DataInterface.Info.P == info_type) {
            return true;
        }
        if (DataInterface.Info.N == info_type) {
            return true;
        }
        if (DataInterface.Info.INDEX == info_type) {
            return true;
        }
        if (DataInterface.Info.TYPE == info_type) {
            return true;
        }
        if (DataInterface.Info.EPOCH == info_type) {
            return true;
        }
        if (DataInterface.Info.UNITS == info_type) {
            return true;
        }
        if (DataInterface.Info.EST == info_type) {
            return true;
        }
        if (DataInterface.Info.STDDEV == info_type) {
            return true;
        }
        return this.Type_.trim().equals(info_type.name());
    }

    public int rectifyYear(Integer year) {
        return this.rectifyYear((int)year);
    }

    public int rectifyYear(int year) {
        if (year <= 50) {
            return year + 2000;
        }
        if (year < 100) {
            return year + 1900;
        }
        return year;
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        if (DataInterface.Info.S == info_type) {
            this.setSiteCode((String)info_value);
        } else if (DataInterface.Info.P == info_type) {
            this.setPointCode((String)info_value);
        } else if (DataInterface.Info.N == info_type) {
            this.setSolutionId((String)info_value);
        } else if (DataInterface.Info.INDEX == info_type) {
            this.setIndex((Integer)info_value);
        } else if (DataInterface.Info.TYPE == info_type) {
            this.setType((String)info_value);
        } else if (DataInterface.Info.EPOCH == info_type) {
            this.setEpoch(info_value);
        } else if (DataInterface.Info.UNITS == info_type) {
            this.setUnits((String)info_value);
        } else if (DataInterface.Info.EST == info_type) {
            this.setEstimate((Double)info_value);
        } else if (DataInterface.Info.STDDEV == info_type) {
            this.setStandardDeviation((Double)info_value);
        } else if (this.Type_.equals(info_type.name())) {
            this.setEstimate((Double)info_value);
        }
    }

    public void set(Matcher matcher) throws IllegalArgumentException {
        if (matcher == null) {
            throw new IllegalArgumentException("null input");
        }
        if (matcher.pattern() != SolutionEstimate.getDataPattern()) {
            throw new IllegalArgumentException("incorrect match");
        }
        this.setNoCheck(matcher);
    }

    public void set(String input) throws IllegalArgumentException {
        this.set(SolutionEstimate.getDataPattern().matcher(input));
    }

    public void setConstraintCode(String input) throws IllegalArgumentException {
        try {
            this.ConstraintCode_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("constraint code " + iaex.getMessage());
        }
    }

    public void setEpoch() {
        this.Epoch_.setTime(new Date());
    }

    public void setEpoch(Calendar epoch) {
        this.Epoch_.setTime(epoch.getTime());
    }

    public void setEpoch(Date date) {
        this.Epoch_.setTime(date);
    }

    public void setEpoch(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.Epoch_.set(1, this.rectifyYear((int)year));
        this.Epoch_.set(6, day_of_year);
        this.Epoch_.set(-3, seconds_of_day);
    }

    public void setEpoch(Object epoch) throws IllegalArgumentException {
        if (epoch instanceof Calendar) {
            this.setEpoch((Calendar)epoch);
        } else if (epoch instanceof Date) {
            this.setEpoch((Date)epoch);
        } else {
            throw new IllegalArgumentException("input = " + epoch.getClass().getSimpleName());
        }
    }

    public void setEpoch(String input) throws IllegalArgumentException {
        try {
            if (input == null || input.length() == 0) {
                this.Epoch_.setTime(new Date());
            } else {
                this.Epoch_.fromSinexString(input);
            }
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException("Epoch input = \"" + input + "\"");
        }
    }

    public void setEpoch(int year, int day_of_year, int seconds_of_day) {
        this.Epoch_.set(1, this.rectifyYear(year));
        this.Epoch_.set(6, day_of_year);
        this.Epoch_.set(-3, seconds_of_day);
    }

    public void setEst(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        this.set(info_type, info_value);
    }

    public void setEst(Double input) {
        this.Estimate_ = input;
    }

    public void setEst(String input) throws IllegalArgumentException {
        try {
            this.setEstimate(Double.valueOf(input.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid estimate = \"" + input + "\"");
        }
    }

    public void setEst(double input) {
        this.Estimate_ = input;
    }

    public void setEstimate(Double input) {
        this.Estimate_ = input;
    }

    public void setEstimate(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        this.set(info_type, info_value);
    }

    public void setEstimate(String input) throws IllegalArgumentException {
        try {
            this.setEstimate(Double.valueOf(input.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid estimate = \"" + input + "\"");
        }
    }

    public void setEstimate(double input) {
        this.Estimate_ = input;
    }

    public void setIndex(Integer input) throws IllegalArgumentException {
        if (input < 0) {
            throw new IllegalArgumentException("index input = \"" + input + "\"");
        }
        this.Index_ = input;
    }

    public void setIndex(String input) throws IllegalArgumentException {
        try {
            this.setIndex(Integer.valueOf(input.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid index = \"" + input + "\"");
        }
    }

    public void setIndex(int input) throws IllegalArgumentException {
        if (input < 0) {
            throw new IllegalArgumentException("index input = \"" + input + "\"");
        }
        this.Index_ = input;
    }

    protected void setNoCheck(Matcher matcher) throws IllegalArgumentException {
        this.setIndex(matcher.group(1));
        this.setType(matcher.group(2));
        super.set(matcher.group(3), matcher.group(4), matcher.group(5));
        this.setEpoch(matcher.group(6));
        this.setUnits(matcher.group(7));
        this.setConstraintCode(matcher.group(8));
        this.setEstimate(matcher.group(9));
        this.setStandardDeviation(matcher.group(10));
    }

    public void setStandardDeviation(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        if (DataInterface.Info.S == info_type) {
            this.setSiteCode((String)info_value);
        } else if (DataInterface.Info.P == info_type) {
            this.setPointCode((String)info_value);
        } else if (DataInterface.Info.N == info_type) {
            this.setSolutionId((String)info_value);
        } else if (DataInterface.Info.INDEX == info_type) {
            this.setIndex((Integer)info_value);
        } else if (DataInterface.Info.TYPE == info_type) {
            this.setType((String)info_value);
        } else if (DataInterface.Info.EPOCH == info_type) {
            this.setEpoch(info_value);
        } else if (DataInterface.Info.UNITS == info_type) {
            this.setUnits((String)info_value);
        } else if (DataInterface.Info.EST == info_type) {
            this.setEstimate((Double)info_value);
        } else if (DataInterface.Info.STDDEV == info_type) {
            this.setStandardDeviation((Double)info_value);
        } else if (this.Type_.equals(info_type.name())) {
            this.setStandardDeviation((Double)info_value);
        }
    }

    public void setStandardDeviation(Double input) {
        this.StandardDeviation_ = input;
    }

    public void setStandardDeviation(String input) throws IllegalArgumentException {
        try {
            this.setStandardDeviation(Double.valueOf(input.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid standard deviation = \"" + input + "\"");
        }
    }

    public void setStandardDeviation(double input) {
        this.StandardDeviation_ = input;
    }

    public void setStdDev(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        this.setStandardDeviation(info_type, info_value);
    }

    public void setStdDev(Double input) {
        this.StandardDeviation_ = input;
    }

    public void setStdDev(String input) throws IllegalArgumentException {
        try {
            this.setStandardDeviation(Double.valueOf(input.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid standard deviation = \"" + input + "\"");
        }
    }

    public void setStdDev(double input) {
        this.StandardDeviation_ = input;
    }

    public void setTime() {
        this.setEpoch();
    }

    public void setTime(Calendar epoch) {
        this.setEpoch(epoch);
    }

    public void setTime(Date date) {
        this.setEpoch(date);
    }

    public void setTime(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.setEpoch(year, day_of_year, seconds_of_day);
    }

    public void setTime(Object epoch) throws IllegalArgumentException {
        this.setEpoch(epoch);
    }

    public void setTime(String input) throws IllegalArgumentException {
        this.setEpoch(input);
    }

    public void setTime(int year, int day_of_year, int seconds_of_day) {
        this.setEpoch(year, day_of_year, seconds_of_day);
    }

    public void setType(String input) throws IllegalArgumentException {
        try {
            this.Type_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("type " + iaex.getMessage());
        }
    }

    public void setUnits(String input) throws IllegalArgumentException {
        try {
            this.Units_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("units " + iaex.getMessage());
        }
    }

    private String toEstString(Double estimate) {
        int exp = (int)StrictMath.log10(StrictMath.abs(estimate));
        exp = exp >= 0 ? exp + 1 : exp;
        double val = estimate * StrictMath.pow(10.0, -exp);
        return EstValFmt_.format(val) + EstExpFmt_.format(exp);
    }

    private String toIndexString(Integer index) {
        String tmp = IndexFmt_.format(index);
        return (tmp.length() < 5 ? "                                                                                ".substring(0, 5 - tmp.length()) : "") + tmp;
    }

    private String toSigString(Double sigma) {
        int exp = (int)StrictMath.log10(StrictMath.abs(sigma));
        exp = exp >= 0 ? exp + 1 : exp;
        double val = sigma * StrictMath.pow(10.0, -exp);
        return EstStdDevFmt_.format(val) + EstExpFmt_.format(exp);
    }

    public String toString() {
        return " " + this.toIndexString(this.Index_) + " " + this.Type_.toString() + " " + super.toString() + " " + this.Epoch_.toSinexString() + " " + this.Units_.toString() + " " + this.ConstraintCode_.toString() + " " + this.toEstString(this.Estimate_) + this.toSigString(this.StandardDeviation_);
    }
}

