/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SiteData;
import GNSS.Sinex.SolutionEstimate;
import GNSS.UtcTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionEpochs
extends SiteData {
    private SortedSet<SolutionEstimate> Storage_ = new TreeSet<SolutionEstimate>();
    private static final String Block_ = "SOLUTION/EPOCHS";
    private static final Pattern BlockPattern_ = Pattern.compile("^[\\+\\-]SOLUTION/EPOCHS.*$");
    private static final Pattern DataPattern_ = Pattern.compile(SiteData.getDataPattern().pattern() + " ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d) *$");
    private UtcTime MeanEpoch_ = new UtcTime();
    private static final double MillisPerSecond_ = 1000.0;
    private static final double MillisPerDay_ = 8.64E7;
    private static final double MillisPerYear_ = 3.15576E10;

    public SolutionEpochs() {
    }

    public SolutionEpochs(Calendar earliest, Calendar latest) {
        super(earliest, latest);
    }

    public SolutionEpochs(Calendar earliest, Calendar latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SolutionEpochs(Calendar earliest, Calendar latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SolutionEpochs(Date earliest, Date latest) {
        super(earliest, latest);
    }

    public SolutionEpochs(Date earliest, Date latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SolutionEpochs(Date earliest, Date latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SolutionEpochs(Object earliest, Object latest) throws IllegalArgumentException {
        super(earliest, latest);
    }

    public SolutionEpochs(Object earliest, Object latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SolutionEpochs(Object earliest, Object latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SolutionEpochs(Matcher matcher) throws IllegalArgumentException {
        this.set(matcher);
    }

    public SolutionEpochs(String input) throws IllegalArgumentException {
        this.set(input);
    }

    public void add(Matcher matcher) throws IllegalArgumentException {
        this.add(new SolutionEstimate(matcher));
    }

    public void add(String input) throws IllegalArgumentException {
        this.add(new SolutionEstimate(input));
    }

    public void add(Object input) throws ClassCastException, IllegalArgumentException {
        if (!(input instanceof SolutionEstimate)) {
            throw new ClassCastException(input.getClass().getSimpleName());
        }
        this.add((SolutionEstimate)input);
    }

    public void add(SolutionEstimate input) throws IllegalArgumentException {
        if (this.compareSPN(input) != 0) {
            throw new IllegalArgumentException(this.getSPN() + " != " + input.getSPN());
        }
        this.Storage_.add(input);
    }

    @Override
    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof SolutionEpochs) {
            return this.compareTo((SolutionEpochs)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareTo(SolutionEpochs input) {
        int value = super.compareTo(input);
        if (value == 0) {
            return this.MeanEpoch_.compareTo(input.getMeanEpoch());
        }
        return value;
    }

    private double deltaPerDay(Calendar epoch, Calendar ref_epoch) {
        return (double)(epoch.getTimeInMillis() - ref_epoch.getTimeInMillis()) / 8.64E7;
    }

    private double deltaPerSecond(Calendar epoch, Calendar ref_epoch) {
        return (double)(epoch.getTimeInMillis() - ref_epoch.getTimeInMillis()) / 1000.0;
    }

    private double deltaPerYear(Calendar epoch, Calendar ref_epoch) {
        return (double)(epoch.getTimeInMillis() - ref_epoch.getTimeInMillis()) / 3.15576E10;
    }

    private double deltaPerDay(Date epoch, Calendar ref_epoch) {
        return (double)(epoch.getTime() - ref_epoch.getTimeInMillis()) / 8.64E7;
    }

    private double deltaPerSecond(Date epoch, Calendar ref_epoch) {
        return (double)(epoch.getTime() - ref_epoch.getTimeInMillis()) / 1000.0;
    }

    private double deltaPerYear(Date epoch, Calendar ref_epoch) {
        return (double)(epoch.getTime() - ref_epoch.getTimeInMillis()) / 3.15576E10;
    }

    @Override
    public boolean equals(Object input) {
        if (input instanceof SolutionEpochs) {
            return this.equals((SolutionEpochs)input);
        }
        return false;
    }

    public boolean equals(SolutionEpochs input) {
        return this.compareTo(input) == 0;
    }

    @Override
    public Object get(DataInterface.Info info_type) {
        if (info_type == DataInterface.Info.MN_EP) {
            return this.getMeanEpoch();
        }
        if (super.has(info_type)) {
            return super.get(info_type);
        }
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.has(info_type)) continue;
            return tmp.getEstimate();
        }
        return null;
    }

    public SolutionEstimate get(Integer input) {
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.getIndex().equals(input)) continue;
            return tmp;
        }
        return null;
    }

    public Double get(DataInterface.Info info_type, Calendar epoch) {
        return this.getEstimate(info_type, epoch.getTime());
    }

    public Double get(DataInterface.Info info_type, Date epoch) {
        return this.getEstimate(info_type, epoch);
    }

    public static String getBlock() {
        return Block_;
    }

    public static Pattern getBlockPattern() {
        return BlockPattern_;
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public UtcTime getEndEpoch() {
        return super.getLastEpoch();
    }

    public UtcTime getEndTime() {
        return this.getEndEpoch();
    }

    public UtcTime getEpoch(DataInterface.Info info_type) {
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.getType().trim().equalsIgnoreCase(info_type.name())) continue;
            return tmp.getEpoch();
        }
        return null;
    }

    public Double getEst(DataInterface.Info info_type) {
        return this.getEstimate(info_type);
    }

    public Double getEst(DataInterface.Info info_type, Calendar epoch) {
        return this.getEstimate(info_type, epoch.getTime());
    }

    public Double getEst(DataInterface.Info info_type, Date epoch) {
        return this.getEstimate(info_type, epoch);
    }

    public Double getEstimate(DataInterface.Info info_type) {
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.has(info_type)) continue;
            return tmp.getEstimate();
        }
        return null;
    }

    public Double getEstimate(DataInterface.Info info_type, Calendar epoch) {
        return this.getEstimate(info_type, epoch.getTime());
    }

    public Double getEstimate(DataInterface.Info info_type, Date epoch) {
        SolutionEstimate record;
        Double value = null;
        if (info_type != null && epoch != null && (record = this.getSolutionEstimate(info_type)) != null) {
            value = record.getEstimate();
            switch (info_type) {
                case STAX: {
                    Double rate = (Double)this.get(DataInterface.Info.VELX);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerYear(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case STAY: {
                    Double rate = (Double)this.get(DataInterface.Info.VELY);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerYear(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case STAZ: {
                    Double rate = (Double)this.get(DataInterface.Info.VELZ);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerYear(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case RS_RA: {
                    Double rate = (Double)this.get(DataInterface.Info.RS_RAR);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerYear(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case RS_DE: {
                    Double rate = (Double)this.get(DataInterface.Info.RS_DER);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerYear(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case XPO: {
                    Double rate = (Double)this.get(DataInterface.Info.XPOR);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerDay(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case YPO: {
                    Double rate = (Double)this.get(DataInterface.Info.YPOR);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerDay(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case NUT_LN: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTRLN);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerDay(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case NUT_OB: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTROB);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerDay(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case NUT_X: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTR_X);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerDay(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case NUT_Y: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTR_Y);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerDay(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case SAT__X: {
                    Double rate = (Double)this.get(DataInterface.Info.SAT_VX);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerSecond(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case SAT__Y: {
                    Double rate = (Double)this.get(DataInterface.Info.SAT_VY);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerSecond(epoch, (Calendar)record.getEpoch());
                    break;
                }
                case SAT__Z: {
                    Double rate = (Double)this.get(DataInterface.Info.SAT_VZ);
                    if (rate == null) break;
                    value = value + rate * this.deltaPerSecond(epoch, (Calendar)record.getEpoch());
                }
            }
        }
        return value;
    }

    public SolutionEstimate getSolutionEstimate(DataInterface.Info info_type) {
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.getType().trim().equalsIgnoreCase(info_type.name())) continue;
            return tmp;
        }
        return null;
    }

    public UtcTime getMeanEpoch() {
        return this.MeanEpoch_;
    }

    public UtcTime getMeanTime() {
        return this.getMeanEpoch();
    }

    public UtcTime getStartEpoch() {
        return super.getFirstEpoch();
    }

    public Double getStandardDeviation(DataInterface.Info info_type) {
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.has(info_type)) continue;
            return tmp.getStandardDeviation();
        }
        return null;
    }

    public Double getStandardDeviation(DataInterface.Info info_type, Calendar epoch) {
        return this.getStandardDeviation(info_type, epoch.getTime());
    }

    public Double getStandardDeviation(DataInterface.Info info_type, Date epoch) {
        Double value = null;
        if (info_type != null && epoch != null && (value = (Double)this.get(info_type)) != null) {
            switch (info_type) {
                case STAX: {
                    Double rate = (Double)this.get(DataInterface.Info.VELX);
                    if (rate == null) break;
                    rate = rate * this.deltaPerYear(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case STAY: {
                    Double rate = (Double)this.get(DataInterface.Info.VELY);
                    if (rate == null) break;
                    rate = rate * this.deltaPerYear(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case STAZ: {
                    Double rate = (Double)this.get(DataInterface.Info.VELZ);
                    if (rate == null) break;
                    rate = rate * this.deltaPerYear(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case RS_RA: {
                    Double rate = (Double)this.get(DataInterface.Info.RS_RAR);
                    if (rate == null) break;
                    rate = rate * this.deltaPerYear(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case RS_DE: {
                    Double rate = (Double)this.get(DataInterface.Info.RS_DER);
                    if (rate == null) break;
                    rate = rate * this.deltaPerYear(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case XPO: {
                    Double rate = (Double)this.get(DataInterface.Info.XPOR);
                    if (rate == null) break;
                    rate = rate * this.deltaPerDay(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case YPO: {
                    Double rate = (Double)this.get(DataInterface.Info.YPOR);
                    if (rate == null) break;
                    rate = rate * this.deltaPerDay(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case NUT_LN: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTRLN);
                    if (rate == null) break;
                    rate = rate * this.deltaPerDay(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case NUT_OB: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTROB);
                    if (rate == null) break;
                    rate = rate * this.deltaPerDay(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case NUT_X: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTR_X);
                    if (rate == null) break;
                    rate = rate * this.deltaPerDay(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case NUT_Y: {
                    Double rate = (Double)this.get(DataInterface.Info.NUTR_Y);
                    if (rate == null) break;
                    rate = rate * this.deltaPerDay(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case SAT__X: {
                    Double rate = (Double)this.get(DataInterface.Info.SAT_VX);
                    if (rate == null) break;
                    rate = rate * this.deltaPerSecond(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case SAT__Y: {
                    Double rate = (Double)this.get(DataInterface.Info.SAT_VY);
                    if (rate == null) break;
                    rate = rate * this.deltaPerSecond(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                    break;
                }
                case SAT__Z: {
                    Double rate = (Double)this.get(DataInterface.Info.SAT_VZ);
                    if (rate == null) break;
                    rate = rate * this.deltaPerSecond(epoch, (Calendar)this.getEpoch(info_type));
                    value = StrictMath.sqrt(value * value + rate * rate);
                }
            }
        }
        return value;
    }

    public UtcTime getStartTime() {
        return this.getStartEpoch();
    }

    public Double getStdDev(DataInterface.Info info_type) {
        return this.getStandardDeviation(info_type);
    }

    public Double getStdDev(DataInterface.Info info_type, Calendar epoch) {
        return this.getStandardDeviation(info_type, epoch.getTime());
    }

    public Double getStdDev(DataInterface.Info info_type, Date epoch) {
        return this.getStandardDeviation(info_type, epoch);
    }

    @Override
    public boolean has(DataInterface.Info info_type) {
        if (info_type == DataInterface.Info.MN_EP) {
            return true;
        }
        if (super.has(info_type)) {
            return true;
        }
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.has(info_type)) continue;
            return true;
        }
        return false;
    }

    public Iterator<SolutionEstimate> iterator() {
        return this.Storage_.iterator();
    }

    @Override
    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        if (info_type == DataInterface.Info.MN_EP) {
            this.setMeanEpoch(info_value);
        } else if (super.has(info_type)) {
            super.set(info_type, info_value);
        } else {
            for (SolutionEstimate tmp : this.Storage_) {
                if (!tmp.has(info_type)) continue;
                tmp.set(info_type, info_value);
            }
        }
    }

    @Override
    public void set(Matcher matcher) throws IllegalArgumentException {
        if (matcher == null) {
            throw new IllegalArgumentException("null input");
        }
        if (matcher.pattern() != SolutionEpochs.getDataPattern()) {
            throw new IllegalArgumentException("incorrect match");
        }
        this.setNoCheck(matcher);
    }

    public void setEndEpoch(Calendar epoch) {
        super.setLastEpoch(epoch);
    }

    public void setEndEpoch(Date date) {
        super.setLastEpoch(date);
    }

    public void setEndEpoch(Integer year, Integer day_of_year, Integer seconds_of_day) {
        super.setLastEpoch(year, day_of_year, seconds_of_day);
    }

    public void setEndEpoch(Object input) throws IllegalArgumentException {
        super.setLastEpoch(input);
    }

    public void setEndEpoch(String input) throws IllegalArgumentException {
        super.setLastEpoch(input);
    }

    public void setEndEpoch(int year, int day_of_year, int seconds_of_day) {
        super.setLastEpoch(year, day_of_year, seconds_of_day);
    }

    public void setEndTime(Calendar epoch) {
        this.setEndEpoch(epoch);
    }

    public void setEndTime(Date date) {
        this.setEndEpoch(date);
    }

    public void setEndTime(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.setEndEpoch(year, day_of_year, seconds_of_day);
    }

    public void setEndTime(Object input) throws IllegalArgumentException {
        this.setEndEpoch(input);
    }

    public void setEndTime(String input) throws IllegalArgumentException {
        this.setEndEpoch(input);
    }

    public void setEndTime(int year, int day_of_year, int seconds_of_day) {
        this.setEndEpoch(year, day_of_year, seconds_of_day);
    }

    public void setEst(DataInterface.Info info_type, Double info_value) throws IllegalArgumentException {
        this.setEstimate(info_type, info_value);
    }

    public void setEstimate(DataInterface.Info info_type, Double info_value) throws IllegalArgumentException {
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.has(info_type)) continue;
            tmp.setEstimate(info_type, info_value);
        }
    }

    public void setMeanEpoch(Calendar epoch) {
        this.MeanEpoch_.setTime(epoch.getTime());
    }

    public void setMeanEpoch(Date date) {
        this.MeanEpoch_.setTime(date);
    }

    public void setMeanEpoch(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.MeanEpoch_.set(1, this.rectifyYear((int)year));
        this.MeanEpoch_.set(6, day_of_year);
        this.MeanEpoch_.set(-3, seconds_of_day);
    }

    public void setMeanEpoch(Object epoch) throws IllegalArgumentException {
        if (epoch instanceof Calendar) {
            this.setMeanEpoch((Calendar)epoch);
        } else if (epoch instanceof Date) {
            this.setMeanEpoch((Date)epoch);
        } else {
            throw new IllegalArgumentException("input = " + epoch.getClass().getSimpleName());
        }
    }

    public void setMeanEpoch(String input) throws IllegalArgumentException {
        try {
            this.MeanEpoch_.fromSinexString(input);
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException("mean epoch input = \"" + input + "\"");
        }
    }

    public void setMeanEpoch(int year, int day_of_year, int seconds_of_day) {
        this.MeanEpoch_.set(1, this.rectifyYear(year));
        this.MeanEpoch_.set(6, day_of_year);
        this.MeanEpoch_.set(-3, seconds_of_day);
    }

    public void setMeanTime(Calendar epoch) {
        this.setMeanEpoch(epoch);
    }

    public void setMeanTime(Date date) {
        this.setMeanEpoch(date);
    }

    public void setMeanTime(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.setMeanEpoch(year, day_of_year, seconds_of_day);
    }

    public void setMeanTime(Object input) throws IllegalArgumentException {
        this.setMeanEpoch(input);
    }

    public void setMeanTime(String input) throws IllegalArgumentException {
        this.setMeanEpoch(input);
    }

    public void setMeanTime(int year, int day_of_year, int seconds_of_day) {
        this.setMeanEpoch(year, day_of_year, seconds_of_day);
    }

    @Override
    protected void setNoCheck(Matcher matcher) throws IllegalArgumentException {
        super.setNoCheck(matcher);
        this.setMeanEpoch(matcher.group(7));
    }

    public void setStandardDeviation(DataInterface.Info info_type, Double info_value) throws IllegalArgumentException {
        for (SolutionEstimate tmp : this.Storage_) {
            if (!tmp.has(info_type)) continue;
            tmp.setStandardDeviation(info_type, info_value);
        }
    }

    public void setStartEpoch() {
        super.setFirstEpoch();
    }

    public void setStartEpoch(Calendar epoch) {
        super.setFirstEpoch(epoch);
    }

    public void setStartEpoch(Date date) {
        super.setFirstEpoch(date);
    }

    public void setStartEpoch(Integer year, Integer day_of_year, Integer seconds_of_day) {
        super.setFirstEpoch(year, day_of_year, seconds_of_day);
    }

    public void setStartEpoch(Object input) throws IllegalArgumentException {
        super.setFirstEpoch(input);
    }

    public void setStartEpoch(String input) throws IllegalArgumentException {
        super.setFirstEpoch(input);
    }

    public void setStartEpoch(int year, int day_of_year, int seconds_of_day) {
        super.setFirstEpoch(year, day_of_year, seconds_of_day);
    }

    public void setStartTime(Calendar epoch) {
        this.setStartEpoch(epoch);
    }

    public void setStartTime(Date date) {
        this.setStartEpoch(date);
    }

    public void setStartTime(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.setStartEpoch(year, day_of_year, seconds_of_day);
    }

    public void setStartTime(Object input) throws IllegalArgumentException {
        this.setStartEpoch(input);
    }

    public void setStartTime(String input) throws IllegalArgumentException {
        this.setStartEpoch(input);
    }

    public void setStartTime(int year, int day_of_year, int seconds_of_day) {
        this.setStartEpoch(year, day_of_year, seconds_of_day);
    }

    public void setStdDev(DataInterface.Info info_type, Double info_value) throws IllegalArgumentException {
        this.setStandardDeviation(info_type, info_value);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.MeanEpoch_.toSinexString();
    }
}

