/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SinexString;
import GNSS.Sinex.SiteHardware;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SiteReceiver
extends SiteHardware {
    private static final String Block_ = "SITE/RECEIVER";
    private static final Pattern BlockPattern_ = Pattern.compile("^[\\+\\-]SITE/RECEIVER.*$");
    private static final Pattern DataPattern_ = Pattern.compile(SiteHardware.getDataPattern().pattern() + " (.{20}) (.{5}) (.{11}) *$");
    private SinexString Firmware_ = new SinexString(11);
    private SinexString SerialNumber_ = new SinexString(5);
    private SinexString Type_ = new SinexString(20);

    public SiteReceiver() {
    }

    public SiteReceiver(Calendar earliest, Calendar latest) {
        super(earliest, latest);
    }

    public SiteReceiver(Calendar earliest, Calendar latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteReceiver(Calendar earliest, Calendar latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteReceiver(Date earliest, Date latest) {
        super(earliest, latest);
    }

    public SiteReceiver(Date earliest, Date latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteReceiver(Date earliest, Date latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteReceiver(Object earliest, Object latest) throws IllegalArgumentException {
        super(earliest, latest);
    }

    public SiteReceiver(Object earliest, Object latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteReceiver(Object earliest, Object latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteReceiver(Matcher matcher) throws IllegalArgumentException {
        this.set(matcher);
    }

    public SiteReceiver(String input) throws IllegalArgumentException {
        this.set(input);
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof SiteReceiver) {
            return this.compareTo((SiteReceiver)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareTo(SiteReceiver input) {
        int value = super.compareTo(input);
        if (value == 0) {
            value = this.Type_.compareTo(input.getType());
            if (value == 0) {
                value = this.SerialNumber_.compareTo(input.getSerialNumber());
                if (value == 0) {
                    return this.Firmware_.compareTo(input.getFirmware());
                }
                return value;
            }
            return value;
        }
        return value;
    }

    public boolean equals(Object input) {
        if (input instanceof SiteReceiver) {
            return this.equals((SiteReceiver)input);
        }
        return false;
    }

    public boolean equals(SiteReceiver input) {
        return this.compareTo(input) == 0;
    }

    public Object get(DataInterface.Info info_type) {
        switch (info_type) {
            case TYPE: {
                return this.getType();
            }
            case FIRMWR: {
                return this.getFirmware();
            }
            case SERNO: {
                return this.getSerialNumber();
            }
        }
        return super.get(info_type);
    }

    public static String getBlock() {
        return Block_;
    }

    public static Pattern getBlockPattern() {
        return BlockPattern_;
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public SinexString getFirmware() {
        return this.Firmware_;
    }

    public SinexString getSerialNumber() {
        return this.SerialNumber_;
    }

    public SinexString getType() {
        return this.Type_;
    }

    public boolean has(DataInterface.Info info_type) {
        switch (info_type) {
            case TYPE: {
                return true;
            }
            case FIRMWR: {
                return true;
            }
            case SERNO: {
                return true;
            }
        }
        return super.has(info_type);
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        switch (info_type) {
            case TYPE: {
                this.setType((String)info_value);
                break;
            }
            case FIRMWR: {
                this.setFirmware((String)info_value);
                break;
            }
            case SERNO: {
                this.setSerialNumber((String)info_value);
                break;
            }
            default: {
                super.set(info_type, info_value);
            }
        }
    }

    public void set(Matcher matcher) throws IllegalArgumentException {
        if (matcher == null) {
            throw new IllegalArgumentException("null input");
        }
        if (matcher.pattern() != SiteReceiver.getDataPattern()) {
            throw new IllegalArgumentException("incorrect match");
        }
        this.setNoCheck(matcher);
    }

    public void setFirmware(String input) throws IllegalArgumentException {
        try {
            this.Firmware_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("receiver firmware " + iaex.getMessage());
        }
    }

    protected void setNoCheck(Matcher matcher) throws IllegalArgumentException {
        super.setNoCheck(matcher);
        this.Type_.set(matcher.group(7));
        this.SerialNumber_.set(matcher.group(8));
        this.Firmware_.set(matcher.group(9));
    }

    public void setSerialNumber(String input) throws IllegalArgumentException {
        try {
            this.SerialNumber_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("receiver serial number " + iaex.getMessage());
        }
    }

    public void setType(String input) throws IllegalArgumentException {
        try {
            this.Type_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("receiver type " + iaex.getMessage());
        }
    }

    public String toString() {
        return super.toString() + " " + this.Type_.toString() + " " + this.SerialNumber_.toString() + " " + this.Firmware_.toString();
    }
}

