/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SP;
import GNSS.Sinex.SPNO;
import GNSS.Sinex.SinexString;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SiteId
extends SPNO
implements DataInterface {
    private static final DecimalFormat Fmt_ = new DecimalFormat("####0.0");
    private static final String Block_ = "SITE/ID";
    private static final Pattern BlockPattern_ = Pattern.compile("^[\\+\\-]SITE/ID.*$");
    private static final Pattern DataPattern_ = Pattern.compile(" " + SP.getDataPattern().pattern() + " (.{9}) " + SPNO.getObservationCodePattern().pattern() + " (.{22})" + " ([\\d ]{2}\\d) ([\\d ]\\d) ([\\d ]\\d\\.\\d)" + " ([\\+\\-\\d ]{2}\\d) ([\\d ]\\d) ([\\d ]\\d\\.\\d)" + " ([\\+\\-\\d  ]{4}\\d\\.\\d) *$");
    private Double Height_ = 0.0;
    private Double LatSec_ = 0.0;
    private Double Latitude_ = 0.0;
    private Double LonSec_ = 0.0;
    private Double Longitude_ = 0.0;
    private Integer LatDeg_ = 0;
    private Integer LatMin_ = 0;
    private Integer LonDeg_ = 0;
    private Integer LonMin_ = 0;
    private SinexString MonumentId_ = new SinexString(9, true, true);
    private SinexString StationDescription_ = new SinexString(22);

    public SiteId() {
    }

    public SiteId(Matcher matcher) throws IllegalArgumentException {
        this.set(matcher);
    }

    public SiteId(String input) throws IllegalArgumentException {
        this.set(input);
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof SiteId) {
            return this.compareTo((SiteId)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareTo(SiteId input) {
        int value = -super.compareTo(input);
        if (value == 0) {
            value = -this.MonumentId_.compareTo(input.getMonumentId());
            if (value == 0) {
                value = -this.Longitude_.compareTo(input.getLongitude());
                if (value == 0) {
                    value = -this.Latitude_.compareTo(input.getLatitude());
                    if (value == 0) {
                        value = -this.Height_.compareTo(input.getHeight());
                        if (value == 0) {
                            return -this.StationDescription_.compareTo(input.getStationDescription());
                        }
                        return value;
                    }
                    return value;
                }
                return value;
            }
            return value;
        }
        return value;
    }

    public boolean equals(Object input) {
        if (input instanceof SiteId) {
            return this.equals((SiteId)input);
        }
        return false;
    }

    public boolean equals(SiteId input) {
        return this.compareTo(input) == 0;
    }

    public Object get(DataInterface.Info info_type) {
        switch (info_type) {
            case MON_ID: {
                return this.getMonumentId();
            }
            case DESC: {
                return this.getStationDescription();
            }
            case APPLAT: {
                return this.getLatitude();
            }
            case APPLON: {
                return this.getLongitude();
            }
            case APPHGT: {
                return this.getHeight();
            }
        }
        return super.get(info_type);
    }

    public static String getBlock() {
        return Block_;
    }

    public static Pattern getBlockPattern() {
        return BlockPattern_;
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public Double getHeight() {
        return this.Height_ == null ? Double.valueOf(0.0) : this.Height_;
    }

    public Double getLatitude() {
        return this.Latitude_ == null ? Double.valueOf(0.0) : this.Latitude_;
    }

    public Double getLongitude() {
        return this.Longitude_ == null ? Double.valueOf(0.0) : this.Longitude_;
    }

    public SinexString getMonumentId() {
        return this.MonumentId_;
    }

    public SinexString getStationDescription() {
        return this.StationDescription_;
    }

    public void set(Matcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("null input");
        }
        if (matcher.pattern() != DataPattern_) {
            throw new IllegalArgumentException("incorrect match");
        }
        super.set(matcher.group(1), matcher.group(2), null, matcher.group(4));
        this.setMonumentId(matcher.group(3));
        this.setStationDescription(matcher.group(5));
        this.setLongitude(matcher.group(6), matcher.group(7), matcher.group(8));
        this.setLatitude(matcher.group(9), matcher.group(10), matcher.group(11));
        this.setHeight(matcher.group(12));
    }

    public void setHeight(Double hgt) throws IllegalArgumentException {
        this.Height_ = hgt;
    }

    public void setHeight(String hgt_str) throws IllegalArgumentException {
        try {
            this.setHeight(Double.valueOf(hgt_str.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid height " + hgt_str);
        }
    }

    public void setLatitude(Integer deg, Integer min, Double sec) throws IllegalArgumentException {
        if (deg == null || min == null || sec == null || min < 0 || sec < 0.0 || deg > 90 || deg < -90 || (deg == 90 || deg == -90) && (min > 0 || sec > 0.0) || min > 60 || min == 60 && sec > 0.0 || sec > 60.0) {
            throw new IllegalArgumentException("invalid latitude " + deg + " " + min + " " + sec);
        }
        if (deg < 0) {
            this.LatDeg_ = deg;
            this.LatMin_ = min;
            this.LatSec_ = sec;
            this.Latitude_ = this.LatDeg_.doubleValue() - (this.LatMin_.doubleValue() + this.LatSec_ / 60.0) / 60.0;
        } else {
            this.LatDeg_ = deg;
            this.LatMin_ = min;
            this.LatSec_ = sec;
            this.Latitude_ = this.LatDeg_.doubleValue() + (this.LatMin_.doubleValue() + this.LatSec_ / 60.0) / 60.0;
        }
    }

    public void setLatitude(String deg_str, String min_str, String sec_str) throws IllegalArgumentException {
        try {
            this.setLatitude(Integer.valueOf(deg_str.trim()), Integer.valueOf(min_str.trim()), Double.valueOf(sec_str.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid latitude " + deg_str + " " + min_str + " " + sec_str);
        }
    }

    public void setLatitude(double degrees) throws IllegalArgumentException {
        double tmp = degrees;
        int deg = (int)tmp;
        tmp = 60.0 * (tmp - (double)deg);
        int min = (int)tmp;
        double sec = 60.0 * (tmp - (double)min);
        this.setLatitude(deg, min < 0 ? -min : min, sec < 0.0 ? -sec : sec);
    }

    public void setLongitude(Integer deg, Integer min, Double sec) throws IllegalArgumentException {
        if (deg == null || min == null || sec == null || min < 0 || sec < 0.0 || deg > 360 || deg < -360 || (deg == 360 || deg == -360) && (min > 0 || sec > 0.0) || min > 60 || min == 60 && sec > 0.0 || sec > 60.0) {
            throw new IllegalArgumentException("invalid longitude " + deg + " " + min + " " + sec);
        }
        if (deg < 0) {
            this.LonDeg_ = 359 + deg;
            this.LonMin_ = 59 - min;
            this.LonSec_ = 60.0 - sec;
            this.Longitude_ = this.LonDeg_.doubleValue() - (this.LonMin_.doubleValue() + this.LonSec_ / 60.0) / 60.0;
        } else {
            this.LonDeg_ = deg;
            this.LonMin_ = min;
            this.LonSec_ = sec;
            this.Longitude_ = this.LonDeg_.doubleValue() + (this.LonMin_.doubleValue() + this.LonSec_ / 60.0) / 60.0;
        }
    }

    public void setLongitude(String deg_str, String min_str, String sec_str) throws IllegalArgumentException {
        try {
            this.setLongitude(Integer.valueOf(deg_str.trim()), Integer.valueOf(min_str.trim()), Double.valueOf(sec_str.trim()));
        }
        catch (NumberFormatException neex) {
            throw new IllegalArgumentException("invalid longitude " + deg_str + " " + min_str + " " + sec_str);
        }
    }

    public void setLongitude(double degrees) throws IllegalArgumentException {
        double tmp = degrees < 0.0 ? 360.0 - degrees : degrees;
        int deg = (int)tmp;
        tmp = 60.0 * (tmp - (double)deg);
        int min = (int)tmp;
        double sec = 60.0 * (tmp - (double)min);
        this.setLongitude(deg, min < 0 ? -min : min, sec < 0.0 ? -sec : sec);
    }

    public void setMonumentId(SinexString input) throws IllegalArgumentException {
        this.setMonumentId(input.toString());
    }

    public void setMonumentId(String input) throws IllegalArgumentException {
        this.MonumentId_.set(input);
        if (this.MonumentId_.trim() != null && this.MonumentId_.trim().length() != 9) {
            this.MonumentId_.set(null);
            throw new IllegalArgumentException("DOMES length > " + Integer.toString(9) + ": \"" + input + "\"");
        }
    }

    public void setStationDescription(SinexString input) throws IllegalArgumentException {
        this.setStationDescription(input.toString());
    }

    public void setStationDescription(String input) throws IllegalArgumentException {
        try {
            this.StationDescription_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("station description " + iaex.getMessage());
        }
    }

    public String toHeightString() {
        return SinexString.justifyRight(Fmt_.format(this.Height_), 7);
    }

    public String toLatitudeString() {
        return (this.LatDeg_ < 0 ? (this.LatDeg_ > -10 ? " " : "") : (this.LatDeg_ < 10 ? "  " : " ")) + this.LatDeg_.toString() + " " + (this.LatMin_ < 10 ? " " : "") + this.LatMin_.toString() + " " + (this.LatSec_ < 9.95 ? " " : "") + Fmt_.format(this.LatSec_);
    }

    public String toLongitudeString() {
        return (this.LonDeg_ < 10 ? "  " : (this.LonDeg_ < 100 ? " " : "")) + this.LonDeg_.toString() + " " + (this.LonMin_ < 10 ? " " : "") + this.LonMin_.toString() + " " + (this.LonSec_ < 9.95 ? " " : "") + Fmt_.format(this.LonSec_);
    }

    public String toString() {
        return " " + super.getSP() + " " + this.MonumentId_.toString() + " " + super.getObservationCode() + " " + this.StationDescription_.toString() + " " + this.toLongitudeString() + " " + this.toLatitudeString() + " " + this.toHeightString();
    }
}

