/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SinexString;
import GNSS.Sinex.SiteHardware;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SiteEccentricity
extends SiteHardware {
    private static final DecimalFormat Fmt_ = new DecimalFormat("##0.0000");
    private static final String Block_ = "SITE/ECCENTRICITY";
    private static final Pattern BlockPattern_ = Pattern.compile("^[\\+\\-]SITE/ECCENTRICITY.*$");
    private static final Pattern DataPattern_ = Pattern.compile(SiteHardware.getDataPattern().pattern() + " ((UNE)|(XYZ))" + " ([\\+\\-\\d ]{2}\\d\\.\\d{4})" + " ([\\+\\-\\d ]{2}\\d\\.\\d{4})" + " ([\\+\\-\\d ]{2}\\d\\.\\d{4})" + " *$");
    private Double[] Offset_ = new Double[]{0.0, 0.0, 0.0};
    private SinexString Type_ = new SinexString(3);

    public SiteEccentricity() {
    }

    public SiteEccentricity(Calendar earliest, Calendar latest) {
        super(earliest, latest);
    }

    public SiteEccentricity(Calendar earliest, Calendar latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteEccentricity(Calendar earliest, Calendar latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteEccentricity(Date earliest, Date latest) {
        super(earliest, latest);
    }

    public SiteEccentricity(Date earliest, Date latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteEccentricity(Date earliest, Date latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteEccentricity(Object earliest, Object latest) throws IllegalArgumentException {
        super(earliest, latest);
    }

    public SiteEccentricity(Object earliest, Object latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteEccentricity(Object earliest, Object latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteEccentricity(Matcher matcher) throws IllegalArgumentException {
        this.set(matcher);
    }

    public SiteEccentricity(String input) throws IllegalArgumentException {
        this.set(input);
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof SiteEccentricity) {
            return this.compareTo((SiteEccentricity)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareTo(SiteEccentricity input) {
        int value = super.compareTo(input);
        if (value == 0) {
            value = this.Type_.compareTo(input.getType());
            if (value == 0) {
                for (int i = 0; i < this.Offset_.length; ++i) {
                    value = this.Offset_[i].compareTo(input.getOffset(i));
                    if (value == 0) continue;
                    return value;
                }
                return value;
            }
            return value;
        }
        return value;
    }

    public boolean equals(Object input) {
        if (input instanceof SiteEccentricity) {
            return this.equals((SiteEccentricity)input);
        }
        return false;
    }

    public boolean equals(SiteEccentricity input) {
        return this.compareTo(input) == 0;
    }

    public Object get(DataInterface.Info info_type) {
        if (info_type == DataInterface.Info.TYPE) {
            return this.getType();
        }
        if (this.Type_.equals("XYZ")) {
            switch (info_type) {
                case ECCX: {
                    return this.getOffset(0);
                }
                case ECCY: {
                    return this.getOffset(1);
                }
                case ECCZ: {
                    return this.getOffset(2);
                }
            }
            return super.get(info_type);
        }
        switch (info_type) {
            case ECCE: {
                return this.getOffset(2);
            }
            case ECCN: {
                return this.getOffset(1);
            }
            case ECCU: {
                return this.getOffset(0);
            }
        }
        return super.get(info_type);
    }

    public boolean has(DataInterface.Info info_type) {
        switch (info_type) {
            case ECCE: {
                return this.Type_.equals("UNE");
            }
            case ECCN: {
                return this.Type_.equals("UNE");
            }
            case TYPE: {
                return true;
            }
            case ECCU: {
                return this.Type_.equals("UNE");
            }
            case ECCX: {
                return this.Type_.equals("XYZ");
            }
            case ECCY: {
                return this.Type_.equals("XYZ");
            }
            case ECCZ: {
                return this.Type_.equals("XYZ");
            }
        }
        return super.has(info_type);
    }

    public static String getBlock() {
        return Block_;
    }

    public static Pattern getBlockPattern() {
        return BlockPattern_;
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public SinexString getType() {
        return this.Type_;
    }

    public Double[] getOffset() {
        return this.Offset_;
    }

    public Double getOffset(int index) throws IllegalArgumentException {
        if (index >= 0 || index < this.Offset_.length) {
            return this.Offset_[index];
        }
        throw new IllegalArgumentException("eccentricity index = " + String.valueOf(index));
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        if (info_type == DataInterface.Info.TYPE) {
            this.setType((String)info_value);
        } else if (this.Type_.equals("XYZ")) {
            switch (info_type) {
                case ECCX: {
                    this.setOffset(0, info_value);
                    break;
                }
                case ECCY: {
                    this.setOffset(1, info_value);
                    break;
                }
                case ECCZ: {
                    this.setOffset(2, info_value);
                    break;
                }
                default: {
                    super.set(info_type, info_value);
                    break;
                }
            }
        } else {
            switch (info_type) {
                case ECCE: {
                    this.setOffset(2, info_value);
                    break;
                }
                case ECCN: {
                    this.setOffset(1, info_value);
                    break;
                }
                case ECCU: {
                    this.setOffset(0, info_value);
                    break;
                }
                default: {
                    super.set(info_type, info_value);
                }
            }
        }
    }

    public void set(Matcher matcher) throws IllegalArgumentException {
        if (matcher == null) {
            throw new IllegalArgumentException("null input");
        }
        if (matcher.pattern() != SiteEccentricity.getDataPattern()) {
            throw new IllegalArgumentException("incorrect match");
        }
        this.setNoCheck(matcher);
    }

    protected void setNoCheck(Matcher matcher) throws IllegalArgumentException {
        super.setNoCheck(matcher);
        this.Type_.set(matcher.group(7));
        this.setOffset(0, matcher.group(10));
        this.setOffset(1, matcher.group(11));
        this.setOffset(2, matcher.group(12));
    }

    public void setOffset(int index, Double input) throws IllegalArgumentException {
        if (index >= 0 || index < this.Offset_.length) {
            if (input == null) {
                throw new IllegalArgumentException("eccentricity value " + String.valueOf(index) + " null");
            }
        } else {
            throw new IllegalArgumentException("eccentricity index = " + String.valueOf(index));
        }
        this.Offset_[index] = (double)input;
    }

    public void setOffset(int index, Object input) throws ClassCastException, IllegalArgumentException {
        if (input instanceof Double) {
            this.setOffset(index, (Double)input);
        } else if (input instanceof String) {
            this.setOffset(index, (String)input);
        } else {
            throw new ClassCastException("eccentricity value " + String.valueOf(index) + " " + input.getClass().getSimpleName());
        }
    }

    public void setOffset(int index, String input) throws IllegalArgumentException {
        if (index >= 0 || index < this.Offset_.length) {
            try {
                this.Offset_[index] = Fmt_.parse(input.trim()).doubleValue();
            }
            catch (ParseException pex) {
                throw new IllegalArgumentException("eccentricity value " + String.valueOf(index) + " " + pex.getMessage());
            }
        } else {
            throw new IllegalArgumentException("eccentricity index = " + String.valueOf(index));
        }
    }

    public void setType(String input) throws IllegalArgumentException {
        try {
            this.Type_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("eccentricity type " + iaex.getMessage());
        }
    }

    public String toString() {
        return super.toString() + " " + this.Type_.toString() + " " + SinexString.justifyRight(Fmt_.format(this.Offset_[0]), 8) + " " + SinexString.justifyRight(Fmt_.format(this.Offset_[1]), 8) + " " + SinexString.justifyRight(Fmt_.format(this.Offset_[2]), 8);
    }
}

