/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SPNO;
import GNSS.UtcTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SiteData
extends SPNO {
    private static final Pattern DataPattern_ = Pattern.compile(" " + SPNO.getDataPattern().pattern() + " ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d)" + " ([\\d ]\\d:[\\d ]{2}\\d:[\\d ]{4}\\d)");
    private static final String DefaultEpochString_ = "00:000:00000";
    private UtcTime DefaultFirstEpoch_ = new UtcTime(1980, 0, 6, 0, 0, 0);
    private UtcTime DefaultLastEpoch_ = new UtcTime(2050, 0, 1, 0, 0, 0);
    private UtcTime FirstEpoch_ = new UtcTime(this.DefaultFirstEpoch_);
    private UtcTime LastEpoch_ = new UtcTime(this.DefaultLastEpoch_);
    private boolean IsFirstEpochSet_ = false;
    private boolean IsLastEpochSet_ = false;

    public SiteData() {
    }

    public SiteData(Calendar earliest, Calendar latest) {
        this.setEpochLimits(earliest, latest);
    }

    public SiteData(Calendar earliest, Calendar latest, Matcher matcher) throws IllegalArgumentException {
        this.setEpochLimits(earliest, latest);
        this.set(matcher);
    }

    public SiteData(Calendar earliest, Calendar latest, String input) throws IllegalArgumentException {
        this.setEpochLimits(earliest, latest);
        this.set(input);
    }

    public SiteData(Date earliest, Date latest) {
        this.setEpochLimits(earliest, latest);
    }

    public SiteData(Date earliest, Date latest, Matcher matcher) throws IllegalArgumentException {
        this.setEpochLimits(earliest, latest);
        this.set(matcher);
    }

    public SiteData(Date earliest, Date latest, String input) throws IllegalArgumentException {
        this.setEpochLimits(earliest, latest);
        this.set(input);
    }

    public SiteData(Object earliest, Object latest) throws IllegalArgumentException {
        this.setEpochLimits(earliest, latest);
    }

    public SiteData(Object earliest, Object latest, Matcher matcher) throws IllegalArgumentException {
        this.setEpochLimits(earliest, latest);
        this.set(matcher);
    }

    public SiteData(Object earliest, Object latest, String input) throws IllegalArgumentException {
        this.setEpochLimits(earliest, latest);
        this.set(input);
    }

    public SiteData(Matcher matcher) throws IllegalArgumentException {
        this.set(matcher);
    }

    public SiteData(String input) throws IllegalArgumentException {
        this.set(input);
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof SiteData) {
            return this.compareTo((SiteData)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareTo(SiteData input) {
        int value = super.compareTo(input);
        if (value == 0) {
            int v_i_i = this.FirstEpoch_.compareTo(input.getFirstEpoch());
            int v_r_r = this.LastEpoch_.compareTo(input.getLastEpoch());
            if (v_i_i < 0 && v_r_r <= 0) {
                return -1;
            }
            if (v_i_i >= 0 && v_r_r > 0) {
                return 1;
            }
            return 0;
        }
        return value;
    }

    public boolean equals(Object input) {
        if (input instanceof SiteData) {
            return this.equals((SiteData)input);
        }
        return false;
    }

    public boolean equals(SiteData input) {
        return this.compareTo(input) == 0;
    }

    public Object get(DataInterface.Info info_type) {
        switch (info_type) {
            case FST_EP: {
                return this.getFirstEpoch();
            }
            case LST_EP: {
                return this.getLastEpoch();
            }
        }
        return super.get(info_type);
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public String getDefaultEpochString() {
        return DefaultEpochString_;
    }

    public UtcTime getFirstEpoch() {
        return this.FirstEpoch_;
    }

    public UtcTime getLastEpoch() {
        return this.LastEpoch_;
    }

    public boolean has(DataInterface.Info info_type) {
        switch (info_type) {
            case FST_EP: 
            case LST_EP: {
                return true;
            }
        }
        return super.has(info_type);
    }

    public boolean isFirstEpochSet() {
        return this.IsFirstEpochSet_;
    }

    public boolean isLastEpochSet() {
        return this.IsLastEpochSet_;
    }

    public int rectifyYear(Integer year) {
        return this.rectifyYear((int)year);
    }

    public int rectifyYear(int year) {
        if (year <= 50) {
            return year + 2000;
        }
        if (year < 100) {
            return year + 1900;
        }
        return year;
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        switch (info_type) {
            case FST_EP: {
                this.setFirstEpoch(info_value);
                break;
            }
            case LST_EP: {
                this.setLastEpoch(info_value);
                break;
            }
            default: {
                super.set(info_type, info_value);
            }
        }
    }

    public void set(Matcher matcher) throws IllegalArgumentException {
        if (matcher == null) {
            throw new IllegalArgumentException("null input");
        }
        if (matcher.pattern() != SiteData.getDataPattern()) {
            throw new IllegalArgumentException("incorrect match");
        }
        this.setNoCheck(matcher);
    }

    public void set(String input) throws IllegalArgumentException {
        this.set(SiteData.getDataPattern().matcher(input));
    }

    private void setEpochLimits(Calendar earliest, Calendar latest) {
        this.DefaultFirstEpoch_.setTime(earliest.getTime());
        this.DefaultLastEpoch_.setTime(latest.getTime());
    }

    private void setEpochLimits(Date earliest, Date latest) {
        this.DefaultFirstEpoch_.setTime(earliest);
        this.DefaultLastEpoch_.setTime(latest);
    }

    private void setEpochLimits(Object earliest, Object latest) throws IllegalArgumentException {
        if (earliest instanceof Calendar) {
            this.DefaultFirstEpoch_.setTime(((Calendar)earliest).getTime());
            this.DefaultLastEpoch_.setTime(((Calendar)latest).getTime());
        } else if (earliest instanceof Date) {
            this.DefaultFirstEpoch_.setTime((Date)earliest);
            this.DefaultLastEpoch_.setTime((Date)latest);
        } else {
            throw new IllegalArgumentException("earliest = " + earliest.getClass().getSimpleName() + " and latest = " + latest.getClass().getSimpleName());
        }
    }

    public void setFirstEpoch() {
        this.FirstEpoch_.setTime(this.DefaultFirstEpoch_.getTime());
        this.IsFirstEpochSet_ = false;
    }

    public void setFirstEpoch(Calendar epoch) {
        this.FirstEpoch_.setTime(epoch.getTime());
        this.IsFirstEpochSet_ = true;
    }

    public void setFirstEpoch(Date date) {
        this.FirstEpoch_.setTime(date);
        this.IsFirstEpochSet_ = true;
    }

    public void setFirstEpoch(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.FirstEpoch_.set(1, this.rectifyYear((int)year));
        this.FirstEpoch_.set(6, day_of_year);
        this.FirstEpoch_.set(-3, seconds_of_day);
        this.IsFirstEpochSet_ = true;
    }

    public void setFirstEpoch(Object epoch) throws IllegalArgumentException {
        if (epoch instanceof Calendar) {
            this.setFirstEpoch((Calendar)epoch);
        } else if (epoch instanceof Date) {
            this.setFirstEpoch((Date)epoch);
        } else {
            throw new IllegalArgumentException("input = " + epoch.getClass().getSimpleName());
        }
    }

    public void setFirstEpoch(String input) throws IllegalArgumentException {
        try {
            if (input == null || input.length() == 0 || input.equals(DefaultEpochString_)) {
                this.FirstEpoch_.setTime(this.DefaultFirstEpoch_.getTime());
                this.IsFirstEpochSet_ = false;
            } else {
                this.FirstEpoch_.fromSinexString(input);
                this.IsFirstEpochSet_ = true;
            }
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException("FirstEpoch input = \"" + input + "\"");
        }
    }

    public void setFirstEpoch(int year, int day_of_year, int seconds_of_day) {
        this.FirstEpoch_.set(1, this.rectifyYear(year));
        this.FirstEpoch_.set(6, day_of_year);
        this.FirstEpoch_.set(-3, seconds_of_day);
        this.IsFirstEpochSet_ = true;
    }

    public void setLastEpoch() {
        this.LastEpoch_.setTime(this.DefaultLastEpoch_.getTime());
        this.IsLastEpochSet_ = false;
    }

    public void setLastEpoch(Calendar epoch) {
        this.LastEpoch_.setTime(epoch.getTime());
        this.IsLastEpochSet_ = true;
    }

    public void setLastEpoch(Date date) {
        this.LastEpoch_.setTime(date);
        this.IsLastEpochSet_ = true;
    }

    public void setLastEpoch(Integer year, Integer day_of_year, Integer seconds_of_day) {
        this.LastEpoch_.set(1, this.rectifyYear((int)year));
        this.LastEpoch_.set(6, day_of_year);
        this.LastEpoch_.set(-3, seconds_of_day);
        this.IsLastEpochSet_ = true;
    }

    public void setLastEpoch(Object epoch) throws IllegalArgumentException {
        if (epoch instanceof Calendar) {
            this.setLastEpoch((Calendar)epoch);
        } else if (epoch instanceof Date) {
            this.setLastEpoch((Date)epoch);
        } else {
            throw new IllegalArgumentException("input = " + epoch.getClass().getSimpleName());
        }
    }

    public void setLastEpoch(String input) throws IllegalArgumentException {
        try {
            if (input == null || input.length() == 0 || input.equals(DefaultEpochString_)) {
                this.LastEpoch_.setTime(this.DefaultLastEpoch_.getTime());
                this.IsLastEpochSet_ = false;
            } else {
                this.LastEpoch_.fromSinexString(input);
                this.IsLastEpochSet_ = true;
            }
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException("LastEpoch input = \"" + input + "\"");
        }
    }

    public void setLastEpoch(int year, int day_of_year, int seconds_of_day) {
        this.LastEpoch_.set(1, this.rectifyYear(year));
        this.LastEpoch_.set(6, day_of_year);
        this.LastEpoch_.set(-3, seconds_of_day);
        this.IsLastEpochSet_ = true;
    }

    protected void setNoCheck(Matcher matcher) throws IllegalArgumentException {
        super.set(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
        this.setFirstEpoch(matcher.group(5));
        this.setLastEpoch(matcher.group(6));
    }

    public String toString() {
        return " " + super.toString() + " " + (this.IsFirstEpochSet_ ? this.FirstEpoch_.toSinexString() : DefaultEpochString_) + " " + (this.IsLastEpochSet_ ? this.LastEpoch_.toSinexString() : DefaultEpochString_);
    }
}

