/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SinexString;
import GNSS.Sinex.SiteHardware;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SiteAntenna
extends SiteHardware
implements DataInterface {
    private static final String Block_ = "SITE/ANTENNA";
    private static final Pattern BlockPattern_ = Pattern.compile("^[\\+\\-]SITE/ANTENNA.*$");
    private static final Pattern DataPattern_ = Pattern.compile(SiteHardware.getDataPattern().pattern() + " (.{20}) (.{5}) *$");
    private SinexString SerialNumber_ = new SinexString(5);
    private SinexString Type_ = new SinexString(20);

    public SiteAntenna() {
    }

    public SiteAntenna(Calendar earliest, Calendar latest) {
        super(earliest, latest);
    }

    public SiteAntenna(Calendar earliest, Calendar latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteAntenna(Calendar earliest, Calendar latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteAntenna(Date earliest, Date latest) {
        super(earliest, latest);
    }

    public SiteAntenna(Date earliest, Date latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteAntenna(Date earliest, Date latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteAntenna(Object earliest, Object latest) throws IllegalArgumentException {
        super(earliest, latest);
    }

    public SiteAntenna(Object earliest, Object latest, Matcher matcher) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(matcher);
    }

    public SiteAntenna(Object earliest, Object latest, String input) throws IllegalArgumentException {
        super(earliest, latest);
        this.set(input);
    }

    public SiteAntenna(Matcher matcher) throws IllegalArgumentException {
        this.set(matcher);
    }

    public SiteAntenna(String input) throws IllegalArgumentException {
        this.set(input);
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof SiteAntenna) {
            return this.compareTo((SiteAntenna)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareTo(SiteAntenna input) {
        int value = super.compareTo(input);
        if (value == 0) {
            value = this.Type_.compareTo(input.getType());
            if (value == 0) {
                return this.SerialNumber_.compareTo(input.getSerialNumber());
            }
            return value;
        }
        return value;
    }

    public boolean equals(Object input) {
        if (input instanceof SiteAntenna) {
            return this.equals((SiteAntenna)input);
        }
        return false;
    }

    public boolean equals(SiteAntenna input) {
        return this.compareTo(input) == 0;
    }

    public Object get(DataInterface.Info info_type) {
        switch (info_type) {
            case TYPE: {
                return this.getType();
            }
            case SERNO: {
                return this.getSerialNumber();
            }
        }
        return super.get(info_type);
    }

    public static String getBlock() {
        return Block_;
    }

    public static Pattern getBlockPattern() {
        return BlockPattern_;
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public SinexString getSerialNumber() {
        return this.SerialNumber_;
    }

    public SinexString getType() {
        return this.Type_;
    }

    public boolean has(DataInterface.Info info_type) {
        switch (info_type) {
            case TYPE: {
                return true;
            }
            case SERNO: {
                return true;
            }
        }
        return super.has(info_type);
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        switch (info_type) {
            case TYPE: {
                this.setType((String)info_value);
                break;
            }
            case SERNO: {
                this.setSerialNumber((String)info_value);
                break;
            }
            default: {
                super.set(info_type, info_value);
            }
        }
    }

    public void set(Matcher matcher) throws IllegalArgumentException {
        if (matcher == null) {
            throw new IllegalArgumentException("null input");
        }
        if (matcher.pattern() != SiteAntenna.getDataPattern()) {
            throw new IllegalArgumentException("incorrect match");
        }
        this.setNoCheck(matcher);
    }

    protected void setNoCheck(Matcher matcher) throws IllegalArgumentException {
        super.setNoCheck(matcher);
        this.Type_.set(matcher.group(7));
        this.SerialNumber_.set(matcher.group(8));
    }

    public void setSerialNumber(String input) throws IllegalArgumentException {
        try {
            this.SerialNumber_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("antenna serial number " + iaex.getMessage());
        }
    }

    public void setType(String input) throws IllegalArgumentException {
        try {
            this.Type_.set(input);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("antenna type " + iaex.getMessage());
        }
    }

    public String toString() {
        return super.toString() + " " + this.Type_.toString() + " " + this.SerialNumber_.toString();
    }
}

