/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

public class SinexString {
    private String Value_ = null;
    private boolean JustifyLeft_ = true;
    private boolean UpperCase_ = false;
    private int MaxWidth_;
    private int MinWidth_;
    protected static final String Blanks_ = "                                                                                ";
    protected static final String Dashes_ = "--------------------------------------------------------------------------------";
    public static final int MAX_LINE_LENGTH = 80;
    public static final int MIN_LINE_LENGTH = 0;

    public SinexString(int max_width) throws IllegalArgumentException {
        this.setLimits(max_width);
        this.JustifyLeft_ = true;
        this.UpperCase_ = false;
        this.set(null);
    }

    public SinexString(int max_width, boolean justify_left) throws IllegalArgumentException {
        this.setLimits(max_width);
        this.JustifyLeft_ = justify_left;
        this.UpperCase_ = false;
        this.set(null);
    }

    public SinexString(int max_width, boolean justify_left, boolean upper_case) throws IllegalArgumentException {
        this.setLimits(max_width);
        this.JustifyLeft_ = justify_left;
        this.UpperCase_ = upper_case;
        this.set(null);
    }

    public SinexString(String input, int max_width) throws IllegalArgumentException {
        this.setLimits(max_width);
        this.JustifyLeft_ = true;
        this.UpperCase_ = false;
        this.set(input);
    }

    public SinexString(String input, int max_width, boolean justify_left) throws IllegalArgumentException {
        this.setLimits(max_width);
        this.JustifyLeft_ = justify_left;
        this.UpperCase_ = false;
        this.set(input);
    }

    public SinexString(String input, int max_width, boolean justify_left, boolean upper_case) throws IllegalArgumentException {
        this.setLimits(max_width);
        this.JustifyLeft_ = justify_left;
        this.UpperCase_ = upper_case;
        this.set(input);
    }

    public SinexString(String input, int min_width, int max_width) throws IllegalArgumentException {
        this.setLimits(min_width, max_width);
        this.JustifyLeft_ = true;
        this.UpperCase_ = false;
        this.set(input);
    }

    public SinexString(String input, int min_width, int max_width, boolean justify_left) throws IllegalArgumentException {
        this.setLimits(min_width, max_width);
        this.JustifyLeft_ = justify_left;
        this.UpperCase_ = false;
        this.set(input);
    }

    public SinexString(String input, int min_width, int max_width, boolean justify_left, boolean upper_case) throws IllegalArgumentException {
        this.setLimits(min_width, max_width);
        this.JustifyLeft_ = justify_left;
        this.UpperCase_ = upper_case;
        this.set(input);
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input == this) {
            return 0;
        }
        if (input instanceof SinexString) {
            if (this.matchAll() || ((SinexString)input).matchAll()) {
                return 0;
            }
            return ((SinexString)input).toString().compareToIgnoreCase(this.toString());
        }
        if (input instanceof String) {
            if (this.matchAll() || SinexString.matchAll((String)input)) {
                return 0;
            }
            return ((String)input).compareToIgnoreCase(this.toString());
        }
        throw new ClassCastException();
    }

    public int compareTo(SinexString input) {
        if (input == this) {
            return 0;
        }
        if (this.matchAll() || input.matchAll()) {
            return 0;
        }
        return input.toString().compareToIgnoreCase(this.toString());
    }

    public int compareTo(String input) {
        if (this.matchAll() || SinexString.matchAll(input)) {
            return 0;
        }
        return input.compareToIgnoreCase(this.toString());
    }

    public boolean equals(Object input) {
        return this.compareTo(input) == 0;
    }

    public boolean equals(SinexString input) {
        return this.compareTo(input) == 0;
    }

    public boolean equals(String input) {
        return this.compareTo(input) == 0;
    }

    public int getMaxWidth() {
        return this.MaxWidth_;
    }

    public int getMinWidth() {
        return this.MinWidth_;
    }

    public int length() {
        return this.MaxWidth_;
    }

    public boolean matchAll() {
        return this.Value_ == null;
    }

    public static boolean matchAll(String input) {
        return input == null || Dashes_.startsWith(input.trim());
    }

    protected String justify(String input, int max_width) {
        if (this.JustifyLeft_) {
            return SinexString.justifyLeft(input, max_width);
        }
        return SinexString.justifyRight(input, max_width);
    }

    public static String justifyLeft(String input, int max_width) {
        if (input == null) {
            return Dashes_.substring(0, max_width);
        }
        return input + Blanks_.substring(0, max_width - input.length());
    }

    public static String justifyRight(String input, int max_width) {
        if (input == null) {
            return Dashes_.substring(0, max_width);
        }
        return Blanks_.substring(0, max_width - input.length()) + input;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(String input) throws IllegalArgumentException {
        if (input == null) {
            if (this.MinWidth_ == 0) {
                this.Value_ = null;
                return;
            }
            this.Value_ = null;
            throw new IllegalArgumentException("input = null");
        }
        String string = this.Value_ = this.UpperCase_ ? input.trim().toUpperCase() : input.trim();
        if (Dashes_.startsWith(this.Value_)) {
            if (this.MinWidth_ == 0) {
                this.Value_ = null;
                return;
            }
            this.Value_ = null;
            throw new IllegalArgumentException("input = no information");
        }
        int length = this.Value_.length();
        if (this.MinWidth_ <= length) {
            if (length <= this.MaxWidth_) return;
        }
        this.Value_ = null;
        throw new IllegalArgumentException("value = \"" + input + "\"");
    }

    protected void setLimits(int max_width) {
        if (max_width <= 0) {
            throw new IllegalArgumentException("max width = " + String.valueOf(max_width) + " <= " + String.valueOf(0));
        }
        if (max_width >= 80) {
            throw new IllegalArgumentException("max width = " + String.valueOf(max_width) + " > " + String.valueOf(80));
        }
        this.MinWidth_ = 0;
        this.MaxWidth_ = max_width;
    }

    protected void setLimits(int min_width, int max_width) {
        if (max_width <= 0) {
            throw new IllegalArgumentException("max width = " + String.valueOf(max_width) + " <= " + String.valueOf(0));
        }
        if (max_width >= 80) {
            throw new IllegalArgumentException("max width = " + String.valueOf(max_width) + " > " + String.valueOf(80));
        }
        if (min_width < 0) {
            throw new IllegalArgumentException("min width = " + String.valueOf(min_width) + " < " + String.valueOf(0));
        }
        if (min_width > max_width) {
            throw new IllegalArgumentException("min width = " + String.valueOf(min_width) + " > " + String.valueOf(max_width));
        }
        this.MinWidth_ = min_width;
        this.MaxWidth_ = max_width;
    }

    public String toString() {
        return this.justify(this.Value_, this.MaxWidth_);
    }

    public String trim() {
        return this.Value_;
    }
}

