/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SPN;
import GNSS.Sinex.SinexString;
import java.util.regex.Pattern;

public class SPNO
extends SPN {
    private static final Pattern ObservationCodePattern_ = Pattern.compile("([CDLMPR])");
    private static final Pattern DataPattern_ = Pattern.compile(SPN.getDataPattern().pattern() + " " + ObservationCodePattern_.pattern());
    private SinexString Observation_ = new ObservationCode();

    public SPNO() throws IllegalArgumentException {
    }

    public SPNO(String input) throws IllegalArgumentException {
        super(input);
    }

    public SPNO(String site_code, String point_code) throws IllegalArgumentException {
        super(site_code, point_code);
    }

    public SPNO(String site_code, String point_code, String solution_id, String observation_type) throws IllegalArgumentException {
        super(site_code, point_code, solution_id);
        this.setObservationCode(observation_type);
    }

    public boolean anyObservationType() {
        return this.Observation_.matchAll();
    }

    public int compareSPNO(Object input) throws ClassCastException {
        if (input == this) {
            return 0;
        }
        if (input instanceof SPNO) {
            return this.compareSPN((SPNO)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareSPN(SPNO input) {
        if (input == this) {
            return 0;
        }
        int value = super.compareSPN(input);
        if (value == 0) {
            return this.Observation_.compareTo(input.getObservationCode());
        }
        return value;
    }

    public int compareTo(Object input) throws ClassCastException {
        return this.compareSPNO(input);
    }

    public int compareTo(SPN input) {
        return this.compareSPNO(input);
    }

    public boolean equals(Object input) {
        return this.compareTo(input) == 0;
    }

    public boolean equals(SPN input) {
        return this.compareTo(input) == 0;
    }

    public String get() {
        return this.getSPNO();
    }

    public Object get(DataInterface.Info info_type) {
        switch (info_type) {
            case SPNO: {
                return this.getSPNO();
            }
            case O: {
                return this.getObservationCode();
            }
        }
        return super.get(info_type);
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public String getObservationCode() {
        return this.Observation_.toString();
    }

    protected static Pattern getObservationCodePattern() {
        return ObservationCodePattern_;
    }

    public String getSPNO() {
        return this.getSPN() + " " + this.getObservationCode();
    }

    public boolean has(DataInterface.Info info_type) {
        switch (info_type) {
            case SPNO: 
            case O: {
                return true;
            }
        }
        return super.has(info_type);
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        switch (info_type) {
            case SPNO: {
                this.set((String)info_value);
                break;
            }
            case O: {
                this.setObservationCode((String)info_value);
                break;
            }
            default: {
                super.set(info_type, info_value);
            }
        }
    }

    public void set(String input) throws IllegalArgumentException {
        String[] tokens = input.trim().split("\\s+");
        switch (tokens.length) {
            case 4: {
                this.setSPN(tokens[0], tokens[1], tokens[2]);
                this.Observation_.set(tokens[3]);
                break;
            }
            case 3: {
                this.setSPN(tokens[0], tokens[1], tokens[2]);
                this.Observation_.set(null);
                break;
            }
            case 2: {
                this.setSPN(tokens[0], tokens[1], null);
                this.Observation_.set(null);
                break;
            }
            case 1: {
                this.setSPN(tokens[0], null, null);
                this.Observation_.set(null);
                break;
            }
            case 0: {
                this.setSPN(null, null, null);
                this.Observation_.set(null);
                break;
            }
            default: {
                throw new IllegalArgumentException("SPN station identifier = " + input + "\"");
            }
        }
    }

    public void set(String site_code, String point_code) throws IllegalArgumentException {
        this.set(site_code, point_code, null, null);
    }

    public void set(String site_code, String point_code, String solution_id) throws IllegalArgumentException {
        this.set(site_code, point_code, solution_id, null);
    }

    public void set(String site_code, String point_code, String solution_id, String observation_code) throws IllegalArgumentException {
        this.setSPNO(site_code, point_code, solution_id, observation_code);
    }

    public void setSPNO(String site_code, String point_code, String solution_id, String observation_code) throws IllegalArgumentException {
        try {
            super.set(site_code, point_code, solution_id);
            this.setObservationCode(observation_code);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("SPNO station identifier site code = \"" + site_code + "\"" + " point code = \"" + point_code + "\"" + " solution id = \"" + solution_id + "\"" + " observation type = \"" + solution_id + "\"");
        }
    }

    public void setObservationCode(String observation_type) throws IllegalArgumentException {
        try {
            this.Observation_.set(observation_type);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException(" observation code = \"" + observation_type + "\"");
        }
    }

    public String toString() {
        return this.getSPN() + " " + this.getObservationCode();
    }

    private class ObservationCode
    extends SinexString {
        ObservationCode() {
            super(1, true, true);
        }

        public String toString() {
            if (this.matchAll()) {
                return "P";
            }
            return super.toString();
        }
    }
}

