/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SP;
import GNSS.Sinex.SinexString;
import java.util.regex.Pattern;

public class SPN
extends SP {
    private static final Pattern DataPattern_ = Pattern.compile(SP.getDataPattern().pattern() + " (.{4})");
    private SinexString Solution_ = new SinexString(4, false, true);

    public SPN() throws IllegalArgumentException {
    }

    public SPN(String input) throws IllegalArgumentException {
        super(input);
    }

    public SPN(String site_code, String point_code) throws IllegalArgumentException {
        super(site_code, point_code);
    }

    public SPN(String site_code, String point_code, String solution_id) throws IllegalArgumentException {
        super(site_code, point_code);
        this.setSolutionId(solution_id);
    }

    public boolean anySolutionId() {
        return this.Solution_.matchAll();
    }

    public int compareSPN(Object input) throws ClassCastException {
        if (input == this) {
            return 0;
        }
        if (input instanceof SPN) {
            return this.compareSPN((SPN)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareSPN(SPN input) {
        if (input == this) {
            return 0;
        }
        int value = super.compareSP(input);
        if (value == 0) {
            return this.Solution_.compareTo(input.getSolutionId());
        }
        return value;
    }

    public int compareTo(Object input) throws ClassCastException {
        return this.compareSPN(input);
    }

    public int compareTo(SPN input) {
        return this.compareSPN(input);
    }

    public boolean equals(Object input) {
        return this.compareTo(input) == 0;
    }

    public boolean equals(SPN input) {
        return this.compareTo(input) == 0;
    }

    public String get() {
        return this.getSPN();
    }

    public Object get(DataInterface.Info info_type) {
        switch (info_type) {
            case SPN: {
                return this.getSPN();
            }
            case N: {
                return this.getSolutionId();
            }
        }
        return super.get(info_type);
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public String getSPN() {
        return this.getSP() + " " + this.getSolutionId();
    }

    public String getSolutionId() {
        return this.Solution_.toString();
    }

    public boolean has(DataInterface.Info info_type) {
        switch (info_type) {
            case SPN: 
            case N: {
                return true;
            }
        }
        return super.has(info_type);
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        switch (info_type) {
            case SPN: {
                this.set((String)info_value);
                break;
            }
            case N: {
                this.setSolutionId((String)info_value);
                break;
            }
            default: {
                super.set(info_type, info_value);
            }
        }
    }

    public void set(String input) throws IllegalArgumentException {
        String[] tokens = input.trim().split("\\s+");
        switch (tokens.length) {
            case 3: {
                this.setSP(tokens[0], tokens[1]);
                this.Solution_.set(tokens[2]);
                break;
            }
            case 2: {
                this.setSP(tokens[0], tokens[1]);
                this.Solution_.set(null);
                break;
            }
            case 1: {
                this.setSP(tokens[0], null);
                this.Solution_.set(null);
                break;
            }
            case 0: {
                this.setSP(null, null);
                this.Solution_.set(null);
                break;
            }
            default: {
                throw new IllegalArgumentException("SPN station identifier = " + input + "\"");
            }
        }
    }

    public void set(String site_code, String point_code) throws IllegalArgumentException {
        this.setSPN(site_code, point_code, null);
    }

    public void set(String site_code, String point_code, String solution_id) throws IllegalArgumentException {
        this.setSPN(site_code, point_code, solution_id);
    }

    public void setSPN(String site_code, String point_code, String solution_id) throws IllegalArgumentException {
        try {
            super.set(site_code, point_code);
            this.Solution_.set(solution_id);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("SPN station identifier site code = \"" + site_code + "\"" + " point code = \"" + point_code + "\"" + " solution id = \"" + solution_id + "\"");
        }
    }

    public void setSolutionId(String solution_id) throws IllegalArgumentException {
        try {
            this.Solution_.set(solution_id);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException(" solution id = \"" + solution_id + "\"");
        }
    }

    public String toString() {
        return this.getSP() + " " + this.getSolutionId();
    }
}

