/*
 * Decompiled with CFR 0.152.
 */
package GNSS.Sinex;

import GNSS.Sinex.DataInterface;
import GNSS.Sinex.SinexString;
import java.util.regex.Pattern;

public class SP
implements DataInterface {
    private static final Pattern DataPattern_ = Pattern.compile("(.{4}) (.{2})");
    private static final String UnknownSiteCode_ = "UNKN";
    private PointCode Point_ = new PointCode();
    private SinexString Site_ = new SinexString("UNKN", 4, 4, false, true);

    public SP() throws IllegalArgumentException {
    }

    public SP(String input) throws IllegalArgumentException {
        this.Site_.set(input);
    }

    public SP(String site_code, String point_code) throws IllegalArgumentException {
        this.set(site_code, point_code);
    }

    public boolean anyPointCode() {
        return this.Point_.matchAll();
    }

    public int compareSP(Object input) throws ClassCastException {
        if (input == this) {
            return 0;
        }
        if (input instanceof SP) {
            return this.compareSP((SP)input);
        }
        throw new ClassCastException(input.getClass().getSimpleName());
    }

    public int compareSP(SP input) {
        if (input == this) {
            return 0;
        }
        int value = this.Site_.compareTo(input.getSiteCode());
        if (value == 0) {
            return this.Point_.compareTo(input.getPointCode());
        }
        return value;
    }

    public int compareTo(Object input) throws ClassCastException {
        return this.compareSP(input);
    }

    public int compareTo(SP input) {
        return this.compareSP(input);
    }

    public boolean equals(Object input) {
        return this.compareTo(input) == 0;
    }

    public boolean equals(SP input) {
        return this.compareTo(input) == 0;
    }

    public String get() {
        return this.getSP();
    }

    public Object get(DataInterface.Info info_type) {
        switch (info_type) {
            case S: {
                return this.getSiteCode();
            }
            case SP: {
                return this.getSP();
            }
            case P: {
                return this.getPointCode();
            }
        }
        return null;
    }

    public static Pattern getDataPattern() {
        return DataPattern_;
    }

    public String getSP() {
        return this.getSiteCode() + " " + this.getPointCode();
    }

    public String getSiteCode() {
        return this.Site_.toString();
    }

    public String getPointCode() {
        return this.Point_.toString();
    }

    public boolean has(DataInterface.Info info_type) {
        switch (info_type) {
            case S: 
            case SP: 
            case P: {
                return true;
            }
        }
        return false;
    }

    public void set(DataInterface.Info info_type, Object info_value) throws IllegalArgumentException {
        switch (info_type) {
            case S: {
                this.setSiteCode((String)info_value);
                break;
            }
            case SP: {
                this.set((String)info_value);
                break;
            }
            case P: {
                this.setPointCode((String)info_value);
            }
        }
    }

    public void set(String input) throws IllegalArgumentException {
        String[] tokens = input.trim().split("\\s+");
        switch (tokens.length) {
            case 2: {
                this.Site_.set(tokens[0]);
                this.Point_.set(tokens[1]);
                break;
            }
            case 1: {
                this.Site_.set(tokens[0]);
                this.Point_.set(null);
                break;
            }
            case 0: {
                this.Site_.set(UnknownSiteCode_);
                this.Point_.set(null);
                break;
            }
            default: {
                throw new IllegalArgumentException("SP station identifier = " + input + "\"");
            }
        }
    }

    public void set(String site_code, String point_code) throws IllegalArgumentException {
        this.setSP(site_code, point_code);
    }

    public void setPointCode(String point_code) throws IllegalArgumentException {
        try {
            this.Point_.set(point_code);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException(" point code = \"" + point_code + "\"");
        }
    }

    public void setSP(String site_code, String point_code) throws IllegalArgumentException {
        try {
            this.Site_.set(site_code);
            this.Point_.set(point_code);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("station identifier site code = \"" + site_code + "\"" + " point code = \"" + point_code + "\"");
        }
    }

    public void setSiteCode(String site_code) throws IllegalArgumentException {
        try {
            this.Site_.set(site_code);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException(" site code = \"" + site_code + "\"");
        }
    }

    public String toString() {
        return this.getSiteCode() + " " + this.getPointCode();
    }

    private class PointCode
    extends SinexString {
        PointCode() {
            super(2, false, true);
        }

        public String toString() {
            if (this.matchAll()) {
                return " A";
            }
            return super.toString();
        }
    }
}

