/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.UtcTime;
import java.util.Date;

public class SeasonalMetModel {
    private Double Hgt_;
    private Double Lat_;
    private Double Seasonal_;
    private static final UtcTime J2000_ = new UtcTime(2000, 0, 1, 12, 0, 0);
    private static final double CentigradeOffsetFromKelvins_ = 273.15;
    private static final double M2Km_ = 0.001;
    private static final double P0_ = 1013.25;
    private static final double P1_ = 6.5;
    private static final double P2_ = 5.26;
    private static final double RH0_ = 0.5;
    private static final double T0_ = -20.5;
    private static final double T1_ = 48.4;
    private static final double T2_ = -3.1;
    private static final double T3_ = -14.3;
    private static final double T4_ = 3.3;
    private static final double T5_ = -4.7;
    private static final double T6_ = 1.1;
    private static final double TropicalYear_ = 365.242191;

    public SeasonalMetModel(Date date, Double lat, Double hgt) {
        this.Seasonal_ = SeasonalMetModel.computeSeasonal(date);
        this.Lat_ = StrictMath.toRadians(lat);
        this.Hgt_ = 0.001 * hgt;
    }

    public SeasonalMetModel(Date date, double lat, double hgt) {
        this.Seasonal_ = SeasonalMetModel.computeSeasonal(date);
        this.Lat_ = StrictMath.toRadians(lat);
        this.Hgt_ = 0.001 * hgt;
    }

    private static Double computePressure(double seasonal, double lat, double hgt) {
        double t_k = 273.15 + SeasonalMetModel.computeTemperature(seasonal, lat, hgt);
        return 1013.25 * StrictMath.pow(t_k / (t_k + 6.5 * hgt), 5.26);
    }

    private static Double computeRelativeHumidity(double seasonal, double lat, double hgt) {
        return 0.5;
    }

    private static Double computeSeasonal(Date date) {
        double epoch = -J2000_.diff(date) / 365.242191;
        return Math.PI * 2 * (epoch - (double)((int)epoch));
    }

    private static Double computeTemperature(double seasonal, double lat, double hgt) {
        return -20.5 + 48.4 * StrictMath.cos(lat) + -3.1 * hgt + (-14.3 + 3.3 * hgt) * StrictMath.sin(lat) * StrictMath.cos(seasonal) + (-4.7 + 1.1 * hgt) * StrictMath.sin(lat) * StrictMath.sin(seasonal);
    }

    public static Double getP(Date date, Double lat_deg, Double hgt_m) {
        double seasonal = SeasonalMetModel.computeSeasonal(date);
        double lat = StrictMath.toRadians(lat_deg);
        double hgt = 0.001 * hgt_m;
        return SeasonalMetModel.computePressure(seasonal, lat, hgt);
    }

    public Double getP() {
        return SeasonalMetModel.computePressure(this.Seasonal_, this.Lat_, this.Hgt_);
    }

    public static Double getRH(Date date, Double lat_deg, Double hgt_m) {
        double seasonal = SeasonalMetModel.computeSeasonal(date);
        double lat = StrictMath.toRadians(lat_deg);
        double hgt = 0.001 * hgt_m;
        return SeasonalMetModel.computeRelativeHumidity(seasonal, lat, hgt);
    }

    public Double getRH() {
        return SeasonalMetModel.computeRelativeHumidity(this.Seasonal_, this.Lat_, this.Hgt_);
    }

    public static Double getT(Date date, Double lat_deg, Double hgt_m) {
        double seasonal = SeasonalMetModel.computeSeasonal(date);
        double lat = StrictMath.toRadians(lat_deg);
        double hgt = 0.001 * hgt_m;
        return SeasonalMetModel.computeTemperature(seasonal, lat, hgt);
    }

    public Double getT() {
        return SeasonalMetModel.computeTemperature(this.Seasonal_, this.Lat_, this.Hgt_);
    }
}

