/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.RinexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class RinexOFile
extends RinexFile {
    public RinexOFile() {
    }

    public RinexOFile(String name) {
        this.open(name);
    }

    public RinexOFile(File file) {
        this.open(file);
    }

    public int open(File file) {
        this.Ios_ = super.open(file);
        if (this.Ios_ == 0 && !this.isOFile()) {
            this.Ios_ = 121;
        }
        return this.Ios_;
    }

    public boolean canRead() {
        return super.canRead() && this.isOFile();
    }

    public Double readInterval() {
        try {
            String text;
            if (this.FileStream_ == null) {
                return null;
            }
            int half_search = 10;
            int max_search = 20;
            ArrayList<Double> interval_set = new ArrayList<Double>();
            long last_time = -1L;
            this.FileStream_.seek(this.StartOfInfo_);
            while ((text = this.FileStream_.readLine()) != null && interval_set.size() < 10) {
                this.Matcher_ = this.EpochEventPtrn_.matcher(text);
                if (this.Matcher_.find(0) && Integer.parseInt(this.Matcher_.group(7).trim()) == 0) {
                    if (last_time < 0L) {
                        last_time = this.parseDate(this.Matcher_).getTime();
                    } else {
                        long time = this.parseDate(this.Matcher_).getTime();
                        interval_set.add(0.001 * (double)(time - last_time));
                        last_time = time;
                    }
                }
                text = null;
            }
            if (interval_set.size() == 0) {
                this.Status_ = "Searching for the first data epoch.";
                this.Ios_ = 5002;
                return null;
            }
            if (interval_set.size() == 10) {
                long offset = this.FileLength_ - 32L;
                last_time = -1L;
                while (interval_set.size() < 20) {
                    this.FileStream_.seek(offset);
                    while (offset > 0L && (text = this.FileStream_.readLine()) != null && !(this.Matcher_ = this.EpochEventPtrn_.matcher(text)).find(0)) {
                        this.FileStream_.seek(--offset);
                    }
                    if (this.Matcher_ != null && Integer.parseInt(this.Matcher_.group(7).trim()) == 0) {
                        if (last_time < 0L) {
                            last_time = this.parseDate(this.Matcher_).getTime();
                        } else {
                            long time = this.parseDate(this.Matcher_).getTime();
                            interval_set.add(0.001 * (double)(last_time - time));
                            last_time = time;
                        }
                    }
                    --offset;
                }
            }
            Collections.sort(interval_set);
            return (Double)interval_set.get((interval_set.size() + 1) / 2);
        }
        catch (IOException ex) {
            this.Status_ = "Reading file to determine the data interval.\n" + ex.getMessage();
            this.Ios_ = 5001;
            return null;
        }
    }
}

