/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Gnss;
import GNSS.GpsTime;
import GNSS.GpsTimeZone;
import GNSS.RinexFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RinexNFile
extends RinexFile {
    static final DecimalFormat DF_ = new DecimalFormat("00");
    private static final Pattern EpochLine_ = Pattern.compile("^([ 0-9][0-9]) ([ 0-9][0-9]) ([ 01][0-9]) ([ 0-3][0-9]) ([ 012][0-9]) ([ 0-6][0-9]) ([ 0-6][0-9]).([0-9])");
    private static final long StandardExtension_ = 0x6DDD00L;
    private static final long GlonassExtension_ = 900000L;
    private long Extension_ = 0x6DDD00L;

    public RinexNFile() {
    }

    public RinexNFile(String name) {
        this.open(name);
    }

    public RinexNFile(File file) {
        this.open(file);
    }

    @Override
    public int open(File file) {
        this.Ios_ = super.open(file);
        if (this.Ios_ == 0 && !this.isNFile()) {
            this.Ios_ = 121;
        }
        this.Extension_ = this.System_ == Gnss.SYSTEM.GLONASS ? 900000L : 0x6DDD00L;
        return this.Ios_;
    }

    @Override
    public boolean canRead() {
        return super.canRead() && this.isNFile();
    }

    public long getSafeExtension() {
        return this.Extension_;
    }

    public SortedSet<String> getSvList() {
        return this.getSvList(new GpsTime(1980, 0, 6).getTime(), new GpsTime(2080, 0, 1).getTime());
    }

    public SortedSet<String> getSvList(Date start, Date stop) {
        TreeSet<String> sv_list = new TreeSet<String>();
        if (start instanceof Date && stop instanceof Date) {
            Date limit1;
            Date limit0;
            if (start.before(stop)) {
                limit0 = new Date(start.getTime() - this.Extension_);
                limit1 = new Date(stop.getTime() + this.Extension_);
            } else {
                limit0 = new Date(stop.getTime() - this.Extension_);
                limit1 = new Date(start.getTime() + this.Extension_);
            }
            try {
                if (this.File_ != null && this.isNFile()) {
                    String a_line;
                    GregorianCalendar epoch = new GregorianCalendar();
                    if (this.System_.equals((Object)Gnss.SYSTEM.GLONASS)) {
                        epoch.setTimeZone(TimeZone.getTimeZone("UTC"));
                    } else {
                        epoch.setTimeZone(new GpsTimeZone());
                    }
                    BufferedReader br = new BufferedReader(new FileReader(this.File_));
                    while ((a_line = br.readLine()) != null) {
                        String sv;
                        Matcher m1 = EpochLine_.matcher(a_line);
                        if (!m1.find()) continue;
                        int year = Integer.parseInt(m1.group(2).trim());
                        if (year < 80) {
                            year += 2000;
                        } else if (year < 100) {
                            year += 1900;
                        }
                        epoch.set(year, Integer.parseInt(m1.group(3).trim()) - 1, Integer.parseInt(m1.group(4).trim()), Integer.parseInt(m1.group(5).trim()), Integer.parseInt(m1.group(6).trim()), Integer.parseInt(m1.group(7).trim()));
                        epoch.set(14, Integer.parseInt(m1.group(8).trim()));
                        if (epoch.getTime().compareTo(limit0) < 0 || epoch.getTime().compareTo(limit1) > 0 || sv_list.contains(sv = this.System_.getAbbreviation() + DF_.format(Integer.valueOf(m1.group(1).trim())))) continue;
                        sv_list.add(sv);
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return sv_list;
    }
}

