/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RinexGnsId {
    private static final Pattern Pattern_ = Pattern.compile("^([ EGRS]?)(([1-9][0-9])|([ 0]?[1-9]))$", 2);
    private static final DecimalFormat Format_ = new DecimalFormat("'G'00");
    public String Id_;

    public RinexGnsId(String input) throws IllegalArgumentException {
        this.Id_ = RinexGnsId.getId(input);
    }

    public RinexGnsId(int input) throws IllegalArgumentException {
        this.Id_ = RinexGnsId.getId(input);
    }

    public static String getId(String input) throws IllegalArgumentException {
        Matcher match = Pattern_.matcher(input);
        if (match.find(0)) {
            if (match.group(1) == null || match.group(1).length() == 0 || match.group(1).compareTo(" ") == 0 || match.group(1).compareTo("G") == 0 || match.group(1).compareTo("g") == 0) {
                return "G" + RinexGnsId.getDigitSubstring(match);
            }
            if (match.group(1).compareTo("R") == 0 || match.group(1).compareTo("r") == 0) {
                return "R" + RinexGnsId.getDigitSubstring(match);
            }
            if (match.group(1).compareTo("E") == 0 || match.group(1).compareTo("e") == 0) {
                return "E" + RinexGnsId.getDigitSubstring(match);
            }
            if (match.group(1).compareTo("S") == 0 || match.group(1).compareTo("s") == 0) {
                return "S" + RinexGnsId.getDigitSubstring(match);
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public static String getId(int input) throws IllegalArgumentException {
        if (input > 0 && input < 100) {
            return Format_.format(input);
        }
        throw new IllegalArgumentException();
    }

    public static int getIndex(String input) throws IllegalArgumentException {
        Matcher match = Pattern_.matcher(input);
        if (match.find(0)) {
            if (match.group(2) != null) {
                return Integer.parseInt(match.group(2));
            }
            return Integer.parseInt(match.group(3));
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.Id_;
    }

    private static String getDigitSubstring(Matcher match) {
        if (match.group(2) != null) {
            if (match.group(2).length() == 1) {
                return "0" + match.group(2);
            }
            if (match.group(2).charAt(0) == ' ') {
                return "0" + match.group(2).charAt(1);
            }
            return match.group(2);
        }
        if (match.group(3).length() == 1) {
            return "0" + match.group(3);
        }
        if (match.group(3).charAt(0) == ' ') {
            return "0" + match.group(3).charAt(1);
        }
        return match.group(3);
    }
}

