/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Gnss;
import GNSS.GpsTime;
import GNSS.UtcTime;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RinexFile {
    private static final Pattern AntDelHenPtrn_ = Pattern.compile("^(.{14})(.{14})(.{14}).{18}ANTENNA: DELTA H/E/N *$");
    private static final Pattern AntNoTypePtrn_ = Pattern.compile("^(.{20})(.{20}).{20}ANT # / TYPE *$");
    private static final Pattern AppPosXyzPtrn_ = Pattern.compile("^(.{14})(.{14})(.{14}).{18}APPROX POSITION XYZ *$");
    private static final Pattern EohPtrn_ = Pattern.compile("^.{60}END OF HEADER *$");
    private static final Pattern MarkerNamePtrn_ = Pattern.compile("^(.{60})MARKER NAME *$");
    private static final Pattern RnxVerTypPtrn_ = Pattern.compile("^(.{9}).{11}(.).{19}(.).{19}RINEX VERSION / TYPE *$");
    private static final Pattern TimeOfFirstObsPtrn_ = Pattern.compile("^(.{6})(.{6})(.{6})(.{6})(.{6})(.{13}).{5}(.{3}).{9}TIME OF FIRST OBS *$");
    protected Matcher Matcher_;
    protected Pattern EpochEventPtrn_;
    protected RandomAccessFile FileStream_;
    protected Double Format_;
    protected GpsTime GpsEpoch_ = new GpsTime();
    protected TreeMap<Fields, Object> HeaderInfo_ = new TreeMap();
    protected String Status_ = "";
    protected UtcTime UtcEpoch_ = new UtcTime();
    protected long FileLength_ = 0L;
    protected long StartOfInfo_ = 0L;
    protected File File_ = null;
    protected Gnss.SYSTEM System_;
    protected String Type_;
    protected int Ios_ = -1;

    public RinexFile() {
    }

    public RinexFile(String name) {
        this.open(name);
    }

    public RinexFile(File file) {
        this.open(file);
    }

    public int open(String name) {
        try {
            return this.open(new File(name));
        }
        catch (NullPointerException npe) {
            this.Status_ = "No file name was entered.";
            this.Ios_ = 1;
            return 1;
        }
    }

    public int open(File file) {
        this.initAll();
        this.Ios_ = 0;
        this.Status_ = "";
        this.File_ = file;
        if (this.File_ == null) {
            this.Status_ = "file = null.";
            this.Ios_ = 100;
        } else if (!this.File_.exists()) {
            this.Status_ = "\"" + this.File_.toString() + "\" does not exist.";
            this.Ios_ = 101;
        } else if (!this.File_.isFile()) {
            this.Status_ = "\"" + this.File_.toString() + "\" is not a file.";
            this.Ios_ = 102;
        } else if (!this.File_.canRead()) {
            this.Status_ = "can not read \"" + this.File_.toString() + "\".";
            this.Ios_ = 103;
        } else {
            try {
                this.FileStream_ = new RandomAccessFile(this.File_, "r");
                this.Ios_ = this.scanHeader();
                if (this.Ios_ == 0) {
                    this.FileLength_ = this.File_.length();
                }
            }
            catch (IOException ioe) {
                this.Status_ = "opening \"" + this.File_.toString() + "\"\n" + ioe.getMessage();
                this.Ios_ = 104;
            }
        }
        return this.Ios_;
    }

    public int close() {
        if (this.FileStream_ != null) {
            try {
                this.FileStream_.close();
                this.FileStream_ = null;
            }
            catch (IOException ioe) {
                this.Status_ = "closeing \"" + this.File_.toString() + "\"\n" + ioe.getMessage();
                this.Ios_ = 201;
            }
        }
        return this.Ios_;
    }

    public boolean canRead() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canRead();
    }

    public boolean canWrite() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canWrite();
    }

    public boolean exists() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.exists();
    }

    public Double format() {
        return this.Format_;
    }

    public Object get(Fields key) {
        if (this.HeaderInfo_.containsKey((Object)key)) {
            return this.HeaderInfo_.get((Object)key);
        }
        return null;
    }

    public Object get(String name) {
        try {
            return this.HeaderInfo_.get((Object)Fields.valueOf(name));
        }
        catch (IllegalArgumentException iaex) {
            return null;
        }
    }

    public String getAbsolutePath() {
        if (this.File_ != null) {
            return this.File_.getAbsolutePath();
        }
        return ".";
    }

    public String getCanonicalPath() {
        if (this.File_ != null) {
            try {
                return this.File_.getCanonicalPath();
            }
            catch (IOException ex) {
                return this.File_.getAbsolutePath();
            }
        }
        return ".";
    }

    public File getFile() {
        return this.File_;
    }

    public int getIos() {
        return this.Ios_;
    }

    public String getName() {
        if (this.File_ != null) {
            return this.File_.getName();
        }
        return "";
    }

    public String getPath() {
        return this.getCanonicalPath().substring(0, this.getCanonicalPath().length() - this.getName().length() - 1);
    }

    public String getStatus() {
        return this.Status_;
    }

    public Gnss.SYSTEM getSystem() {
        return this.System_;
    }

    public boolean has(Fields key) {
        return this.HeaderInfo_.containsKey((Object)key);
    }

    public boolean has(String name) {
        try {
            return this.HeaderInfo_.containsKey((Object)Fields.valueOf(name));
        }
        catch (IllegalArgumentException iaex) {
            return false;
        }
    }

    public void initAll() {
        this.Ios_ = -1;
        this.Status_ = "";
        this.Format_ = null;
        this.System_ = null;
        this.Type_ = null;
        this.HeaderInfo_.clear();
        this.close();
        this.File_ = null;
    }

    private void initFormatDependentVariables(Double format) {
        if (this.Type_.equals("O")) {
            this.EpochEventPtrn_ = format < 3.0 ? Pattern.compile("^([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{3}\\.\\d[ \\d]{6})([ \\d]{2}\\d)([ \\d]{2}\\d)") : Pattern.compile("^> ([ \\d]{3}\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d)([ \\d]{3}\\.\\d[ \\d]{6})  (\\d)([ \\d]{2}\\d)");
        } else if (this.Type_.equals("N")) {
            if (!this.HeaderInfo_.containsKey((Object)Fields.TIME_SYSTEM)) {
                if (this.System_ == Gnss.SYSTEM.GPS) {
                    this.HeaderInfo_.put(Fields.TIME_SYSTEM, "GPS");
                } else {
                    throw new RuntimeException("can set time system for = " + format + " " + this.Type_ + " " + (Object)((Object)this.System_));
                }
            }
            this.EpochEventPtrn_ = format < 3.0 ? Pattern.compile("^([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d)([ \\d]{3}\\.\\d)([ \\d\\-\\+]{2}\\.\\d{12}[DEde][\\-\\+]\\d{2})([ \\d\\-\\+]{2}\\.\\d{12}[DEde][\\-\\+]\\d{2})([ \\d\\-\\+]{2}\\.\\d{12}[DEde][\\-\\+]\\d{2})") : Pattern.compile("^([ GRES][ \\d]\\d) ([ \\d]{3}\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d)([ \\d\\-\\+]{2}\\.\\d{12}[DEde][\\-\\+]\\d{2})([ \\d\\-\\+]{2}\\.\\d{12}[DEde][\\-\\+]\\d{2})([ \\d\\-\\+]{2}\\.\\d{12}[DEde][\\-\\+]\\d{2})");
        } else if (this.Type_.equals("M")) {
            if (!this.HeaderInfo_.containsKey((Object)Fields.TIME_SYSTEM)) {
                this.HeaderInfo_.put(Fields.TIME_SYSTEM, "GPS");
            }
            this.EpochEventPtrn_ = Pattern.compile("^([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d)([ \\d]{5}\\.\\d)");
        }
    }

    protected boolean isDateOk(Date date, long ms_interval, long ms_limit) {
        if (date != null) {
            long tmp = date.getTime() % ms_interval;
            return tmp < ms_limit || StrictMath.abs(ms_interval - tmp) < ms_limit;
        }
        return false;
    }

    public boolean isFile() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.isFile();
    }

    public boolean isMFile() {
        if (this.Type_ == null) {
            return false;
        }
        return this.Type_.equals("M");
    }

    public boolean isNFile() {
        if (this.Type_ == null) {
            return false;
        }
        return this.Type_.equals("N");
    }

    public boolean isOFile() {
        if (this.Type_ == null) {
            return false;
        }
        return this.Type_.equals("O");
    }

    public long length() {
        if (this.File_ != null) {
            return this.File_.length();
        }
        return 0L;
    }

    protected Date parseDate(Matcher matcher) {
        matcher.find(0);
        int offset = 0;
        if (this.Type_.equals("N")) {
            offset = 1;
        }
        if (((String)this.HeaderInfo_.get((Object)Fields.TIME_SYSTEM)).equals("GLO")) {
            this.UtcEpoch_.set(this.rectifyYear(Integer.valueOf(matcher.group(1 + offset).trim())), Integer.valueOf(matcher.group(2 + offset).trim()) - 1, Integer.valueOf(matcher.group(3 + offset).trim()), Integer.valueOf(matcher.group(4 + offset).trim()), Integer.valueOf(matcher.group(5 + offset).trim()));
            Double second = Double.valueOf(matcher.group(6 + offset).trim());
            this.UtcEpoch_.set(13, second.intValue());
            this.UtcEpoch_.set(14, (int)((second - (double)second.intValue()) * 1000.0 + 0.5));
            return this.UtcEpoch_.getTime();
        }
        this.GpsEpoch_.set(this.rectifyYear(Integer.valueOf(matcher.group(1 + offset).trim())), Integer.valueOf(matcher.group(2 + offset).trim()) - 1, Integer.valueOf(matcher.group(3 + offset).trim()), Integer.valueOf(matcher.group(4 + offset).trim()), Integer.valueOf(matcher.group(5 + offset).trim()));
        Double second = Double.valueOf(matcher.group(6 + offset).trim());
        this.GpsEpoch_.set(13, second.intValue());
        this.GpsEpoch_.set(14, (int)((second - (double)second.intValue()) * 1000.0 + 0.5));
        return this.GpsEpoch_.getTime();
    }

    private void parseTimeSystem(String name) {
        if (this.HeaderInfo_.containsKey((Object)Fields.TIME_SYSTEM)) {
            if (!((name.equals("   ") || name.equals("GPS")) && ((String)this.HeaderInfo_.get((Object)Fields.TIME_SYSTEM)).equals("GPS") || ((String)this.HeaderInfo_.get((Object)Fields.TIME_SYSTEM)).equals(name))) {
                throw new RuntimeException("time system = \"" + name + "\"" + "does not match current value = \"" + this.HeaderInfo_.get((Object)Fields.TIME_SYSTEM) + "\"");
            }
        } else if (name.equals("   ") || name.equals("GPS")) {
            this.HeaderInfo_.put(Fields.TIME_SYSTEM, new String("GPS"));
        } else if (name.equals("GLO")) {
            this.HeaderInfo_.put(Fields.TIME_SYSTEM, name);
        } else if (name.equals("GAL")) {
            this.HeaderInfo_.put(Fields.TIME_SYSTEM, name);
        } else {
            throw new RuntimeException("invalid time system = \"" + name + "\"");
        }
    }

    public Date readTimeOfFirstEpoch() {
        return this.readTimeOfFirstEpoch(0);
    }

    public Date readTimeOfFirstEpoch(int min_number_of_satellites) {
        return this.readTimeOfFirstEpoch(min_number_of_satellites, 0.0);
    }

    public Date readTimeOfFirstEpoch(int min_number_of_satellites, double interval) {
        return this.readTimeOfFirstEpoch(min_number_of_satellites, interval, interval > 0.01 ? interval / 10.0 : 0.01);
    }

    public Date readTimeOfFirstEpoch(int min_number_of_satellites, double interval, double limit) {
        try {
            String text;
            if (this.FileStream_ == null) {
                return null;
            }
            long ms_interval = this.safelyConvertToMillis(interval);
            long ms_limit = this.safelyConvertToMillis(limit);
            this.FileStream_.seek(this.StartOfInfo_);
            while ((text = this.FileStream_.readLine()) != null) {
                this.Matcher_ = this.EpochEventPtrn_.matcher(text);
                if (!this.Matcher_.find(0)) continue;
                Date date = this.parseDate(this.Matcher_);
                if (this.Type_.equals("O")) {
                    if (Integer.parseInt(this.Matcher_.group(7).trim()) != 0 || Integer.parseInt(this.Matcher_.group(8).trim()) < min_number_of_satellites || !this.isDateOk(date, ms_interval, ms_limit)) continue;
                    return date;
                }
                return date;
            }
            this.Status_ = "could not find the first epoch";
            this.Ios_ = 3002;
            return null;
        }
        catch (IOException ex) {
            this.Status_ = "reading time of the first epoch\n" + ex.getMessage();
            this.Ios_ = 3001;
            return null;
        }
    }

    public Date readTimeOfFirstEpoch(double interval) {
        return this.readTimeOfFirstEpoch(0, interval);
    }

    public Date readTimeOfFirstEpoch(double interval, double limit) {
        return this.readTimeOfFirstEpoch(0, interval, limit);
    }

    public Date readTimeOfLastEpoch() {
        return this.readTimeOfLastEpoch(0);
    }

    public Date readTimeOfLastEpoch(int min_number_of_satellites) {
        return this.readTimeOfLastEpoch(min_number_of_satellites, 0.0);
    }

    public Date readTimeOfLastEpoch(int min_number_of_satellites, double interval) {
        return this.readTimeOfLastEpoch(min_number_of_satellites, interval, interval > 0.01 ? interval / 10.0 : 0.01);
    }

    public Date readTimeOfLastEpoch(int min_number_of_satellites, double interval, double limit) {
        try {
            String text;
            if (this.FileStream_ == null) {
                return null;
            }
            long ms_interval = this.safelyConvertToMillis(interval);
            long ms_limit = this.safelyConvertToMillis(limit);
            long offset = this.FileLength_ - 32L;
            this.FileStream_.seek(offset);
            while (offset > 0L && (text = this.FileStream_.readLine()) != null) {
                this.Matcher_ = this.EpochEventPtrn_.matcher(text);
                if (this.Matcher_.find(0)) {
                    Date date = this.parseDate(this.Matcher_);
                    if (this.Type_.equals("O")) {
                        if (Integer.parseInt(this.Matcher_.group(7).trim()) == 0 && Integer.parseInt(this.Matcher_.group(8).trim()) >= min_number_of_satellites && this.isDateOk(date, ms_interval, ms_limit)) {
                            return date;
                        }
                    } else {
                        return date;
                    }
                }
                this.FileStream_.seek(--offset);
            }
            this.Status_ = "could not find the last epoch";
            this.Ios_ = 4003;
            return null;
        }
        catch (IOException ex) {
            this.Status_ = "reading time of the last epoch\n" + ex.getMessage();
            this.Ios_ = 4001;
            return null;
        }
    }

    public Date readTimeOfLastEpoch(double interval) {
        return this.readTimeOfLastEpoch(0, interval);
    }

    public Date readTimeOfLastEpoch(double interval, double limit) {
        return this.readTimeOfLastEpoch(0, interval, limit);
    }

    private Gnss.SYSTEM rectifySystem(String type, String system) {
        if (type.equals("O") || type.equals("N") || type.equals("M")) {
            if (system.equals(" ")) {
                return Gnss.SYSTEM.GPS;
            }
            for (Gnss.SYSTEM tmp : Gnss.SYSTEM.values()) {
                if (!tmp.equalsIgnoreCase(system)) continue;
                return tmp;
            }
            throw new RuntimeException("invalid satellite system  = \"" + system + "\"");
        }
        if (type.equals("G")) {
            return Gnss.SYSTEM.GLONASS;
        }
        if (type.equals("H")) {
            return Gnss.SYSTEM.SBAS;
        }
        throw new RuntimeException("invalid file type = \"" + type + "\"");
    }

    private String rectifyType(String type, String system) {
        if (type.equals("O") || type.equals("N") || type.equals("M")) {
            return type;
        }
        if (type.equals("G") || type.equals("H")) {
            return "N";
        }
        throw new RuntimeException("invalid file type = \"" + type + "\"");
    }

    private int rectifyYear(Integer year) {
        return this.rectifyYear((int)year);
    }

    private int rectifyYear(int year) {
        if (year < 1980) {
            return year + 2000;
        }
        if (year < 2000) {
            return year + 1900;
        }
        return year;
    }

    protected long safelyConvertToMillis(double value) {
        return value > 0.0 ? StrictMath.round(value * 1000.0) : 1L;
    }

    private int scanHeader() {
        String text = "UNKNOWN";
        int ios = this.Ios_;
        if (ios == 0) {
            try {
                this.FileStream_.seek(0L);
                this.Ios_ = 0;
                this.Status_ = "";
                this.Format_ = null;
                this.System_ = null;
                this.Type_ = null;
                this.HeaderInfo_.clear();
                text = this.FileStream_.readLine();
                if (text == null) {
                    this.Status_ = "empty file";
                    ios = 2001;
                } else {
                    this.Matcher_ = RnxVerTypPtrn_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        if (!this.validType(this.Matcher_.group(2)) && !this.validSystem(this.Matcher_.group(3))) {
                            this.Status_ = "invalid RINEX file type = \"" + this.Matcher_.group(2) + "\"" + " sysetm = \"" + this.Matcher_.group(3) + "\"";
                            ios = 2002;
                        } else if (!this.validType(this.Matcher_.group(2))) {
                            this.Status_ = "invalid RINEX file type = \"" + this.Matcher_.group(2) + "\"";
                            ios = 2003;
                        } else if (!this.validSystem(this.Matcher_.group(3))) {
                            this.Status_ = "invalid RINEX file system = \"" + this.Matcher_.group(3) + "\"";
                            ios = 2004;
                        } else {
                            this.Format_ = Double.valueOf(this.Matcher_.group(1));
                            this.Type_ = this.rectifyType(this.Matcher_.group(2), this.Matcher_.group(3));
                            this.System_ = this.rectifySystem(this.Matcher_.group(2), this.Matcher_.group(3));
                            this.initFormatDependentVariables(this.Format_);
                        }
                    } else {
                        this.Status_ = "not a RINEX format file";
                        ios = 2005;
                    }
                }
                while (ios == 0 && (text = this.FileStream_.readLine()) != null && !(this.Matcher_ = EohPtrn_.matcher(text)).find(0)) {
                    this.Matcher_ = AntDelHenPtrn_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        this.HeaderInfo_.put(Fields.ANT_DEL_H, Double.valueOf(this.Matcher_.group(1)));
                        this.HeaderInfo_.put(Fields.ANT_DEL_E, Double.valueOf(this.Matcher_.group(2)));
                        this.HeaderInfo_.put(Fields.ANT_DEL_N, Double.valueOf(this.Matcher_.group(3)));
                        continue;
                    }
                    this.Matcher_ = AntNoTypePtrn_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        this.HeaderInfo_.put(Fields.ANT_NO, this.Matcher_.group(1));
                        this.HeaderInfo_.put(Fields.ANT_TYPE, this.Matcher_.group(2));
                        continue;
                    }
                    this.Matcher_ = AppPosXyzPtrn_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        this.HeaderInfo_.put(Fields.APP_POS_X, Double.valueOf(this.Matcher_.group(1)));
                        this.HeaderInfo_.put(Fields.APP_POS_Y, Double.valueOf(this.Matcher_.group(2)));
                        this.HeaderInfo_.put(Fields.APP_POS_Z, Double.valueOf(this.Matcher_.group(3)));
                        continue;
                    }
                    this.Matcher_ = MarkerNamePtrn_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        this.HeaderInfo_.put(Fields.MARKER_NAME, this.Matcher_.group(1));
                        continue;
                    }
                    this.Matcher_ = TimeOfFirstObsPtrn_.matcher(text);
                    if (!this.Matcher_.find(0)) continue;
                    this.parseTimeSystem(this.Matcher_.group(7));
                    this.HeaderInfo_.put(Fields.TIME_OF_FIRST_OBS, this.parseDate(this.Matcher_));
                }
                if (text == null) {
                    this.Status_ = "END OF HEADER not found";
                    ios = 2006;
                    return ios;
                }
                this.StartOfInfo_ = this.FileStream_.getFilePointer();
                ios = 0;
            }
            catch (NumberFormatException nfe) {
                this.Status_ = "nfe in RINEX header " + text.substring(60).trim() + "record\n" + nfe.getMessage();
                ios = 2007;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                this.Status_ = "sioobe in RINEX header " + text.substring(60).trim() + "record\n" + sioobe.getMessage();
                ios = 2008;
            }
            catch (EOFException eof) {
                this.Status_ = "eof reached";
                ios = -1;
            }
            catch (RuntimeException re) {
                this.Status_ = "re in RINEX header " + text.substring(60).trim() + "record\n" + re.getMessage();
                ios = 2009;
            }
            catch (IOException e) {
                this.Status_ = "e in RINEX header " + text.substring(60).trim() + "record\n" + e.getMessage();
                ios = 2010;
            }
        }
        return ios;
    }

    public long tell() {
        try {
            return this.FileStream_.getFilePointer();
        }
        catch (IOException ioe) {
            return this.FileLength_;
        }
    }

    public int tellPercentage() {
        try {
            return this.FileLength_ == 0L ? 0 : (int)(100L * this.FileStream_.getFilePointer() / this.FileLength_);
        }
        catch (IOException ioe) {
            return 100;
        }
    }

    private boolean validSystem(String system) {
        if (system.startsWith(" ")) {
            return true;
        }
        for (Gnss.SYSTEM tmp : Gnss.SYSTEM.values()) {
            if (!tmp.equalsIgnoreCase(system)) continue;
            return true;
        }
        return false;
    }

    private boolean validType(String type) {
        return type.equals("O") || type.equals("M") || type.equals("N") || type.equals("H") || type.equals("G");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Fields {
        ANT_DEL_E,
        ANT_DEL_H,
        ANT_DEL_N,
        ANT_DEL_X,
        ANT_DEL_Y,
        ANT_DEL_Z,
        ANT_NO,
        ANT_TYPE,
        APP_POS_X,
        APP_POS_Y,
        APP_POS_Z,
        INTERVAL,
        MARKER_NAME,
        TIME_OF_FIRST_OBS,
        TIME_OF_LAST_OBS,
        TIME_SYSTEM;

    }
}

