/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class PomFile {
    private File File_ = null;
    private RandomAccessFile FileStream_;
    private TreeMap<String, Object> Info_ = new TreeMap();
    private String Status_ = "";
    private int Ios_ = -1;
    private long FileLength_ = 0L;
    private long StartOfInfo_ = 0L;

    public PomFile() {
    }

    public PomFile(String name) {
        this.open(name);
    }

    public PomFile(File file) {
        this.open(file);
    }

    public int open(String name) {
        try {
            return this.open(new File(name));
        }
        catch (NullPointerException npe) {
            this.Status_ = "No file name was entered.";
            this.Ios_ = 1;
            return 1;
        }
    }

    public int open(File file) {
        this.Ios_ = 0;
        this.Status_ = "";
        this.initAll();
        this.File_ = file;
        if (this.File_ == null) {
            this.Status_ = "file = null.";
            this.Ios_ = 100;
        } else if (!this.File_.exists()) {
            this.Status_ = "\"" + this.File_.toString() + "\" does not exist.";
            this.Ios_ = 101;
        } else if (!this.File_.isFile()) {
            this.Status_ = "\"" + this.File_.toString() + "\" is not a file.";
            this.Ios_ = 102;
        } else if (!this.File_.canRead()) {
            this.Status_ = "can not read \"" + this.File_.toString() + "\".";
            this.Ios_ = 103;
        } else {
            try {
                this.FileStream_ = new RandomAccessFile(this.File_, "r");
                this.Ios_ = this.scan();
            }
            catch (IOException ioe) {
                this.Status_ = "opening \"" + this.File_.toString() + "\"\n" + ioe.getMessage();
                this.Ios_ = 104;
            }
        }
        return this.Ios_;
    }

    public int close() {
        if (this.Ios_ == 0) {
            try {
                this.FileStream_.close();
                this.FileStream_ = null;
            }
            catch (IOException ioe) {
                this.Status_ = "closeing \"" + this.File_.toString() + "\"\n" + ioe.getMessage();
                this.Ios_ = 201;
            }
        }
        return this.Ios_;
    }

    public boolean canRead() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canRead();
    }

    public boolean canWrite() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canWrite();
    }

    public boolean exists() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.exists();
    }

    public Object get(String name) {
        if (this.Info_.containsKey(name)) {
            return this.Info_.get(name);
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.File_ != null) {
            return this.File_.getAbsolutePath();
        }
        return ".";
    }

    public String getCanonicalPath() {
        if (this.File_ != null) {
            try {
                return this.File_.getCanonicalPath();
            }
            catch (IOException ex) {
                return this.File_.getAbsolutePath();
            }
        }
        return ".";
    }

    public File getFile() {
        return this.File_;
    }

    public int getIos() {
        return this.Ios_;
    }

    public String getName() {
        if (this.File_ != null) {
            return this.File_.getName();
        }
        return "";
    }

    public String getPath() {
        return this.getCanonicalPath().substring(0, this.getCanonicalPath().length() - this.getName().length() - 1);
    }

    public String getStatus() {
        return this.Status_;
    }

    public boolean has(String name) {
        return this.Info_.containsKey(name);
    }

    private void initAll() {
        this.Ios_ = 0;
        this.Status_ = "";
        this.Info_.clear();
    }

    public boolean isFile() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.isFile();
    }

    public long length() {
        if (this.File_ != null) {
            return this.File_.length();
        }
        return 0L;
    }

    private int scan() {
        String text = "UNKNOWN";
        String type = "";
        int ios = this.Ios_;
        if (ios == 0) {
            try {
                StringTokenizer tokens;
                this.FileStream_.seek(0L);
                this.initAll();
                type = "first (coordinates) line";
                text = this.FileStream_.readLine();
                if (text == null) {
                    this.Status_ = "empty file";
                    ios = 2001;
                } else if (text.length() == 0 || (tokens = new StringTokenizer(text)).countTokens() != 3) {
                    this.Status_ = "invalid POM file format on " + type;
                    ios = 2002;
                } else {
                    this.Info_.put("MON_X", Double.valueOf(tokens.nextToken()));
                    this.Info_.put("MON_Y", Double.valueOf(tokens.nextToken()));
                    this.Info_.put("MON_Z", Double.valueOf(tokens.nextToken()));
                }
                type = "second (offsets) line";
                text = this.FileStream_.readLine();
                if (text == null || text.length() == 0 || (tokens = new StringTokenizer(text)).countTokens() != 4) {
                    this.Status_ = "invalid POM file format on " + type;
                    ios = 2003;
                } else {
                    this.Info_.put("ANT_DEL_N", Double.valueOf(tokens.nextToken()));
                    this.Info_.put("ANT_DEL_E", Double.valueOf(tokens.nextToken()));
                    this.Info_.put("ANT_DEL_H", Double.valueOf(tokens.nextToken()));
                    this.Info_.put("ANT_L1_L2_DEL_H", Double.valueOf(tokens.nextToken()));
                }
                type = "third (met) line";
                text = this.FileStream_.readLine();
                if (text == null || text.length() == 0 || (tokens = new StringTokenizer(text)).countTokens() != 3) {
                    this.Status_ = "invalid POM file format on " + type;
                    ios = 2004;
                } else {
                    this.Info_.put("MET_T", Double.valueOf(tokens.nextToken()));
                    this.Info_.put("MET_P", Double.valueOf(tokens.nextToken()));
                    this.Info_.put("MET_RH", Double.valueOf(tokens.nextToken()));
                }
                type = "fourth (antenna ID) line";
                text = this.FileStream_.readLine();
                if (text == null || text.length() == 0) {
                    this.Status_ = "invalid POM file format on " + type;
                    ios = 2005;
                } else {
                    this.Info_.put("ANT_TYPE", text.substring(0, text.length() < 20 ? text.length() : 20));
                }
                ios = 0;
            }
            catch (NumberFormatException nfe) {
                this.Status_ = "nfe in POM file " + type + "\n" + nfe.getMessage();
                ios = 2007;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                this.Status_ = "sioobe in POM file " + type + "\n" + sioobe.getMessage();
                ios = 2008;
            }
            catch (EOFException eof) {
                this.Status_ = "eof reached";
                ios = -1;
            }
            catch (RuntimeException re) {
                this.Status_ = "re in POM file " + type + "\n" + re.getMessage();
                ios = 2009;
            }
            catch (IOException e) {
                this.Status_ = "e in POM file " + type + "\n" + e.getMessage();
                ios = 2010;
            }
        }
        return ios;
    }

    public long tell() {
        try {
            return this.FileStream_.getFilePointer();
        }
        catch (IOException ioe) {
            return this.FileLength_;
        }
    }

    public int tellPercentage() {
        try {
            return this.FileLength_ == 0L ? 0 : (int)(100L * this.FileStream_.getFilePointer() / this.FileLength_);
        }
        catch (IOException ioe) {
            return 100;
        }
    }
}

