/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpusFile {
    private File File_ = null;
    private Matcher Matcher_;
    private Pattern AntName_ = Pattern.compile("ANT NAME: *([A-Z].{19}) *");
    private Pattern ArpHeight_ = Pattern.compile("ARP HEIGHT: *([\\+\\-]?\\d*\\.\\d*) *");
    private Pattern Empty_ = Pattern.compile("^ *$");
    private Pattern RefFrame_ = Pattern.compile("REF FRAME:.*\\(EPOCH: *\\d+\\.\\d+\\) *(.*) *\\(EPOCH: *(\\d+\\.\\d+)\\)");
    private Pattern XCoord_ = Pattern.compile("^ +X:.*\\([Mm]\\).*\\([Mm]\\) *(.*) *\\([Mm]\\).*\\([Mm]\\)");
    private Pattern YCoord_ = Pattern.compile("^ +Y:.*\\([Mm]\\).*\\([Mm]\\) *(.*) *\\([Mm]\\).*\\([Mm]\\)");
    private Pattern ZCoord_ = Pattern.compile("^ +Z:.*\\([Mm]\\).*\\([Mm]\\) *(.*) *\\([Mm]\\).*\\([Mm]\\)");
    private String Format_ = "";
    private String Status_ = "";
    private TreeMap<Fields, Object> Info_ = new TreeMap();
    private int Ios_ = -1;
    private long FileLength_ = 0L;

    public OpusFile() {
    }

    public OpusFile(String name) {
        this.open(name);
    }

    public OpusFile(File file) {
        this.open(file);
    }

    public int open(String name) {
        try {
            return this.open(new File(name));
        }
        catch (NullPointerException npe) {
            this.Status_ = "No file name was entered.";
            this.Ios_ = 1;
            return 1;
        }
    }

    public int open(File file) {
        this.Ios_ = 0;
        this.Status_ = "";
        if (file == null) {
            this.Status_ = "file = null.";
            this.Ios_ = -1;
        } else if (!file.exists()) {
            this.Status_ = "\"" + file.toString() + "\" does not exist.";
            this.Ios_ = -1;
        } else if (!file.isFile()) {
            this.Status_ = "\"" + file.toString() + "\" is not a file.";
            this.Ios_ = 1;
        } else if (!file.canRead()) {
            this.Status_ = "can not read \"" + file.toString() + "\".";
            this.Ios_ = 2;
        } else {
            this.File_ = file;
            this.Ios_ = this.scanFile();
        }
        return this.Ios_;
    }

    public int close() {
        if (this.Ios_ == 0) {
            // empty if block
        }
        return this.Ios_;
    }

    public boolean canRead() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canRead();
    }

    public boolean canWrite() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canWrite();
    }

    public boolean exists() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.exists();
    }

    public String format() {
        return this.Format_;
    }

    public Object get(Fields field) {
        if (this.Info_.containsKey((Object)field)) {
            return this.Info_.get((Object)field);
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.File_ != null) {
            return this.File_.getAbsolutePath();
        }
        return "";
    }

    public String getCanonicalPath() {
        if (this.File_ != null) {
            try {
                return this.File_.getCanonicalPath();
            }
            catch (IOException ex) {
                return this.File_.getAbsolutePath();
            }
        }
        return "";
    }

    public File getFile() {
        return this.File_;
    }

    public int getIos() {
        return this.Ios_;
    }

    public Iterator getKeyIterator() {
        return this.Info_.keySet().iterator();
    }

    public Set<Fields> getKeys() {
        return this.Info_.keySet();
    }

    public String getName() {
        if (this.File_ != null) {
            return this.File_.getName();
        }
        return "";
    }

    public String getStatus() {
        return this.Status_;
    }

    public boolean has(Fields field) {
        return this.Info_.containsKey((Object)field);
    }

    public boolean has(String field) {
        Iterator<Fields> itr = this.Info_.keySet().iterator();
        while (itr.hasNext()) {
            if (!itr.next().name().equalsIgnoreCase(field)) continue;
            return true;
        }
        return false;
    }

    private void initAll() {
        this.Format_ = "1.0";
        this.Info_.clear();
    }

    public boolean isFile() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.isFile();
    }

    public long length() {
        if (this.File_ != null) {
            return this.File_.length();
        }
        return 0L;
    }

    private int scanFile() {
        if (this.Ios_ == 0) {
            this.initAll();
            try {
                BufferedReader input_stream = new BufferedReader(new FileReader(this.File_));
                String text = "";
                text = input_stream.readLine();
                if (text != null) {
                    this.Ios_ = text.startsWith("<?xml") ? this.scanXmlFile(input_stream) : this.scanTextFile(input_stream);
                }
                input_stream.close();
            }
            catch (IOException ioe) {
                this.Status_ = "ioe in OPUS report = " + ioe.getMessage();
                this.Ios_ = 2000;
            }
        }
        return this.Ios_;
    }

    private int scanTextFile(BufferedReader input_stream) {
        this.Format_ = "t1.0";
        boolean coord_flag = false;
        boolean ref_frame_flag = false;
        String text = "";
        try {
            while ((text = input_stream.readLine()) != null) {
                this.Matcher_ = this.AntName_.matcher(text);
                if (this.Matcher_.find(0)) {
                    this.Info_.put(Fields.ANT_TYPE, this.Matcher_.group(1));
                    continue;
                }
                this.Matcher_ = this.ArpHeight_.matcher(text);
                if (this.Matcher_.find(0)) {
                    this.Info_.put(Fields.ANT_DEL_H, Double.valueOf(this.Matcher_.group(1)));
                    this.Info_.put(Fields.ANT_DEL_E, 0.0);
                    this.Info_.put(Fields.ANT_DEL_N, 0.0);
                    continue;
                }
                if (!ref_frame_flag && (this.Matcher_ = this.RefFrame_.matcher(text)).find(0)) {
                    ref_frame_flag = true;
                    this.Info_.put(Fields.REF_FRAME, this.Matcher_.group(1));
                    this.Info_.put(Fields.POS_EPOCH, Double.valueOf(this.Matcher_.group(2)));
                    continue;
                }
                if (ref_frame_flag && (this.Matcher_ = this.XCoord_.matcher(text)).find(0)) {
                    coord_flag = true;
                    this.Info_.put(Fields.POS_X, Double.valueOf(this.Matcher_.group(1)));
                    continue;
                }
                if (ref_frame_flag && (this.Matcher_ = this.YCoord_.matcher(text)).find(0)) {
                    coord_flag = true;
                    this.Info_.put(Fields.POS_Y, Double.valueOf(this.Matcher_.group(1)));
                    continue;
                }
                if (ref_frame_flag && (this.Matcher_ = this.ZCoord_.matcher(text)).find(0)) {
                    coord_flag = true;
                    this.Info_.put(Fields.POS_Z, Double.valueOf(this.Matcher_.group(1)));
                    continue;
                }
                if (!coord_flag || !ref_frame_flag || !(this.Matcher_ = this.Empty_.matcher(text)).find(0)) continue;
            }
            if (this.Info_.size() == 0) {
                this.Status_ = "no values found";
                this.Ios_ = 2001;
            } else {
                this.Ios_ = 0;
            }
        }
        catch (NumberFormatException nfe) {
            this.Status_ = "nfe in OPUS text report = " + nfe.getMessage();
            this.Ios_ = 2002;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            this.Status_ = "sioobe  in OPUS text report = " + sioobe.getMessage();
            this.Ios_ = 2003;
        }
        catch (EOFException eof) {
            this.Status_ = "eof reached in OPUS text report";
            this.Ios_ = 2004;
        }
        catch (RuntimeException re) {
            this.Status_ = "re  in OPUS text report = " + re.getMessage();
            this.Ios_ = 2005;
        }
        catch (IOException ioe) {
            this.Status_ = "ioe  in OPUS text report = " + ioe.getMessage();
            this.Ios_ = 2006;
        }
        return this.Ios_;
    }

    private int scanXmlFile(BufferedReader input_stream) {
        this.Format_ = "x1.0";
        try {
            boolean coord_flag = false;
            boolean ref_frame_flag = false;
            String text = "";
            while ((text = input_stream.readLine()) != null) {
                String[] tokens = text.split("[<>]");
                if (tokens.length != 4) continue;
                if (tokens[1].equalsIgnoreCase("ANTENNA_NAME")) {
                    this.Info_.put(Fields.ANT_TYPE, tokens[2]);
                    continue;
                }
                if (tokens[1].equalsIgnoreCase("ARP_HEIGHT")) {
                    this.Info_.put(Fields.ANT_DEL_H, Double.valueOf(tokens[2]));
                    this.Info_.put(Fields.ANT_DEL_E, 0.0);
                    this.Info_.put(Fields.ANT_DEL_N, 0.0);
                    continue;
                }
                if (tokens[1].equalsIgnoreCase("REF_FRAME")) {
                    if ((tokens = tokens[2].trim().split(" +")).length <= 0 || !tokens[0].startsWith("I")) continue;
                    this.Info_.put(Fields.REF_FRAME, tokens[0]);
                    continue;
                }
                if (tokens[1].equalsIgnoreCase("EPOCH") && this.Info_.containsKey((Object)Fields.REF_FRAME)) {
                    this.Info_.put(Fields.POS_EPOCH, Double.valueOf(tokens[2]));
                    continue;
                }
                if (tokens[1].equalsIgnoreCase("COORDINATE AXIS=\"X") && this.Info_.containsKey((Object)Fields.REF_FRAME) && !this.Info_.containsKey((Object)Fields.POS_X)) {
                    this.Info_.put(Fields.POS_X, Double.valueOf(tokens[2]));
                    continue;
                }
                if (tokens[1].equalsIgnoreCase("COORDINATE AXIS=\"Y") && this.Info_.containsKey((Object)Fields.REF_FRAME) && !this.Info_.containsKey((Object)Fields.POS_Y)) {
                    this.Info_.put(Fields.POS_X, Double.valueOf(tokens[2]));
                    continue;
                }
                if (!tokens[1].equalsIgnoreCase("COORDINATE AXIS=\"Z") || !this.Info_.containsKey((Object)Fields.REF_FRAME) || this.Info_.containsKey((Object)Fields.POS_Z)) continue;
                this.Info_.put(Fields.POS_X, Double.valueOf(tokens[2]));
            }
            if (this.Info_.size() == 0) {
                this.Status_ = "no values found";
                this.Ios_ = 2001;
            } else {
                this.Ios_ = 0;
            }
        }
        catch (NumberFormatException nfe) {
            this.Status_ = "nfe in OPUS XML report = " + nfe.getMessage();
            this.Ios_ = 2002;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            this.Status_ = "sioobe in OPUS XML report = " + sioobe.getMessage();
            this.Ios_ = 2003;
        }
        catch (EOFException eof) {
            this.Status_ = "eof reached in OPUS XML report";
            this.Ios_ = 2004;
        }
        catch (RuntimeException re) {
            this.Status_ = "re in OPUS XML report = " + re.getMessage();
            this.Ios_ = 2005;
        }
        catch (IOException ioe) {
            this.Status_ = "ioe in OPUS XML report = " + ioe.getMessage();
            this.Ios_ = 2006;
        }
        return this.Ios_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Fields {
        ANT_DEL_H,
        ANT_DEL_E,
        ANT_DEL_N,
        ANT_TYPE,
        POS_EPOCH,
        POS_X,
        POS_Y,
        POS_Z,
        REF_FRAME;

    }
}

