/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

public class Gpt {
    static final double[] a_geoid = new double[]{-0.56195, -0.060794, -0.20125, -0.06418, -0.036997, 10.098, 16.436, 14.065, 1.9881, 0.64414, -4.7482, -3.229, 0.50652, 0.38279, -0.026646, 1.7224, -0.2797, 0.68177, -0.096658, -0.015113, 0.0029206, -3.4621, -0.38198, 0.032306, 0.0069915, -0.0023068, -0.0013548, 4.7324E-6, 2.3527, 1.2985, 0.21232, 0.022571, -0.0037855, 2.9449E-5, -1.6265E-4, 1.1711E-7, 1.6732, 0.19858, 0.023975, -9.0013E-4, -0.0022475, -3.3095E-5, -1.204E-5, 2.201E-6, -1.0083E-6, 0.86297, 0.58231, 0.020545, -0.007811, -1.4085E-4, -8.8459E-6, 5.7256E-6, -1.5068E-6, 4.0095E-7, -2.4185E-8};
    static final double[] b_geoid = new double[]{0.0, 0.0, -0.065993, 0.0, 0.065364, -5.832, 0.0, 1.6961, -1.3557, 1.2694, 0.0, -2.931, 0.94805, -0.076243, 0.041076, 0.0, -0.51808, -0.34583, -0.043632, 0.0022101, -0.010663, 0.0, 0.10927, -0.29463, 0.0014371, -0.011452, -0.0028156, -3.533E-4, 0.0, 0.44049, 0.055653, -0.020396, -0.0017312, 3.5805E-5, 7.2682E-5, 2.2535E-6, 0.0, 0.019502, 0.027919, -0.0081812, 4.454E-4, 8.8663E-5, 5.5596E-5, 2.4826E-6, 1.0279E-6, 0.0, 0.060529, -0.035824, -0.0051367, 3.0119E-5, -2.9911E-5, 1.9844E-5, -1.2349E-6, -7.6756E-9, 5.01E-8};
    static final double[] ap_mean = new double[]{1010.8, 8.4886, 1.4799, -13.897, 0.0037516, -0.14936, 12.232, -0.76615, -0.067699, 0.0081002, -15.874, 0.36614, -0.067807, -0.0036309, 5.9966E-4, 4.8163, -0.37363, -0.072071, 0.0019998, -6.2385E-4, -3.7916E-4, 4.7609, -0.39534, 0.0086667, 0.011569, 0.0011441, -1.4193E-4, -8.5723E-5, 0.65008, -0.50889, -0.015754, -0.0028305, 5.7458E-4, 3.2577E-5, -9.6052E-6, -2.7974E-6, 1.353, -0.27271, -3.0276E-4, 0.0036286, -2.0398E-4, 1.5846E-5, -7.7787E-6, 1.121E-6, 9.902E-8, 0.55046, -0.27312, 0.0032532, -0.0024277, 1.1596E-4, 2.6421E-7, -1.3263E-6, 2.7322E-7, 1.4058E-7, 4.9414E-9};
    static final double[] bp_mean = new double[]{0.0, 0.0, -1.2878, 0.0, 0.70444, 0.33222, 0.0, -0.29636, 0.0072248, 0.0079655, 0.0, 1.0854, 0.011145, -0.036513, 0.0031527, 0.0, -0.48434, 0.052023, -0.013091, 0.0018515, 1.5422E-4, 0.0, 0.68298, 0.0025261, -9.9703E-4, -0.0010829, 1.7688E-4, -3.1418E-5, 0.0, -0.37018, 0.043234, 0.0072559, 3.1516E-4, 2.0024E-5, -8.0581E-6, -2.3653E-6, 0.0, 0.10298, -0.015086, 0.0056186, 3.2613E-5, 4.0567E-5, -1.3925E-6, -3.6219E-7, -2.0176E-8, 0.0, -0.18364, 0.018508, 7.5016E-4, -9.6139E-5, -3.1995E-6, 1.3868E-7, -1.9486E-7, 3.0165E-10, -6.4376E-10};
    static final double[] ap_amp = new double[]{-0.10444, 0.16618, -0.063974, 1.0922, 0.57472, -0.30277, -3.5087, 0.0071264, -0.1403, 0.03705, 0.40208, -0.30431, -0.13292, 0.0046746, -1.5902E-4, 2.8624, -0.39315, -0.064371, 0.016444, -0.0023403, 4.2127E-5, 1.9945, -0.60907, -0.035386, -0.001091, -1.2799E-4, 4.097E-5, 2.2131E-5, -0.53292, -0.29765, -0.032877, 0.0017691, 5.9692E-5, 3.1725E-5, 2.0741E-5, -3.7622E-7, 2.6372, -0.31165, 0.016439, 2.1633E-4, 1.7485E-4, 2.1587E-5, 6.1064E-6, -1.3755E-8, -7.8748E-8, -0.59152, -0.17676, 0.0081807, 0.0010445, 2.3432E-4, 9.3421E-6, 2.8104E-6, -1.5788E-7, -3.0648E-8, 2.6421E-10};
    static final double[] bp_amp = new double[]{0.0, 0.0, 0.9334, 0.0, 0.82346, 0.22082, 0.0, 0.96177, -0.01565, 0.0012708, 0.0, -0.39913, 0.02802, 0.028334, 8.598E-4, 0.0, 0.30545, -0.021691, 6.4067E-4, -3.6528E-5, -1.1166E-4, 0.0, -0.076974, -0.018986, 0.0056896, -2.4159E-4, -2.3033E-4, -9.6783E-6, 0.0, -0.10218, -0.013916, -0.0041025, -5.134E-5, -7.0114E-5, -3.3152E-7, 1.6901E-6, 0.0, -0.012422, 0.0025072, 0.0011205, -1.3034E-4, -2.3971E-5, -2.6622E-6, 5.7852E-7, 4.5847E-8, 0.0, 0.044777, -0.0030421, 2.6062E-5, -7.2421E-5, 1.9119E-6, 3.9236E-7, 2.239E-7, 2.9765E-9, -4.6452E-9};
    static final double[] at_mean = new double[]{16.257, 2.1224, 0.92569, -25.974, 1.451, 0.092468, -0.53192, 0.21094, -0.06921, -0.03406, -4.6569, 0.26385, -0.036093, 0.010198, -0.0018783, 0.74983, 0.11741, 0.03994, 0.0051348, 0.0059111, 8.6133E-6, 0.63057, 0.15203, 0.039702, 0.0046334, 2.4406E-4, 1.5189E-4, 1.9581E-7, 0.54414, 0.35722, 0.052763, 0.0041147, -2.7239E-4, -5.9957E-5, 1.6394E-6, -7.3045E-7, -2.9394, 0.055579, 0.018852, 0.0034272, -2.3193E-5, -2.9349E-5, 3.6397E-7, 2.049E-6, -6.4719E-8, -0.52225, 0.20799, 0.0013477, 3.1613E-4, -2.2285E-4, -1.8137E-5, -1.5177E-7, 6.1343E-7, 7.8566E-8, 1.0749E-9};
    static final double[] bt_mean = new double[]{0.0, 0.0, 1.021, 0.0, 0.60194, 0.12292, 0.0, -0.42184, 0.1823, 0.042329, 0.0, 0.093312, 0.095346, -0.0019724, 0.0058776, 0.0, -0.2094, 0.034199, -0.0057672, -0.002159, 5.6815E-4, 0.0, 0.22858, 0.012283, -0.0093679, -0.0014233, -1.5962E-4, 4.016E-5, 0.0, 0.036353, -9.4263E-4, -0.0036762, 5.8608E-5, -2.6391E-5, 3.2095E-6, -1.1605E-6, 0.0, 0.16306, 0.013293, -0.0011395, 5.1097E-5, 3.3977E-5, 7.6449E-6, -1.7602E-7, -7.6558E-8, 0.0, -0.045415, -0.018027, 3.6561E-4, -1.1274E-4, 1.3047E-5, 2.0001E-6, -1.5152E-7, -2.7807E-8, 7.7491E-9};
    static final double[] at_amp = new double[]{-1.8654, -9.0041, -0.12974, -3.6053, 0.020284, 0.21872, -1.3015, 0.40355, 0.22216, -0.0040605, 1.9623, 0.42887, 0.21437, -0.010061, -0.0011368, -0.069235, 0.56758, 0.11917, -0.0070765, 3.0017E-4, 3.0601E-4, 1.6559, 0.20722, 0.060013, 1.7023E-4, -9.2424E-4, 1.1269E-5, -6.9911E-6, -2.0886, -0.067879, -8.5922E-4, -0.0016087, -4.5549E-5, 3.3178E-5, -6.1715E-6, -1.4446E-6, -0.3721, 0.15775, -0.0017827, -4.4396E-4, 2.2844E-4, -1.1215E-5, -2.112E-6, -9.6421E-7, -1.417E-8, 0.7872, -0.044238, -0.001512, -9.4119E-4, 4.0645E-6, -4.9253E-6, -1.8656E-6, -4.0736E-7, -4.9594E-8, 1.6134E-9};
    static final double[] bt_amp = new double[]{0.0, 0.0, -0.89895, 0.0, -1.079, -0.12699, 0.0, -0.59033, 0.034865, -0.032614, 0.0, -0.02431, 0.015607, -0.029833, -0.0059048, 0.0, 0.28383, 0.040509, -0.018834, -0.0012654, -1.3794E-4, 0.0, 0.13306, 0.03496, -0.0036799, -3.5626E-4, 1.4814E-4, 3.7932E-6, 0.0, 0.20801, 0.006564, -0.0034893, -2.7395E-4, 7.4296E-5, -7.9927E-6, -1.0277E-6, 0.0, 0.036515, -0.0074319, -6.2873E-4, -8.2461E-5, 3.1095E-5, -5.386E-7, -1.2055E-7, -1.1517E-7, 0.0, 0.031404, 0.01558, -0.0011428, 3.3529E-5, 1.0387E-5, -1.9378E-6, -2.7327E-7, 7.5833E-9, -9.2323E-9};
    static final double[] dfac = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17};
    static final int n = 9;
    static final int m = 9;
    static final int mn = 55;
    static final double C0 = 0.9999774;
    static final double C1 = 5.225;
    static final double C2 = -0.0065;
    static final double Mjd0 = 44266.0;
    static final double DaysInYear = 365.25;

    public void get(double dmjd, double dlat, double dlon, double dhgt) {
        int i;
        double[][] P = new double[10][10];
        double[] aP = new double[55];
        double[] bP = new double[55];
        double t = StrictMath.sin(dlat);
        double doy = dmjd - 44266.0;
        double cdoy = StrictMath.cos(doy / 365.25 * 2.0 * Math.PI);
        double tmp0 = 1.0 - t * t;
        for (i = 0; i <= 9; ++i) {
            double tmp1 = 1.0 / StrictMath.pow(2.0, i);
            for (int j = 0; j <= (i < 9 ? i : 9); ++j) {
                int ir = (i - j) / 2;
                double sum = 0.0;
                double sign = 1.0;
                for (int k = 0; k <= ir; ++k) {
                    sum += (2 * (k / 2) == k ? 1.0 : -1.0) * dfac[2 * i - 2 * k] / dfac[k] / dfac[i - k] / dfac[i - j - 2 * k] * StrictMath.pow(t, i - j - 2 * k);
                }
                P[i][j] = tmp1 * StrictMath.pow(tmp0, (double)j / 2.0) * sum;
            }
        }
        i = 0;
        for (int jn = 0; jn <= 9; ++jn) {
            for (int jm = 0; jm <= jn; ++jm) {
                aP[i] = P[jn][jm] * StrictMath.cos((double)jm * dlon);
                bP[i] = P[jn][jm] * StrictMath.sin((double)jm * dlon);
                ++i;
            }
        }
        double undu = 0.0;
        for (i = 0; i < 55; ++i) {
            undu += a_geoid[i] * aP[i] + b_geoid[i] * bP[i];
        }
        double hort = dhgt - undu;
        double apm = 0.0;
        double apa = 0.0;
        for (i = 0; i < 55; ++i) {
            apm += ap_mean[i] * aP[i] + bp_mean[i] * bP[i];
            apa += ap_amp[i] * aP[i] + bp_amp[i] * bP[i];
        }
        double pres0 = apm + apa * cdoy;
        double pres = pres0 * StrictMath.pow(0.9999774 * hort, 5.225);
        double atm = 0.0;
        double ata = 0.0;
        for (i = 0; i < 55; ++i) {
            atm = atm + at_mean[i] * aP[i] + bt_mean[i] * bP[i];
            ata = ata + at_amp[i] * aP[i] + bt_amp[i] * bP[i];
        }
        double temp0 = atm + ata * cdoy;
        double temp = temp0 + -0.0065 * hort;
    }
}

