/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import java.util.Date;
import java.util.TimeZone;

public class GpsTimeZone
extends TimeZone {
    private static final int MillisInSecond_ = 1000;
    private static final int Mjd0_ = 679006;
    private static final int Mjd1970_ = 40587;
    private static final long MillisInDay_ = 86400000L;
    private static final double DaysInYear_ = 365.25;
    private static final double DaysInMonth_ = 30.6001;
    private int RawOffset_ = 0;
    private int LeapSeconds_ = 0;

    public GpsTimeZone() {
        this.setRawOffset(new Date());
        this.setID("GPST");
    }

    public GpsTimeZone(Date date) {
        this.setRawOffset(date);
        this.setID("GPST");
    }

    public GpsTimeZone(long date) {
        this.setRawOffset(date);
        this.setID("GPST");
    }

    public GpsTimeZone(int year, int month, int day) {
        this.setRawOffset(year, month, day);
        this.setID("GPST");
    }

    public Object clone() {
        GpsTimeZone tmp = new GpsTimeZone();
        tmp.setRawOffset(this.RawOffset_);
        return tmp;
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        return this.RawOffset_;
    }

    public int getOffset(Date date) {
        return this.RawOffset_;
    }

    public int getOffset(long date) {
        return this.RawOffset_;
    }

    public int getRawOffset() {
        return this.RawOffset_;
    }

    public static TimeZone getTimeZone(String id) {
        if (id.equalsIgnoreCase("GPST")) {
            return new GpsTimeZone();
        }
        return TimeZone.getTimeZone(id);
    }

    public boolean inDaylightTime(Date date) {
        return false;
    }

    public void setRawOffset(int offsetMillis) {
        this.RawOffset_ = offsetMillis;
    }

    public void setRawOffset(Date date) {
        this.LeapSeconds_ = this.getLeapSeconds(date);
        this.RawOffset_ = 0;
    }

    public void setRawOffset(long date) {
        this.LeapSeconds_ = this.getLeapSeconds(this.toMjd(date));
        this.RawOffset_ = 0;
    }

    public void setRawOffset(int year, int month, int day) {
        this.LeapSeconds_ = this.getLeapSeconds(this.toMjd(year, month, day));
        this.RawOffset_ = 0;
    }

    public boolean useDaylightTime() {
        return false;
    }

    public int toMjd(Date date) {
        return this.toMjd(date.getTime());
    }

    public int toMjd(long date) {
        return (int)(date / 86400000L) + 40587;
    }

    public int toMjd(int year, int month, int day) {
        if (year < 80) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        if (month < 2) {
            --year;
            month += 12;
        }
        int A = year / 100;
        int B = 2 - A + A / 4;
        int C = (int)(365.25 * (double)year);
        int D = (int)(30.6001 * (double)(month + 2 - 0));
        return B + C + D + day + 679006;
    }

    public int getLeapSeconds() {
        return this.LeapSeconds_;
    }

    public int getLeapSeconds(Date date) {
        return this.getLeapSeconds(this.toMjd(date));
    }

    public int getLeapSeconds(long date) {
        return this.getLeapSeconds(this.toMjd(date));
    }

    public int getLeapSeconds(int year, int month, int day) {
        return this.getLeapSeconds(this.toMjd(year, month, day));
    }

    public int getLeapSeconds(int mjd) {
        if (mjd < 44786) {
            return 0;
        }
        if (mjd < 45151) {
            return 1;
        }
        if (mjd < 45516) {
            return 2;
        }
        if (mjd < 46247) {
            return 3;
        }
        if (mjd < 47161) {
            return 4;
        }
        if (mjd < 47892) {
            return 5;
        }
        if (mjd < 48257) {
            return 6;
        }
        if (mjd < 48804) {
            return 7;
        }
        if (mjd < 49169) {
            return 8;
        }
        if (mjd < 49534) {
            return 9;
        }
        if (mjd < 50083) {
            return 10;
        }
        if (mjd < 50630) {
            return 11;
        }
        if (mjd < 51179) {
            return 12;
        }
        if (mjd < 53736) {
            return 13;
        }
        return 14;
    }

    public boolean isLeapSecondDay(Date date) {
        return this.isLeapSecondDay(this.toMjd(date));
    }

    public boolean isLeapSecondDay(long date) {
        return this.isLeapSecondDay(this.toMjd(date));
    }

    public boolean isLeapSecondDay(int mjd) {
        if (mjd + 1 == 44786) {
            return true;
        }
        if (mjd + 1 == 45151) {
            return true;
        }
        if (mjd + 1 == 45516) {
            return true;
        }
        if (mjd + 1 == 46247) {
            return true;
        }
        if (mjd + 1 == 47161) {
            return true;
        }
        if (mjd + 1 == 47892) {
            return true;
        }
        if (mjd + 1 == 48257) {
            return true;
        }
        if (mjd + 1 == 48804) {
            return true;
        }
        if (mjd + 1 == 49169) {
            return true;
        }
        if (mjd + 1 == 49534) {
            return true;
        }
        if (mjd + 1 == 50083) {
            return true;
        }
        if (mjd + 1 == 50630) {
            return true;
        }
        if (mjd + 1 == 51179) {
            return true;
        }
        return mjd + 1 == 53736;
    }
}

