/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.GpsTimeZone;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GpsTime
extends GregorianCalendar {
    public static final int MODIFIED_JULIAN_DAY = -1;
    public static final int GPS_WEEK = -2;
    public static final int SECOND_OF_DAY = -3;
    public static final int SECOND_OF_WEEK = -4;
    public static final int MJD = -1;
    public static final int SOD = -3;
    public static final int SOW = -4;
    private static final DecimalFormat A2DF_ = new DecimalFormat("#0");
    private static final DecimalFormat A3DF_ = new DecimalFormat("##0");
    private static final DecimalFormat A4DF_ = new DecimalFormat("###0");
    private static final DecimalFormat A5DF_ = new DecimalFormat("####0");
    private static final DecimalFormat A6DF_ = new DecimalFormat("#####0");
    private static final DecimalFormat AADF_ = new DecimalFormat("##.0######");
    private static final DecimalFormat F1DF_ = new DecimalFormat("0");
    private static final DecimalFormat F2DF_ = new DecimalFormat("00");
    private static final DecimalFormat F3DF_ = new DecimalFormat("000");
    private static final DecimalFormat F4DF_ = new DecimalFormat("0000");
    private static final DecimalFormat F5DF_ = new DecimalFormat("00000");
    private static final DecimalFormat F6DF_ = new DecimalFormat("000000");
    private static final Pattern DateTimeSep_ = Pattern.compile("(?<=\\d)T(?=\\d)");
    private static final Pattern TimeSep_ = Pattern.compile("(?<=\\d):(?=\\d)");
    private static final Pattern DateSep_ = Pattern.compile("(?<=\\d)[\\-/](?=\\d)");
    private static final Pattern AllSep_ = Pattern.compile("(?<=\\d)[T:\\-/](?=\\d)");
    private static final Pattern NonDigit_ = Pattern.compile("[^ 0-9\\.]");
    private static final int GpsWeek0_ = -6321;
    private static final int Mjd1970_ = 40587;
    private static final int DaysInWeek_ = 7;
    private static final int MillisInSecond_ = 1000;
    private static final int SecondsInDay_ = 86400;
    private static final int WeekOffset_ = 3;
    private static final long MillisInDay_ = 86400000L;
    private Matcher Matcher_;
    private int StoreDayOfWeek_ = 0;

    public GpsTime() {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.complete();
    }

    public GpsTime(Locale aLocale) {
        super(new GpsTimeZone(), aLocale);
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.complete();
    }

    public GpsTime(Calendar epoch) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.setTime(epoch.getTime());
        this.complete();
    }

    public GpsTime(Date epoch) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.setTime(epoch);
        this.complete();
    }

    public GpsTime(int year, int day_of_year) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.set(1, year);
        this.set(6, day_of_year);
        this.set(11, 0);
        this.set(12, 0);
        this.set(13, 0);
        this.set(14, 0);
        this.complete();
    }

    public GpsTime(int year, int month, int day) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
        this.set(11, 0);
        this.set(12, 0);
        this.set(13, 0);
        this.set(14, 0);
        this.complete();
    }

    public GpsTime(int year, int day_of_year, int hour, int minute, int second) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.set(1, year);
        this.set(6, day_of_year);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
        this.set(14, 0);
        this.complete();
    }

    public GpsTime(int year, int day_of_year, int hour, int minute, double second) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.set(1, year);
        this.set(6, day_of_year);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, (int)second);
        this.set(14, 1000 * (int)(second - (double)((int)second)));
        this.complete();
    }

    public GpsTime(int year, int month, int day, int hour, int minute, int second) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
        this.set(14, 0);
        this.complete();
    }

    public GpsTime(int year, int month, int day, int hour, int minute, double second) {
        super(new GpsTimeZone());
        this.setLenient(true);
        this.setFirstDayOfWeek(1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, (int)second);
        this.set(14, 1000 * (int)(second - (double)((int)second)));
        this.complete();
    }

    public int compareTo(Calendar anotherCalendar) {
        return super.compareTo(anotherCalendar);
    }

    public int compareTo(Date input) {
        return this.getTime().compareTo(input);
    }

    protected void complete() {
        TimeZone zone = this.getTimeZone();
        if (zone instanceof GpsTimeZone) {
            long low;
            GpsTimeZone gpszone = (GpsTimeZone)zone;
            long millis = this.getTimeInMillis();
            long high = millis - (low = millis % 86400000L);
            if (gpszone.isLeapSecondDay(high - 86400000L) && low < (long)(gpszone.getLeapSeconds(high) * 1000)) {
                gpszone.setRawOffset(high - 86400000L);
            } else {
                gpszone.setRawOffset(high);
            }
        }
        super.complete();
    }

    public double diff(Calendar date) {
        return (double)(this.getTimeInMillis() - date.getTimeInMillis()) / 8.64E7;
    }

    public double diff(Date date) {
        return (double)(this.getTimeInMillis() - date.getTime()) / 8.64E7;
    }

    public double diff(long date) {
        return (double)(this.getTimeInMillis() - date) / 8.64E7;
    }

    public void fromGpsString(String input) throws ParseException {
        this.Matcher_ = AllSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (this.Matcher_.find() || tokens.countTokens() != 2) {
            throw new ParseException("GpsTime: GPS week/sow = \"" + input + "\"", 0);
        }
        this.set(-2, A4DF_.parse(tokens.nextToken()).intValue());
        this.set(-4, A6DF_.parse(tokens.nextToken()).intValue());
        this.complete();
    }

    public void fromGpsSecondOfWeekString(String input) throws ParseException {
        this.Matcher_ = NonDigit_.matcher(input);
        if (this.Matcher_.find()) {
            throw new ParseException("GpsTime: GPS sow = \"" + input + "\"", 0);
        }
        this.set(-4, A6DF_.parse(input.trim()).intValue());
        this.complete();
    }

    public void fromGpsWeekString(String input) throws ParseException {
        this.Matcher_ = NonDigit_.matcher(input);
        if (this.Matcher_.find()) {
            throw new ParseException("GpsTime: GPS week = \"" + input + "\"", 0);
        }
        this.set(-4, A4DF_.parse(input.trim()).intValue());
        this.complete();
    }

    public void fromIsoHString(String input) throws ParseException {
        this.Matcher_ = NonDigit_.matcher(input);
        if (this.Matcher_.find()) {
            throw new ParseException("GpsTime: ISO HH = \"" + input + "\"", 0);
        }
        this.set(11, A2DF_.parse(input.trim()).intValue());
        this.complete();
    }

    public void fromIsoHmString(String input) throws ParseException {
        this.Matcher_ = TimeSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (this.Matcher_.find() || tokens.countTokens() != 2) {
            throw new ParseException("GpsTime: HH:MM = \"" + input + "\"", 0);
        }
        this.set(11, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(12, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(13, 0);
        this.set(14, 0);
        this.complete();
    }

    public void fromIsoHmsString(String input) throws ParseException {
        this.Matcher_ = TimeSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (this.Matcher_.find() || tokens.countTokens() != 3) {
            throw new ParseException("GpsTime: HH:MM:SS = \"" + input + "\"", 0);
        }
        this.set(11, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(12, A2DF_.parse(tokens.nextToken()).intValue());
        double second = AADF_.parse(tokens.nextToken()).doubleValue();
        this.set(13, (int)second);
        this.set(14, (int)(1000.0 * (second - (double)((int)second)) + 0.5));
        this.complete();
    }

    public void fromIsoString(String input) throws ParseException {
        this.Matcher_ = AllSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (this.Matcher_.find() || tokens.countTokens() != 6) {
            throw new ParseException("GpsTime: YYYY-MM-DDTHH:MM:SS = \"" + input + "\"", 0);
        }
        this.set(10, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(2, A2DF_.parse(tokens.nextToken()).intValue() - 1);
        this.set(5, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(11, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(12, A2DF_.parse(tokens.nextToken()).intValue());
        double second = AADF_.parse(tokens.nextToken()).doubleValue();
        this.set(13, (int)second);
        this.set(14, (int)(1000.0 * (second - (double)((int)second)) + 0.5));
        this.complete();
    }

    public void fromIsoYdString(String input) throws ParseException {
        int year;
        this.Matcher_ = DateSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (!this.Matcher_.find() && tokens.countTokens() == 2) {
            year = A2DF_.parse(tokens.nextToken()).intValue();
            if (year < 80) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            }
        } else {
            throw new ParseException("GpsTime: YYYY-DDD = \"" + input + "\"", 0);
        }
        this.set(1, year);
        this.set(6, A3DF_.parse(tokens.nextToken()).intValue());
        this.complete();
    }

    public void fromIsoYmdString(String input) throws ParseException {
        int year;
        this.Matcher_ = DateSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (!this.Matcher_.find() && tokens.countTokens() == 3) {
            year = A2DF_.parse(tokens.nextToken()).intValue();
            if (year < 80) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            }
        } else {
            throw new ParseException("GpsTime: YYYY-MM-DD = \"" + input + "\"", 0);
        }
        this.set(1, year);
        this.set(2, A2DF_.parse(tokens.nextToken()).intValue() - 1);
        this.set(5, A2DF_.parse(tokens.nextToken()).intValue());
        this.complete();
    }

    public void fromMjdString(String input) throws ParseException {
        this.Matcher_ = NonDigit_.matcher(input);
        if (this.Matcher_.find()) {
            throw new ParseException("GpsTime: MJD = \"" + input + "\"", 0);
        }
        this.set(-1, A5DF_.parse(input.trim()).intValue());
        this.complete();
    }

    public void fromRinexString(String input) throws ParseException {
        int year;
        this.Matcher_ = NonDigit_.matcher(input);
        StringTokenizer tokens = new StringTokenizer(input);
        if (!this.Matcher_.find() && tokens.countTokens() == 6) {
            year = A4DF_.parse(tokens.nextToken()).intValue();
            if (year < 80) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            }
        } else {
            throw new ParseException("GpsTime: RINEX = \"" + input + "\"", 0);
        }
        this.set(1, year);
        this.set(2, A2DF_.parse(tokens.nextToken()).intValue() - 1);
        this.set(5, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(11, A2DF_.parse(tokens.nextToken()).intValue());
        this.set(12, A2DF_.parse(tokens.nextToken()).intValue());
        double second = AADF_.parse(tokens.nextToken()).doubleValue() + 5.0E-4;
        this.set(13, (int)second);
        this.set(14, (int)(1000.0 * (second - (double)((int)second))));
        this.complete();
    }

    public void fromSinexDateString(String input) throws ParseException {
        int year;
        this.Matcher_ = TimeSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (!this.Matcher_.find() && tokens.countTokens() == 2) {
            year = A2DF_.parse(tokens.nextToken()).intValue();
            if (year < 80) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            }
        } else {
            throw new ParseException("GpsTime: YY:DDD = \"" + input + "\"", 0);
        }
        this.set(1, year);
        this.set(6, A3DF_.parse(tokens.nextToken()).intValue());
        this.complete();
    }

    public void fromSinexString(String input) throws ParseException {
        int year;
        this.Matcher_ = TimeSep_.matcher(input);
        String tmp = this.Matcher_.replaceAll(" ");
        this.Matcher_ = NonDigit_.matcher(tmp);
        StringTokenizer tokens = new StringTokenizer(tmp);
        if (!this.Matcher_.find() && tokens.countTokens() == 3) {
            year = A2DF_.parse(tokens.nextToken()).intValue();
            if (year < 80) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            }
        } else {
            throw new ParseException("GpsTime: YY:DDD:SSSSS = \"" + input + "\"", 0);
        }
        this.set(1, year);
        this.set(6, A3DF_.parse(tokens.nextToken()).intValue());
        this.set(-3, A5DF_.parse(tokens.nextToken()).intValue());
        this.complete();
    }

    public void fromSinexTimeString(String input) throws ParseException {
        this.Matcher_ = NonDigit_.matcher(input);
        if (this.Matcher_.find()) {
            throw new ParseException("GpsTime: SINEX sod = \"" + input + "\"", 0);
        }
        this.set(-3, A5DF_.parse(input.trim()).intValue());
        this.complete();
    }

    public int get(int field) {
        switch (field) {
            case -1: {
                this.complete();
                return (int)(super.getTimeInMillis() / 86400000L) + 40587;
            }
            case -2: {
                return (this.get(-1) + 3) / 7 + -6321;
            }
            case -3: {
                return super.get(13) + 60 * (super.get(12) + 60 * super.get(11));
            }
            case -4: {
                switch (super.get(7)) {
                    case 7: {
                        return this.get(-3) + 518400;
                    }
                    case 6: {
                        return this.get(-3) + 432000;
                    }
                    case 5: {
                        return this.get(-3) + 345600;
                    }
                    case 4: {
                        return this.get(-3) + 259200;
                    }
                    case 3: {
                        return this.get(-3) + 172800;
                    }
                    case 2: {
                        return this.get(-3) + 86400;
                    }
                }
                return this.get(-3);
            }
        }
        return super.get(field);
    }

    public TimeZone getTimeZone() {
        return super.getTimeZone();
    }

    public void set(int field, int value) {
        switch (field) {
            case -1: {
                this.set(1, 1970);
                this.set(2, 0);
                this.set(5, 1);
                this.add(6, value - 40587);
                break;
            }
            case -2: {
                this.set(1, 1980);
                this.set(2, 0);
                this.set(5, 6);
                this.add(6, value * 7 + this.StoreDayOfWeek_);
                this.StoreDayOfWeek_ = 0;
                break;
            }
            case -3: {
                this.set(11, 0);
                this.set(12, 0);
                this.set(13, value);
                this.set(14, 0);
                break;
            }
            case -4: {
                this.StoreDayOfWeek_ = value / 86400;
                this.add(6, this.StoreDayOfWeek_);
                this.set(11, 0);
                this.set(12, 0);
                this.set(13, value % 86400);
                this.set(14, 0);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public String toGpsString() {
        return F4DF_.format(this.get(-2)) + "-" + F6DF_.format(this.get(-4));
    }

    public String toGpsSecondOfWeekString() {
        return F6DF_.format(this.get(-4));
    }

    public String toGpsWeekString() {
        return F4DF_.format(this.get(-2));
    }

    public String toIsoString() {
        return this.toIsoYmdString() + "T" + this.toIsoHmsString();
    }

    public String toIsoYmdString() {
        return A4DF_.format(this.get(1)) + "-" + F2DF_.format(this.get(2) + 1) + "-" + F2DF_.format(this.get(5));
    }

    public String toIsoHString() {
        return F2DF_.format(this.get(11));
    }

    public String toIsoHmString() {
        return F2DF_.format(this.get(11)) + ":" + F2DF_.format(this.get(12));
    }

    public String toIsoHmsString() {
        return F2DF_.format(this.get(11)) + ":" + F2DF_.format(this.get(12)) + ":" + F2DF_.format(this.get(13));
    }

    public String toIsoHms1String() {
        return F2DF_.format(this.get(11)) + ":" + F2DF_.format(this.get(12)) + ":" + F2DF_.format(this.get(13)) + "." + F1DF_.format((this.get(14) + 50) / 100);
    }

    public String toIsoHms2String() {
        return F2DF_.format(this.get(11)) + ":" + F2DF_.format(this.get(12)) + ":" + F2DF_.format(this.get(13)) + "." + F2DF_.format((this.get(14) + 5) / 10);
    }

    public String toIsoHms3String() {
        return F2DF_.format(this.get(11)) + ":" + F2DF_.format(this.get(12)) + ":" + F2DF_.format(this.get(13)) + "." + F3DF_.format(this.get(14));
    }

    public String toIsoYdString() {
        return A4DF_.format(this.get(1)) + "-" + F3DF_.format(this.get(6));
    }

    public String toMjdString() {
        return A5DF_.format(this.get(-1));
    }

    public String toRinexString() {
        return " " + F2DF_.format(this.get(1) % 100) + " " + F2DF_.format(this.get(2) + 1) + " " + F2DF_.format(this.get(5)) + " " + F2DF_.format(this.get(11)) + " " + F2DF_.format(this.get(12)) + " " + F2DF_.format(this.get(13)) + "." + F3DF_.format(this.get(14)) + "0000";
    }

    public String toSinexString() {
        return this.toSinexDateString() + ":" + this.toSinexTimeString();
    }

    public String toSinexDateString() {
        return F2DF_.format(this.get(1) % 100) + ":" + F3DF_.format(this.get(6));
    }

    public String toSinexTimeString() {
        return F5DF_.format(this.get(-3));
    }

    public String toString() {
        return this.toIsoString();
    }
}

