/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Ellipsoid;
import GNSS.GPS;
import GNSS.GRS80;
import GNSS.IERS1989;
import GNSS.IERS1996;
import GNSS.IERS2003;
import GNSS.PZ90;
import GNSS.WGS72;
import GNSS.WGS84;

public class Gnss {
    public static final double EDIT = -9999.0;
    public static final double EPS = 5.0E-4;

    public static int gpsYear(Integer input) {
        return Gnss.gpsYear((int)input);
    }

    public static int gpsYear(String input) {
        return Gnss.gpsYear(Integer.parseInt(input));
    }

    public static int gpsYear(int input) {
        int year = input;
        if (year < 80) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        return year;
    }

    public static boolean isDeleted(Double input) {
        return Gnss.isDeleted((double)input);
    }

    public static boolean isDeleted(double input) {
        return Gnss.isDeleted(input, 5.0E-4);
    }

    public static boolean isDeleted(double input, double eps) {
        return StrictMath.abs(input - -9999.0) < eps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SYSTEM {
        GALILEO("E"),
        GLONASS("R"),
        GPS("G"),
        LEO("L"),
        MIXED("M"),
        SBAS("S");

        private final String Abbreviation_;

        private SYSTEM(String name) {
            this.Abbreviation_ = name;
        }

        public static SYSTEM fromString(String input) {
            if (input.length() == 1 && input.equals(" ")) {
                return GPS;
            }
            for (SYSTEM ab : SYSTEM.values()) {
                if (!ab.equalsIgnoreCase(input)) continue;
                return ab;
            }
            return null;
        }

        public boolean equalsIgnoreCase(String input) {
            return this.toString().equalsIgnoreCase(input) || this.Abbreviation_.equalsIgnoreCase(input);
        }

        public String getAbbreviation() {
            return this.Abbreviation_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OFFSET {
        HEN("<html>MON \u2193 ARP</html>"),
        XYZ("<html>POINT \u2193 ARP</html>");

        private final String Name_;

        private OFFSET(String name) {
            this.Name_ = name;
        }

        public static OFFSET fromString(String input) {
            for (OFFSET crd : OFFSET.values()) {
                if (!crd.toString().equalsIgnoreCase(input)) continue;
                return crd;
            }
            return null;
        }

        public String toString() {
            return this.Name_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ELLIPSOID {
        GPS("GPS"),
        GRS80("GRS-80"),
        IERS1989("IERS(1989)"),
        IERS1996("IERS(1996)"),
        IERS2003("IERS(2003)"),
        PZ90("PZ-90"),
        WGS72("WGS-72"),
        WGS84("WGS-84");

        private final String Name_;

        private ELLIPSOID(String name) {
            this.Name_ = name;
        }

        public Ellipsoid get() {
            if (this.equals((Object)GPS)) {
                return new GPS();
            }
            if (this.equals((Object)GRS80)) {
                return new GRS80();
            }
            if (this.equals((Object)IERS1989)) {
                return new IERS1989();
            }
            if (this.equals((Object)IERS1996)) {
                return new IERS1996();
            }
            if (this.equals((Object)IERS2003)) {
                return new IERS2003();
            }
            if (this.equals((Object)PZ90)) {
                return new PZ90();
            }
            if (this.equals((Object)WGS72)) {
                return new WGS72();
            }
            if (this.equals((Object)WGS84)) {
                return new WGS84();
            }
            return null;
        }

        public static ELLIPSOID fromString(String input) {
            for (ELLIPSOID crd : ELLIPSOID.values()) {
                if (!crd.toString().equalsIgnoreCase(input)) continue;
                return crd;
            }
            return null;
        }

        public String toString() {
            return this.Name_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COORDINATE {
        ITS97("IGS97", ELLIPSOID.IERS1996),
        IGS00("IGS00", ELLIPSOID.IERS1996),
        IGS05("IGS05", ELLIPSOID.IERS2003),
        IGb00("IGb00", ELLIPSOID.IERS1996),
        NAD83("NAD-83(CORS96)", ELLIPSOID.GRS80),
        ITRF88("ITRF88", ELLIPSOID.IERS1989),
        ITRF89("ITRF89", ELLIPSOID.IERS1989),
        ITRF90("ITRF90", ELLIPSOID.IERS1989),
        ITRF91("ITRF91", ELLIPSOID.IERS1989),
        ITRF92("ITRF92", ELLIPSOID.IERS1989),
        ITRF93("ITRF93", ELLIPSOID.IERS1989),
        ITRF94("ITRF94", ELLIPSOID.IERS1989),
        ITRF96("ITRF96", ELLIPSOID.IERS1989),
        ITRF97("ITRF97", ELLIPSOID.IERS1996),
        ITRF00("ITRF2000", ELLIPSOID.IERS1996),
        ITRF05("ITRF2005", ELLIPSOID.IERS2003),
        PZ90("PZ-90", ELLIPSOID.PZ90),
        WGS72("WGS-72", ELLIPSOID.WGS72),
        WGS84("WGS-84(original)", ELLIPSOID.WGS84),
        WGS84G730("WGS-84(G730)", ELLIPSOID.WGS84),
        WGS84G873("WGS-84(G873)", ELLIPSOID.WGS84),
        WGS84G1150("WGS-84(G1150)", ELLIPSOID.WGS84);

        private final ELLIPSOID Ellipsoid_;
        private final String Name_;

        private COORDINATE(String name, ELLIPSOID ellipsoid) {
            this.Name_ = name;
            this.Ellipsoid_ = ellipsoid;
        }

        public static COORDINATE fromString(String input) {
            for (COORDINATE crd : COORDINATE.values()) {
                if (!crd.toString().equalsIgnoreCase(input)) continue;
                return crd;
            }
            return null;
        }

        public ELLIPSOID getEllipsoid() {
            return this.Ellipsoid_;
        }

        public String toString() {
            return this.Name_;
        }
    }
}

