/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Ellipsoid;

public class GPS
extends Ellipsoid {
    public static final Double DynamicalFormFactor = StrictMath.sqrt(5.0) * 4.84166774985E-4;
    public static final Double Flattening = 0.00335281066474;
    public static final Double SemiMajorAxis = 6378135.0;
    public static final Double SemiMinorAxis = SemiMajorAxis * (1.0 - Flattening);
    public static final Double EccentricitySquared = 1.0 - StrictMath.pow(SemiMinorAxis / SemiMajorAxis, 2.0);
    public static final String Name = "WGS-84(ICD-200C)";

    public Double getDynamicalFormFactor() {
        return DynamicalFormFactor;
    }

    public Double getEccentricitySquared() {
        return EccentricitySquared;
    }

    public Double getFlattening() {
        return Flattening;
    }

    public String getName() {
        return Name;
    }

    public Double getSemiMajorAxis() {
        return SemiMajorAxis;
    }

    public Double getSemiMinorAxis() {
        return SemiMinorAxis;
    }
}

