/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.GpsTime;
import GNSS.RinexGnsId;
import GNSS.UtcTime;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EphFile {
    private File File_ = null;
    private Matcher Matcher_;
    private Pattern Sp3Ver_ = Pattern.compile("^#([ac])([PV])(\\d\\d\\d\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]{2}\\.\\d{8}) ([ \\d]{6}\\d) (.{5}) (.{5}) (.{3}) (.{4}) *$");
    private Pattern Sp3Start_ = Pattern.compile("^## ([ \\d]{3}\\d) ([ \\d]{6}\\.\\d{8}) ([ \\d]{5}\\.\\d{8}) ([ \\d]{4}\\d) ([ \\d]\\.\\d{13}) *$");
    private Pattern Sp3GnsFirst_ = Pattern.compile("^\\+ .{2}([ \\d]\\d) {3}([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d) *$");
    private Pattern Sp3Gns_ = Pattern.compile("^\\+  {7}([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d)([ GR][ \\d]\\d) *$");
    private Pattern Sp3Acc_ = Pattern.compile("^\\+\\+ {7}([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d)([ \\d]{2}\\d) *$");
    private Pattern Sp3Char_ = Pattern.compile("^%c (.{2}) (.{2}) (.{3}) (.{3}) (.{4}) (.{4}) (.{4}) (.{4}) (.{5}) (.{5}) (.{5}) (.{5}) *$");
    private Pattern Sp3Float_ = Pattern.compile("^%f ([ \\d]{2}\\.\\d{7}) ([ \\d]{2}\\.\\d{9}) ([ \\d]{2}\\.\\d{11}) ([ \\d]{2}\\.\\d{15}) *$");
    private Pattern Sp3Int_ = Pattern.compile("^%i ([ \\d]{3}\\d) ([ \\d]{3}\\d) ([ \\d]{3}\\d) ([ \\d]{3}\\d) ([ \\d]{5}\\d) ([ \\d]{5}\\d) ([ \\d]{5}\\d) ([ \\d]{5}\\d) ([ \\d]{8}\\d) *$");
    private Pattern Sp3Com_ = Pattern.compile("^/\\* (.{0,55}) *$");
    private Pattern Sp3Epoch_ = Pattern.compile("^\\*  ([ \\d]{3}\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]{2}\\.\\d{8}) *$");
    private Pattern Sp3Pos_ = Pattern.compile("^P([ GR][ \\d]\\d)([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6}) *$");
    private Pattern Sp3cPos_ = Pattern.compile("^P([ GR][ \\d]\\d)([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6}) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]{2}\\d) ([ E])([ P]) ([ M])([ P]) *$");
    private Pattern Sp3Vel_ = Pattern.compile("^V([ GR][ \\d]\\d)([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6}) *$");
    private Pattern Sp3cVel_ = Pattern.compile("^V([ GR][ \\d]\\d)([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6})([ \\d]{7}\\.\\d{6}) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]\\d) ([ \\d]{2}\\d) *$");
    private Pattern Sp3Eof_ = Pattern.compile("^EOF.*$");
    private RandomAccessFile FileStream_;
    private GpsTime GpsEpoch_ = new GpsTime();
    private UtcTime UtcEpoch_ = new UtcTime();
    private List<String> GnsList_ = new ArrayList<String>();
    private List<Integer> GnsAccList_ = new ArrayList<Integer>();
    private TreeMap<String, Object> HeaderInfo_ = new TreeMap();
    private String Format_ = "";
    private String Status_ = "";
    private int Ios_ = -1;
    private static final long Extension_ = 900000L;
    private long FileLength_ = 0L;
    private long StartOfInfo_ = 0L;

    public EphFile() {
    }

    public EphFile(String name) {
        this.open(name);
    }

    public EphFile(File file) {
        this.open(file);
    }

    public int open(String name) {
        try {
            return this.open(new File(name));
        }
        catch (NullPointerException npe) {
            this.Status_ = "No file name was entered.";
            this.Ios_ = 1;
            return 1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int open(File file) {
        this.initAll();
        this.Ios_ = 0;
        this.Status_ = "";
        this.File_ = file;
        if (this.File_ == null) {
            this.Status_ = "file = null.";
            this.Ios_ = 100;
            return this.Ios_;
        } else if (!this.File_.exists()) {
            this.Status_ = "\"" + this.File_.toString() + "\" does not exist.";
            this.Ios_ = 101;
            return this.Ios_;
        } else if (!this.File_.isFile()) {
            this.Status_ = "\"" + this.File_.toString() + "\" is not a file.";
            this.Ios_ = 102;
            return this.Ios_;
        } else if (!this.File_.canRead()) {
            this.Status_ = "can not read \"" + this.File_.toString() + "\".";
            this.Ios_ = 103;
            return this.Ios_;
        } else {
            try {
                this.FileStream_ = new RandomAccessFile(this.File_, "r");
                this.FileLength_ = this.File_.length();
                this.Ios_ = this.scanSp3File();
                if (this.Ios_ != 0) return this.Ios_;
            }
            catch (IOException ioe) {
                this.Status_ = ioe.getMessage() + " opening \"" + this.File_.toString() + "\"";
                this.Ios_ = 104;
            }
        }
        return this.Ios_;
    }

    public int close() {
        if (this.FileStream_ != null) {
            try {
                this.FileStream_.close();
                this.FileStream_ = null;
            }
            catch (IOException ioe) {
                this.Status_ = ioe.getMessage() + " closing \"" + this.File_.toString() + "\"";
                this.Ios_ = 201;
            }
        }
        return this.Ios_;
    }

    public boolean canRead() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canRead();
    }

    public boolean canWrite() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canWrite();
    }

    public boolean exists() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.exists();
    }

    public String format() {
        return this.Format_;
    }

    public Object get(String field) {
        if (this.HeaderInfo_.containsKey(field)) {
            return this.HeaderInfo_.get(field);
        }
        return null;
    }

    public String getAbsolutePath() {
        if (this.File_ != null) {
            return this.File_.getAbsolutePath();
        }
        return "";
    }

    public String getCanonicalPath() {
        if (this.File_ != null) {
            try {
                return this.File_.getCanonicalPath();
            }
            catch (IOException ex) {
                return this.File_.getAbsolutePath();
            }
        }
        return "";
    }

    public File getFile() {
        return this.File_;
    }

    public int getIos() {
        return this.Ios_;
    }

    public Iterator getGnsIterator() {
        return this.GnsList_.iterator();
    }

    public String getName() {
        if (this.File_ != null) {
            return this.File_.getName();
        }
        return "";
    }

    public long getSafeExtension() {
        return 900000L;
    }

    public String getStatus() {
        return this.Status_;
    }

    public boolean has(String field) {
        return this.HeaderInfo_.containsKey(field);
    }

    public boolean hasGns(String id) {
        return this.GnsList_.contains(id);
    }

    public void initAll() {
        this.Ios_ = -1;
        this.Format_ = "";
        this.GnsList_.clear();
        this.GnsAccList_.clear();
        this.HeaderInfo_.clear();
        this.close();
    }

    public boolean isFile() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.isFile();
    }

    public long length() {
        if (this.File_ != null) {
            return this.File_.length();
        }
        return 0L;
    }

    private Date parseDate(Matcher matcher) {
        matcher.find(0);
        if (((String)this.HeaderInfo_.get("TIME_SYSTEM")).equals("UTC")) {
            this.UtcEpoch_.set(Integer.valueOf(matcher.group(1).trim()), Integer.valueOf(matcher.group(2).trim()) - 1, Integer.valueOf(matcher.group(3).trim()), Integer.valueOf(matcher.group(4).trim()), Integer.valueOf(matcher.group(5).trim()));
            Double second = Double.valueOf(matcher.group(6).trim());
            this.UtcEpoch_.set(13, second.intValue());
            this.UtcEpoch_.set(14, (int)((second - (double)second.intValue() + 0.5) * 1000.0));
            return this.UtcEpoch_.getTime();
        }
        this.GpsEpoch_.set(Integer.valueOf(matcher.group(1).trim()), Integer.valueOf(matcher.group(2).trim()) - 1, Integer.valueOf(matcher.group(3).trim()), Integer.valueOf(matcher.group(4).trim()), Integer.valueOf(matcher.group(5).trim()));
        Double second = Double.valueOf(matcher.group(6).trim());
        this.GpsEpoch_.set(13, second.intValue());
        this.GpsEpoch_.set(14, (int)(second - (double)second.intValue() + 0.5) * 1000);
        return this.GpsEpoch_.getTime();
    }

    public Date readTimeOfFirstEpoch() {
        try {
            String text;
            if (this.FileStream_ == null) {
                return null;
            }
            this.FileStream_.seek(this.StartOfInfo_);
            while ((text = this.FileStream_.readLine()) != null) {
                this.Matcher_ = this.Sp3Epoch_.matcher(text);
                if (!this.Matcher_.find(0)) continue;
                return this.parseDate(this.Matcher_);
            }
            this.Status_ = "could not find the first epoch";
            this.Ios_ = 3002;
            return null;
        }
        catch (IOException ex) {
            this.Status_ = "reading time of the first epoch\n" + ex.getMessage();
            this.Ios_ = 3001;
            return null;
        }
    }

    public Date readTimeOfLastEpoch() {
        try {
            String text;
            if (this.FileStream_ == null) {
                return null;
            }
            long offset = this.FileLength_ - 32L;
            this.FileStream_.seek(offset);
            while (offset > 0L && (text = this.FileStream_.readLine()) != null && !(this.Matcher_ = this.Sp3Epoch_.matcher(text)).find(0)) {
                this.FileStream_.seek(--offset);
            }
            if (this.Matcher_ != null) {
                return this.parseDate(this.Matcher_);
            }
            this.Status_ = "could not find the last epoch";
            this.Ios_ = 4003;
            return null;
        }
        catch (IOException ex) {
            this.Status_ = "reading time of the last epoch\n" + ex.getMessage();
            this.Ios_ = 4001;
            return null;
        }
    }

    private int scanSp3File() {
        int ios = this.Ios_;
        if (ios == 0) {
            try {
                String id;
                int i;
                this.FileStream_.seek(0L);
                this.Format_ = "";
                this.GnsList_.clear();
                this.GnsAccList_.clear();
                this.HeaderInfo_.clear();
                String text = this.FileStream_.readLine();
                if (text == null) {
                    this.Status_ = "empty file";
                    ios = 2001;
                    return ios;
                }
                this.Matcher_ = this.Sp3Ver_.matcher(text);
                if (!this.Matcher_.find(0)) {
                    this.Status_ = "not a recognized ephemeris file";
                    ios = 2002;
                    return ios;
                }
                this.Format_ = "SP3" + this.Matcher_.group(1) + this.Matcher_.group(2);
                this.HeaderInfo_.put("YEAR_START", Integer.valueOf(this.Matcher_.group(3).trim()));
                this.HeaderInfo_.put("MONTH_START", Integer.valueOf(this.Matcher_.group(4).trim()));
                this.HeaderInfo_.put("DAY_OF_MONTH_START", Integer.valueOf(this.Matcher_.group(5).trim()));
                this.HeaderInfo_.put("HOUR_START", Integer.valueOf(this.Matcher_.group(6).trim()));
                this.HeaderInfo_.put("MINUTE_START", Integer.valueOf(this.Matcher_.group(7).trim()));
                this.HeaderInfo_.put("SECOND_START", Double.valueOf(this.Matcher_.group(8).trim()));
                this.HeaderInfo_.put("NUMBER_OF_EPOCHS", Integer.valueOf(this.Matcher_.group(9).trim()));
                this.HeaderInfo_.put("DATA_USED", this.Matcher_.group(10).trim());
                this.HeaderInfo_.put("COORDINATE_SYSTEM", this.Matcher_.group(11).trim());
                this.HeaderInfo_.put("ORBIT_TYPE", this.Matcher_.group(12).trim());
                this.HeaderInfo_.put("AGENCY_NAME", this.Matcher_.group(13).trim());
                int line_count = 1;
                ++line_count;
                text = this.FileStream_.readLine();
                if (text == null) {
                    this.Status_ = "unexpected EOF at line " + Integer.toString(line_count);
                    ios = 2003;
                    return ios;
                }
                this.Matcher_ = this.Sp3Start_.matcher(text);
                if (!this.Matcher_.find(0)) {
                    this.Status_ = "invalid " + this.Format_ + " header line " + Integer.toString(line_count) + " format";
                    ios = 2004;
                    return ios;
                }
                this.HeaderInfo_.put("GPS_WEEK_START", Integer.valueOf(this.Matcher_.group(1).trim()));
                this.HeaderInfo_.put("SECOND_OF_WEEK_START", Double.valueOf(this.Matcher_.group(2).trim()));
                this.HeaderInfo_.put("EPOCH_INTEVAL", Double.valueOf(this.Matcher_.group(3).trim()));
                this.HeaderInfo_.put("MJD_START", Integer.valueOf(this.Matcher_.group(4).trim()));
                this.HeaderInfo_.put("FRACT_DAY_START", Double.valueOf(this.Matcher_.group(5).trim()));
                int number_of_gns = 0;
                ++line_count;
                text = this.FileStream_.readLine();
                if (text == null) {
                    this.Status_ = "unexpected EOF at line " + Integer.toString(line_count);
                    ios = 2003;
                    return ios;
                }
                this.Matcher_ = this.Sp3GnsFirst_.matcher(text);
                if (this.Matcher_.find(0)) {
                    number_of_gns = Integer.parseInt(this.Matcher_.group(1).trim());
                    for (i = 0; i < 17; ++i) {
                        id = this.Matcher_.group(i + 2);
                        if (id.trim().equals("0")) continue;
                        this.GnsList_.add(RinexGnsId.getId(id));
                    }
                } else {
                    this.Status_ = "invalid " + this.Format_ + " header line " + Integer.toString(line_count) + " format";
                    ios = 2004;
                    return ios;
                }
                for (line_count = 4; line_count <= 7; ++line_count) {
                    text = this.FileStream_.readLine();
                    if (text == null) {
                        this.Status_ = "unexpected EOF at line " + Integer.toString(line_count);
                        ios = 2003;
                        return ios;
                    }
                    this.Matcher_ = this.Sp3Gns_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        for (i = 0; i < 17; ++i) {
                            id = this.Matcher_.group(i + 1);
                            if (id.trim().equals("0")) continue;
                            this.GnsList_.add(RinexGnsId.getId(id));
                        }
                        continue;
                    }
                    this.Status_ = "invalid " + this.Format_ + " header line " + Integer.toString(line_count) + " format";
                    ios = 2004;
                    return ios;
                }
                if (this.GnsList_.size() != number_of_gns) {
                    this.Status_ = "number of satellite IDs expectd/found = " + Integer.toString(number_of_gns) + "/" + Integer.toString(this.GnsList_.size());
                    ios = 2005;
                    return ios;
                }
                Iterator<String> itr = this.GnsList_.iterator();
                for (line_count = 8; line_count <= 12; ++line_count) {
                    text = this.FileStream_.readLine();
                    if (text == null) {
                        this.Status_ = "unexpected EOF at line " + Integer.toString(line_count);
                        ios = 2003;
                        return ios;
                    }
                    this.Matcher_ = this.Sp3Acc_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        for (int i2 = 0; i2 < 17; ++i2) {
                            if (!itr.hasNext()) continue;
                            this.GnsAccList_.add(Integer.valueOf(this.Matcher_.group(i2 + 1).trim()));
                            itr.next();
                        }
                        continue;
                    }
                    this.Status_ = "invalid " + this.Format_ + " header line " + Integer.toString(line_count) + " format";
                    ios = 2004;
                    return ios;
                }
                itr = null;
                this.HeaderInfo_.put("FILE_TYPE", "G");
                this.HeaderInfo_.put("TIME_SYSTEM", "GPS");
                for (line_count = 13; line_count <= 14; ++line_count) {
                    text = this.FileStream_.readLine();
                    if (text == null) {
                        this.Status_ = "unexpected EOF at line " + Integer.toString(line_count);
                        ios = 2003;
                        return ios;
                    }
                    this.Matcher_ = this.Sp3Char_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        if (line_count != 13) continue;
                        String id2 = this.Matcher_.group(1);
                        if (!id2.equalsIgnoreCase("cc")) {
                            this.HeaderInfo_.put("FILE_TYPE", id2.trim());
                        }
                        if ((id2 = this.Matcher_.group(3)).equalsIgnoreCase("ccc")) continue;
                        this.HeaderInfo_.put("TIME_SYSTEM", id2.trim());
                        continue;
                    }
                    this.Status_ = "invalid " + this.Format_ + " header line " + Integer.toString(line_count) + " format";
                    ios = 2004;
                    return ios;
                }
                for (line_count = 15; line_count <= 16; ++line_count) {
                    text = this.FileStream_.readLine();
                    if (text == null) {
                        this.Status_ = "unexpected EOF at line " + Integer.toString(line_count);
                        ios = 2003;
                        return ios;
                    }
                    this.Matcher_ = this.Sp3Float_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        if (line_count != 15 || this.Format_.length() <= 4 || !this.Format_.substring(0, 4).equals("SP3c")) continue;
                        this.HeaderInfo_.put("BASE_FOR_POS", Double.valueOf(this.Matcher_.group(1).trim()));
                        this.HeaderInfo_.put("BASE_FOR_CLK", Double.valueOf(this.Matcher_.group(2).trim()));
                        continue;
                    }
                    this.Status_ = "invalid " + this.Format_ + " header line " + Integer.toString(line_count) + " format";
                    ios = 2004;
                    return ios;
                }
                for (line_count = 17; line_count <= 18; ++line_count) {
                    text = this.FileStream_.readLine();
                    if (text == null) {
                        this.Status_ = "unexpected EOF at line " + Integer.toString(line_count);
                        ios = 2003;
                        return ios;
                    }
                    this.Matcher_ = this.Sp3Int_.matcher(text);
                    if (this.Matcher_.find(0)) continue;
                    this.Status_ = "invalid " + this.Format_ + " header line " + Integer.toString(line_count) + " format";
                    ios = 2004;
                    return ios;
                }
                this.StartOfInfo_ = this.FileStream_.getFilePointer();
                int count = 0;
                while ((text = this.FileStream_.readLine()) != null && (this.Matcher_ = this.Sp3Com_.matcher(text)).find(0)) {
                    this.StartOfInfo_ = this.FileStream_.getFilePointer();
                    this.HeaderInfo_.put("COMMENT_" + Integer.toString(++count), this.Matcher_.group(1).trim());
                }
                ios = 0;
            }
            catch (NumberFormatException nfe) {
                this.Status_ = "nfe in ephemeris = " + nfe.getMessage();
                ios = 2007;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                this.Status_ = "sioobe in ephemeris = " + sioobe.getMessage();
                ios = 2008;
            }
            catch (EOFException eof) {
                this.Status_ = "eof reached";
                ios = -1;
            }
            catch (RuntimeException re) {
                this.Status_ = "re in ephemeris = " + re.getMessage();
                ios = 2009;
            }
            catch (IOException e) {
                this.Status_ = "e in ephemeris = " + e.getMessage();
                ios = 2010;
            }
        }
        return ios;
    }

    public int size() {
        return this.GnsList_.size();
    }

    public long tell() {
        try {
            return this.FileStream_.getFilePointer();
        }
        catch (IOException ioe) {
            return this.FileLength_;
        }
    }

    public int tellPercentage() {
        try {
            return this.FileLength_ == 0L ? 0 : (int)(100L * this.FileStream_.getFilePointer() / this.FileLength_);
        }
        catch (IOException ioe) {
            return 100;
        }
    }

    public void traverse() {
        Iterator<String> iter = this.GnsList_.iterator();
        while (iter.hasNext()) {
            System.out.println((Object)iter.next());
        }
        System.out.println();
    }
}

