/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import GNSS.Coordinates;
import GNSS.GRS80;

public class Ellipsoid
extends Coordinates {
    public final boolean equals(Double semi_major, Double flattening) {
        return this.getSemiMajorAxis().compareTo(semi_major) == 0 && this.getFlattening().compareTo(flattening) == 0;
    }

    public final boolean equals(Ellipsoid el) {
        return this.getSemiMajorAxis().compareTo(el.getSemiMajorAxis()) == 0 && this.getFlattening().compareTo(el.getFlattening()) == 0;
    }

    public final boolean equals(Ellipsoid el1, Ellipsoid el2) {
        return el1.getSemiMajorAxis().compareTo(el2.getSemiMajorAxis()) == 0 && el1.getFlattening().compareTo(el2.getFlattening()) == 0;
    }

    public Double getDynamicalFormFactor() {
        return (double)GRS80.DynamicalFormFactor;
    }

    public Double getEccentricitySquared() {
        return (double)GRS80.EccentricitySquared;
    }

    public Double getFlattening() {
        return (double)GRS80.Flattening;
    }

    public String getName() {
        return "GRS-80";
    }

    public Double getSemiMajorAxis() {
        return (double)GRS80.SemiMajorAxis;
    }

    public Double getSemiMinorAxis() {
        return (double)GRS80.SemiMinorAxis;
    }

    public final Double[] toPlh(Double x, Double y, Double z) {
        return Ellipsoid.toPlh(x, y, z, this.getSemiMajorAxis(), this.getSemiMinorAxis());
    }

    public final Double[] toXyz(Double lat_deg, Double lon_deg, Double el_hgt) {
        return Ellipsoid.toXyz(lat_deg, lon_deg, el_hgt, this.getSemiMajorAxis(), this.getFlattening());
    }
}

