/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

abstract class Coordinates {
    Coordinates() {
    }

    protected static Double[] toPlh(Double x, Double y, Double z, Double semi_major, Double semi_minor) {
        double q;
        double f;
        Double[] plh = new Double[]{0.0, 0.0, 0.0};
        double A = semi_major;
        double B = semi_minor;
        if (z < 0.0) {
            B = -B;
        }
        double r = StrictMath.sqrt(x * x + y * y);
        double e = (B * z - (A * A - B * B)) / (A * r);
        double p = 1.3333333333333333 * (e * (f = (B * z + (A * A - B * B)) / (A * r)) + 1.0);
        double d = p * p * p + (q = 2.0 * (e * e - f * f)) * q;
        double v = d >= 0.0 ? StrictMath.pow(StrictMath.sqrt(d) - q, 0.3333333333333333) - StrictMath.pow(StrictMath.sqrt(d) + q, 0.3333333333333333) : 2.0 * StrictMath.sqrt(-p) * StrictMath.cos(StrictMath.acos(q / (p * StrictMath.sqrt(-p))) / 3.0);
        if (v * v < StrictMath.abs(p)) {
            v = -(v * v * v + 2.0 * q) / (3.0 * p);
        }
        double g = (StrictMath.sqrt(e * e + v) + e) / 2.0;
        double t = StrictMath.sqrt(g * g + (f - v * g) / (2.0 * g - e)) - g;
        plh[0] = StrictMath.atan(A * (1.0 - t * t) / (2.0 * B * t));
        plh[2] = (r - A * t) * StrictMath.cos(plh[0]) + (z - B) * StrictMath.sin(plh[0]);
        double zlong = StrictMath.atan2(y, x);
        if (zlong < 0.0) {
            zlong += Math.PI * 2;
        }
        plh[1] = zlong;
        plh[0] = StrictMath.toDegrees(plh[0]);
        plh[1] = StrictMath.toDegrees(plh[1]);
        return plh;
    }

    protected static Double[] toXyz(Double lat_deg, Double lon_deg, Double el_hgt, Double semi_major, Double flattening) {
        Double[] xyz = new Double[]{0.0, 0.0, 0.0};
        double flatfn = (2.0 - flattening) * flattening;
        double funsq = (1.0 - flattening) * (1.0 - flattening);
        double lat = StrictMath.toRadians(lat_deg);
        double lon = StrictMath.toRadians(lon_deg);
        double hgt = el_hgt;
        double sin_lat = StrictMath.sin(lat);
        double g1 = semi_major / StrictMath.sqrt(1.0 - flatfn * sin_lat * sin_lat);
        double g2 = g1 * funsq + hgt;
        xyz[0] = (g1 += hgt) * StrictMath.cos(lat);
        xyz[1] = xyz[0] * StrictMath.sin(lon);
        xyz[0] = xyz[0] * StrictMath.cos(lon);
        xyz[2] = g2 * sin_lat;
        return xyz;
    }
}

