/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

public class AntennaId
implements Comparable {
    public static final int MANUFACTURER_LENGTH = 3;
    public static final int MODEL_LENGTH = 12;
    public static final int ANTENNA_LENGTH = 15;
    public static final int RADOME_LENGTH = 4;
    public static final int SPACER_LENGTH = 1;
    public static final int ANTENNA_ID_LENGTH = 20;
    protected static final String Blanks_ = new String("               ");
    protected static final String NoRadome_ = new String("NONE");
    protected static final String Spacer_ = new String(" ");
    protected final String AntennaId_;

    public AntennaId(String str) {
        String tmp = str.trim();
        int len = tmp.length();
        this.AntennaId_ = AntennaId.rectifyModelName(tmp.substring(0, len > 15 ? 15 : len)) + Spacer_ + AntennaId.rectifyRadomeName(tmp.substring(len > 16 ? 16 : len));
    }

    public AntennaId(String antenna, String radome) {
        this.AntennaId_ = AntennaId.rectifyModelName(antenna) + Spacer_ + AntennaId.rectifyRadomeName(radome);
    }

    public int compareTo(AntennaId input) {
        return this.getIgsAntennaId().compareTo(input.getIgsAntennaId());
    }

    public int compareTo(Object input) throws ClassCastException {
        if (input instanceof AntennaId) {
            return this.compareTo((AntennaId)input);
        }
        if (input instanceof String) {
            return this.compareTo((String)input);
        }
        throw new ClassCastException("not an Antenna or String");
    }

    public int compareTo(String input) {
        return this.compareTo(new AntennaId(input));
    }

    public int compareToIgnoreCase(AntennaId input) {
        return this.compareTo(input);
    }

    public int compareToIgnoreCase(Object input) throws ClassCastException {
        return this.compareTo(input);
    }

    public int compareToIgnoreCase(String input) {
        return this.compareTo(input);
    }

    public boolean equals(AntennaId input) {
        return this.compareTo(input) == 0;
    }

    public boolean equals(Object input) throws ClassCastException {
        return this.compareTo(input) == 0;
    }

    public boolean equals(String input) {
        return this.compareTo(input) == 0;
    }

    public boolean equalsIgnoreCase(AntennaId input) {
        return this.equals(input);
    }

    public boolean equalsIgnoreCase(Object input) throws ClassCastException {
        return this.equals(input);
    }

    public boolean equalsIgnoreCase(String input) {
        return this.equals(input);
    }

    public String getAntennaId() {
        return this.AntennaId_;
    }

    public String getIgsAntennaId() {
        return this.getModelName() + Spacer_ + this.getIgsRadomeName();
    }

    public static String getIgsAntennaId(String str) {
        return new AntennaId(str).getIgsAntennaId();
    }

    public String getIgsModelName() {
        return this.getModelName();
    }

    public static String getIgsModelName(String str) {
        return AntennaId.rectifyModelName(str);
    }

    public String getIgsRadomeName() {
        String tmp = this.getRadomeName();
        return tmp.equals(Blanks_.substring(0, 4)) ? NoRadome_ : tmp;
    }

    public static String getIgsRadomeName(String str) {
        String tmp = AntennaId.rectifyRadomeName(str);
        return tmp.equals(Blanks_.substring(0, 4)) ? NoRadome_ : tmp;
    }

    public String getModelName() {
        return this.AntennaId_.substring(0, 15);
    }

    public String getRadomeName() {
        return this.AntennaId_.substring(16);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    protected static String rectifyModelName(String str) {
        String tmp = str.trim().toUpperCase();
        int len = tmp.length() > 15 ? 15 : tmp.length();
        return tmp.substring(0, len) + Blanks_.substring(0, 15 - len);
    }

    protected static String rectifyRadomeName(String str) {
        String tmp = str.trim().toUpperCase();
        int len = tmp.length() > 4 ? 4 : tmp.length();
        return tmp.substring(0, len) + Blanks_.substring(0, 4 - len);
    }

    public boolean startsWith(String str) {
        return this.AntennaId_.startsWith(str) || this.getIgsAntennaId().startsWith(str);
    }

    public String toString() {
        return this.AntennaId_;
    }
}

