/*
 * Decompiled with CFR 0.152.
 */
package GNSS;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntFile {
    private static final String Blanks_ = new String("                ");
    private static final String None_ = new String("    ");
    static final int MaxNameLength_ = 16;
    static final int MaxRadomeLength_ = 4;
    static final int MaxIdLength_ = 20;
    private File File_ = null;
    private Matcher Matcher_;
    private Pattern AtxComPattern_ = Pattern.compile("^.{60}COMMENT *$");
    private Pattern AtxEndOfAntPattern_ = Pattern.compile("^.{60}END OF ANTENNA *$");
    private Pattern AtxEohPattern_ = Pattern.compile("^.{60}END OF HEADER *$");
    private Pattern AtxPcvRefPattern_ = Pattern.compile("^(.).{19}(.{20})(.{20})PCV TYPE / REFANT *$");
    private Pattern AtxStaOfAntPattern_ = Pattern.compile("^.{60}START OF ANTENNA *$");
    private Pattern AtxTypSerNoPattern_ = Pattern.compile("^(.{20})(.{20})(.{10})(.{10})TYPE / SERIAL NO *$");
    private Pattern AtxVerPattern_ = Pattern.compile("^(.{8}).{12}(.).{39}ANTEX VERSION / SYST *$");
    private Pattern Ngs003IdPattern_ = Pattern.compile("^<ant_info\\.003>");
    private Pattern Ngs003ModPattern_ = Pattern.compile("<(.+)>");
    private Pattern Ngs003NamePattern_ = Pattern.compile("(.{20})(.*)");
    private RandomAccessFile FileStream_;
    private SortedMap<String, Long> NameList_ = new TreeMap<String, Long>();
    private String Format_ = "";
    private String ModInfo_ = "";
    private String PcvType_ = "";
    private String RefAnt_ = "";
    private String RefAntSerNo_ = "";
    private String Status_ = "";
    private String System_ = "";
    private int Ios_ = -1;
    private long FileLength_ = 0L;
    private long StartOfInfo_ = 0L;

    public AntFile() {
    }

    public AntFile(String name) {
        this.open(name);
    }

    public AntFile(File file) {
        this.open(file);
    }

    public int open(String name) {
        try {
            return this.open(new File(name));
        }
        catch (NullPointerException npe) {
            this.Status_ = "No file name was entered.";
            this.Ios_ = 1;
            return 1;
        }
    }

    public int open(File file) {
        this.initAll();
        this.Ios_ = 0;
        this.Status_ = "";
        this.File_ = file;
        if (this.File_ == null) {
            this.Status_ = "file = null.";
            this.Ios_ = 100;
        } else if (!this.File_.exists()) {
            this.Status_ = "\"" + this.File_.toString() + "\" does not exist.";
            this.Ios_ = 101;
        } else if (!this.File_.isFile()) {
            this.Status_ = "\"" + this.File_.toString() + "\" is not a file.";
            this.Ios_ = 102;
        } else if (!this.File_.canRead()) {
            this.Status_ = "can not read \"" + this.File_.toString() + "\".";
            this.Ios_ = 103;
        } else {
            try {
                this.FileStream_ = new RandomAccessFile(this.File_, "r");
                if (this.scanAntexFile() != 0 && this.scanNgs003File() != 0) {
                    this.Ios_ = 104;
                }
            }
            catch (IOException ioe) {
                this.Status_ = ioe.getMessage() + " opening \"" + this.File_.toString() + "\"";
                this.Ios_ = 105;
            }
        }
        return this.Ios_;
    }

    public int close() {
        if (this.FileStream_ != null) {
            try {
                this.FileStream_.close();
                this.FileStream_ = null;
            }
            catch (IOException ioe) {
                this.Status_ = ioe.getMessage() + " closing \"" + this.File_.toString() + "\"";
                this.Ios_ = 201;
            }
        }
        return this.Ios_;
    }

    public boolean canRead() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canRead();
    }

    public boolean canWrite() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.canWrite();
    }

    public boolean exists() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.exists();
    }

    public String format() {
        return this.Format_;
    }

    public Object get(String id, String field) {
        return null;
    }

    public String getAbsolutePath() {
        if (this.File_ != null) {
            return this.File_.getAbsolutePath();
        }
        return "";
    }

    public String getCanonicalPath() {
        if (this.File_ != null) {
            try {
                return this.File_.getCanonicalPath();
            }
            catch (IOException ioe) {
                return this.File_.getAbsolutePath();
            }
        }
        return "";
    }

    public File getFile() {
        return this.File_;
    }

    public int getIos() {
        return this.Ios_;
    }

    public Iterator getKeyIterator() {
        return this.NameList_.keySet().iterator();
    }

    public Set<String> getKeys() {
        return this.NameList_.keySet();
    }

    public String getName() {
        if (this.File_ != null) {
            return this.File_.getName();
        }
        return "";
    }

    public void initAll() {
        this.Ios_ = -1;
        this.Format_ = "";
        this.ModInfo_ = "";
        this.PcvType_ = "";
        this.RefAnt_ = "";
        this.RefAntSerNo_ = "";
        this.System_ = "";
        this.NameList_.clear();
        this.close();
    }

    public boolean isFile() {
        if (this.File_ == null) {
            return false;
        }
        return this.File_.isFile();
    }

    public long length() {
        if (this.File_ != null) {
            return this.File_.length();
        }
        return 0L;
    }

    private int scanAntexFile() {
        int ios = this.Ios_;
        if (ios == 0) {
            try {
                this.FileStream_.seek(0L);
                this.Format_ = "";
                this.ModInfo_ = "";
                this.PcvType_ = "";
                this.RefAnt_ = "";
                this.RefAntSerNo_ = "";
                this.System_ = "";
                this.NameList_.clear();
                String text = this.FileStream_.readLine();
                if (text == null) {
                    this.Status_ = "empty file";
                    ios = 2001;
                    return ios;
                }
                this.Matcher_ = this.AtxVerPattern_.matcher(text);
                if (this.Matcher_.find(0)) {
                    this.Format_ = this.Matcher_.group(1);
                    this.System_ = this.Matcher_.group(2);
                    if (this.System_.equals(" ")) {
                        this.System_ = "G";
                    }
                } else {
                    this.Status_ = "not an ANTEX format file";
                    ios = 2002;
                    return ios;
                }
                while ((text = this.FileStream_.readLine()) != null && !(this.Matcher_ = this.AtxEohPattern_.matcher(text)).find(0)) {
                    this.Matcher_ = this.AtxPcvRefPattern_.matcher(text);
                    if (!this.Matcher_.find(0)) continue;
                    this.RefAnt_ = this.Matcher_.group(1);
                    this.RefAntSerNo_ = this.Matcher_.group(2);
                }
                if (text == null) {
                    this.Status_ = "ANTEX END OF HEADER not found";
                    ios = 2003;
                    return ios;
                }
                this.StartOfInfo_ = this.FileStream_.getFilePointer();
                long index = 0L;
                while ((text = this.FileStream_.readLine()) != null) {
                    this.Matcher_ = this.AtxStaOfAntPattern_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        index = this.FileStream_.getFilePointer();
                        continue;
                    }
                    this.Matcher_ = this.AtxEndOfAntPattern_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        index = 0L;
                        continue;
                    }
                    if (index <= 0L || !(this.Matcher_ = this.AtxTypSerNoPattern_.matcher(text)).find(0)) continue;
                    this.NameList_.put(this.Matcher_.group(1), index);
                }
                ios = 0;
            }
            catch (NumberFormatException nfe) {
                this.Status_ = "nfe in ANTEX header = " + nfe.getMessage();
                ios = 2004;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                this.Status_ = "sioobe in ANTEX header = " + sioobe.getMessage();
                ios = 2005;
            }
            catch (EOFException eof) {
                this.Status_ = "eof reached";
                ios = -1;
            }
            catch (RuntimeException re) {
                this.Status_ = "re in ANTEX header = " + re.getMessage();
                ios = 2006;
            }
            catch (IOException ioe) {
                this.Status_ = "ioe in ANTEX header = " + ioe.getMessage();
                ios = 2007;
            }
        }
        return ios;
    }

    private int scanNgs003File() {
        int ios = this.Ios_;
        if (ios == 0) {
            try {
                this.FileStream_.seek(0L);
                this.Format_ = "";
                this.ModInfo_ = "";
                this.PcvType_ = "";
                this.RefAnt_ = "";
                this.RefAntSerNo_ = "";
                this.System_ = "";
                this.NameList_.clear();
                String text = this.FileStream_.readLine();
                if (text == null) {
                    this.Status_ = "empty file";
                    ios = 1001;
                    return ios;
                }
                Matcher matcher = this.Ngs003IdPattern_.matcher(text);
                if (!matcher.find(0) || !(this.Matcher_ = this.Ngs003ModPattern_.matcher(text)).find(matcher.end())) {
                    this.Status_ = "not an NGS 003 format file";
                    ios = 1002;
                    return ios;
                }
                this.ModInfo_ = this.Matcher_.group(1);
                this.Format_ = "NGS 003";
                this.PcvType_ = "R";
                this.RefAnt_ = "AOAD/M_T        NONE";
                this.RefAntSerNo_ = "";
                this.System_ = "G";
                this.NameList_.clear();
                this.StartOfInfo_ = -1L;
                long index = this.FileStream_.getFilePointer();
                while ((text = this.FileStream_.readLine()) != null) {
                    if (text.length() != 0) {
                        if (Character.isLetter(text.charAt(0)) && text.length() <= 20) {
                            int length = text.length() > 16 ? 16 : text.length();
                            this.NameList_.put(text.substring(0, length).toUpperCase() + Blanks_.substring(0, Blanks_.length() - length) + None_, index);
                            if (this.StartOfInfo_ < 0L) {
                                this.StartOfInfo_ = index;
                            }
                        } else if (Character.isLetter(text.charAt(0)) && Character.isWhitespace(text.charAt(20))) {
                            this.NameList_.put(text.substring(0, 20).toUpperCase(), index);
                            if (this.StartOfInfo_ < 0L) {
                                this.StartOfInfo_ = index;
                            }
                        }
                    }
                    index = this.FileStream_.getFilePointer();
                }
                ios = 0;
            }
            catch (NumberFormatException nfe) {
                this.Status_ = "nfe in NGS 003 header = " + nfe.getMessage();
                ios = 1004;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                this.Status_ = "sioobe in NGS 003 header = " + sioobe.getMessage();
                ios = 1005;
            }
            catch (EOFException eof) {
                this.Status_ = "eof reached";
                ios = -1;
            }
            catch (RuntimeException re) {
                this.Status_ = "re in NGS 003 header = " + re.getMessage();
                ios = 1006;
            }
            catch (IOException ioe) {
                this.Status_ = "ioe in NGS 003 header = " + ioe.getMessage();
                ios = 1007;
            }
        }
        return ios;
    }

    public int size() {
        return this.NameList_.size();
    }

    public long tell() {
        try {
            return this.FileStream_.getFilePointer();
        }
        catch (IOException ioe) {
            return this.FileLength_;
        }
    }

    public int tellPercentage() {
        try {
            return this.FileLength_ == 0L ? 0 : (int)(100L * this.FileStream_.getFilePointer() / this.FileLength_);
        }
        catch (IOException ioe) {
            return 100;
        }
    }

    public void traverse() {
        Iterator<String> iter = this.NameList_.keySet().iterator();
        while (iter.hasNext()) {
            System.out.println((Object)iter.next());
        }
        System.out.println();
    }
}

