/*
 * Decompiled with CFR 0.152.
 */
package GPos.VuposInstallationWizard;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JTextArea;

public class PrintableTextArea
extends JTextArea
implements Printable {
    public void printText() throws PrinterException {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(OrientationRequested.PORTRAIT);
        aset.add(new JobName("PrintableTextArea", null));
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length > 0) {
            pj.setPrintService(services[0]);
            if (pj.printDialog(aset)) {
                pj.print(aset);
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int requested_page_number) {
        Graphics2D g2d = (Graphics2D)g;
        int page_width_offset = (int)StrictMath.round(pf.getImageableX());
        int page_height_offset = (int)StrictMath.round(pf.getImageableY());
        int page_width = (int)StrictMath.round(pf.getImageableWidth());
        int page_height = (int)StrictMath.round(pf.getImageableHeight());
        g2d.setClip(page_width_offset, page_height_offset, page_width, page_height);
        g2d.setFont(this.getFont());
        FontMetrics font_metrics = g2d.getFontMetrics();
        int font_height = font_metrics.getHeight();
        int font_descent = font_metrics.getDescent();
        LineNumberReader lnr = new LineNumberReader(new StringReader(this.getText()));
        int current_height = 0;
        int line_count = 0;
        int current_page_number = 0;
        try {
            String a_line;
            while ((a_line = lnr.readLine()) != null) {
                if (current_height + font_height > page_height) {
                    if (current_page_number == requested_page_number) break;
                    ++current_page_number;
                    current_height = 0;
                }
                current_height += font_height;
                if (current_page_number != requested_page_number) continue;
                ++line_count;
                g2d.drawString(a_line, page_width_offset, current_height - font_descent + page_height_offset);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        g2d.dispose();
        g2d = null;
        if (current_page_number == requested_page_number && line_count > 0) {
            return 0;
        }
        return 1;
    }
}

