/*
 * Decompiled with CFR 0.152.
 */
package GPos.VuposInstallationWizard;

import GPos.VuposInstallationWizard.GPosKey;
import GPos.VuposInstallationWizard.InstallPanelDescriptor;
import GPos.VuposInstallationWizard.LicensePanelDescriptor;
import GPos.VuposInstallationWizard.SelectionPanel;
import GPos.VuposInstallationWizard.SelectionPanelDescriptor;
import GPos.VuposInstallationWizard.WelcomePanelDescriptor;
import Wizard.Wizard;
import Wizard.WizardPanelDescriptor;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Main {
    protected static Properties Properties_ = new Properties();
    protected static ResourceBundle ResourceBundle_;
    protected OsType Os_;
    protected SelectionPanel SelectionPanel_;
    protected String License_ = new String();
    protected Wizard Wizard_;
    protected WizardPanelDescriptor descriptor1;
    protected WizardPanelDescriptor descriptor2;
    protected WizardPanelDescriptor descriptor3;
    protected WizardPanelDescriptor descriptor4;
    protected int BufferLength_ = 1024;

    public Main() {
        this.Os_ = System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0 ? OsType.Windows : (System.getProperty("user.name").equalsIgnoreCase("root") ? OsType.Linux : OsType.Linux);
        try {
            ResourceBundle_ = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".wizard", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("Error: resource file\n" + mre.toString());
        }
        catch (NullPointerException npe) {
            System.err.println("Error: resource file\n" + npe.toString());
        }
        String property_file_name = System.getProperty("user.home") + "/." + ResourceBundle_.getString("Product").toLowerCase() + "_installer.xml";
        boolean properties = false;
        try {
            FileInputStream fin = new FileInputStream(property_file_name);
            if (fin != null) {
                Properties_.loadFromXML(fin);
                ((InputStream)fin).close();
                properties = true;
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            System.err.println("Error: property file\n" + ioe.toString());
        }
        if (!properties) {
            if (System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0) {
                this.setProperty("SOFTWARE_FOLDER", System.getProperty("user.home"));
                this.setProperty("TUTORIALS_FOLDER", System.getProperty("user.home"));
            } else if (System.getProperty("user.name").equalsIgnoreCase("root")) {
                this.setProperty("SOFTWARE_FOLDER", new String("/usr/local/share"));
                this.setProperty("TUTORIALS_FOLDER", new String("/"));
            } else {
                this.setProperty("SOFTWARE_FOLDER", System.getProperty("user.home"));
                this.setProperty("TUTORIALS_FOLDER", System.getProperty("user.home"));
            }
            this.setProperty("INSTALL", "true");
            this.setProperty("INSTALL_SOFTWARE", "false");
        }
        if (!this.readLicense()) {
            System.exit(1);
        }
        this.Wizard_ = new Wizard();
        this.Wizard_.getDialog().setTitle(this.i18nString("Title"));
        this.descriptor1 = new WelcomePanelDescriptor(this);
        this.Wizard_.registerWizardPanel("INTRODUCTION_PANEL", this.descriptor1);
        this.descriptor2 = new LicensePanelDescriptor(this);
        this.Wizard_.registerWizardPanel("LICENSE_AGREEMENT_PANEL", this.descriptor2);
        this.descriptor3 = new SelectionPanelDescriptor(this);
        this.Wizard_.registerWizardPanel("SELECTION_PANEL", this.descriptor3);
        this.descriptor4 = new InstallPanelDescriptor(this);
        this.Wizard_.registerWizardPanel("INSTALL_PANEL", this.descriptor4);
        this.Wizard_.setCurrentPanel("INTRODUCTION_PANEL");
        int ret = this.Wizard_.showModalDialog();
        if (ret == 0) {
            File software_folder = new File(((SelectionPanel)this.descriptor3.getPanelComponent()).getSoftwareFolder() + File.separator + this.i18nString("SelectSoftwareLabel"));
            if (software_folder.exists()) {
                if (this.getProperty("INSTALL_KEY") == null) {
                    this.setProperty("INSTALL_KEY", GPosKey.toKey(ResourceBundle_.getString("Product"), System.getProperty("user.name"), System.getProperty("os.name")));
                } else {
                    this.setProperty("INSTALL_KEY", GPosKey.updateKey(this.getProperty("INSTALL_KEY")));
                }
                SelectionPanel panel = (SelectionPanel)this.descriptor3.getPanelComponent();
                this.setProperty("INSTALL", panel.install() ? "true" : "false");
                this.setProperty("SOFTWARE_FOLDER", panel.getSoftwareFolder());
                if (panel.install()) {
                    this.setProperty("INSTALL_SOFTWARE", panel.install() ? "true" : "false");
                }
                try {
                    FileOutputStream fos = new FileOutputStream(property_file_name);
                    Properties_.storeToXML(fos, ResourceBundle_.getString("Product"));
                    fos.close();
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("Error: property file\n" + fnfe.toString());
                }
                catch (IOException ioe) {
                    System.err.println("Error: property file\n" + ioe.toString());
                }
            } else {
                this.remove(new File(property_file_name));
            }
        }
        System.exit(0);
    }

    public boolean copyBinaryFile(File source, Object target) {
        try {
            int bytes_read;
            DataInputStream source_stream = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
            DataOutputStream target_stream = target instanceof String ? new DataOutputStream(new BufferedOutputStream(new FileOutputStream((String)target))) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)target)));
            byte[] buffer = new byte[this.BufferLength_];
            while ((bytes_read = source_stream.read(buffer)) != -1) {
                target_stream.write(buffer, 0, bytes_read);
            }
            source_stream.close();
            target_stream.close();
            return true;
        }
        catch (IOException ioe) {
            System.err.println("Error: copying binary file\n" + ioe.toString());
            return false;
        }
    }

    public void copyRecursively(File source_folder, File target_folder) {
        File[] source_files;
        for (File source : source_files = source_folder.listFiles()) {
            if (source.isDirectory()) {
                File target_subfolder = new File(target_folder.getAbsolutePath() + File.separator + source.getName());
                if (!this.makeFolder(target_subfolder)) continue;
                this.copyRecursively(source, target_subfolder);
                continue;
            }
            if (this.isTextFile(source)) {
                this.copyTextFile(source, target_folder.getAbsolutePath() + File.separator + source.getName());
                continue;
            }
            this.copyBinaryFile(source, target_folder.getAbsolutePath() + File.separator + source.getName());
        }
    }

    public boolean copyTextFile(File source, Object target) {
        try {
            BufferedReader source_stream = new BufferedReader(new FileReader(source), this.BufferLength_);
            BufferedWriter target_stream = target instanceof String ? new BufferedWriter(new FileWriter((String)target), this.BufferLength_) : new BufferedWriter(new FileWriter((File)target), this.BufferLength_);
            boolean flag = false;
            String buffer = new String();
            while ((buffer = source_stream.readLine()) != null) {
                if (flag) {
                    target_stream.newLine();
                }
                target_stream.write(buffer);
                flag = true;
            }
            source_stream.close();
            target_stream.close();
            return true;
        }
        catch (IOException ioe) {
            System.err.println("Error: copying text file\n" + ioe.toString());
            return false;
        }
    }

    public boolean createBatchFiles(String target) {
        try {
            File batch_file;
            String batch_file_name = target + File.separator + "Vupos";
            if (this.Os_.equals((Object)OsType.Windows)) {
                batch_file_name = batch_file_name + ".bat";
            }
            if ((batch_file = new File(batch_file_name)).exists()) {
                batch_file.delete();
            }
            BufferedWriter target_stream = new BufferedWriter(new FileWriter(batch_file), this.BufferLength_);
            if (this.Os_.equals((Object)OsType.Windows)) {
                target_stream.write("javaw " + this.i18nString("JavaOptions") + " -jar \"" + target + File.separator + "Vupos.jar\"");
            } else {
                target_stream.write("java " + this.i18nString("JavaOptions") + " -jar \"" + target + File.separator + "Vupos.jar\"");
            }
            target_stream.newLine();
            target_stream.close();
            if (this.Os_.equals((Object)OsType.Linux)) {
                Runtime.getRuntime().exec("chmod u+x " + batch_file.getAbsolutePath());
            }
            batch_file_name = target + File.separator + "Vupos";
            if (this.Os_.equals((Object)OsType.Windows)) {
                batch_file_name = batch_file_name + ".bat";
            }
            if ((batch_file = new File(batch_file_name)).exists()) {
                batch_file.delete();
            }
            target_stream = new BufferedWriter(new FileWriter(batch_file), this.BufferLength_);
            if (this.Os_.equals((Object)OsType.Windows)) {
                target_stream.write("javaw " + this.i18nString("JavaOptions") + " -jar \"" + target + File.separator + "Vupos.jar\"");
            } else {
                target_stream.write("java " + this.i18nString("JavaOptions") + " -jar \"" + target + File.separator + "Vupos.jar\"");
            }
            target_stream.newLine();
            target_stream.close();
            if (this.Os_.equals((Object)OsType.Linux)) {
                Runtime.getRuntime().exec("chmod u+x " + batch_file.getAbsolutePath());
            }
            return true;
        }
        catch (IOException ioe) {
            System.err.println("Error: copying batch files\n" + ioe.toString());
            return false;
        }
    }

    public boolean createLicense(String target) {
        try {
            File license_file = new File(target + File.separator + "LICENSE.TXT");
            if (license_file.exists()) {
                license_file.delete();
            }
            BufferedWriter target_stream = new BufferedWriter(new FileWriter(license_file), this.BufferLength_);
            target_stream.write(this.License_.replace("\n", System.getProperty("line.separator")));
            target_stream.close();
            if (this.Os_.equals((Object)OsType.Linux)) {
                Runtime.getRuntime().exec("chmod -wx " + license_file.getAbsolutePath());
            }
            return true;
        }
        catch (IOException ioe) {
            System.err.println("Error: copying license\n" + ioe.toString());
            return false;
        }
    }

    public void createShortcut(String target, String application) throws IOException {
        String cmd = null;
        if (this.Os_.equals((Object)OsType.Windows)) {
            File desktop_folder = new File(System.getProperty("user.home") + File.separator + "Desktop");
            if (desktop_folder.exists()) {
                cmd = "Shortcut /f:\"" + desktop_folder.getAbsolutePath() + File.separator + application + ".lnk\"" + " /a:c" + " /d:\"" + application + "\"" + " /i:\"" + target + File.separator + this.Os_.getIcon() + "\"" + " /t:\"javaw\"" + " /p:\"" + this.i18nString("JavaOptions") + " -jar \\\"" + target + File.separator + application + ".jar\\\"\"";
                Process p = Runtime.getRuntime().exec(cmd);
            }
        } else {
            File desktop_folder = new File(System.getProperty("user.home") + File.separator + "Desktop");
            if (desktop_folder.exists()) {
                File desktop_file = new File(desktop_folder.getAbsolutePath() + File.separator + application + ".desktop");
                if (desktop_file.exists()) {
                    desktop_file.delete();
                }
                BufferedWriter target_stream = new BufferedWriter(new FileWriter(desktop_file), this.BufferLength_);
                target_stream.write("[Desktop Entry]");
                target_stream.newLine();
                target_stream.write("Name=" + application);
                target_stream.newLine();
                target_stream.write("Name[en_US]=" + application);
                target_stream.newLine();
                target_stream.write("MimeType=");
                target_stream.newLine();
                target_stream.write("Exec=java " + this.i18nString("JavaOptions") + " -jar " + target + File.separator + application + ".jar");
                target_stream.newLine();
                target_stream.write("Icon=" + target + File.separator + this.Os_.getIcon() + "");
                target_stream.newLine();
                target_stream.write("Path=$HOME");
                target_stream.newLine();
                target_stream.write("Type=Application");
                target_stream.newLine();
                target_stream.write("Terminal=0");
                target_stream.newLine();
                target_stream.write("X-SuSE-translate=true");
                target_stream.newLine();
                target_stream.close();
            }
        }
    }

    public boolean createShortcuts(String target) {
        Object cmd = null;
        try {
            this.createShortcut(target, "Vupos");
            this.createShortcut(target, "Vupos");
            return true;
        }
        catch (IOException ioe) {
            System.err.println("Error: creating shortcut\n" + ioe.toString());
            return false;
        }
    }

    public SelectionPanel getSelectionPanel() {
        return this.SelectionPanel_;
    }

    public JDialog getDialog() {
        return this.Wizard_.getDialog();
    }

    public String getLicense() {
        return this.License_;
    }

    public String getProperty(String key) {
        return Properties_.getProperty(key);
    }

    public Component getOwner() {
        return this.Wizard_.getOwner();
    }

    public boolean hasProperties() {
        return Properties_.getProperty("INSTALL_KEY") instanceof String;
    }

    public String i18nString(String key) {
        if (ResourceBundle_ != null) {
            try {
                return ResourceBundle_.getString(key);
            }
            catch (Exception npe) {
                return null;
            }
        }
        return null;
    }

    public void install() {
        Thread t = new Thread(){
            SelectionPanel selection_panel;
            InstallPanelDescriptor install_panel;
            {
                this.selection_panel = (SelectionPanel)Main.this.descriptor3.getPanelComponent();
                this.install_panel = (InstallPanelDescriptor)Main.this.descriptor4;
            }

            public void run() {
                this.install_panel.setWelcomeText(Main.this.i18nString("InstallLabel"));
                this.install_panel.setPartingNotes(Main.this.i18nString("InstallationPartingNotes"));
                if (this.selection_panel.isCheckBoxSelected(0)) {
                    this.install_panel.setProgressText(Main.this.i18nString("InstallVupos"));
                    File source_folder = new File("." + File.separator + "Vupos");
                    File target_folder = new File(this.selection_panel.getSoftwareFolder() + File.separator + Main.this.i18nString("SelectSoftwareLabel"));
                    if (Main.this.makeFolder(target_folder) && Main.this.createLicense(target_folder.getAbsolutePath())) {
                        Main.this.copyRecursively(source_folder, target_folder);
                        File source_file = new File("." + File.separator + Main.this.Os_.toString() + File.separator + Main.this.Os_.getIcon());
                        File target_file = new File(target_folder.getAbsolutePath() + File.separator + Main.this.Os_.getIcon());
                        Main.this.copyBinaryFile(source_file, target_file);
                        Main.this.createBatchFiles(target_folder.getAbsolutePath());
                        Main.this.createShortcuts(target_folder.getAbsolutePath());
                    }
                    this.install_panel.setProgressValue(this.selection_panel.getSize(0));
                }
                this.install_panel.finish();
            }
        };
        t.start();
    }

    public boolean isTextFile(File source) {
        try {
            DataInputStream source_stream = new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
            boolean flag = true;
            byte[] buffer = new byte[this.BufferLength_];
            int bytes_read = source_stream.read(buffer);
            if (bytes_read != -1) {
                for (int i = 0; i < bytes_read; ++i) {
                    if (buffer[i] >= 9 && (buffer[i] <= 13 || buffer[i] >= 32) && buffer[i] <= 126) continue;
                    flag = false;
                }
            }
            source_stream.close();
            return flag;
        }
        catch (IOException ioe) {
            System.err.println("Error: testing for text file\n" + ioe.toString());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean makeFolder(File folder) {
        try {
            if (!folder.exists()) {
                if (folder.mkdir()) return true;
                System.err.println("Error: can not mkdir \"" + folder.getName() + "\".");
                return false;
            }
            if (folder.isDirectory()) {
                String msg = "";
                if (msg.length() <= 0) return true;
                System.err.println("Error: can not " + msg + " \"" + folder.getName() + "\".");
                return false;
            }
            System.err.println("Error: \"" + folder.getName() + "\" exists but is not a directory.");
            return false;
        }
        catch (SecurityException se) {
            System.err.println("Error: mkdir software folder\n" + se.toString());
            return false;
        }
    }

    public boolean makeFolder(File folder, String name) {
        return this.makeFolder(new File(folder.getAbsoluteFile() + File.separator + name));
    }

    public boolean okToInstall() {
        return ((SelectionPanel)this.descriptor3.getPanelComponent()).install();
    }

    public boolean readLicense() {
        try {
            BufferedReader source_stream = new BufferedReader(new FileReader("." + File.separator + "LICENSE.TXT"), this.BufferLength_);
            boolean flag = false;
            String buffer = new String();
            while ((buffer = source_stream.readLine()) != null) {
                if (flag) {
                    this.License_ = this.License_ + "\n";
                }
                this.License_ = this.License_ + buffer;
                flag = true;
            }
            source_stream.close();
            return true;
        }
        catch (IOException ioe) {
            System.err.println("Error: reading the license agreement\n" + ioe.toString());
            return false;
        }
    }

    public boolean remove(File target) {
        boolean flag = true;
        if (target.exists()) {
            if (target.isDirectory()) {
                if (!(target.canWrite() && this.removeRecursively(target) && target.delete())) {
                    System.err.println("Error: removing folder\n" + target.getName());
                    flag = false;
                }
            } else if (!target.canWrite() || !target.delete()) {
                System.err.println("Error: removing file\n" + target.getName());
                flag = false;
            }
        }
        return flag;
    }

    public boolean removeRecursively(File source_folder, File target_folder) {
        File[] source_files;
        boolean flag = true;
        for (File source : source_files = source_folder.listFiles()) {
            File target = new File(target_folder.getAbsolutePath() + File.separator + source.getName());
            if (this.remove(target)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean removeRecursively(File target_folder) {
        File[] target_files;
        boolean flag = true;
        for (File target : target_files = target_folder.listFiles()) {
            if (target.canWrite()) {
                if (target.isDirectory()) {
                    if (this.removeRecursively(target) && target.delete()) continue;
                    System.err.println("Error: removing folder\n" + target.getName());
                    flag = false;
                    continue;
                }
                if (target.delete()) continue;
                System.err.println("Error: removing file\n" + target.getName());
                flag = false;
                continue;
            }
            System.err.println("Error: removing file\n" + target.getName());
            flag = false;
        }
        return flag;
    }

    public boolean removeShortcuts() {
        boolean flag = true;
        if (this.Os_.equals((Object)OsType.Windows)) {
            File tmp = new File(System.getProperty("user.home") + File.separator + "Desktop" + File.separator + "Vupos.lnk");
            if (tmp.exists() && !tmp.delete()) {
                System.err.println("Error: removing Vupos shortcut\n");
                flag = false;
            }
            if ((tmp = new File(System.getProperty("user.home") + File.separator + "Desktop" + File.separator + "Vupos.lnk")).exists() && !tmp.delete()) {
                System.err.println("Error: removing Vupos shortcut\n");
                flag = false;
            }
        } else {
            File tmp = new File(System.getProperty("user.home") + File.separator + "Desktop" + File.separator + "Vupos.desktop");
            if (tmp.exists() && !tmp.delete()) {
                System.err.println("Error: removing Vupos shortcut\n");
                flag = false;
            }
            if ((tmp = new File(System.getProperty("user.home") + File.separator + "Desktop" + File.separator + "Vupos.desktop")).exists() && !tmp.delete()) {
                System.err.println("Error: removing Vupos shortcut\n");
                flag = false;
            }
        }
        return flag;
    }

    public void uninstall() {
        Thread t = new Thread(){
            SelectionPanel selection_panel;
            InstallPanelDescriptor install_panel;
            {
                this.selection_panel = (SelectionPanel)Main.this.descriptor3.getPanelComponent();
                this.install_panel = (InstallPanelDescriptor)Main.this.descriptor4;
            }

            public void run() {
                this.install_panel.setWelcomeText(Main.this.i18nString("UninstallLabel"));
                File software_folder = new File(this.selection_panel.getSoftwareFolder() + File.separator + Main.this.i18nString("SelectSoftwareLabel"));
                if (this.selection_panel.isCheckBoxSelected(0)) {
                    this.install_panel.setProgressText(Main.this.i18nString("UninstallVupos"));
                    File license_file = new File(this.selection_panel.getSoftwareFolder() + File.separator + Main.this.i18nString("SelectSoftwareLabel") + File.separator + "LICENSE.TXT");
                    try {
                        Runtime.getRuntime().exec("chmod u+w " + license_file.getAbsolutePath());
                        Thread.sleep(1000L);
                    }
                    catch (IOException ioe) {
                        System.err.println("Error: changing permissions on " + license_file.getAbsolutePath() + "\n" + ioe.toString());
                    }
                    catch (InterruptedException ie) {
                        System.err.println("Error: changing permissions on " + license_file.getAbsolutePath() + "\n" + ie.toString());
                    }
                    Main.this.remove(software_folder);
                    Main.this.removeShortcuts();
                    this.install_panel.setProgressValue(this.selection_panel.getSize(0));
                }
                this.install_panel.finish();
            }
        };
        t.start();
    }

    public void removeProperty(String key) {
        if (key != null) {
            Properties_.remove(key);
        }
    }

    public void setProperty(String key, String value) {
        if (key != null) {
            Properties_.setProperty(key, value);
        }
    }

    public void setSelectionPanel(SelectionPanel panel) {
        this.SelectionPanel_ = panel;
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new Main();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OsType {
        Linux("KPos", "gpos.gif"),
        Mac("KPos", "gpos.gif"),
        Windows("KPos.exe", "gpos.ico");

        private final String Engine_;
        private final String Icon_;

        private OsType(String engine, String icon) {
            this.Engine_ = engine;
            this.Icon_ = icon;
        }

        public String getEngine() {
            return this.Engine_;
        }

        public String getIcon() {
            return this.Icon_;
        }
    }
}

